/*
 * Decompiled with CFR 0.152.
 */
package jalview.ws.jws1;

import ext.vamsas.Jpred;
import jalview.analysis.AlignSeq;
import jalview.analysis.SeqsetUtils;
import jalview.bin.Console;
import jalview.commands.RemoveGapsCommand;
import jalview.datamodel.Alignment;
import jalview.datamodel.AlignmentAnnotation;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.AlignmentView;
import jalview.datamodel.HiddenColumns;
import jalview.datamodel.SequenceI;
import jalview.gui.AlignFrame;
import jalview.gui.Desktop;
import jalview.gui.WebserviceInfo;
import jalview.io.DataSourceType;
import jalview.io.FileFormatI;
import jalview.io.FormatAdapter;
import jalview.io.IdentifyFile;
import jalview.io.JPredFile;
import jalview.io.JnetAnnotationMaker;
import jalview.io.PileUpfile;
import jalview.util.Comparison;
import jalview.util.MessageManager;
import jalview.ws.AWsJob;
import jalview.ws.JobStateSummary;
import jalview.ws.WSClientI;
import jalview.ws.jws1.JWS1Thread;
import jalview.ws.jws1.WSJob;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import java.util.List;
import vamsas.objects.simple.JpredResult;
import vamsas.objects.simple.Msfalignment;
import vamsas.objects.simple.Sequence;

class JPredThread
extends JWS1Thread
implements WSClientI {
    Jpred server;
    String altitle = "";

    JPredThread(WebserviceInfo wsinfo, String altitle, Jpred server, String wsurl, AlignmentView alview, AlignFrame alframe) {
        super(alframe, wsinfo, alview, wsurl);
        this.altitle = altitle;
        this.server = server;
    }

    JPredThread(WebserviceInfo wsinfo, String altitle, Jpred server, String wsurl, Hashtable SequenceInfo, SequenceI seq, int[] delMap, AlignmentView alview, AlignFrame alframe) {
        this(wsinfo, altitle, server, wsurl, alview, alframe);
        JPredJob job = new JPredJob(SequenceInfo, seq, delMap);
        if (job.hasValidInput()) {
            this.OutputHeader = this.wsInfo.getProgressText();
            this.jobs = new WSJob[]{job};
            job.setJobnum(0);
        } else {
            this.wsInfo.appendProgressText(job.getValidationMessages());
        }
    }

    JPredThread(WebserviceInfo wsinfo, String altitle, Jpred server, Hashtable SequenceInfo, SequenceI[] msf, int[] delMap, AlignmentView alview, AlignFrame alframe, String wsurl) {
        this(wsinfo, altitle, server, wsurl, alview, alframe);
        JPredJob job = new JPredJob(SequenceInfo, msf, delMap);
        if (job.hasValidInput()) {
            this.jobs = new WSJob[]{job};
            this.OutputHeader = this.wsInfo.getProgressText();
            job.setJobnum(0);
        } else {
            this.wsInfo.appendProgressText(job.getValidationMessages());
        }
    }

    @Override
    public void StartJob(AWsJob j) {
        if (!(j instanceof JPredJob)) {
            throw new Error(MessageManager.formatMessage("error.implementation_error_startjob_called", new String[]{j.getClass().toString()}));
        }
        try {
            JPredJob job = (JPredJob)j;
            if (job.msa != null) {
                job.setJobId(this.server.predictOnMsa(job.msa));
            } else if (job.sequence != null) {
                job.setJobId(this.server.predict(job.sequence));
            }
            if (job.getJobId() != null) {
                if (job.getJobId().startsWith("Broken")) {
                    job.result = new JpredResult();
                    job.result.setInvalid(true);
                    job.result.setStatus(MessageManager.formatMessage("label.submission_params", new String[]{job.getJobId().toString()}));
                    throw new Exception(job.getJobId());
                }
            } else {
                throw new Exception(MessageManager.getString("exception.server_timeout_try_later"));
            }
            job.setSubmitted(true);
            job.setSubjobComplete(false);
            Console.info(this.WsUrl + " Job Id '" + job.getJobId() + "'");
        }
        catch (Exception e) {
            this.wsInfo.setStatus(5);
            if (e.getMessage().indexOf("Exception") > -1) {
                this.wsInfo.setStatus(j.getJobnum(), 5);
                this.wsInfo.setProgressText(j.getJobnum(), "Failed to submit the prediction. (Just close the window)\nIt is most likely that there is a problem with the server.\n");
                Console.errPrintln("JPredWS Client: Failed to submit the prediction. Quite possibly because of a server error - see below)\n" + e.getMessage() + "\n");
                Console.warn("Server Exception", e);
            } else {
                this.wsInfo.setStatus(j.getJobnum(), 4);
                this.wsInfo.appendProgressText(j.getJobnum(), MessageManager.formatMessage("info.failed_to_submit_prediction", new String[]{e.getMessage(), this.wsInfo.getProgressText()}));
                Console.debug("Failed Submission of job " + j.getJobnum(), e);
            }
            j.setAllowedServerExceptions(-1);
            j.setSubjobComplete(true);
        }
    }

    @Override
    public void parseResult() {
        int results = 0;
        JobStateSummary finalState = new JobStateSummary();
        try {
            for (int j = 0; j < this.jobs.length; ++j) {
                finalState.updateJobPanelState(this.wsInfo, this.OutputHeader, this.jobs[j]);
                if (!this.jobs[j].isSubmitted() || !this.jobs[j].isSubjobComplete() || !this.jobs[j].hasResults()) continue;
                ++results;
            }
        }
        catch (Exception ex) {
            Console.error("Unexpected exception when processing results for " + this.altitle, ex);
            this.wsInfo.setStatus(4);
        }
        if (results > 0) {
            this.wsInfo.showResultsNewFrame.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    JPredThread.this.displayResults(true);
                }
            });
            this.wsInfo.mergeResults.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    JPredThread.this.displayResults(false);
                }
            });
            this.wsInfo.setResultsReady();
        } else {
            this.wsInfo.setStatus(4);
            this.wsInfo.appendInfoText("No jobs ran.");
            this.wsInfo.setFinishedNoResults();
        }
    }

    void displayResults(boolean newWindow) {
        if (this.jobs != null) {
            Object[] res = null;
            boolean msa = false;
            for (int jn = 0; jn < this.jobs.length; ++jn) {
                Object[] jobres = null;
                JPredJob j = (JPredJob)this.jobs[jn];
                if (!j.hasResults()) continue;
                msa = j.msa != null ? true : msa;
                try {
                    Console.debug("Parsing output of job " + jn);
                    jobres = j.getResultSet();
                    Console.debug("Finished parsing output.");
                    if (this.jobs.length != 1) {
                        throw new Error(MessageManager.getString("error.multiple_jnet_subjob_merge_not_implemented"));
                    }
                    res = jobres;
                    continue;
                }
                catch (Exception e) {
                    Console.error("JNet Client: JPred Annotation Parse Error", e);
                    this.wsInfo.setStatus(j.getJobnum(), 4);
                    this.wsInfo.appendProgressText(j.getJobnum(), MessageManager.formatMessage("info.invalid_jnet_job_result_data", new String[]{this.OutputHeader.toString(), j.result.getStatus(), e.getMessage()}));
                    j.result.setBroken(true);
                }
            }
            if (res != null) {
                if (newWindow) {
                    ((AlignmentI)res[0]).setSeqrep(((AlignmentI)res[0]).getSequenceAt(0));
                    AlignFrame af = this.input == null ? (res[1] != null ? new AlignFrame((AlignmentI)((Alignment)res[0]), (HiddenColumns)res[1], 700, 500) : new AlignFrame((Alignment)res[0], 700, 500)) : new AlignFrame((AlignmentI)((Alignment)res[0]), (HiddenColumns)res[1], 700, 500);
                    Desktop.addInternalFrame(af, this.altitle, 700, 500);
                } else {
                    Console.info("Append results onto existing alignment.");
                }
            }
        }
    }

    @Override
    public void pollJob(AWsJob job) throws Exception {
        ((JPredJob)job).result = this.server.getresult(job.getJobId());
    }

    @Override
    public boolean isCancellable() {
        return false;
    }

    @Override
    public void cancelJob() {
        throw new Error(MessageManager.getString("error.implementation_error"));
    }

    @Override
    public boolean canMergeResults() {
        return false;
    }

    class JPredJob
    extends WSJob {
        int[] predMap = null;
        Sequence sequence;
        Msfalignment msa;
        Hashtable SequenceInfo = null;
        int msaIndex = 0;
        String errorMessage = "";

        @Override
        public boolean hasResults() {
            return this.subjobComplete && this.result != null && this.result.isFinished() && ((JpredResult)this.result).getPredfile() != null && ((JpredResult)this.result).getAligfile() != null;
        }

        @Override
        public boolean hasValidInput() {
            return this.sequence != null;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public Object[] getResultSet() throws Exception {
            SequenceI[] sqs;
            if (this.result == null || !this.result.isFinished()) {
                return null;
            }
            AlignmentI al = null;
            HiddenColumns alhidden = null;
            int FirstSeq = -1;
            JpredResult result = (JpredResult)this.result;
            Console.debug("Parsing output from JNet job.");
            JPredFile prediction = new JPredFile(result.getPredfile(), DataSourceType.PASTE);
            SequenceI[] preds = prediction.getSeqsAsArray();
            Console.debug("Got prediction profile.");
            if (this.msa != null && result.getAligfile() != null) {
                Console.debug("Getting associated alignment.");
                FileFormatI format = new IdentifyFile().identify(result.getAligfile(), DataSourceType.PASTE);
                if (format == null) throw new Exception(MessageManager.formatMessage("exception.unknown_format_for_file", new String[]{"", result.getAligfile()}));
                if (this.predMap != null) {
                    Object[] alandcolsel = JPredThread.this.input.getAlignmentAndHiddenColumns(JPredThread.this.getGapChar());
                    sqs = (SequenceI[])alandcolsel[0];
                    al = new Alignment(sqs);
                    alhidden = (HiddenColumns)alandcolsel[1];
                } else {
                    al = new FormatAdapter().readFile(result.getAligfile(), DataSourceType.PASTE, format);
                    sqs = new SequenceI[al.getHeight()];
                    int j = al.getHeight();
                    for (int i = 0; i < j; ++i) {
                        sqs[i] = al.getSequenceAt(i);
                    }
                    if (!SeqsetUtils.deuniquify(this.SequenceInfo, sqs)) {
                        throw new Exception(MessageManager.getString("exception.couldnt_recover_sequence_properties_for_alignment"));
                    }
                }
                FirstSeq = 0;
                if (JPredThread.this.currentView.getDataset() != null) {
                    al.setDataset(JPredThread.this.currentView.getDataset());
                } else {
                    al.setDataset(null);
                }
                JnetAnnotationMaker.add_annotation(prediction, al, FirstSeq, false, this.predMap);
            } else {
                al = new Alignment(preds);
                FirstSeq = prediction.getQuerySeqPosition();
                if (this.predMap != null) {
                    char gc = JPredThread.this.getGapChar();
                    sqs = (SequenceI[])JPredThread.this.input.getAlignmentAndHiddenColumns(gc)[0];
                    if (this.msaIndex >= sqs.length) {
                        throw new Error(MessageManager.getString("error.implementation_error_invalid_msa_index_for_job"));
                    }
                    new RemoveGapsCommand(MessageManager.getString("label.remove_gaps"), new SequenceI[]{sqs[this.msaIndex]}, JPredThread.this.currentView);
                    SequenceI profileseq = al.getSequenceAt(FirstSeq);
                    profileseq.setSequence(sqs[this.msaIndex].getSequenceAsString());
                }
                if (!SeqsetUtils.SeqCharacterUnhash(al.getSequenceAt(FirstSeq), this.SequenceInfo)) {
                    throw new Exception(MessageManager.getString("exception.couldnt_recover_sequence_props_for_jnet_query"));
                }
                if (JPredThread.this.currentView.getDataset() != null) {
                    al.setDataset(JPredThread.this.currentView.getDataset());
                } else {
                    al.setDataset(null);
                }
                JnetAnnotationMaker.add_annotation(prediction, al, FirstSeq, true, this.predMap);
                SequenceI profileseq = al.getSequenceAt(0);
                this.alignToProfileSeq(al, profileseq);
                if (this.predMap != null) {
                    alhidden = al.propagateInsertions(profileseq, JPredThread.this.input);
                }
            }
            for (AlignmentAnnotation alant : al.getAlignmentAnnotation()) {
                if (alant.sequenceRef == null) continue;
                this.replaceAnnotationOnAlignmentWith(alant, alant.label, "jalview.jws1.Jpred" + (this.msa == null ? "" : "MSA"), alant.sequenceRef);
            }
            return new Object[]{al, alhidden};
        }

        protected void replaceAnnotationOnAlignmentWith(AlignmentAnnotation newAnnot, String typeName, String calcId, SequenceI aSeq) {
            SequenceI dsseq = aSeq.getDatasetSequence();
            while (dsseq.getDatasetSequence() != null) {
                dsseq = dsseq.getDatasetSequence();
            }
            List<AlignmentAnnotation> dsan = dsseq.getAlignmentAnnotations(calcId, typeName);
            if (dsan != null && dsan.size() > 0) {
                for (AlignmentAnnotation dssan : dsan) {
                    dsseq.removeAlignmentAnnotation(dssan);
                }
            }
            AlignmentAnnotation dssan = new AlignmentAnnotation(newAnnot);
            dsseq.addAlignmentAnnotation(dssan);
            dssan.adjustForAlignment();
        }

        private void alignToProfileSeq(AlignmentI al, SequenceI profileseq) {
            char gc = al.getGapCharacter();
            int[] gapMap = profileseq.gapMap();
            int lp = 0;
            for (int r = 0; r < gapMap.length; ++r) {
                if (gapMap[r] - lp > 1) {
                    int s;
                    StringBuffer sb = new StringBuffer();
                    int ns = gapMap[r] - lp;
                    for (s = 0; s < ns; ++s) {
                        sb.append(gc);
                    }
                    ns = al.getHeight();
                    for (s = 1; s < ns; ++s) {
                        Object sq = al.getSequenceAt(s).getSequenceAsString();
                        int diff = gapMap[r] - ((String)sq).length();
                        if (diff > 0) {
                            sq = (String)sq + sb;
                            while ((diff = gapMap[r] - ((String)sq).length()) > 0) {
                                sq = (String)sq + (diff >= sb.length() ? sb.toString() : sb.substring(0, diff));
                            }
                            al.getSequenceAt(s).setSequence((String)sq);
                            continue;
                        }
                        al.getSequenceAt(s).setSequence(((String)sq).substring(0, gapMap[r]) + sb.toString() + ((String)sq).substring(gapMap[r]));
                    }
                }
                lp = gapMap[r];
            }
        }

        public JPredJob(Hashtable SequenceInfo, SequenceI seq, int[] delMap) {
            this.predMap = delMap;
            String sq = AlignSeq.extractGaps(Comparison.GapChars, seq.getSequenceAsString());
            if (sq.length() >= 20) {
                this.SequenceInfo = SequenceInfo;
                this.sequence = new Sequence();
                this.sequence.setId(seq.getName());
                this.sequence.setSeq(sq);
            } else {
                this.errorMessage = "Sequence is too short to predict with JPred - need at least 20 amino acids.";
            }
        }

        public JPredJob(Hashtable SequenceInfo, SequenceI[] msf, int[] delMap) {
            this(SequenceInfo, msf[0], delMap);
            if (this.sequence != null && msf.length > 1) {
                this.msa = new Msfalignment();
                PileUpfile pileup = new PileUpfile();
                this.msa.setMsf(pileup.print(msf, true));
            }
        }

        public String getValidationMessages() {
            return this.errorMessage + "\n";
        }
    }
}

