/*
 * Decompiled with CFR 0.152.
 */
package jalview.viewmodel.seqfeatures;

import jalview.api.AlignViewportI;
import jalview.api.FeatureColourI;
import jalview.api.FeaturesDisplayedI;
import jalview.datamodel.AlignedCodonFrame;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.MappedFeatures;
import jalview.datamodel.SearchResultMatchI;
import jalview.datamodel.SearchResults;
import jalview.datamodel.SequenceFeature;
import jalview.datamodel.SequenceI;
import jalview.datamodel.features.FeatureMatcherSetI;
import jalview.datamodel.features.SequenceFeatures;
import jalview.renderer.seqfeatures.FeatureRenderer;
import jalview.schemes.FeatureColour;
import jalview.util.ColorUtils;
import jalview.util.Platform;
import jalview.util.QuickSort;
import jalview.viewmodel.seqfeatures.FeatureRendererSettings;
import jalview.viewmodel.seqfeatures.FeaturesDisplayed;
import java.awt.Color;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public abstract class FeatureRendererModel
implements jalview.api.FeatureRenderer {
    protected float transparency = 1.0f;
    protected Map<String, FeatureColourI> featureColours = new ConcurrentHashMap<String, FeatureColourI>();
    protected Map<String, Boolean> featureGroups = new ConcurrentHashMap<String, Boolean>();
    protected Map<String, FeatureMatcherSetI> featureFilters = new HashMap<String, FeatureMatcherSetI>();
    protected String[] renderOrder;
    Map<String, Float> featureOrder = null;
    protected AlignViewportI av;
    private PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);
    protected Map<String, float[][]> minmax = new Hashtable<String, float[][]>();
    boolean newFeatureAdded = false;
    boolean findingFeatures = false;
    protected Boolean firing = Boolean.FALSE;

    @Override
    public AlignViewportI getViewport() {
        return this.av;
    }

    public FeatureRendererSettings getSettings() {
        return new FeatureRendererSettings(this);
    }

    public void transferSettings(FeatureRendererSettings fr) {
        this.renderOrder = fr.renderOrder;
        this.featureGroups = fr.featureGroups;
        this.featureColours = fr.featureColours;
        this.transparency = fr.transparency;
        this.featureOrder = fr.featureOrder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transferSettings(jalview.api.FeatureRenderer _fr) {
        FeatureRenderer fr = (FeatureRenderer)_fr;
        FeatureRendererSettings frs = new FeatureRendererSettings(fr);
        this.renderOrder = frs.renderOrder;
        this.featureGroups = frs.featureGroups;
        this.featureColours = frs.featureColours;
        this.featureFilters = frs.featureFilters;
        this.transparency = frs.transparency;
        this.featureOrder = frs.featureOrder;
        if (this.av != null && this.av != fr.getViewport() && _fr.getFeaturesDisplayed() != null) {
            FeaturesDisplayedI fd = this.getFeaturesDisplayed();
            if (fd == null) {
                this.setFeaturesDisplayedFrom(_fr.getFeaturesDisplayed());
            } else {
                FeaturesDisplayedI featuresDisplayedI = fd;
                synchronized (featuresDisplayedI) {
                    fd.clear();
                    for (String type : _fr.getFeaturesDisplayed().getVisibleFeatures()) {
                        fd.setVisible(type);
                    }
                }
            }
        }
    }

    public void setFeaturesDisplayedFrom(FeaturesDisplayedI featuresDisplayed) {
        this.av.setFeaturesDisplayed(new FeaturesDisplayed(featuresDisplayed));
    }

    @Override
    public void setVisible(String featureType) {
        FeaturesDisplayedI fdi = this.av.getFeaturesDisplayed();
        if (fdi == null) {
            fdi = new FeaturesDisplayed();
            this.av.setFeaturesDisplayed(fdi);
        }
        if (!fdi.isRegistered(featureType)) {
            this.pushFeatureType(Arrays.asList(featureType));
        }
        fdi.setVisible(featureType);
    }

    @Override
    public void setAllVisible(List<String> featureTypes) {
        FeaturesDisplayedI fdi = this.av.getFeaturesDisplayed();
        if (fdi == null) {
            fdi = new FeaturesDisplayed();
            this.av.setFeaturesDisplayed(fdi);
        }
        ArrayList<String> nft = new ArrayList<String>();
        for (String featureType : featureTypes) {
            if (fdi.isRegistered(featureType)) continue;
            nft.add(featureType);
        }
        if (nft.size() > 0) {
            this.pushFeatureType(nft);
        }
        fdi.setAllVisible(featureTypes);
    }

    private void pushFeatureType(List<String> types) {
        int ts = types.size();
        String[] neworder = new String[(this.renderOrder == null ? 0 : this.renderOrder.length) + ts];
        types.toArray(neworder);
        if (this.renderOrder != null) {
            System.arraycopy(neworder, 0, neworder, this.renderOrder.length, ts);
            System.arraycopy(this.renderOrder, 0, neworder, 0, this.renderOrder.length);
        }
        this.renderOrder = neworder;
    }

    public Map<String, float[][]> getMinMax() {
        return this.minmax;
    }

    protected final byte[] normaliseScore(SequenceFeature sequenceFeature) {
        float[] mm = this.minmax.get(sequenceFeature.type)[0];
        byte[] r = new byte[]{0, -1};
        if (mm != null) {
            if (r[0] != 0 || (double)mm[0] < 0.0) {
                r[0] = 1;
                r[1] = (byte)(128.0 + 127.0 * (double)(sequenceFeature.score / mm[1]));
            } else {
                r[1] = (byte)(255.0f * (sequenceFeature.score / mm[1]));
            }
        }
        return r;
    }

    protected boolean updateFeatures() {
        if (this.av.getFeaturesDisplayed() == null || this.renderOrder == null || this.newFeatureAdded) {
            this.findAllFeatures();
            if (this.av.getFeaturesDisplayed().getVisibleFeatureCount() < 1) {
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void findAllFeatures() {
        Boolean bl = this.firing;
        synchronized (bl) {
            if (this.firing.equals(Boolean.FALSE)) {
                this.firing = Boolean.TRUE;
                this.findAllFeatures(true);
                this.notifyFeaturesChanged();
                this.firing = Boolean.FALSE;
            }
        }
    }

    @Override
    public void notifyFeaturesChanged() {
        this.changeSupport.firePropertyChange("changeSupport", null, null);
    }

    @Override
    public List<SequenceFeature> findFeaturesAtColumn(SequenceI sequence, int column) {
        ArrayList<SequenceFeature> result = new ArrayList<SequenceFeature>();
        if (!this.av.areFeaturesDisplayed() || this.getFeaturesDisplayed() == null) {
            return result;
        }
        Set<String> visibleFeatures = this.getFeaturesDisplayed().getVisibleFeatures();
        String[] visibleTypes = visibleFeatures.toArray(new String[visibleFeatures.size()]);
        List<SequenceFeature> features = sequence.findFeatures(column, column, visibleTypes);
        for (SequenceFeature sf : features) {
            if (this.getColour(sf) == null) continue;
            result.add(sf);
        }
        return result;
    }

    @Override
    public synchronized void findAllFeatures(boolean newMadeVisible) {
        this.newFeatureAdded = false;
        if (this.findingFeatures) {
            this.newFeatureAdded = true;
            return;
        }
        this.findingFeatures = true;
        if (this.av.getFeaturesDisplayed() == null) {
            this.av.setFeaturesDisplayed(new FeaturesDisplayed());
        }
        FeaturesDisplayedI featuresDisplayed = this.av.getFeaturesDisplayed();
        HashSet<String> oldfeatures = new HashSet<String>();
        if (this.renderOrder != null) {
            for (int i = 0; i < this.renderOrder.length; ++i) {
                if (this.renderOrder[i] == null) continue;
                oldfeatures.add(this.renderOrder[i]);
            }
        }
        AlignmentI alignment = this.av.getAlignment();
        ArrayList<String> allfeatures = new ArrayList<String>();
        for (int i = 0; i < alignment.getHeight(); ++i) {
            SequenceI asq = alignment.getSequenceAt(i);
            for (String group : asq.getFeatures().getFeatureGroups(true, new String[0])) {
                boolean groupDisplayed = true;
                if (group != null) {
                    if (this.featureGroups.containsKey(group)) {
                        groupDisplayed = this.featureGroups.get(group);
                    } else {
                        groupDisplayed = newMadeVisible;
                        this.featureGroups.put(group, groupDisplayed);
                    }
                }
                if (!groupDisplayed) continue;
                Set<String> types = asq.getFeatures().getFeatureTypesForGroups(true, group);
                for (String type : types) {
                    if (!allfeatures.contains(type)) {
                        allfeatures.add(type);
                    }
                    this.updateMinMax(asq, type, true);
                }
            }
        }
        if (newMadeVisible) {
            for (String type : allfeatures) {
                if (oldfeatures.contains(type)) continue;
                featuresDisplayed.setVisible(type);
                this.setOrder(type, 0.0f);
            }
        }
        this.updateRenderOrder(allfeatures);
        this.findingFeatures = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateMinMax(SequenceI seq, String featureType, boolean positional) {
        float min = seq.getFeatures().getMinimumScore(featureType, positional);
        if (Float.isNaN(min)) {
            return;
        }
        float max = seq.getFeatures().getMaximumScore(featureType, positional);
        if (this.minmax == null) {
            this.minmax = new Hashtable<String, float[][]>();
        }
        Map<String, float[][]> map = this.minmax;
        synchronized (map) {
            int index;
            Object mm = this.minmax.get(featureType);
            int n = index = positional ? 0 : 1;
            if (mm == null) {
                mm = new float[][]{null, null};
                this.minmax.put(featureType, (float[][])mm);
            }
            if (mm[index] == null) {
                mm[index] = new float[]{min, max};
            } else {
                mm[index][0] = Math.min(mm[index][0], min);
                mm[index][1] = Math.max(mm[index][1], max);
            }
        }
    }

    private void updateRenderOrder(List<String> allFeatures) {
        int i;
        ArrayList<String> allfeatures = new ArrayList<String>(allFeatures);
        String[] oldRender = this.renderOrder;
        this.renderOrder = new String[allfeatures.size()];
        boolean initOrders = this.featureOrder == null;
        int opos = 0;
        if (oldRender != null && oldRender.length > 0) {
            for (int j = 0; j < oldRender.length; ++j) {
                FeatureColourI fc;
                float[][] mmrange;
                if (oldRender[j] == null) continue;
                if (initOrders) {
                    this.setOrder(oldRender[j], 1.0f - (1.0f + (float)j) / (float)oldRender.length);
                }
                if (!allfeatures.contains(oldRender[j])) continue;
                this.renderOrder[opos++] = oldRender[j];
                allfeatures.remove(oldRender[j]);
                if (this.minmax == null || (mmrange = this.minmax.get(oldRender[j])) == null || (fc = this.featureColours.get(oldRender[j])) == null || fc.isSimpleColour() || !fc.isAutoScaled() || fc.isColourByAttribute()) continue;
                fc.updateBounds(mmrange[0][0], mmrange[0][1]);
            }
        }
        if (allfeatures.size() == 0) {
            return;
        }
        int iSize = i = allfeatures.size() - 1;
        boolean sort = false;
        Object[] newf = new String[allfeatures.size()];
        float[] sortOrder = new float[allfeatures.size()];
        Iterator iterator = allfeatures.iterator();
        while (iterator.hasNext()) {
            FeatureColourI fc;
            float[][] mmrange;
            String newfeat;
            newf[i] = newfeat = (String)iterator.next();
            if (this.minmax != null && (mmrange = this.minmax.get(newf[i])) != null && (fc = this.featureColours.get(newf[i])) != null && !fc.isSimpleColour() && fc.isAutoScaled() && !fc.isColourByAttribute()) {
                fc.updateBounds(mmrange[0][0], mmrange[0][1]);
            }
            if (initOrders || !this.featureOrder.containsKey(newf[i])) {
                int denom = initOrders ? allfeatures.size() : this.featureOrder.size();
                this.setOrder((String)newf[i], (float)i / (float)denom);
            }
            sortOrder[i] = 2.0f - this.featureOrder.get(newf[i]).floatValue();
            if (i < iSize) {
                sort = sort || sortOrder[i] > sortOrder[i + 1];
            }
            --i;
        }
        if (iSize > 1 && sort) {
            QuickSort.sort(sortOrder, newf);
        }
        sortOrder = null;
        System.arraycopy(newf, 0, this.renderOrder, opos, newf.length);
    }

    @Override
    public FeatureColourI getFeatureStyle(String featureType) {
        FeatureColourI fc = this.featureColours.get(featureType);
        if (fc == null) {
            Color col = ColorUtils.createColourFromName(featureType);
            fc = new FeatureColour(col);
            this.featureColours.put(featureType, fc);
        }
        return fc;
    }

    @Override
    public Color getColour(SequenceFeature feature) {
        FeatureColourI fc = this.getFeatureStyle(feature.getType());
        return this.getColor(feature, fc);
    }

    public boolean showFeatureOfType(String type) {
        return type == null ? false : (this.av.getFeaturesDisplayed() == null ? true : this.av.getFeaturesDisplayed().isVisible(type));
    }

    @Override
    public void setColour(String featureType, FeatureColourI col) {
        this.featureColours.put(featureType, col);
    }

    @Override
    public void setTransparency(float value) {
        this.transparency = value;
    }

    @Override
    public float getTransparency() {
        return this.transparency;
    }

    public float setOrder(String type, float position) {
        if (this.featureOrder == null) {
            this.featureOrder = new Hashtable<String, Float>();
        }
        this.featureOrder.put(type, Float.valueOf(position));
        return position;
    }

    public float getOrder(String type) {
        if (this.featureOrder != null && this.featureOrder.containsKey(type)) {
            return this.featureOrder.get(type).floatValue();
        }
        return -1.0f;
    }

    @Override
    public Map<String, FeatureColourI> getFeatureColours() {
        return this.featureColours;
    }

    public boolean setFeaturePriority(FeatureSettingsBean[] data) {
        return this.setFeaturePriority(data, true);
    }

    public boolean setFeaturePriority(FeatureSettingsBean[] data, boolean visibleNew) {
        List<String> reorderedVisibleFeatures;
        List<String> visibleFeatures = this.getDisplayedFeatureTypes();
        HashMap<String, FeatureColourI> visibleColours = new HashMap<String, FeatureColourI>(this.getFeatureColours());
        FeaturesDisplayedI av_featuresdisplayed = null;
        if (visibleNew) {
            av_featuresdisplayed = this.av.getFeaturesDisplayed();
            if (av_featuresdisplayed != null) {
                this.av.getFeaturesDisplayed().clear();
            } else {
                av_featuresdisplayed = new FeaturesDisplayed();
                this.av.setFeaturesDisplayed(av_featuresdisplayed);
            }
        } else {
            av_featuresdisplayed = this.av.getFeaturesDisplayed();
        }
        if (data == null) {
            return false;
        }
        this.renderOrder = new String[data.length];
        if (data.length > 0) {
            for (int i = 0; i < data.length; ++i) {
                String type = data[i].featureType;
                this.setColour(type, data[i].featureColour);
                if (data[i].show.booleanValue()) {
                    av_featuresdisplayed.setVisible(type);
                }
                this.renderOrder[data.length - i - 1] = type;
            }
        }
        if (!visibleFeatures.equals(reorderedVisibleFeatures = this.getDisplayedFeatureTypes())) {
            return true;
        }
        for (String feature : visibleFeatures) {
            if (visibleColours.get(feature) == this.getFeatureStyle(feature)) continue;
            return true;
        }
        return false;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(listener);
    }

    public Set<String> getAllFeatureColours() {
        return this.featureColours.keySet();
    }

    public void clearRenderOrder() {
        this.renderOrder = null;
    }

    public boolean hasRenderOrder() {
        return this.renderOrder != null;
    }

    public List<String> getRenderOrder() {
        if (this.renderOrder == null) {
            return Arrays.asList(new String[0]);
        }
        return Arrays.asList(this.renderOrder);
    }

    public int getFeatureGroupsSize() {
        return this.featureGroups != null ? 0 : this.featureGroups.size();
    }

    @Override
    public List<String> getFeatureGroups() {
        return this.featureGroups == null ? Arrays.asList(new String[0]) : Arrays.asList(this.featureGroups.keySet().toArray(new String[0]));
    }

    public boolean checkGroupVisibility(String group, boolean newGroupsVisible) {
        if (this.featureGroups == null) {
            // empty if block
        }
        if (this.featureGroups.containsKey(group)) {
            return this.featureGroups.get(group);
        }
        if (newGroupsVisible) {
            this.featureGroups.put(group, true);
            return true;
        }
        return false;
    }

    @Override
    public List<String> getGroups(boolean visible) {
        if (this.featureGroups != null) {
            ArrayList<String> gp = new ArrayList<String>();
            for (String grp : this.featureGroups.keySet()) {
                Boolean state = this.featureGroups.get(grp);
                if (state != visible) continue;
                gp.add(grp);
            }
            return gp;
        }
        return null;
    }

    @Override
    public void setGroupVisibility(String group, boolean visible) {
        this.featureGroups.put(group, visible);
    }

    @Override
    public void setGroupVisibility(List<String> toset, boolean visible) {
        if (toset != null && toset.size() > 0 && this.featureGroups != null) {
            boolean rdrw = false;
            for (String gst : toset) {
                Boolean st = this.featureGroups.get(gst);
                this.featureGroups.put(gst, visible);
                if (st == null) continue;
                rdrw = rdrw || visible != st;
            }
            if (rdrw) {
                // empty if block
            }
        }
    }

    @Override
    public Map<String, FeatureColourI> getDisplayedFeatureCols() {
        Hashtable<String, FeatureColourI> fcols = new Hashtable<String, FeatureColourI>();
        if (this.getViewport().getFeaturesDisplayed() == null) {
            return fcols;
        }
        Set<String> features = this.getViewport().getFeaturesDisplayed().getVisibleFeatures();
        for (String feature : features) {
            fcols.put(feature, this.getFeatureStyle(feature));
        }
        return fcols;
    }

    @Override
    public FeaturesDisplayedI getFeaturesDisplayed() {
        return this.av.getFeaturesDisplayed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getDisplayedFeatureTypes() {
        List<String> typ = this.getRenderOrder();
        ArrayList<String> displayed = new ArrayList<String>();
        FeaturesDisplayedI feature_disp = this.av.getFeaturesDisplayed();
        if (feature_disp != null) {
            FeaturesDisplayedI featuresDisplayedI = feature_disp;
            synchronized (featuresDisplayedI) {
                for (String type : typ) {
                    if (!feature_disp.isVisible(type)) continue;
                    displayed.add(type);
                }
            }
        }
        return displayed;
    }

    @Override
    public List<String> getDisplayedFeatureGroups() {
        ArrayList<String> _gps = new ArrayList<String>();
        for (String gp : this.getFeatureGroups()) {
            if (!this.checkGroupVisibility(gp, false)) continue;
            _gps.add(gp);
        }
        return _gps;
    }

    public boolean featureGroupNotShown(SequenceFeature sequenceFeature) {
        return this.featureGroups != null && sequenceFeature.featureGroup != null && sequenceFeature.featureGroup.length() != 0 && this.featureGroups.containsKey(sequenceFeature.featureGroup) && this.featureGroups.get(sequenceFeature.featureGroup) == false;
    }

    @Override
    public List<SequenceFeature> findFeaturesAtResidue(SequenceI sequence, int fromResNo, int toResNo) {
        ArrayList<SequenceFeature> result = new ArrayList<SequenceFeature>();
        if (!this.av.areFeaturesDisplayed() || this.getFeaturesDisplayed() == null) {
            return result;
        }
        List<String> visibleFeatures = this.getDisplayedFeatureTypes();
        String[] visibleTypes = visibleFeatures.toArray(new String[visibleFeatures.size()]);
        List<SequenceFeature> features = sequence.getFeatures().findFeatures(fromResNo, toResNo, visibleTypes);
        for (SequenceFeature sf : features) {
            if (this.featureGroupNotShown(sf) || this.getColour(sf) == null) continue;
            result.add(sf);
        }
        return result;
    }

    public void filterFeaturesForDisplay(List<SequenceFeature> features) {
        if (Platform.isJS()) {
            return;
        }
        if (features.isEmpty() || this.transparency != 1.0f || !this.featureFilters.isEmpty()) {
            return;
        }
        SequenceFeatures.sortFeatures(features, true);
        SequenceFeature lastFeature = null;
        Iterator<SequenceFeature> it = features.iterator();
        while (it.hasNext()) {
            SequenceFeature sf = it.next();
            if (this.featureGroupNotShown(sf)) {
                it.remove();
                continue;
            }
            if (lastFeature != null && sf.getBegin() == lastFeature.getBegin() && sf.getEnd() == lastFeature.getEnd() && sf.isContactFeature() == lastFeature.isContactFeature() && sf.getType().equals(lastFeature.getType())) {
                it.remove();
            }
            lastFeature = sf;
        }
    }

    @Override
    public Map<String, FeatureMatcherSetI> getFeatureFilters() {
        return this.featureFilters;
    }

    @Override
    public void setFeatureFilters(Map<String, FeatureMatcherSetI> filters) {
        this.featureFilters = filters;
    }

    @Override
    public FeatureMatcherSetI getFeatureFilter(String featureType) {
        return this.featureFilters.get(featureType);
    }

    @Override
    public void setFeatureFilter(String featureType, FeatureMatcherSetI filter) {
        if (filter == null || filter.isEmpty()) {
            this.featureFilters.remove(featureType);
        } else {
            this.featureFilters.put(featureType, filter);
        }
    }

    public Color getColor(SequenceFeature sf, FeatureColourI fc) {
        if (this.featureGroupNotShown(sf)) {
            return null;
        }
        if (!this.featureMatchesFilters(sf)) {
            return null;
        }
        return fc.getColor(sf);
    }

    protected boolean featureMatchesFilters(SequenceFeature sf) {
        FeatureMatcherSetI filter = this.featureFilters.get(sf.getType());
        return filter == null ? true : filter.matches(sf);
    }

    public boolean isGroupVisible(String group) {
        if (!this.featureGroups.containsKey(group)) {
            return true;
        }
        return this.featureGroups.get(group);
    }

    public void orderFeatures(Comparator<String> order) {
        Arrays.sort(this.renderOrder, order);
    }

    @Override
    public MappedFeatures findComplementFeaturesAtResidue(SequenceI sequence, int pos) {
        SequenceI ds = sequence.getDatasetSequence();
        if (ds == null) {
            ds = sequence;
        }
        char residue = ds.getCharAt(pos - ds.getStart());
        ArrayList<SequenceFeature> found = new ArrayList<SequenceFeature>();
        List<AlignedCodonFrame> mappings = this.av.getAlignment().getCodonFrame(sequence);
        if (mappings.isEmpty()) {
            mappings = this.av.getCodingComplement().getAlignment().getCodonFrame(sequence);
        }
        AlignedCodonFrame.SequenceToSequenceMapping mapping = null;
        SequenceI mapFrom = null;
        for (AlignedCodonFrame acf : mappings) {
            mapping = acf.getCoveringCodonMapping(ds);
            if (mapping == null) continue;
            SearchResults sr = new SearchResults();
            mapping.markMappedRegion(ds, pos, sr);
            for (SearchResultMatchI match : sr.getResults()) {
                int fromRes = match.getStart();
                int toRes = match.getEnd();
                mapFrom = match.getSequence();
                List<SequenceFeature> fs = this.findFeaturesAtResidue(mapFrom, fromRes, toRes);
                for (SequenceFeature sf : fs) {
                    if (found.contains(sf)) continue;
                    found.add(sf);
                }
            }
            if (found.isEmpty()) continue;
            break;
        }
        if (found.isEmpty()) {
            return null;
        }
        ArrayList<SequenceFeature> result = new ArrayList<SequenceFeature>();
        int toAdd = found.size();
        int added = 0;
        block3: for (String type : this.renderOrder) {
            for (SequenceFeature sf : found) {
                if (type.equals(sf.getType())) {
                    result.add(sf);
                    ++added;
                }
                if (added != toAdd) continue;
                continue block3;
            }
        }
        return new MappedFeatures(mapping.getMapping(), mapFrom, pos, residue, result);
    }

    @Override
    public boolean isVisible(SequenceFeature feature) {
        if (feature == null) {
            return false;
        }
        if (this.getFeaturesDisplayed() == null || !this.getFeaturesDisplayed().isVisible(feature.getType())) {
            return false;
        }
        if (this.featureGroupNotShown(feature)) {
            return false;
        }
        FeatureColourI fc = this.featureColours.get(feature.getType());
        if (fc != null && fc.isOutwithThreshold(feature)) {
            return false;
        }
        return this.featureMatchesFilters(feature);
    }

    public static class FeatureSettingsBean {
        public final String featureType;
        public final FeatureColourI featureColour;
        public final FeatureMatcherSetI filter;
        public final Boolean show;

        public FeatureSettingsBean(String type, FeatureColourI colour, FeatureMatcherSetI theFilter, Boolean isShown) {
            this.featureType = type;
            this.featureColour = colour;
            this.filter = theFilter;
            this.show = isShown;
        }
    }
}

