/*
 * Decompiled with CFR 0.152.
 */
package jalview.structure;

import jalview.structure.AtomSpecModel;
import jalview.structure.StructureCommand;
import jalview.structure.StructureCommandI;
import jalview.structure.StructureCommandsI;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public abstract class StructureCommandsBase
implements StructureCommandsI {
    public static final String NAMESPACE_PREFIX = "jv_";
    private static final String CMD_SEPARATOR = ";";

    protected String getCommandSeparator() {
        return CMD_SEPARATOR;
    }

    @Override
    public int getModelStartNo() {
        return 0;
    }

    public static final void addAtomSpecRange(Map<Object, AtomSpecModel> map, Object value, String model, int startPos, int endPos, String chain) {
        AtomSpecModel atomSpec = map.get(value);
        if (atomSpec == null) {
            atomSpec = new AtomSpecModel();
            map.put(value, atomSpec);
        }
        atomSpec.addRange(model, startPos, endPos, chain);
    }

    protected String makeAttributeName(String featureType) {
        StringBuilder sb = new StringBuilder();
        if (featureType != null) {
            for (char c : featureType.toCharArray()) {
                sb.append(Character.isLetterOrDigit(c) ? c : (char)'_');
            }
        }
        String attName = NAMESPACE_PREFIX + sb.toString();
        return attName;
    }

    @Override
    public List<StructureCommandI> colourBySequence(Map<Object, AtomSpecModel> colourMap) {
        ArrayList<StructureCommandI> commands = new ArrayList<StructureCommandI>();
        StringBuilder sb = new StringBuilder(colourMap.size() * 20);
        boolean first = true;
        for (Object key : colourMap.keySet()) {
            Color colour = (Color)key;
            AtomSpecModel colourData = colourMap.get(colour);
            StructureCommandI command = this.getColourCommand(colourData, colour);
            if (!first) {
                sb.append(this.getCommandSeparator());
            }
            first = false;
            sb.append(command.getCommand());
        }
        commands.add(new StructureCommand(sb.toString(), new String[0]));
        return commands;
    }

    protected StructureCommandI getColourCommand(AtomSpecModel atomSpecModel, Color colour) {
        String atomSpec = this.getAtomSpec(atomSpecModel, StructureCommandsI.AtomSpecType.RESIDUE_ONLY);
        return this.colourResidues(atomSpec, colour);
    }

    protected abstract StructureCommandI colourResidues(String var1, Color var2);

    @Override
    public List<StructureCommandI> colourByResidues(Map<String, Color> colours) {
        ArrayList<StructureCommandI> commands = new ArrayList<StructureCommandI>();
        for (Map.Entry<String, Color> entry : colours.entrySet()) {
            commands.add(this.colourResidue(entry.getKey(), entry.getValue()));
        }
        return commands;
    }

    private StructureCommandI colourResidue(String resName, Color col) {
        String atomSpec = this.getResidueSpec(resName);
        return this.colourResidues(atomSpec, col);
    }

    protected void appendRange(StringBuilder sb, int start, int end, String chain, boolean firstPositionForModel, boolean isChimeraX) {
        if (!firstPositionForModel) {
            sb.append(",");
        }
        if (end == start) {
            sb.append(start);
        } else {
            sb.append(start).append("-").append(end);
        }
        if (!isChimeraX) {
            sb.append(".");
            if (!" ".equals(chain)) {
                sb.append(chain);
            }
        }
    }

    protected abstract String getResidueSpec(String var1);

    @Override
    public List<StructureCommandI> setAttributes(Map<String, Map<Object, AtomSpecModel>> featureValues) {
        return null;
    }

    @Override
    public List<StructureCommandI> startNotifications(String uri) {
        return null;
    }

    @Override
    public List<StructureCommandI> stopNotifications() {
        return null;
    }

    @Override
    public StructureCommandI getSelectedResidues() {
        return null;
    }

    @Override
    public StructureCommandI listResidueAttributes() {
        return null;
    }

    @Override
    public StructureCommandI getResidueAttributes(String attName) {
        return null;
    }

    @Override
    public StructureCommandI restoreSession(String filePath) {
        return this.loadFile(filePath);
    }
}

