/*
 * Decompiled with CFR 0.152.
 */
package jalview.renderer;

import jalview.analysis.AlignmentUtils;
import jalview.analysis.Conservation;
import jalview.api.ViewStyleI;
import jalview.datamodel.AnnotatedCollectionI;
import jalview.datamodel.ProfileI;
import jalview.datamodel.ProfilesI;
import jalview.datamodel.SequenceCollectionI;
import jalview.datamodel.SequenceI;
import jalview.renderer.ResidueShaderI;
import jalview.schemes.ColourSchemeI;
import jalview.util.ColorUtils;
import jalview.util.Comparison;
import java.awt.Color;
import java.util.Map;

public class ResidueShader
implements ResidueShaderI {
    private static final int INITIAL_CONSERVATION = 30;
    private ColourSchemeI colourScheme;
    private ProfilesI consensus;
    private Map<String, ProfilesI> ssConsensusProfileMap;
    private boolean conservationColouring;
    private boolean consensusSecondaryStructureColouring;
    private char[] conservation;
    private int pidThreshold;
    private boolean ignoreGaps;
    private int conservationIncrement = 30;
    private int consensusSecondaryStructureThreshold = 30;

    @Override
    public boolean isConsensusSecondaryStructureColouring() {
        return this.consensusSecondaryStructureColouring;
    }

    public ResidueShader(ColourSchemeI cs) {
        this.colourScheme = cs;
    }

    public ResidueShader() {
    }

    public ResidueShader(ViewStyleI viewStyle) {
        this();
        this.setConservationApplied(viewStyle.isConservationColourSelected());
    }

    public ResidueShader(ResidueShader rs) {
        this.colourScheme = rs.colourScheme;
        this.consensus = rs.consensus;
        this.conservation = rs.conservation;
        this.conservationColouring = rs.conservationColouring;
        this.conservationIncrement = rs.conservationIncrement;
        this.ignoreGaps = rs.ignoreGaps;
        this.pidThreshold = rs.pidThreshold;
        this.ssConsensusProfileMap = rs.ssConsensusProfileMap;
        this.consensusSecondaryStructureColouring = rs.consensusSecondaryStructureColouring;
        this.consensusSecondaryStructureThreshold = rs.consensusSecondaryStructureThreshold;
    }

    @Override
    public void setConsensus(ProfilesI cons) {
        this.consensus = cons;
    }

    @Override
    public boolean conservationApplied() {
        return this.conservationColouring;
    }

    @Override
    public void setConservationApplied(boolean conservationApplied) {
        this.conservationColouring = conservationApplied;
    }

    @Override
    public void setConservation(Conservation cons) {
        if (cons == null) {
            this.conservationColouring = false;
            this.conservation = null;
        } else {
            this.conservationColouring = true;
            this.conservation = cons.getConsSequence().getSequenceAsString().toCharArray();
        }
    }

    @Override
    public void setConsensusSecondaryStructureColouring(boolean colourByConsensusSecondaryStructure) {
        this.consensusSecondaryStructureColouring = colourByConsensusSecondaryStructure;
    }

    @Override
    public void alignmentChanged(AnnotatedCollectionI alignment, Map<SequenceI, SequenceCollectionI> hiddenReps) {
        if (this.colourScheme != null) {
            this.colourScheme.alignmentChanged(alignment, hiddenReps);
        }
    }

    @Override
    public void setThreshold(int consensusThreshold, boolean ignoreGaps) {
        this.pidThreshold = consensusThreshold;
        this.ignoreGaps = ignoreGaps;
    }

    @Override
    public void setConservationInc(int i) {
        this.conservationIncrement = i;
    }

    @Override
    public int getConservationInc() {
        return this.conservationIncrement;
    }

    @Override
    public void setConsensusSecondaryStructureThreshold(int i) {
        this.consensusSecondaryStructureThreshold = i;
    }

    @Override
    public int getConsensusSecondaryStructureThreshold() {
        return this.consensusSecondaryStructureThreshold;
    }

    @Override
    public int getThreshold() {
        return this.pidThreshold;
    }

    @Override
    public Color findColour(char symbol, int position, SequenceI seq) {
        if (this.colourScheme == null) {
            return Color.white;
        }
        ProfileI profile = this.consensus == null ? null : this.consensus.get(position);
        String modalResidue = profile == null ? null : profile.getModalResidue();
        float pid = profile == null ? 0.0f : profile.getPercentageIdentity(this.ignoreGaps);
        Color colour = this.colourScheme.findColour(symbol, position, seq, modalResidue, pid);
        if (!Comparison.isGap(symbol)) {
            colour = this.adjustColour(symbol, position, colour, false);
        }
        return colour;
    }

    @Override
    public Color findSSColour(char symbol, int position) {
        if (this.colourScheme == null) {
            return Color.white;
        }
        Color colour = AlignmentUtils.getSecondaryStructureAnnotationColour(symbol);
        if (!Comparison.isGap(symbol)) {
            colour = this.adjustColour(symbol, position, colour, true);
        }
        return colour;
    }

    protected Color adjustColour(char symbol, int column, Color colour, boolean isSecondaryStructure) {
        if (!isSecondaryStructure && !this.aboveThreshold(symbol, column)) {
            colour = Color.white;
        }
        if (this.consensusSecondaryStructureColouring) {
            colour = this.applyByConsensusSecondaryStructure(colour, column);
        }
        if (this.conservationColouring) {
            colour = this.applyConservation(colour, column);
        }
        return colour;
    }

    protected boolean aboveThreshold(char residue, int column) {
        if (this.pidThreshold == 0) {
            return true;
        }
        if ('a' <= residue && residue <= 'z') {
            residue = (char)(residue - 32);
        }
        if (this.consensus == null) {
            return false;
        }
        ProfileI profile = this.consensus.get(column);
        return profile != null && profile.getModalResidue().contains(String.valueOf(residue)) && profile.getPercentageIdentity(this.ignoreGaps) >= (float)this.pidThreshold;
    }

    protected Color applyConservation(Color currentColour, int column) {
        if (this.conservation == null || this.conservation.length <= column) {
            return currentColour;
        }
        char conservationScore = this.conservation[column];
        if (conservationScore == '*' || conservationScore == '+' || conservationScore == '\n' || conservationScore == '\u000b') {
            return currentColour;
        }
        if (Comparison.isGap(conservationScore)) {
            return Color.white;
        }
        float bleachFactor = (float)(11 - (conservationScore - 48)) / 10.0f;
        return ColorUtils.bleachColour(currentColour, bleachFactor *= (float)this.conservationIncrement / 20.0f);
    }

    protected Color applyByConsensusSecondaryStructure(Color currentColour, int column) {
        if (this.ssConsensusProfileMap == null && this.ssConsensusProfileMap.get("All") == null) {
            return currentColour;
        }
        ProfilesI consensusSSProfileForAllSources = this.ssConsensusProfileMap.get("All");
        ProfileI profile = consensusSSProfileForAllSources.get(column);
        if (profile != null) {
            float pid = profile.getSSPercentageIdentity(this.ignoreGaps);
            if (pid == 0.0f) {
                return Color.white;
            }
            float bleachFactor = 1.0f - pid / 100.0f;
            return ColorUtils.bleachColour(currentColour, bleachFactor *= (float)(this.consensusSecondaryStructureThreshold / 20));
        }
        return currentColour;
    }

    @Override
    public ColourSchemeI getColourScheme() {
        return this.colourScheme;
    }

    @Override
    public void setColourScheme(ColourSchemeI cs) {
        this.colourScheme = cs;
    }

    public Map<String, ProfilesI> getSSConsensusProfileMap() {
        return this.ssConsensusProfileMap;
    }

    @Override
    public void setSSConsensusProfileMap(Map<String, ProfilesI> ssConsensusProfileMap) {
        this.ssConsensusProfileMap = ssConsensusProfileMap;
    }
}

