/*
 * Decompiled with CFR 0.152.
 */
package jalview.datamodel;

import jalview.analysis.Rna;
import jalview.analysis.SecStrConsensus;
import jalview.analysis.WUSSParseException;
import jalview.datamodel.Annotation;
import jalview.datamodel.GraphLine;
import jalview.datamodel.HiddenColumns;
import jalview.datamodel.Mapping;
import jalview.datamodel.SFSortByEnd;
import jalview.datamodel.SequenceFeature;
import jalview.datamodel.SequenceGroup;
import jalview.datamodel.SequenceI;
import jalview.datamodel.VisibleContigsIterator;
import jalview.schemes.ResidueProperties;
import jalview.structure.StructureImportSettings;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class AlignmentAnnotation {
    private static final String ANNOTATION_ID_PREFIX = "ann";
    public static final int SEQUENCE_PROFILE = 0;
    public static final int STRUCTURE_PROFILE = 1;
    public static final int CDNA_PROFILE = 2;
    private static long counter = 0L;
    private long noOfSequencesIncluded = -1L;
    public boolean autoCalculated = false;
    public String annotationId;
    public SequenceI sequenceRef;
    public String label;
    public String description;
    public Annotation[] annotations;
    public List<SecStrConsensus.SimpleBP> bps = null;
    public SequenceFeature[] _rnasecstr = null;
    private long invalidrnastruc = -2L;
    private StructureImportSettings.TFType tfType = StructureImportSettings.TFType.DEFAULT;
    private Color annotationGroupColour = null;
    private Map<Integer, Annotation> sequenceMapping;
    public float graphMin;
    public float graphMax;
    public double score = Double.NaN;
    public boolean hasScore = false;
    public GraphLine threshold;
    public boolean editable = false;
    public boolean hasIcons;
    public boolean hasText;
    public boolean visible = true;
    public boolean hasData = true;
    public int graphGroup = -1;
    public int height = 0;
    public int graph = 0;
    public int graphHeight = 40;
    public boolean padGaps = false;
    public static final int NO_GRAPH = 0;
    public static final int BAR_GRAPH = 1;
    public static final int LINE_GRAPH = 2;
    public static final int CONTACT_MAP = 4;
    public static final String CONTACT_MAP_NOGROUPS = "CMNOGRPS";
    public boolean belowAlignment = true;
    public SequenceGroup groupRef = null;
    public boolean showAllColLabels = false;
    public boolean scaleColLabel = false;
    public boolean centreColLabels = false;
    private boolean isrna;
    private long _lastrnaannot = -1L;
    protected String calcId = "";
    protected Map<String, String> properties = new HashMap<String, String>();
    public Color _linecolour;

    public void setTFType(StructureImportSettings.TFType t) {
        this.tfType = t;
    }

    public StructureImportSettings.TFType getTFType() {
        return this.tfType;
    }

    private void _updateRnaSecStr(CharSequence rnaAnnotation) {
        try {
            this._rnasecstr = Rna.getHelixMap(rnaAnnotation);
            this.invalidrnastruc = -1L;
        }
        catch (WUSSParseException px) {
            this.invalidrnastruc = px.getProblemPos();
        }
        if (this.invalidrnastruc > -1L) {
            return;
        }
        if (this._rnasecstr != null && this._rnasecstr.length > 0) {
            this.isrna = true;
            this.showAllColLabels = true;
            this.scaleColLabel = true;
            this._markRnaHelices();
        }
    }

    private void _markRnaHelices() {
        int mxval = 0;
        for (int x = 0; x < this._rnasecstr.length; ++x) {
            int val = 0;
            try {
                val = Integer.valueOf(this._rnasecstr[x].getFeatureGroup());
                if (mxval < val) {
                    mxval = val;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.annotations[this._rnasecstr[x].getBegin()].value = val;
            this.annotations[this._rnasecstr[x].getEnd()].value = val;
        }
        this.setScore(mxval);
    }

    public Color getAnnotationGroupColour() {
        return this.annotationGroupColour;
    }

    public void setAnnotationGroupColour(Color annotationGroupColour) {
        this.annotationGroupColour = annotationGroupColour;
    }

    public SequenceFeature[] getRnaSecondaryStructure() {
        return this._rnasecstr;
    }

    public boolean rnaSecondaryStructureEquivalent(AlignmentAnnotation that) {
        return this.rnaSecondaryStructureEquivalent(that, true);
    }

    public boolean rnaSecondaryStructureEquivalent(AlignmentAnnotation that, boolean compareType) {
        SequenceFeature[] thisSfArray = this.getRnaSecondaryStructure();
        SequenceFeature[] thatSfArray = that.getRnaSecondaryStructure();
        if (thisSfArray == null || thatSfArray == null) {
            return thisSfArray == null && thatSfArray == null;
        }
        if (thisSfArray.length != thatSfArray.length) {
            return false;
        }
        Arrays.sort(thisSfArray, new SFSortByEnd());
        Arrays.sort(thatSfArray, new SFSortByEnd());
        for (int i = 0; i < thisSfArray.length; ++i) {
            SequenceFeature thisSf = thisSfArray[i];
            SequenceFeature thatSf = thatSfArray[i];
            if (compareType) {
                if (thisSf.getType() == null || thatSf.getType() == null) {
                    if (thisSf.getType() == null && thatSf.getType() == null) continue;
                    return false;
                }
                if (!thisSf.getType().equals(thatSf.getType())) {
                    return false;
                }
            }
            if (thisSf.getBegin() == thatSf.getBegin() && thisSf.getEnd() == thatSf.getEnd()) continue;
            return false;
        }
        return true;
    }

    public static int getGraphValueFromString(String string) {
        if (string.equalsIgnoreCase("BAR_GRAPH")) {
            return 1;
        }
        if (string.equalsIgnoreCase("LINE_GRAPH")) {
            return 2;
        }
        return 0;
    }

    public AlignmentAnnotation(String label, String description, Annotation[] annotations) {
        this.setAnnotationId();
        this.editable = true;
        this.label = label;
        this.description = description;
        this.annotations = annotations;
        this.validateRangeAndDisplay();
    }

    void areLabelsSecondaryStructure() {
        boolean nonSSLabel = false;
        this.isrna = false;
        StringBuffer rnastring = new StringBuffer();
        char firstChar = '\u0000';
        for (int i = 0; i < this.annotations.length; ++i) {
            if (this.annotations[i] == null) continue;
            if (this.annotations[i].secondaryStructure == 'H' || this.annotations[i].secondaryStructure == 'E') {
                this.hasIcons |= true;
            } else if (this.annotations[i].secondaryStructure == '(' || this.annotations[i].secondaryStructure == '[' || this.annotations[i].secondaryStructure == '<' || this.annotations[i].secondaryStructure == '{' || this.annotations[i].secondaryStructure == 'A' || this.annotations[i].secondaryStructure == 'D' || this.annotations[i].secondaryStructure == 'F' || this.annotations[i].secondaryStructure == 'J' || this.annotations[i].secondaryStructure == 'K' || this.annotations[i].secondaryStructure == 'L' || this.annotations[i].secondaryStructure == 'M' || this.annotations[i].secondaryStructure == 'N' || this.annotations[i].secondaryStructure == 'O' || this.annotations[i].secondaryStructure == 'P' || this.annotations[i].secondaryStructure == 'Q' || this.annotations[i].secondaryStructure == 'R' || this.annotations[i].secondaryStructure == 'U' || this.annotations[i].secondaryStructure == 'V' || this.annotations[i].secondaryStructure == 'W' || this.annotations[i].secondaryStructure == 'Y' || this.annotations[i].secondaryStructure == 'Z') {
                this.hasIcons |= true;
                this.isrna |= true;
            }
            if (this.annotations[i].displayCharacter == null || this.annotations[i].displayCharacter.length() == 0) {
                rnastring.append('.');
                continue;
            }
            if (this.annotations[i].displayCharacter.length() == 1) {
                firstChar = this.annotations[i].displayCharacter.charAt(0);
                if (this.annotations[i].secondaryStructure != ' ' && !this.hasIcons && firstChar != ' ' && firstChar != '$' && firstChar != '\u00ce' && firstChar != '(' && firstChar != '[' && firstChar != '<' && firstChar != '{' && firstChar != 'A' && firstChar != 'B' && firstChar != 'C' && firstChar != 'D' && firstChar != 'E' && firstChar != 'F' && firstChar != 'G' && firstChar != 'H' && firstChar != 'I' && firstChar != 'J' && firstChar != 'K' && firstChar != 'L' && firstChar != 'M' && firstChar != 'N' && firstChar != 'O' && firstChar != 'P' && firstChar != 'Q' && firstChar != 'R' && firstChar != 'S' && firstChar != 'T' && firstChar != 'U' && firstChar != 'V' && firstChar != 'W' && firstChar != 'X' && firstChar != 'Y' && firstChar != 'Z' && firstChar != '-' && firstChar < ResidueProperties.aaIndex.length && ResidueProperties.aaIndex[firstChar] < 23) {
                    nonSSLabel = true;
                }
            } else {
                rnastring.append(this.annotations[i].displayCharacter.charAt(1));
            }
            if (this.annotations[i].displayCharacter.length() <= 0) continue;
            this.hasText = true;
        }
        if (nonSSLabel) {
            this.hasIcons = false;
            for (int j = 0; j < this.annotations.length; ++j) {
                if (this.annotations[j] == null || this.annotations[j].secondaryStructure == ' ') continue;
                this.annotations[j].displayCharacter = String.valueOf(this.annotations[j].secondaryStructure);
                this.annotations[j].secondaryStructure = (char)32;
            }
        } else if (this.isrna) {
            this._updateRnaSecStr(new AnnotCharSequence());
        }
    }

    public String getRNAStruc() {
        if (this.isrna) {
            String rnastruc = new AnnotCharSequence().toString();
            if (this._lastrnaannot != (long)rnastruc.hashCode()) {
                this._lastrnaannot = rnastruc.hashCode();
                this._updateRnaSecStr(rnastruc);
            }
            return rnastruc;
        }
        return null;
    }

    public AlignmentAnnotation(String label, String description, Annotation[] annotations, float min, float max, int graphType) {
        this.setAnnotationId();
        this.editable = graphType == 0;
        this.label = label;
        this.description = description;
        this.annotations = annotations;
        this.graph = graphType;
        this.graphMin = min;
        this.graphMax = max;
        this.validateRangeAndDisplay();
    }

    public void validateRangeAndDisplay() {
        int i;
        if (this.annotations == null) {
            this.visible = false;
            this.invalidrnastruc = -1L;
            return;
        }
        int graphType = this.graph;
        float min = this.graphMin;
        float max = this.graphMax;
        boolean drawValues = true;
        this._linecolour = null;
        if (min == max) {
            min = 1.0E9f;
            for (i = 0; i < this.annotations.length; ++i) {
                if (this.annotations[i] == null) continue;
                if (drawValues && this.annotations[i].displayCharacter != null && this.annotations[i].displayCharacter.length() > 1) {
                    drawValues = false;
                }
                if (this.annotations[i].value > max) {
                    max = this.annotations[i].value;
                }
                if (this.annotations[i].value < min) {
                    min = this.annotations[i].value;
                }
                if (this._linecolour != null || this.annotations[i].colour == null) continue;
                this._linecolour = this.annotations[i].colour;
            }
            if (min > 0.0f) {
                min = 0.0f;
            } else if (max < 0.0f) {
                max = 0.0f;
            }
        }
        this.graphMin = min;
        this.graphMax = max;
        this.areLabelsSecondaryStructure();
        if (!drawValues && graphType != 0) {
            for (i = 0; i < this.annotations.length; ++i) {
                if (this.annotations[i] == null) continue;
                this.annotations[i].displayCharacter = "";
            }
        }
    }

    public AlignmentAnnotation(AlignmentAnnotation annotation) {
        this.setAnnotationId();
        this.label = new String(annotation.label);
        if (annotation.description != null) {
            this.description = new String(annotation.description);
        }
        this.graphMin = annotation.graphMin;
        this.graphMax = annotation.graphMax;
        this.graph = annotation.graph;
        this.graphHeight = annotation.graphHeight;
        this.graphGroup = annotation.graphGroup;
        this.groupRef = annotation.groupRef;
        this.editable = annotation.editable;
        this.autoCalculated = annotation.autoCalculated;
        this.hasIcons = annotation.hasIcons;
        this.hasText = annotation.hasText;
        this.height = annotation.height;
        this.label = annotation.label;
        this.padGaps = annotation.padGaps;
        this.visible = annotation.visible;
        this.hasData = annotation.hasData;
        this.centreColLabels = annotation.centreColLabels;
        this.scaleColLabel = annotation.scaleColLabel;
        this.showAllColLabels = annotation.showAllColLabels;
        this.calcId = annotation.calcId;
        if (annotation.properties != null) {
            this.properties = new HashMap<String, String>();
            for (Map.Entry<String, String> val : annotation.properties.entrySet()) {
                this.properties.put(val.getKey(), val.getValue());
            }
        }
        if (this.hasScore = annotation.hasScore) {
            this.score = annotation.score;
        }
        if (annotation.threshold != null) {
            this.threshold = new GraphLine(annotation.threshold);
        }
        Annotation[] ann = annotation.annotations;
        if (annotation.annotations != null) {
            this.annotations = new Annotation[ann.length];
            for (int i = 0; i < ann.length; ++i) {
                if (ann[i] == null) continue;
                this.annotations[i] = new Annotation(ann[i]);
                if (this._linecolour == null) continue;
                this._linecolour = this.annotations[i].colour;
            }
        }
        if (annotation.sequenceRef != null) {
            this.sequenceRef = annotation.sequenceRef;
            if (annotation.sequenceMapping != null) {
                Integer p2 = null;
                this.sequenceMapping = new HashMap<Integer, Annotation>();
                for (Integer p2 : annotation.sequenceMapping.keySet()) {
                    Annotation a = annotation.sequenceMapping.get(p2);
                    if (a == null || ann == null) continue;
                    for (int i = 0; i < ann.length; ++i) {
                        if (ann[i] != a) continue;
                        this.sequenceMapping.put(p2, this.annotations[i]);
                    }
                }
            } else {
                this.sequenceMapping = null;
            }
        }
        this.validateRangeAndDisplay();
    }

    public void restrict(int startRes, int endRes) {
        if (this.annotations == null) {
            return;
        }
        if (startRes < 0) {
            startRes = 0;
        }
        if (startRes >= this.annotations.length) {
            startRes = this.annotations.length - 1;
        }
        if (endRes >= this.annotations.length) {
            endRes = this.annotations.length - 1;
        }
        if (this.annotations == null) {
            return;
        }
        Annotation[] temp = new Annotation[endRes - startRes + 1];
        if (startRes < this.annotations.length) {
            System.arraycopy(this.annotations, startRes, temp, 0, endRes - startRes + 1);
        }
        if (this.sequenceRef != null) {
            int spos = this.sequenceRef.findPosition(startRes);
            int epos = this.sequenceRef.findPosition(endRes);
            if (this.sequenceMapping != null) {
                HashMap<Integer, Annotation> newmapping = new HashMap<Integer, Annotation>();
                for (Integer pos : this.sequenceMapping.keySet()) {
                    if (pos < spos || pos > epos) continue;
                    newmapping.put(pos, this.sequenceMapping.get(pos));
                }
                this.sequenceMapping.clear();
                this.sequenceMapping = newmapping;
            }
        }
        this.annotations = temp;
    }

    public boolean padAnnotation(int length) {
        if (this.annotations == null) {
            return true;
        }
        if (this.annotations.length < length) {
            Annotation[] na = new Annotation[length];
            System.arraycopy(this.annotations, 0, na, 0, this.annotations.length);
            this.annotations = na;
            return true;
        }
        return this.annotations.length > length;
    }

    public String toString() {
        int i;
        if (this.annotations == null) {
            return "";
        }
        StringBuilder buffer = new StringBuilder(256);
        for (i = 0; i < this.annotations.length; ++i) {
            if (this.annotations[i] != null) {
                if (this.graph != 0) {
                    buffer.append(this.annotations[i].value);
                } else if (this.hasIcons) {
                    buffer.append(this.annotations[i].secondaryStructure);
                } else {
                    buffer.append(this.annotations[i].displayCharacter);
                }
            }
            buffer.append(", ");
        }
        if (this.label.indexOf("Consensus") == 0) {
            buffer.append("\n");
            for (i = 0; i < this.annotations.length; ++i) {
                if (this.annotations[i] != null) {
                    buffer.append(this.annotations[i].description);
                }
                buffer.append(", ");
            }
        }
        return buffer.toString();
    }

    public void setThreshold(GraphLine line) {
        this.threshold = line;
    }

    public GraphLine getThreshold() {
        return this.threshold;
    }

    public void createSequenceMapping(SequenceI seqRef, int startRes, boolean alreadyMapped) {
        if (seqRef == null) {
            return;
        }
        this.sequenceRef = seqRef;
        if (this.annotations == null) {
            return;
        }
        this.sequenceMapping = new HashMap<Integer, Annotation>();
        for (int i = 0; i < this.annotations.length; ++i) {
            if (this.annotations[i] == null) continue;
            int seqPos = alreadyMapped ? seqRef.findPosition(i) : i + startRes;
            this.sequenceMapping.put(seqPos, this.annotations[i]);
        }
    }

    public void adjustForAlignment() {
        if (this.sequenceRef == null) {
            return;
        }
        if (this.annotations == null) {
            return;
        }
        int a = 0;
        int aSize = this.sequenceRef.getLength();
        if (aSize == 0) {
            return;
        }
        Annotation[] temp = new Annotation[aSize];
        if (this.sequenceMapping != null) {
            for (a = this.sequenceRef.getStart(); a <= this.sequenceRef.getEnd(); ++a) {
                Integer index = a;
                Annotation annot = this.sequenceMapping.get(index);
                if (annot == null) continue;
                int position = this.sequenceRef.findIndex(a) - 1;
                temp[position] = annot;
            }
        }
        this.annotations = temp;
    }

    public int compactAnnotationArray() {
        int i = 0;
        int iSize = this.annotations.length;
        while (i < iSize) {
            if (this.annotations[i] == null) {
                if (i + 1 < iSize) {
                    System.arraycopy(this.annotations, i + 1, this.annotations, i, iSize - i - 1);
                }
                --iSize;
                continue;
            }
            ++i;
        }
        Annotation[] ann = this.annotations;
        this.annotations = new Annotation[i];
        System.arraycopy(ann, 0, this.annotations, 0, i);
        ann = null;
        return iSize;
    }

    public void setSequenceRef(SequenceI sequenceI) {
        if (sequenceI != null) {
            if (this.sequenceRef != null) {
                boolean tIsDs;
                boolean rIsDs = this.sequenceRef.getDatasetSequence() == null;
                boolean bl = tIsDs = sequenceI.getDatasetSequence() == null;
                if (!(this.sequenceRef == sequenceI || !rIsDs || tIsDs || this.sequenceRef == sequenceI.getDatasetSequence() || rIsDs || !tIsDs || this.sequenceRef.getDatasetSequence() == sequenceI || rIsDs || tIsDs || this.sequenceRef.getDatasetSequence() == sequenceI.getDatasetSequence() || this.sequenceRef.equals(sequenceI))) {
                    this.sequenceRef = null;
                    if (this.sequenceMapping != null) {
                        this.sequenceMapping = null;
                    }
                    this.createSequenceMapping(sequenceI, 1, true);
                    this.adjustForAlignment();
                } else {
                    this.sequenceRef = sequenceI;
                }
            } else {
                this.createSequenceMapping(sequenceI, 1, true);
                this.adjustForAlignment();
            }
        } else {
            this.sequenceMapping = null;
            this.sequenceRef = null;
        }
    }

    public double getScore() {
        return this.score;
    }

    public void setScore(double score) {
        this.hasScore = true;
        this.score = score;
    }

    public boolean hasScore() {
        return this.hasScore || !Double.isNaN(this.score);
    }

    public AlignmentAnnotation(String label, String description, double score) {
        this(label, description, null);
        this.setScore(score);
    }

    public AlignmentAnnotation(AlignmentAnnotation alignmentAnnotation, HiddenColumns hidden) {
        this(alignmentAnnotation);
        if (this.annotations == null) {
            return;
        }
        this.makeVisibleAnnotation(hidden);
    }

    public void setPadGaps(boolean padgaps, char gapchar) {
        this.padGaps = padgaps;
        if (padgaps) {
            this.hasText = true;
            for (int i = 0; i < this.annotations.length; ++i) {
                if (this.annotations[i] == null) {
                    this.annotations[i] = new Annotation(String.valueOf(gapchar), null, ' ', 0.0f, null);
                    continue;
                }
                if (this.annotations[i].displayCharacter != null && !this.annotations[i].displayCharacter.equals(" ")) continue;
                this.annotations[i].displayCharacter = String.valueOf(gapchar);
            }
        }
    }

    public String getDescription(boolean seqname) {
        if (seqname && this.sequenceRef != null) {
            int i = this.description.toLowerCase(Locale.ROOT).indexOf("<html>");
            if (i > -1) {
                return "<html>" + this.sequenceRef.getName() + " : " + this.description.substring(i + 6);
            }
            return this.sequenceRef.getName() + " : " + this.description;
        }
        return this.description;
    }

    public boolean isValidStruc() {
        return this.invalidrnastruc == -1L;
    }

    public long getInvalidStrucPos() {
        return this.invalidrnastruc;
    }

    public String getCalcId() {
        return this.calcId;
    }

    public void setCalcId(String calcId) {
        this.calcId = calcId;
    }

    public boolean isRNA() {
        return this.isrna;
    }

    public void liftOver(SequenceI sq, Mapping sp2sq) {
        if (sp2sq.getMappedWidth() != sp2sq.getWidth()) {
            throw new Error("liftOver currently not implemented for transfer of annotation between different types of seqeunce");
        }
        boolean mapIsTo = sp2sq != null ? sp2sq.getTo() == sq || sp2sq.getTo() == sq.getDatasetSequence() : false;
        HashMap<Integer, Annotation> mapForsq = new HashMap<Integer, Annotation>();
        if (this.sequenceMapping != null && sp2sq != null) {
            for (Map.Entry<Integer, Annotation> ie : this.sequenceMapping.entrySet()) {
                Integer mpos = mapIsTo ? sp2sq.getMappedPosition(ie.getKey()) : sp2sq.getPosition(ie.getKey());
                if (mpos < sq.getStart() || mpos > sq.getEnd()) continue;
                mapForsq.put(mpos, ie.getValue());
            }
            this.sequenceMapping = mapForsq;
            this.sequenceRef = sq;
            this.adjustForAlignment();
        }
    }

    public void remap(SequenceI newref, HashMap<Integer, int[]> mapping, int from, int to, int idxoffset) {
        if (mapping != null) {
            Map<Integer, Annotation> old = this.sequenceMapping;
            HashMap<Integer, Annotation> remap = new HashMap<Integer, Annotation>();
            int index = -1;
            for (int[] mp : mapping.values()) {
                if (index++ < 0) continue;
                Annotation ann = null;
                if (from == -1) {
                    ann = this.sequenceMapping.get(idxoffset + index);
                } else if (mp != null && mp.length > from) {
                    ann = this.sequenceMapping.get(mp[from]);
                }
                if (ann == null) continue;
                if (to == -1) {
                    remap.put(idxoffset + index, ann);
                    continue;
                }
                if (to <= -1 || to >= mp.length) continue;
                remap.put(mp[to], ann);
            }
            this.sequenceMapping = remap;
            old.clear();
            if (newref != null) {
                this.sequenceRef = newref;
            }
            this.adjustForAlignment();
        }
    }

    public String getProperty(String property) {
        if (this.properties == null) {
            return null;
        }
        return this.properties.get(property);
    }

    public void setProperty(String property, String value) {
        if (this.properties == null) {
            this.properties = new HashMap<String, String>();
        }
        this.properties.put(property, value);
    }

    public boolean hasProperties() {
        return this.properties != null && this.properties.size() > 0;
    }

    public Collection<String> getProperties() {
        if (this.properties == null) {
            return Collections.emptyList();
        }
        return this.properties.keySet();
    }

    public Annotation getAnnotationForPosition(int position) {
        return this.sequenceMapping == null ? null : this.sequenceMapping.get(position);
    }

    protected final void setAnnotationId() {
        this.annotationId = ANNOTATION_ID_PREFIX + Long.toString(AlignmentAnnotation.nextId());
    }

    public String getDefaultRnaHelixSymbol(int column) {
        String result = "(";
        if (this.annotations == null) {
            return result;
        }
        for (int col = column - 1; col >= 0; --col) {
            char symbol;
            String displayed;
            Annotation annotation = this.annotations[col];
            if (annotation == null || (displayed = annotation.displayCharacter) == null || displayed.length() != 1 || !Rna.isOpeningParenthesis(symbol = displayed.charAt(0))) continue;
            String closer = String.valueOf(Rna.getMatchingClosingParenthesis(symbol));
            String opener = String.valueOf(symbol);
            int count = 0;
            for (int j = col + 1; j < column; ++j) {
                if (this.annotations[j] == null) continue;
                String s = this.annotations[j].displayCharacter;
                if (closer.equals(s)) {
                    ++count;
                    continue;
                }
                if (!opener.equals(s)) continue;
                --count;
            }
            if (count >= true) continue;
            return closer;
        }
        return result;
    }

    protected static synchronized long nextId() {
        return counter++;
    }

    public boolean isQuantitative() {
        return this.graphMin < this.graphMax;
    }

    public boolean isForDisplay() {
        return this.hasData && this.visible;
    }

    public void makeVisibleAnnotation(HiddenColumns hiddenColumns) {
        if (this.annotations != null) {
            this.makeVisibleAnnotation(0, this.annotations.length, hiddenColumns);
        }
    }

    public void makeVisibleAnnotation(int start, int end, HiddenColumns hiddenColumns) {
        if (this.annotations != null) {
            if (hiddenColumns.hasHiddenColumns()) {
                this.removeHiddenAnnotation(start, end, hiddenColumns);
            } else {
                this.restrict(start, end);
            }
        }
    }

    private void removeHiddenAnnotation(int start, int end, HiddenColumns hiddenColumns) {
        ArrayList<Annotation[]> annels = new ArrayList<Annotation[]>();
        Annotation[] els = null;
        int w = 0;
        VisibleContigsIterator blocks = hiddenColumns.getVisContigsIterator(start, end + 1, false);
        while (blocks.hasNext()) {
            int[] block = (int[])blocks.next();
            int annotationLength = block[1] - block[0] + 1;
            int copylength = blocks.hasNext() ? annotationLength : (annotationLength + block[0] <= this.annotations.length ? annotationLength : this.annotations.length - block[0]);
            els = new Annotation[annotationLength];
            annels.add(els);
            System.arraycopy(this.annotations, block[0], els, 0, copylength);
            w += annotationLength;
        }
        if (w != 0) {
            this.annotations = new Annotation[w];
            w = 0;
            for (Annotation[] chnk : annels) {
                System.arraycopy(chnk, 0, this.annotations, w, chnk.length);
                w += chnk.length;
            }
        }
    }

    public static Iterable<AlignmentAnnotation> findAnnotations(Iterable<AlignmentAnnotation> list, SequenceI seq, String calcId, String label) {
        ArrayList<AlignmentAnnotation> aa = new ArrayList<AlignmentAnnotation>();
        for (AlignmentAnnotation ann : list) {
            if (calcId != null && (ann.getCalcId() == null || !ann.getCalcId().equals(calcId)) || seq != null && (ann.sequenceRef == null || ann.sequenceRef != seq) || label != null && (ann.label == null || !ann.label.equals(label))) continue;
            aa.add(ann);
        }
        return aa;
    }

    public static boolean hasAnnotation(List<AlignmentAnnotation> list, String calcId) {
        if (calcId != null && !"".equals(calcId)) {
            for (AlignmentAnnotation a : list) {
                if (a.getCalcId() != calcId) continue;
                return true;
            }
        }
        return false;
    }

    public static Iterable<AlignmentAnnotation> findAnnotation(List<AlignmentAnnotation> list, String calcId) {
        ArrayList<AlignmentAnnotation> aa = new ArrayList<AlignmentAnnotation>();
        if (calcId == null) {
            return aa;
        }
        for (AlignmentAnnotation a : list) {
            if (a.getCalcId() != calcId && (a.getCalcId() == null || calcId == null || !a.getCalcId().equals(calcId))) continue;
            aa.add(a);
        }
        return aa;
    }

    public boolean isShowGroupsForContactMatrix() {
        return this.getProperty(CONTACT_MAP_NOGROUPS) == null || "".equals(this.getProperty(CONTACT_MAP_NOGROUPS));
    }

    public void setShowGroupsForContactMatrix(boolean showGroups) {
        this.setProperty(CONTACT_MAP_NOGROUPS, showGroups ? "" : "nogroups");
    }

    public long getNoOfSequencesIncluded() {
        return this.noOfSequencesIncluded;
    }

    public void setNoOfSequencesIncluded(long noOfSequencesIncluded) {
        this.noOfSequencesIncluded = noOfSequencesIncluded;
    }

    private class AnnotCharSequence
    implements CharSequence {
        int offset = 0;
        int max = 0;

        public AnnotCharSequence() {
            this(0, alignmentAnnotation.annotations.length);
        }

        AnnotCharSequence(int start, int end) {
            this.offset = start;
            this.max = end;
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            return new AnnotCharSequence(this.offset + start, this.offset + end);
        }

        @Override
        public int length() {
            return this.max - this.offset;
        }

        @Override
        public char charAt(int index) {
            return index + this.offset < 0 || index + this.offset >= this.max || AlignmentAnnotation.this.annotations[index + this.offset] == null || AlignmentAnnotation.this.annotations[index + this.offset].secondaryStructure <= ' ' ? (char)' ' : (AlignmentAnnotation.this.annotations[index + this.offset].displayCharacter == null || AlignmentAnnotation.this.annotations[index + this.offset].displayCharacter.length() == 0 ? AlignmentAnnotation.this.annotations[index + this.offset].secondaryStructure : AlignmentAnnotation.this.annotations[index + this.offset].displayCharacter.charAt(0));
        }

        @Override
        public String toString() {
            char[] string = new char[this.max - this.offset];
            int mx = AlignmentAnnotation.this.annotations.length;
            for (int i = this.offset; i < mx; ++i) {
                string[i] = AlignmentAnnotation.this.annotations[i] == null || AlignmentAnnotation.this.annotations[i].secondaryStructure <= ' ' ? 32 : (AlignmentAnnotation.this.annotations[i].displayCharacter == null || AlignmentAnnotation.this.annotations[i].displayCharacter.length() == 0 ? (int)AlignmentAnnotation.this.annotations[i].secondaryStructure : (int)AlignmentAnnotation.this.annotations[i].displayCharacter.charAt(0));
            }
            return new String(string);
        }
    }
}

