/*
 * Decompiled with CFR 0.152.
 */
package ext.edu.ucsf.rbvi.strucviz2;

import ext.edu.ucsf.rbvi.strucviz2.ChimeraModel;
import ext.edu.ucsf.rbvi.strucviz2.ChimeraResidue;
import ext.edu.ucsf.rbvi.strucviz2.ChimeraStructuralObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TreeMap;

public class ChimeraChain
implements ChimeraStructuralObject {
    private int modelNumber;
    private int subModelNumber;
    private ChimeraModel chimeraModel;
    private String chainId;
    private TreeMap<String, ChimeraResidue> residueMap;
    private Object userData;
    private boolean selected = false;

    public ChimeraChain(int model, int subModel, String chainId) {
        this.modelNumber = model;
        this.subModelNumber = subModel;
        this.chainId = chainId;
        this.residueMap = new TreeMap();
    }

    @Override
    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    @Override
    public boolean isSelected() {
        return this.selected;
    }

    @Override
    public boolean hasSelectedChildren() {
        if (this.selected) {
            return true;
        }
        for (ChimeraResidue residue : this.getResidues()) {
            if (!residue.isSelected()) continue;
            return true;
        }
        return false;
    }

    public List<ChimeraResidue> getSelectedResidues() {
        ArrayList<ChimeraResidue> residueList = new ArrayList<ChimeraResidue>();
        if (this.selected) {
            residueList.addAll(this.getResidues());
        } else {
            for (ChimeraResidue residue : this.getResidues()) {
                if (!residue.isSelected()) continue;
                residueList.add(residue);
            }
        }
        return residueList;
    }

    public void addResidue(ChimeraResidue residue) {
        String index = residue.getIndex();
        this.residueMap.put(index, residue);
    }

    public Collection<ChimeraResidue> getResidues() {
        return this.residueMap.values();
    }

    @Override
    public List<ChimeraStructuralObject> getChildren() {
        return new ArrayList<ChimeraStructuralObject>(this.residueMap.values());
    }

    public ChimeraResidue getResidue(String index) {
        if (this.residueMap.containsKey(index)) {
            return this.residueMap.get(index);
        }
        return null;
    }

    public List<ChimeraResidue> getResidueRange(String residueRange) {
        String[] range = residueRange.split("-", 2);
        if (range[1] == null || range[1].length() == 0) {
            range[1] = range[0];
        }
        ArrayList<ChimeraResidue> resultRange = new ArrayList<ChimeraResidue>();
        int start = Integer.parseInt(range[0]);
        int end = Integer.parseInt(range[1]);
        for (int i = start; i <= end; ++i) {
            String index = String.valueOf(i);
            if (!this.residueMap.containsKey(index)) continue;
            resultRange.add(this.residueMap.get(index));
        }
        return resultRange;
    }

    public String getChainId() {
        return this.chainId;
    }

    public int getModelNumber() {
        return this.modelNumber;
    }

    public int getSubModelNumber() {
        return this.subModelNumber;
    }

    public String displayName() {
        if (this.chainId.equals("_")) {
            return "Chain (no ID) (" + this.getResidueCount() + " residues)";
        }
        return "Chain " + this.chainId + " (" + this.getResidueCount() + " residues)";
    }

    @Override
    public String toString() {
        Object displayName = this.chimeraModel.getModelName();
        if (((String)displayName).length() > 14) {
            displayName = ((String)displayName).substring(0, 13) + "...";
        }
        if (this.chainId.equals("_")) {
            return (String)displayName + " Chain (no ID) (" + this.getResidueCount() + " residues)";
        }
        return (String)displayName + " Chain " + this.chainId + " (" + this.getResidueCount() + " residues)";
    }

    @Override
    public String toSpec() {
        if (this.chainId.equals("_")) {
            return "#" + this.modelNumber + "." + this.subModelNumber + ":.";
        }
        return "#" + this.modelNumber + "." + this.subModelNumber + ":." + this.chainId;
    }

    public int getResidueCount() {
        return this.residueMap.size();
    }

    public void setChimeraModel(ChimeraModel model) {
        this.chimeraModel = model;
    }

    @Override
    public ChimeraModel getChimeraModel() {
        return this.chimeraModel;
    }

    @Override
    public Object getUserData() {
        return this.userData;
    }

    @Override
    public void setUserData(Object data) {
        this.userData = data;
    }
}

