/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelset;

import java.util.Arrays;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import javajs.util.AU;
import javajs.util.BS;
import javajs.util.Lst;
import javajs.util.P3;
import javajs.util.PT;
import javajs.util.Quat;
import javajs.util.SB;
import javajs.util.V3;
import org.jmol.api.Interface;
import org.jmol.api.JmolAdapter;
import org.jmol.api.JmolAdapterAtomIterator;
import org.jmol.api.JmolAdapterBondIterator;
import org.jmol.api.SymmetryInterface;
import org.jmol.atomdata.RadiusData;
import org.jmol.c.VDW;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Bond;
import org.jmol.modelset.Chain;
import org.jmol.modelset.Group;
import org.jmol.modelset.Model;
import org.jmol.modelset.ModelSet;
import org.jmol.modelset.Trajectory;
import org.jmol.modelsetbio.BioModel;
import org.jmol.modelsetbio.BioResolver;
import org.jmol.script.T;
import org.jmol.util.BSUtil;
import org.jmol.util.Elements;
import org.jmol.util.JmolMolecule;
import org.jmol.util.Logger;
import org.jmol.viewer.JC;
import org.jmol.viewer.Viewer;

public final class ModelLoader {
    private Viewer vwr;
    public ModelSet ms;
    private ModelSet modelSet0;
    private boolean merging;
    private boolean appendNew;
    private String jmolData;
    public String[] group3Lists;
    public int[][] group3Counts;
    public int[] specialAtomIndexes;
    private boolean someModelsHaveUnitcells;
    private boolean someModelsAreModulated;
    private boolean is2D;
    private boolean isMOL2D;
    private boolean isMutate;
    public boolean isTrajectory;
    private boolean isPyMOLsession;
    private boolean doMinimize;
    private boolean doAddHydrogens;
    private String fileHeader;
    private BioResolver jbr;
    public Group[] groups;
    private int groupCount;
    private P3 modulationTUV;
    private final Map<Object, Atom> htAtomMap = new Hashtable<Object, Atom>();
    private static final int defaultGroupCount = 32;
    private Chain[] chainOf;
    private String[] group3Of;
    private int[] seqcodes;
    private int[] firstAtomIndexes;
    private int iModel;
    private Model model;
    private int currentChainID;
    private boolean isNewChain;
    private Chain currentChain;
    private int currentGroupSequenceNumber;
    private char currentGroupInsertionCode = '\u0000';
    private String currentGroup3;
    private Group nullGroup;
    public int baseModelIndex = 0;
    private int baseModelCount = 0;
    public int baseAtomIndex = 0;
    public int baseGroupIndex = 0;
    private int baseTrajectoryCount = 0;
    private int adapterModelCount = 0;
    private int adapterTrajectoryCount = 0;
    private boolean noAutoBond;
    private boolean modulationOn;
    private Map<String, String> htGroup1;
    private Group[] mergeGroups;
    private int iChain;
    private Lst<Bond> vStereo;
    private int lastModel = -1;
    public BS structuresDefinedInFile = new BS();
    private int stereodir = 1;

    public ModelLoader(Viewer vwr, String modelSetName, SB loadScript, Object asc, ModelSet modelSet0, BS bsNew) {
        this.vwr = vwr;
        this.ms = new ModelSet(vwr, modelSetName);
        JmolAdapter adapter = vwr.getModelAdapter();
        this.modelSet0 = modelSet0;
        boolean bl = this.merging = modelSet0 != null && modelSet0.ac > 0;
        if (this.merging) {
            this.ms.canSkipLoad = false;
        } else {
            vwr.resetShapes(false);
        }
        this.ms.preserveState = vwr.getPreserveState();
        this.ms.showRebondTimes = vwr.getBoolean(603979934);
        if (bsNew == null) {
            this.initializeInfo(modelSetName, null);
            this.createModelSet(null, null, null);
            vwr.setStringProperty("_fileType", "");
            return;
        }
        if (!this.ms.preserveState) {
            this.ms.canSkipLoad = false;
        }
        Map<String, Object> info = adapter.getAtomSetCollectionAuxiliaryInfo(asc);
        info.put("loadScript", loadScript);
        this.initializeInfo(adapter.getFileTypeName(asc).toLowerCase().intern(), info);
        this.createModelSet(adapter, asc, bsNew);
        if (this.jbr != null) {
            this.jbr.setLoader(null);
        }
        this.jbr = null;
    }

    private void initializeInfo(String name, Map<String, Object> info) {
        this.ms.g3d = this.vwr.gdata;
        this.ms.modelSetTypeName = name;
        this.ms.isXYZ = name == "xyz";
        this.ms.msInfo = info;
        this.ms.modelSetProperties = (Properties)this.ms.getInfoM("properties");
        this.ms.haveBioModels = this.ms.getMSInfoB("isPDB");
        this.isMutate = this.ms.getMSInfoB("isMutate");
        if (this.ms.haveBioModels) {
            this.jbr = this.vwr.getJBR().setLoader(this);
        }
        this.jmolData = this.adapterModelCount == 0 ? (String)this.ms.getInfoM("jmolData") : null;
        this.fileHeader = (String)this.ms.getInfoM("fileHeader");
        Lst steps = (Lst)this.ms.getInfoM("trajectorySteps");
        boolean bl = this.isTrajectory = steps != null;
        if (this.isTrajectory) {
            this.ms.trajectory = this.newTrajectory(this.ms, steps);
        }
        this.isPyMOLsession = this.ms.getMSInfoB("isPyMOL");
        boolean bl2 = this.doAddHydrogens = this.jbr != null && !this.isTrajectory && !this.isPyMOLsession && !this.ms.getMSInfoB("pdbNoHydrogens") && (this.ms.getMSInfoB("pdbAddHydrogens") || this.vwr.getBooleanProperty("pdbAddHydrogens"));
        if (info != null) {
            info.remove("pdbNoHydrogens");
            info.remove("pdbAddHydrogens");
            info.remove("trajectorySteps");
            if (this.isTrajectory) {
                this.ms.vibrationSteps = (Lst)info.remove("vibrationSteps");
            }
            if (info.containsKey("legacyJavaFloat")) {
                this.vwr.setBooleanProperty("legacyJavaFloat", true);
            }
        }
        this.htGroup1 = (Map)this.ms.getInfoM("htGroup1");
        Object mod = this.ms.getInfoM("modulationOn");
        if (mod != null) {
            this.modulationOn = true;
            this.modulationTUV = mod == Boolean.TRUE ? null : (P3)mod;
        }
        this.noAutoBond = this.ms.getMSInfoB("noAutoBond");
        this.is2D = this.ms.getMSInfoB("is2D");
        this.doMinimize = this.is2D && this.ms.getMSInfoB("doMinimize");
        this.adapterTrajectoryCount = this.isTrajectory ? this.ms.trajectory.steps.size() : 0;
        this.ms.someModelsHaveSymmetry = this.ms.getMSInfoB("someModelsHaveSymmetry");
        this.someModelsHaveUnitcells = this.ms.getMSInfoB("someModelsHaveUnitcells");
        this.someModelsAreModulated = this.ms.getMSInfoB("someModelsAreModulated");
        this.ms.someModelsHaveFractionalCoordinates = this.ms.getMSInfoB("someModelsHaveFractionalCoordinates");
        if (this.merging) {
            this.ms.haveBioModels |= this.modelSet0.haveBioModels;
            this.ms.bioModelset = this.modelSet0.bioModelset;
            if (this.ms.bioModelset != null) {
                this.ms.bioModelset.set(this.vwr, this.ms);
            }
            this.ms.someModelsHaveSymmetry |= this.modelSet0.getMSInfoB("someModelsHaveSymmetry");
            this.someModelsHaveUnitcells |= this.modelSet0.getMSInfoB("someModelsHaveUnitcells");
            this.ms.someModelsHaveFractionalCoordinates |= this.modelSet0.getMSInfoB("someModelsHaveFractionalCoordinates");
            this.ms.someModelsHaveAromaticBonds |= this.modelSet0.someModelsHaveAromaticBonds;
            this.ms.msInfo.put("someModelsHaveSymmetry", this.ms.someModelsHaveSymmetry);
            this.ms.msInfo.put("someModelsHaveUnitcells", this.someModelsHaveUnitcells);
            this.ms.msInfo.put("someModelsHaveFractionalCoordinates", this.ms.someModelsHaveFractionalCoordinates);
            this.ms.msInfo.put("someModelsHaveAromaticBonds", this.ms.someModelsHaveAromaticBonds);
        }
    }

    private Trajectory newTrajectory(ModelSet ms, Lst<P3[]> steps) {
        return ((Trajectory)Interface.getInterface("org.jmol.modelset.Trajectory", this.vwr, "load")).set(this.vwr, ms, steps);
    }

    public String getGroup3(int iGroup) {
        return iGroup >= this.group3Of.length ? null : this.group3Of[iGroup];
    }

    public int getFirstAtomIndex(int iGroup) {
        return this.firstAtomIndexes[iGroup];
    }

    public int getAtomCount() {
        return this.ms.ac;
    }

    private void createModelSet(JmolAdapter adapter, Object asc, BS bsNew) {
        int nAtoms;
        int n = nAtoms = adapter == null ? 0 : adapter.getAtomCount(asc);
        if (nAtoms > 0) {
            Logger.info("reading " + nAtoms + " atoms");
        }
        this.adapterModelCount = adapter == null ? 1 : adapter.getAtomSetCount(asc);
        this.appendNew = !this.isMutate && (!this.merging || adapter == null || this.adapterModelCount > 1 || this.isTrajectory || this.vwr.getBoolean(603979792));
        this.htAtomMap.clear();
        this.chainOf = new Chain[32];
        this.group3Of = new String[32];
        this.seqcodes = new int[32];
        this.firstAtomIndexes = new int[32];
        this.currentChainID = Integer.MAX_VALUE;
        this.currentChain = null;
        this.currentGroupInsertionCode = (char)65535;
        this.currentGroup3 = "xxxxx";
        this.iModel = -1;
        this.model = null;
        if (this.merging) {
            this.mergeTrajAndVib(this.modelSet0, this.ms);
        }
        this.initializeAtomBondModelCounts(nAtoms);
        if (bsNew != null && (this.doMinimize || this.is2D)) {
            bsNew.setBits(this.baseAtomIndex, this.baseAtomIndex + nAtoms);
        }
        if (adapter == null) {
            this.setModelNameNumberProperties(0, -1, "", 1, null, null, null);
        } else {
            Quat q;
            if (this.adapterModelCount > 0) {
                Logger.info("ModelSet: haveSymmetry:" + this.ms.someModelsHaveSymmetry + " haveUnitcells:" + this.someModelsHaveUnitcells + " haveFractionalCoord:" + this.ms.someModelsHaveFractionalCoordinates);
                Logger.info(this.adapterModelCount + " model" + (this.ms.mc == 1 ? "" : "s") + " in this collection. Use getProperty \"modelInfo\" or getProperty \"auxiliaryInfo\" to inspect them.");
            }
            if ((q = (Quat)this.ms.getInfoM("defaultOrientationQuaternion")) != null) {
                Logger.info("defaultOrientationQuaternion = " + q);
                Logger.info("Use \"set autoLoadOrientation TRUE\" before loading or \"restore orientation DEFAULT\" after loading to view this orientation.");
            }
            this.iterateOverAllNewModels(adapter, asc);
            this.iterateOverAllNewAtoms(adapter, asc);
            this.iterateOverAllNewBonds(adapter, asc);
            if (this.merging && !this.appendNew) {
                Map<String, Object> info = adapter.getAtomSetAuxiliaryInfo(asc, 0);
                this.ms.setInfo(this.baseModelIndex, "initialAtomCount", info.get("initialAtomCount"));
                this.ms.setInfo(this.baseModelIndex, "initialBondCount", info.get("initialBondCount"));
            }
            this.initializeUnitCellAndSymmetry();
            this.initializeBonding();
        }
        this.finalizeGroupBuild();
        if (this.is2D && this.doMinimize) {
            this.applyStereochemistry();
        }
        if (this.doAddHydrogens) {
            this.jbr.finalizeHydrogens();
        }
        if (adapter != null) {
            this.ms.calculatePolymers(this.groups, this.groupCount, this.baseGroupIndex, null);
            if (this.jbr != null) {
                this.jbr.iterateOverAllNewStructures(adapter, asc);
            }
        }
        this.setDefaultRendering(this.vwr.getInt(553648170));
        RadiusData rd = this.vwr.rd;
        int ac = this.ms.ac;
        Atom[] atoms = this.ms.at;
        for (int i = this.baseAtomIndex; i < ac; ++i) {
            atoms[i].setMadAtom(this.vwr, rd);
        }
        Model[] models = this.ms.am;
        for (int i = models[this.baseModelIndex].firstAtomIndex; i < ac; ++i) {
            models[atoms[i].mi].bsAtoms.set(i);
        }
        this.freeze();
        this.finalizeShapes();
        this.vwr.setModelSet(this.ms);
        this.setAtomProperties();
        if (adapter != null) {
            adapter.finish(asc);
        }
        if (this.modelSet0 != null) {
            this.modelSet0.releaseModelSet();
        }
        this.modelSet0 = null;
    }

    private void mergeTrajAndVib(ModelSet oldSet, ModelSet newSet) {
        int n;
        int i;
        this.baseModelCount = oldSet.mc;
        this.baseTrajectoryCount = 0;
        if (oldSet.trajectory == null && this.isTrajectory) {
            this.newTrajectory(oldSet, new Lst<P3[]>());
        }
        if (oldSet.trajectory == null || oldSet.mc == 0) {
            return;
        }
        this.baseTrajectoryCount = oldSet.mc;
        for (i = n = oldSet.trajectory.steps.size(); i < this.baseTrajectoryCount; ++i) {
            oldSet.trajectory.steps.addLast(null);
        }
        if (this.isTrajectory) {
            if (oldSet.vibrationSteps == null) {
                oldSet.vibrationSteps = new Lst();
                i = n;
                while (--i >= 0) {
                    oldSet.vibrationSteps.addLast(null);
                }
            }
            n = newSet.trajectory.steps.size();
            for (i = 0; i < n; ++i) {
                oldSet.trajectory.steps.addLast((P3[])newSet.trajectory.steps.get(i));
                oldSet.vibrationSteps.addLast(newSet.vibrationSteps == null ? null : (V3[])newSet.vibrationSteps.get(i));
            }
        } else {
            newSet.trajectory = this.newTrajectory(newSet, null);
        }
        newSet.vibrationSteps = oldSet.vibrationSteps;
        newSet.trajectory.steps = oldSet.trajectory.steps;
        oldSet.trajectory = null;
    }

    private void setDefaultRendering(int maxAtoms) {
        if (this.isPyMOLsession) {
            return;
        }
        SB sb = new SB();
        int modelCount = this.ms.mc;
        Model[] models = this.ms.am;
        for (int i = this.baseModelIndex; i < modelCount; ++i) {
            if (!models[i].isBioModel) continue;
            ((BioModel)models[i]).getDefaultLargePDBRendering(sb, maxAtoms);
        }
        if (sb.length() == 0) {
            return;
        }
        sb.append("select *;");
        String script = (String)this.ms.getInfoM("jmolscript");
        if (script == null) {
            script = "";
        }
        sb.append(script);
        this.ms.msInfo.put("jmolscript", sb.toString());
    }

    private void setAtomProperties() {
        int modelCount = this.ms.mc;
        for (int i = this.baseModelIndex; i < modelCount; ++i) {
            Map atomProperties = (Map)this.ms.getInfo(i, "atomProperties");
            if (this.jmolData != null) {
                this.addJmolDataProperties(this.ms.am[i], (Map)this.ms.getInfo(i, "jmolDataProperties"));
            }
            String groupList = (String)this.ms.getInfo(i, "groupPropertyList");
            if (this.ms.am[i].isBioModel && this.ms.getInfo(i, "dssr") != null) {
                this.vwr.getAnnotationParser(true).setGroup1(this.ms, i);
            }
            if (atomProperties == null) continue;
            for (Map.Entry entry : atomProperties.entrySet()) {
                String key = (String)entry.getKey();
                Object value = entry.getValue();
                BS bs = this.ms.getModelAtomBitSetIncludingDeleted(i, true);
                if (this.doAddHydrogens) {
                    boolean isGroup = groupList != null && PT.isOneOf(key, groupList);
                    value = this.jbr.fixPropertyValue(bs, value, isGroup);
                }
                key = "property_" + key.toLowerCase();
                Logger.info("creating " + key + " for model " + this.ms.getModelName(i));
                this.vwr.setData(key, new Object[]{key, value, bs, -1, Boolean.FALSE}, this.ms.ac, 0, 0, Integer.MAX_VALUE, 0);
            }
        }
    }

    private void initializeAtomBondModelCounts(int nAtoms) {
        int trajectoryCount = this.adapterTrajectoryCount;
        if (this.merging) {
            if (this.appendNew) {
                this.baseModelIndex = this.baseModelCount;
                this.ms.mc = this.baseModelCount + this.adapterModelCount;
            } else {
                this.baseModelIndex = this.vwr.am.cmi;
                if (this.baseModelIndex < 0) {
                    this.baseModelIndex = this.baseModelCount - 1;
                }
                this.ms.mc = this.baseModelCount;
            }
            this.ms.ac = this.baseAtomIndex = this.modelSet0.ac;
            this.ms.bondCount = this.modelSet0.bondCount;
            this.mergeGroups = this.modelSet0.getGroups();
            this.groupCount = this.baseGroupIndex = this.mergeGroups.length;
            this.ms.mergeModelArrays(this.modelSet0);
            this.ms.growAtomArrays(this.ms.ac + nAtoms);
        } else {
            this.ms.mc = this.adapterModelCount;
            this.ms.ac = 0;
            this.ms.bondCount = 0;
            this.ms.at = new Atom[nAtoms];
            this.ms.bo = new Bond[250 + nAtoms];
        }
        if (this.doAddHydrogens) {
            this.jbr.initializeHydrogenAddition();
        }
        if (trajectoryCount > 1) {
            this.ms.mc += trajectoryCount - 1;
        }
        this.ms.am = (Model[])AU.arrayCopyObject(this.ms.am, this.ms.mc);
        this.ms.modelFileNumbers = AU.arrayCopyI(this.ms.modelFileNumbers, this.ms.mc);
        this.ms.modelNumbers = AU.arrayCopyI(this.ms.modelNumbers, this.ms.mc);
        this.ms.modelNumbersForAtomLabel = AU.arrayCopyS(this.ms.modelNumbersForAtomLabel, this.ms.mc);
        this.ms.modelNames = AU.arrayCopyS(this.ms.modelNames, this.ms.mc);
        this.ms.frameTitles = AU.arrayCopyS(this.ms.frameTitles, this.ms.mc);
        if (this.merging) {
            for (int i = 0; i < this.modelSet0.mc; ++i) {
                this.ms.am[i] = this.modelSet0.am[i];
                this.modelSet0.am[i].ms = this.ms;
            }
        }
    }

    private void mergeGroups() {
        Map<String, Object> info = this.modelSet0.getAuxiliaryInfo(null);
        String[] mergeGroup3Lists = (String[])info.get("group3Lists");
        int[][] mergeGroup3Counts = (int[][])info.get("group3Counts");
        if (mergeGroup3Lists != null) {
            for (int i = 0; i < this.baseModelCount; ++i) {
                this.group3Lists[i + 1] = mergeGroup3Lists[i + 1];
                this.group3Counts[i + 1] = mergeGroup3Counts[i + 1];
                this.structuresDefinedInFile.set(i);
            }
            this.group3Lists[0] = mergeGroup3Lists[0];
            this.group3Counts[0] = mergeGroup3Counts[0];
        }
        if (!this.appendNew && this.ms.haveBioModels) {
            this.structuresDefinedInFile.clear(this.baseModelIndex);
        }
    }

    private void iterateOverAllNewModels(JmolAdapter adapter, Object asc) {
        int i;
        this.group3Lists = new String[this.ms.mc + 1];
        this.group3Counts = AU.newInt2(this.ms.mc + 1);
        this.structuresDefinedInFile = new BS();
        if (this.merging) {
            this.mergeGroups();
        }
        int iTrajectory = this.isTrajectory ? this.baseTrajectoryCount : -1;
        int ipt = this.baseModelIndex;
        int i2 = 0;
        while (i2 < this.adapterModelCount) {
            int modelNumber = adapter.getAtomSetNumber(asc, i2);
            String modelName = adapter.getAtomSetName(asc, i2);
            Map<String, Object> modelAuxiliaryInfo = adapter.getAtomSetAuxiliaryInfo(asc, i2);
            if (modelAuxiliaryInfo.containsKey("modelID")) {
                modelAuxiliaryInfo.put("modelID0", modelAuxiliaryInfo.get("modelID"));
            }
            Properties modelProperties = (Properties)modelAuxiliaryInfo.get("modelProperties");
            this.vwr.setStringProperty("_fileType", (String)modelAuxiliaryInfo.get("fileType"));
            if (modelName == null) {
                modelName = this.jmolData != null && this.jmolData.indexOf(";") > 2 ? this.jmolData.substring(this.jmolData.indexOf(":") + 2, this.jmolData.indexOf(";")) : (this.appendNew ? "" + modelNumber % 1000000 : "");
            }
            this.setModelNameNumberProperties(ipt, iTrajectory, modelName, modelNumber, modelProperties, modelAuxiliaryInfo, this.jmolData);
            ++i2;
            ++ipt;
        }
        Model m = this.ms.am[this.baseModelIndex];
        this.vwr.setSmilesString((String)this.ms.msInfo.get("smilesString"));
        String loadState = (String)this.ms.msInfo.remove("loadState");
        SB loadScript = (SB)this.ms.msInfo.remove("loadScript");
        if (loadScript.indexOf("Viewer.AddHydrogens") < 0 || !m.isModelKit) {
            String[] lines = PT.split(loadState, "\n");
            SB sb = new SB();
            for (i = 0; i < lines.length; ++i) {
                int pt = m.loadState.indexOf(lines[i]);
                if (pt >= 0 && pt == m.loadState.lastIndexOf(lines[i])) continue;
                sb.append(lines[i]).appendC('\n');
            }
            m.loadState = m.loadState + m.loadScript.toString() + sb.toString();
            m.loadScript = new SB();
            if (loadScript.indexOf("load append ") >= 0) {
                loadScript.append("; set appendNew true");
            }
            m.loadScript.append("  ").appendSB(loadScript).append(";\n");
        }
        if (this.isTrajectory) {
            int n = this.ms.mc - ipt + 1;
            Logger.info(n + " trajectory steps read");
            this.ms.setInfo(this.baseModelCount, "trajectoryStepCount", n);
            int ia = this.adapterModelCount;
            i = ipt;
            while (i < this.ms.mc) {
                this.ms.am[i] = this.ms.am[this.baseModelCount];
                this.ms.modelNumbers[i] = adapter.getAtomSetNumber(asc, ia);
                this.ms.modelNames[i] = adapter.getAtomSetName(asc, ia);
                this.structuresDefinedInFile.set(i);
                ++i;
                ++ia;
            }
        }
        this.finalizeModels(this.baseModelCount);
    }

    private void setModelNameNumberProperties(int modelIndex, int trajectoryBaseIndex, String modelName, int modelNumber, Properties modelProperties, Map<String, Object> modelAuxiliaryInfo, String jmolData) {
        boolean isModelKit;
        if (this.appendNew) {
            boolean modelIsPDB = modelAuxiliaryInfo != null && Boolean.TRUE == modelAuxiliaryInfo.get("isPDB");
            this.ms.am[modelIndex] = modelIsPDB ? this.jbr.getBioModel(modelIndex, trajectoryBaseIndex, jmolData, modelProperties, modelAuxiliaryInfo) : new Model().set(this.ms, modelIndex, trajectoryBaseIndex, jmolData, modelProperties, modelAuxiliaryInfo);
            this.ms.modelNumbers[modelIndex] = modelNumber;
            this.ms.modelNames[modelIndex] = modelName;
            if (modelIsPDB) {
                this.jbr.setGroupLists(modelIndex);
            }
        } else {
            Object atomInfo = modelAuxiliaryInfo.get("PDB_CONECT_firstAtom_count_max");
            if (atomInfo != null) {
                this.ms.setInfo(modelIndex, "PDB_CONECT_firstAtom_count_max", atomInfo);
            }
        }
        Model[] models = this.ms.am;
        Atom[] atoms = this.ms.at;
        models[modelIndex].bsAtoms.set(atoms.length + 1);
        models[modelIndex].bsAtoms.clear(atoms.length + 1);
        String codes = (String)this.ms.getInfo(modelIndex, "altLocs");
        int n = models[modelIndex].altLocCount = codes == null ? 0 : codes.length();
        if (codes != null) {
            char[] altlocs = codes.toCharArray();
            Arrays.sort(altlocs);
            codes = String.valueOf(altlocs);
            this.ms.setInfo(modelIndex, "altLocs", codes);
        }
        codes = (String)this.ms.getInfo(modelIndex, "insertionCodes");
        models[modelIndex].insertionCount = codes == null ? 0 : codes.length();
        models[modelIndex].isModelKit = isModelKit = this.ms.modelSetName != null && this.ms.modelSetName.startsWith("Jmol Model Kit") || modelName.startsWith("Jmol Model Kit") || "Jme".equals(this.ms.getInfo(modelIndex, "fileType"));
    }

    private void finalizeModels(int baseModelCount) {
        int i;
        int i2;
        int modelCount = this.ms.mc;
        if (modelCount == baseModelCount) {
            return;
        }
        int modelnumber = 0;
        int lastfilenumber = -1;
        int[] modelNumbers = this.ms.modelNumbers;
        String[] modelNames = this.ms.modelNames;
        if (this.isTrajectory) {
            i2 = baseModelCount;
            while (++i2 < this.ms.mc) {
                modelNumbers[i2] = modelNumbers[i2 - 1] + 1;
            }
        }
        if (baseModelCount > 0) {
            if (modelNumbers[0] < 1000000) {
                for (i2 = 0; i2 < baseModelCount; ++i2) {
                    if (modelNames[i2].length() == 0) {
                        modelNames[i2] = "" + modelNumbers[i2];
                    }
                    int n = i2;
                    modelNumbers[n] = modelNumbers[n] + 1000000;
                    this.ms.modelNumbersForAtomLabel[i2] = "1." + (i2 + 1);
                }
            }
            int filenumber = modelNumbers[baseModelCount - 1];
            filenumber -= filenumber % 1000000;
            if (modelNumbers[baseModelCount] < 1000000) {
                filenumber += 1000000;
            }
            i = baseModelCount;
            while (i < modelCount) {
                int n = i++;
                modelNumbers[n] = modelNumbers[n] + filenumber;
            }
        }
        Model[] models = this.ms.am;
        for (i = baseModelCount; i < modelCount; ++i) {
            String sNum;
            int filenumber;
            this.ms.setInfo(i, "fileType", this.ms.modelSetTypeName);
            if (this.fileHeader != null) {
                this.ms.setInfo(i, "fileHeader", this.fileHeader);
            }
            if ((filenumber = modelNumbers[i] / 1000000) != lastfilenumber) {
                modelnumber = 0;
                lastfilenumber = filenumber;
            }
            ++modelnumber;
            if (filenumber == 0) {
                sNum = "" + this.ms.getModelNumber(i);
                filenumber = 1;
            } else {
                sNum = filenumber + "." + modelnumber;
            }
            this.ms.modelNumbersForAtomLabel[i] = sNum;
            models[i].fileIndex = filenumber - 1;
            this.ms.modelFileNumbers[i] = filenumber * 1000000 + modelnumber;
            if (modelNames[i] != null && modelNames[i].length() != 0) continue;
            modelNames[i] = sNum;
        }
        if (this.merging) {
            for (i = 0; i < baseModelCount; ++i) {
                models[i].ms = this.ms;
            }
        }
        for (i = 0; i < modelCount; ++i) {
            this.ms.setInfo(i, "modelName", modelNames[i]);
            this.ms.setInfo(i, "modelNumber", modelNumbers[i] % 1000000);
            this.ms.setInfo(i, "modelFileNumber", this.ms.modelFileNumbers[i]);
            this.ms.setInfo(i, "modelNumberDotted", this.ms.getModelNumberDotted(i));
            String codes = (String)this.ms.getInfo(i, "altLocs");
            if (codes == null) continue;
            Logger.info("model " + this.ms.getModelNumberDotted(i) + " alternative locations: " + codes);
        }
    }

    private void iterateOverAllNewAtoms(JmolAdapter adapter, Object asc) {
        int iLast = -1;
        boolean isPdbThisModel = false;
        boolean addH = false;
        boolean isLegacyHAddition = false;
        JmolAdapterAtomIterator iterAtom = adapter.getAtomIterator(asc);
        this.ms.setCapacity(adapter.getAtomCount(asc));
        int nRead = 0;
        Model[] models = this.ms.am;
        if (this.ms.mc > 0) {
            this.nullGroup = new Group().setGroup(new Chain(this.ms.am[this.baseModelIndex], 32, 0), "", 0, -1, -1);
        }
        while (iterAtom.hasNext()) {
            ++nRead;
            int modelIndex = iterAtom.getAtomSetIndex() + this.baseModelIndex;
            if (modelIndex != iLast) {
                this.iChain = 0;
                this.iModel = modelIndex;
                this.model = models[modelIndex];
                this.currentChainID = Integer.MAX_VALUE;
                this.isNewChain = true;
                models[modelIndex].bsAtoms.clearAll();
                isPdbThisModel = models[modelIndex].isBioModel;
                iLast = modelIndex;
                boolean bl = addH = isPdbThisModel && this.doAddHydrogens;
                if (this.jbr != null) {
                    this.jbr.setHaveHsAlready(false);
                }
            }
            String group3 = iterAtom.getGroup3();
            int chainID = iterAtom.getChainID();
            this.checkNewGroup(adapter, chainID, group3, iterAtom.getSequenceNumber(), iterAtom.getInsertionCode(), addH, isLegacyHAddition);
            int isotope = iterAtom.getElementNumber();
            if (addH && Elements.getElementNumber(isotope) == 1) {
                this.jbr.setHaveHsAlready(true);
            }
            String name = iterAtom.getAtomName();
            int charge = addH ? this.getPdbCharge(group3, name) : iterAtom.getFormalCharge();
            this.addAtom(isPdbThisModel, iterAtom.getSymmetry(), iterAtom.getAtomSite(), iterAtom.getUniqueID(), isotope, name, charge, iterAtom.getPartialCharge(), iterAtom.getTensors(), iterAtom.getOccupancy(), iterAtom.getBfactor(), iterAtom.getXYZ(), iterAtom.getIsHetero(), iterAtom.getSerial(), iterAtom.getSeqID(), group3, iterAtom.getVib(), iterAtom.getAltLoc(), iterAtom.getRadius(), iterAtom.getBondRadius());
        }
        if (this.groupCount > 0 && addH) {
            this.jbr.addImplicitHydrogenAtoms(adapter, this.groupCount - 1, this.isNewChain && !isLegacyHAddition ? 1 : 0);
        }
        iLast = -1;
        VDW vdwtypeLast = null;
        Atom[] atoms = this.ms.at;
        for (int i = 0; i < this.ms.ac; ++i) {
            if (atoms[i].mi == iLast) continue;
            iLast = atoms[i].mi;
            models[iLast].firstAtomIndex = i;
            VDW vdwtype = this.ms.getDefaultVdwType(iLast);
            if (vdwtype == vdwtypeLast) continue;
            Logger.info("Default Van der Waals type for model set to " + vdwtype.getVdwLabel());
            vdwtypeLast = vdwtype;
        }
        Logger.info(nRead + " atoms created");
    }

    private void addJmolDataProperties(Model m, Map<String, float[]> jmolDataProperties) {
        if (jmolDataProperties == null) {
            return;
        }
        BS bs = m.bsAtoms;
        int nAtoms = bs.cardinality();
        block4: for (Map.Entry<String, float[]> e : jmolDataProperties.entrySet()) {
            String key = e.getKey();
            float[] data = e.getValue();
            if (data.length != nAtoms) {
                return;
            }
            int tok = key.startsWith("property_") ? 1715472409 : T.getTokFromName(key);
            switch (tok) {
                default: {
                    if (T.tokAttr(tok, 2048)) {
                        this.vwr.setAtomProperty(bs, tok, 0, 0.0f, null, data, null);
                        continue block4;
                    }
                }
                case 1111492629: 
                case 1111492630: 
                case 1111492631: {
                    key = "property_" + key;
                    tok = 1715472409;
                }
                case 1715472409: 
            }
            this.vwr.setData(key, new Object[]{key, data, bs, 1}, 0, 0, 0, 0, 0);
        }
    }

    private int getPdbCharge(String group3, String name) {
        return group3.equals("ARG") && name.equals("NH1") || group3.equals("LYS") && name.equals("NZ") || group3.equals("HIS") && name.equals("ND1") ? 1 : 0;
    }

    private void addAtom(boolean isPDB, BS atomSymmetry, int atomSite, Object atomUid, int atomicAndIsotopeNumber, String atomName, int formalCharge, float partialCharge, Lst<Object> tensors, float occupancy, float bfactor, P3 xyz, boolean isHetero, int atomSerial, int atomSeqID, String group3, V3 vib, char alternateLocationID, float radius, float bondRadius) {
        byte specialAtomID = 0;
        String atomType = null;
        if (atomName != null) {
            int i = atomName.indexOf(0);
            if (i >= 0) {
                atomType = atomName.substring(i + 1);
                atomName = atomName.substring(0, i);
            }
            if (isPDB) {
                if (atomName.indexOf(42) >= 0) {
                    atomName = atomName.replace('*', '\'');
                }
                if ((specialAtomID = this.vwr.getJBR().lookupSpecialAtomID(atomName)) == 2 && "CA".equalsIgnoreCase(group3)) {
                    specialAtomID = 0;
                }
            }
        }
        Atom atom = this.ms.addAtom(this.iModel, this.nullGroup, atomicAndIsotopeNumber, atomName, atomType, atomSerial, atomSeqID, atomSite, xyz, radius, vib, formalCharge, partialCharge, occupancy, bfactor, tensors, isHetero, specialAtomID, atomSymmetry, bondRadius);
        atom.altloc = alternateLocationID;
        this.htAtomMap.put(atomUid, atom);
    }

    private void checkNewGroup(JmolAdapter adapter, int chainID, String group3, int groupSequenceNumber, char groupInsertionCode, boolean addH, boolean isLegacyHAddition) {
        String group3i;
        String string = group3i = group3 == null ? null : group3.intern();
        if (chainID != this.currentChainID) {
            this.currentChainID = chainID;
            this.currentChain = this.getOrAllocateChain(this.model, chainID);
            this.currentGroupInsertionCode = (char)65535;
            this.currentGroupSequenceNumber = -1;
            this.currentGroup3 = "xxxx";
            this.isNewChain = true;
        }
        if (groupSequenceNumber != this.currentGroupSequenceNumber || groupInsertionCode != this.currentGroupInsertionCode || group3i != this.currentGroup3) {
            if (this.groupCount > 0 && addH) {
                this.jbr.addImplicitHydrogenAtoms(adapter, this.groupCount - 1, this.isNewChain && !isLegacyHAddition ? 1 : 0);
                this.jbr.setHaveHsAlready(false);
            }
            this.currentGroupSequenceNumber = groupSequenceNumber;
            this.currentGroupInsertionCode = groupInsertionCode;
            this.currentGroup3 = group3i;
            while (this.groupCount >= this.group3Of.length) {
                this.chainOf = (Chain[])AU.doubleLength(this.chainOf);
                this.group3Of = AU.doubleLengthS(this.group3Of);
                this.seqcodes = AU.doubleLengthI(this.seqcodes);
                this.firstAtomIndexes = AU.doubleLengthI(this.firstAtomIndexes);
            }
            this.firstAtomIndexes[this.groupCount] = this.ms.ac;
            this.chainOf[this.groupCount] = this.currentChain;
            this.group3Of[this.groupCount] = group3;
            this.seqcodes[this.groupCount] = Group.getSeqcodeFor(groupSequenceNumber, groupInsertionCode);
            ++this.groupCount;
        }
    }

    private Chain getOrAllocateChain(Model model, int chainID) {
        Chain chain = model.getChain(chainID);
        if (chain != null) {
            return chain;
        }
        if (model.chainCount == model.chains.length) {
            model.chains = (Chain[])AU.doubleLength(model.chains);
        }
        Chain chain2 = new Chain(model, chainID, chainID == 0 || chainID == 32 ? 0 : (this.iChain = this.iChain + 1));
        model.chains[model.chainCount++] = chain2;
        return chain2;
    }

    private void iterateOverAllNewBonds(JmolAdapter adapter, Object asc) {
        JmolAdapterBondIterator iterBond = adapter.getBondIterator(asc);
        if (iterBond == null) {
            return;
        }
        short mad = this.vwr.getMadBond();
        this.ms.defaultCovalentMad = this.jmolData == null ? mad : (short)0;
        boolean haveMultipleBonds = false;
        while (iterBond.hasNext()) {
            short colix;
            float radius;
            int iOrder = iterBond.getEncodedOrder();
            short order = (short)iOrder;
            Bond b = this.bondAtoms(iterBond.getAtomUniqueID1(), iterBond.getAtomUniqueID2(), order);
            if (b == null) continue;
            if (order > 1 && order != 1025 && order != 1041) {
                haveMultipleBonds = true;
            }
            if ((radius = iterBond.getRadius()) > 0.0f) {
                b.setMad((short)(radius * 2000.0f));
            }
            if ((colix = iterBond.getColix()) >= 0) {
                b.colix = colix;
            }
            b.order |= iOrder & 0x18000;
        }
        if (haveMultipleBonds && this.ms.someModelsHaveSymmetry && !this.vwr.getBoolean(603979794)) {
            Logger.info("ModelSet: use \"set appletSymmetryToBonds TRUE \" to apply the file-based multiple bonds to symmetry-generated atoms.");
        }
        this.ms.defaultCovalentMad = mad;
    }

    private Bond bondAtoms(Object atomUid1, Object atomUid2, short order) {
        Bond bond;
        boolean isFar;
        Atom atom1 = this.htAtomMap.get(atomUid1);
        if (atom1 == null) {
            Logger.error("bondAtoms cannot find atomUid1?:" + atomUid1);
            return null;
        }
        Atom atom2 = this.htAtomMap.get(atomUid2);
        if (atom2 == null) {
            Logger.error("bondAtoms cannot find atomUid2?:" + atomUid2);
            return null;
        }
        if (atom1.isBonded(atom2)) {
            return null;
        }
        boolean isNear = order == 1025;
        boolean bl = isFar = order == 1041;
        if (isNear || isFar) {
            int m = atom1.getModelIndex();
            if (m != this.lastModel) {
                this.lastModel = m;
                Map<String, Object> info = this.ms.getModelAuxiliaryInfo(m);
                this.isMOL2D = info != null && "2D".equals(info.get("dimension"));
            }
            bond = this.ms.bondMutually(atom1, atom2, this.isMOL2D ? order : (short)1, this.ms.getDefaultMadFromOrder(1), 0.0f);
            if (this.vStereo == null) {
                this.vStereo = new Lst();
            }
            this.vStereo.addLast(bond);
        } else {
            bond = this.ms.bondMutually(atom1, atom2, order, this.ms.getDefaultMadFromOrder(order), 0.0f);
            if (bond.isAromatic()) {
                this.ms.someModelsHaveAromaticBonds = true;
            }
        }
        if (this.ms.bondCount == this.ms.bo.length) {
            this.ms.bo = (Bond[])AU.arrayCopyObject(this.ms.bo, this.ms.bondCount + 250);
        }
        this.ms.setBond(this.ms.bondCount++, bond);
        return bond;
    }

    private void initializeUnitCellAndSymmetry() {
        if (this.someModelsAreModulated && this.ms.bsModulated == null) {
            this.ms.bsModulated = new BS();
        }
        if (this.someModelsHaveUnitcells) {
            this.ms.unitCells = new SymmetryInterface[this.ms.mc];
            this.ms.haveUnitCells = true;
            boolean haveMergeCells = this.modelSet0 != null && this.modelSet0.unitCells != null;
            int pt = 0;
            for (int i = 0; i < this.ms.mc; ++i) {
                Lst lst;
                if (haveMergeCells && i < this.baseModelCount) {
                    this.ms.unitCells[i] = this.modelSet0.unitCells[i];
                    continue;
                }
                this.ms.unitCells[i] = Interface.getSymmetry(this.vwr, "file");
                float[] notionalCell = null;
                if (this.isTrajectory && (lst = (Lst)this.ms.getInfoM("unitCells")) != null) {
                    notionalCell = (float[])lst.get(pt++);
                }
                this.ms.unitCells[i].setSymmetryInfo(i, this.ms.getModelAuxiliaryInfo(i), notionalCell);
            }
        }
        if (this.appendNew && this.ms.someModelsHaveSymmetry) {
            this.ms.getAtoms(1088421903, null);
            Atom[] atoms = this.ms.at;
            short iModel = -1;
            int i0 = 0;
            for (int iAtom = this.baseAtomIndex; iAtom < this.ms.ac; ++iAtom) {
                if (atoms[iAtom].mi != iModel) {
                    iModel = atoms[iAtom].mi;
                    i0 = this.baseAtomIndex + this.ms.getInfoI(iModel, "presymmetryAtomIndex") + this.ms.getInfoI(iModel, "presymmetryAtomCount");
                }
                if (iAtom < i0) continue;
                this.ms.bsSymmetry.set(iAtom);
            }
        }
        if (this.appendNew && this.ms.someModelsHaveFractionalCoordinates) {
            Atom[] atoms = this.ms.at;
            short modelIndex = -1;
            SymmetryInterface c = null;
            boolean isFractional = false;
            boolean roundCoords = !this.vwr.g.legacyJavaFloat;
            for (int i = this.baseAtomIndex; i < this.ms.ac; ++i) {
                if (atoms[i].mi != modelIndex) {
                    modelIndex = atoms[i].mi;
                    c = this.ms.getUnitCell(modelIndex);
                    boolean bl = isFractional = c != null && c.getCoordinatesAreFractional();
                }
                if (!isFractional) continue;
                c = atoms[i].getUnitCell();
                c.toCartesian(c.toSupercell(atoms[i]), false);
                if (!roundCoords) continue;
                PT.fixPtFloats(atoms[i], 10000.0f);
            }
            for (int imodel = this.baseModelIndex; imodel < this.ms.mc; ++imodel) {
                if (!this.ms.isTrajectory(imodel)) continue;
                this.ms.trajectory.setUnitCell(imodel);
            }
        }
    }

    private void initializeBonding() {
        int modelCount = this.ms.mc;
        Model[] models = this.ms.am;
        int modelAtomCount = 0;
        BS bsExclude = (BS)this.ms.getInfoM("bsExcludeBonding");
        if (bsExclude == null) {
            BS bS = bsExclude = this.ms.getInfoM("someModelsHaveCONECT") == null ? null : new BS();
            if (bsExclude != null) {
                this.ms.setPdbConectBonding(this.baseAtomIndex, this.baseModelIndex, bsExclude);
            }
        }
        boolean symmetryAlreadyAppliedToBonds = this.vwr.getBoolean(603979794);
        boolean doAutoBond = this.vwr.getBoolean(603979798);
        boolean forceAutoBond = this.vwr.getBoolean(603979846);
        BS bs = null;
        boolean autoBonding = false;
        if (!this.noAutoBond) {
            for (int i = this.baseModelIndex; i < modelCount; ++i) {
                boolean doBond;
                modelAtomCount = models[i].bsAtoms.cardinality();
                int modelBondCount = this.ms.getInfoI(i, "initialBondCount");
                boolean modelIsPDB = models[i].isBioModel;
                if (modelBondCount < 0) {
                    modelBondCount = this.ms.bondCount;
                }
                boolean bl = doBond = forceAutoBond || doAutoBond && (modelBondCount == 0 || modelIsPDB && this.jmolData == null && (this.ms.getMSInfoB("havePDBHeaderName") || modelBondCount < modelAtomCount / 2) || this.ms.getInfoB(i, "hasSymmetry") && !symmetryAlreadyAppliedToBonds && !this.ms.getInfoB(i, "hasBonds"));
                if (!doBond) continue;
                autoBonding = true;
                if (!this.merging && modelCount <= 1) continue;
                if (bs == null) {
                    bs = BS.newN(this.ms.ac);
                }
                if (i != this.baseModelIndex && this.isTrajectory) continue;
                bs.or(models[i].bsAtoms);
            }
        }
        if (this.modulationOn) {
            this.ms.setModulation(null, true, this.modulationTUV, false);
        }
        if (autoBonding) {
            this.ms.autoBondBs4(bs, bs, bsExclude, null, this.ms.defaultCovalentMad, this.vwr.getBoolean(603979872));
            Logger.info("ModelSet: autobonding; use  autobond=false  to not generate bonds automatically");
        } else {
            Logger.info("ModelSet: not autobonding; use  forceAutobond=true  to force automatic bond creation");
        }
    }

    private void finalizeGroupBuild() {
        int i;
        this.groups = new Group[this.groupCount];
        if (this.merging) {
            for (i = 0; i < this.mergeGroups.length; ++i) {
                this.groups[i] = this.mergeGroups[i];
                this.mergeGroups[i].chain.model.ms = this.ms;
            }
        }
        for (i = this.baseGroupIndex; i < this.groupCount; ++i) {
            this.distinguishAndPropagateGroup(i, this.chainOf[i], this.group3Of[i], this.seqcodes[i], this.firstAtomIndexes[i], (i == this.groupCount - 1 ? this.ms.ac : this.firstAtomIndexes[i + 1]) - 1);
        }
        if (this.group3Lists != null) {
            this.ms.msInfo.put("group3Lists", this.group3Lists);
            this.ms.msInfo.put("group3Counts", this.group3Counts);
            for (i = 0; i < this.group3Counts.length; ++i) {
                if (this.group3Counts[i] != null) continue;
                this.group3Counts[i] = new int[0];
            }
        }
    }

    private void distinguishAndPropagateGroup(int groupIndex, Chain chain, String group3, int seqcode, int firstAtomIndex, int lastAtomIndex) {
        String key;
        Group group;
        if (lastAtomIndex < firstAtomIndex) {
            throw new NullPointerException();
        }
        Group group2 = group = group3 == null || this.jbr == null ? null : this.jbr.distinguishAndPropagateGroup(chain, group3, seqcode, firstAtomIndex, lastAtomIndex, this.specialAtomIndexes, this.ms.at);
        if (group == null) {
            group = new Group().setGroup(chain, group3, seqcode, firstAtomIndex, lastAtomIndex);
            if (this.jbr != null) {
                group.groupID = this.jbr.getGroupID(group3);
            }
            key = "o>";
        } else {
            String string = group.isProtein() ? "p>" : (group.isNucleic() ? "n>" : (key = group.isCarbohydrate() ? "c>" : "o>"));
        }
        if (group3 != null) {
            this.countGroup(this.ms.at[firstAtomIndex].mi, key, group3);
            if (group.isNucleic()) {
                String g1;
                String string = g1 = this.htGroup1 == null ? null : this.htGroup1.get(group3);
                if (g1 != null) {
                    group.group1 = g1.charAt(0);
                }
            }
        }
        this.addGroup(chain, group);
        this.groups[groupIndex] = group;
        group.groupIndex = groupIndex;
        int i = lastAtomIndex + 1;
        while (--i >= firstAtomIndex) {
            this.ms.at[i].group = group;
        }
    }

    private void addGroup(Chain chain, Group group) {
        if (chain.groupCount == chain.groups.length) {
            chain.groups = (Group[])AU.doubleLength(chain.groups);
        }
        chain.groups[chain.groupCount++] = group;
    }

    private void countGroup(int modelIndex, String code, String group3) {
        int ptm = modelIndex + 1;
        if (this.group3Lists == null || this.group3Lists[ptm] == null) {
            return;
        }
        String g3code = (group3 + "   ").substring(0, 3);
        int pt = this.group3Lists[ptm].indexOf(g3code);
        if (pt < 0) {
            int n = ptm;
            this.group3Lists[n] = this.group3Lists[n] + ",[" + g3code + "]";
            pt = this.group3Lists[ptm].indexOf(g3code);
            this.group3Counts[ptm] = AU.arrayCopyI(this.group3Counts[ptm], this.group3Counts[ptm].length + 10);
        }
        int[] nArray = this.group3Counts[ptm];
        int n = pt / 6;
        nArray[n] = nArray[n] + 1;
        pt = this.group3Lists[ptm].indexOf(",[" + g3code);
        if (pt >= 0) {
            this.group3Lists[ptm] = this.group3Lists[ptm].substring(0, pt) + code + this.group3Lists[ptm].substring(pt + 2);
        }
        if (modelIndex >= 0) {
            this.countGroup(-1, code, group3);
        }
    }

    private void freeze() {
        this.htAtomMap.clear();
        if (this.ms.ac < this.ms.at.length) {
            this.ms.growAtomArrays(this.ms.ac);
        }
        if (this.ms.bondCount < this.ms.bo.length) {
            this.ms.bo = (Bond[])AU.arrayCopyObject(this.ms.bo, this.ms.bondCount);
        }
        int i = 5;
        while (--i > 0) {
            this.ms.numCached[i] = 0;
            Bond[][] bondsCache = this.ms.freeBonds[i];
            int j = bondsCache.length;
            while (--j >= 0) {
                bondsCache[j] = null;
            }
        }
        this.ms.setAtomNamesAndNumbers(0, this.baseAtomIndex, this.modelSet0);
        this.findElementsPresent();
        this.ms.resetMolecules();
        this.model = null;
        this.currentChain = null;
        if (!this.ms.haveBioModels || this.isPyMOLsession || this.isMutate) {
            this.ms.freezeModels();
            return;
        }
        boolean asDSSP = this.vwr.getBoolean(603979826);
        String ret = this.ms.calculateStructuresAllExcept(this.structuresDefinedInFile, asDSSP, false, true, true, asDSSP, JC.versionInt >= 1405000 && this.ms.getInfoM("DSSP1") == null ? 2 : 1);
        if (ret.length() > 0) {
            Logger.info(ret);
        }
    }

    private void findElementsPresent() {
        int i;
        this.ms.elementsPresent = new BS[this.ms.mc];
        for (i = 0; i < this.ms.mc; ++i) {
            this.ms.elementsPresent[i] = BS.newN(64);
        }
        i = this.ms.ac;
        while (--i >= 0) {
            int n = this.ms.at[i].getAtomicAndIsotopeNumber();
            if (n >= Elements.elementNumberMax) {
                n = Elements.elementNumberMax + Elements.altElementIndexFromNumber(n);
            }
            this.ms.elementsPresent[this.ms.at[i].mi].set(n);
        }
    }

    private void applyStereochemistry() {
        this.set2DLengths(this.baseAtomIndex, this.ms.ac);
        V3 v = new V3();
        if (this.vStereo != null) {
            int i = this.vStereo.size();
            block0: while (--i >= 0) {
                Bond b = (Bond)this.vStereo.get(i);
                Atom a1 = b.atom1;
                Bond[] bonds = a1.bonds;
                int j = a1.getBondCount();
                while (--j >= 0) {
                    Bond b2 = bonds[j];
                    if (b2 == b) continue;
                    Atom a2 = b2.getOtherAtom(a1);
                    v.sub2(a2, a1);
                    if (!((double)Math.abs(v.x) < 0.1)) continue;
                    if (b.order == 1025 != v.y < 0.0f) break block0;
                    this.stereodir = -1;
                    break block0;
                }
            }
        }
        this.set2dZ(this.baseAtomIndex, this.ms.ac, v);
        if (this.vStereo != null) {
            BS bsToTest = new BS();
            bsToTest.setBits(this.baseAtomIndex, this.ms.ac);
            int i = this.vStereo.size();
            while (--i >= 0) {
                Bond b = (Bond)this.vStereo.get(i);
                float dz2 = b.order == 1025 ? 3 : -3;
                b.order = 1;
                if (b.atom2.z != b.atom1.z && dz2 < 0.0f == b.atom2.z < b.atom1.z) {
                    dz2 /= 3.0f;
                }
                BS bs = JmolMolecule.getBranchBitSet(this.ms.at, b.atom2.i, bsToTest, null, b.atom1.i, false, true);
                bs.set(b.atom2.i);
                int j = bs.nextSetBit(0);
                while (j >= 0) {
                    this.ms.at[j].z += dz2;
                    j = bs.nextSetBit(j + 1);
                }
                b.atom2.x = (b.atom1.x + b.atom2.x) / 2.0f;
                b.atom2.y = (b.atom1.y + b.atom2.y) / 2.0f;
            }
            this.vStereo = null;
        }
        this.is2D = false;
    }

    private void set2DLengths(int iatom1, int iatom2) {
        int i;
        float scaling = 0.0f;
        int n = 0;
        for (i = iatom1; i < iatom2; ++i) {
            Atom a = this.ms.at[i];
            Bond[] bonds = a.bonds;
            if (bonds == null) continue;
            int j = bonds.length;
            while (--j >= 0) {
                Atom b;
                if (bonds[j] == null || (b = bonds[j].getOtherAtom(a)).getAtomNumber() == 1 || b.getIndex() <= i) continue;
                scaling += b.distance(a);
                ++n;
            }
        }
        if (n == 0) {
            return;
        }
        scaling = 1.45f / (scaling / (float)n);
        for (i = iatom1; i < iatom2; ++i) {
            this.ms.at[i].scale(scaling);
        }
    }

    private void set2dZ(int iatom1, int iatom2, V3 v) {
        BS atomlist = BS.newN(iatom2);
        BS bsBranch = new BS();
        V3 v0 = V3.new3(0.0f, 1.0f, 0.0f);
        V3 v1 = new V3();
        BS bs0 = new BS();
        bs0.setBits(iatom1, iatom2);
        for (int i = iatom1; i < iatom2; ++i) {
            if (atomlist.get(i) || bsBranch.get(i)) continue;
            bsBranch = this.getBranch2dZ(i, -1, bs0, bsBranch, v, v0, v1, this.stereodir);
            atomlist.or(bsBranch);
        }
    }

    private BS getBranch2dZ(int atomIndex, int atomIndexNot, BS bs0, BS bsBranch, V3 v, V3 v0, V3 v1, int dir) {
        BS bs = BS.newN(this.ms.ac);
        if (atomIndex < 0) {
            return bs;
        }
        BS bsToTest = new BS();
        bsToTest.or(bs0);
        if (atomIndexNot >= 0) {
            bsToTest.clear(atomIndexNot);
        }
        ModelLoader.setBranch2dZ(this.ms.at[atomIndex], bs, bsToTest, v, v0, v1, dir);
        return bs;
    }

    private static void setBranch2dZ(Atom atom, BS bs, BS bsToTest, V3 v, V3 v0, V3 v1, int dir) {
        int atomIndex = atom.i;
        if (!bsToTest.get(atomIndex)) {
            return;
        }
        bsToTest.clear(atomIndex);
        bs.set(atomIndex);
        if (atom.bonds == null) {
            return;
        }
        int i = atom.bonds.length;
        while (--i >= 0) {
            Bond bond = atom.bonds[i];
            if (bond.isHydrogen()) continue;
            Atom atom2 = bond.getOtherAtom(atom);
            ModelLoader.setAtom2dZ(atom, atom2, v, v0, v1, dir);
            ModelLoader.setBranch2dZ(atom2, bs, bsToTest, v, v0, v1, dir);
        }
    }

    private static void setAtom2dZ(Atom atomRef, Atom atom2, V3 v, V3 v0, V3 v1, int dir) {
        v.sub2(atom2, atomRef);
        v.z = 0.0f;
        v.normalize();
        v1.cross(v0, v);
        double theta = Math.acos(v.dot(v0));
        float f = (float)((double)(0.4f * (float)(-dir)) * Math.sin(4.0 * theta));
        atom2.z = atomRef.z + f;
    }

    private void finalizeShapes() {
        this.ms.sm = this.vwr.shm;
        this.ms.sm.setModelSet(this.ms);
        this.ms.setBsHidden(this.vwr.slm.getHiddenSet());
        if (!this.merging) {
            this.ms.sm.resetShapes();
        }
        this.ms.sm.loadDefaultShapes(this.ms);
        if (this.ms.someModelsHaveAromaticBonds && this.vwr.getBoolean(603979944)) {
            this.ms.assignAromaticBondsBs(false, null);
        }
        if (this.merging && this.baseModelCount == 1) {
            this.ms.sm.setShapePropertyBs(6, "clearModelIndex", null, null);
        }
    }

    public void undeleteAtom(int iAtom) {
        this.ms.at[iAtom].valence = 0;
    }

    public static String createAtomDataSet(Viewer vwr, ModelSet modelSet, int tokType, Object asc, BS bsSelected) {
        int i;
        if (asc == null) {
            return null;
        }
        JmolAdapter adapter = vwr.getModelAdapter();
        P3 pt = new P3();
        Atom[] atoms = modelSet.at;
        float tolerance = vwr.getFloat(570425363);
        if (modelSet.unitCells != null) {
            i = bsSelected.nextSetBit(0);
            while (i >= 0) {
                if (atoms[i].atomSymmetry != null) {
                    tolerance = -tolerance;
                    break;
                }
                i = bsSelected.nextSetBit(i + 1);
            }
        }
        i = -1;
        int n = 0;
        boolean loadAllData = BSUtil.cardinalityOf(bsSelected) == vwr.ms.ac;
        JmolAdapterAtomIterator iterAtom = adapter.getAtomIterator(asc);
        while (iterAtom.hasNext()) {
            P3 xyz = iterAtom.getXYZ();
            if (Float.isNaN(xyz.x + xyz.y + xyz.z)) continue;
            if (tokType == 1145047050) {
                if ((i = bsSelected.nextSetBit(i + 1)) < 0) break;
                ++n;
                if (Logger.debugging) {
                    Logger.debug("atomIndex = " + i + ": " + atoms[i] + " --> (" + xyz.x + "," + xyz.y + "," + xyz.z);
                }
                modelSet.setAtomCoord(i, xyz.x, xyz.y, xyz.z);
                continue;
            }
            pt.setT(xyz);
            BS bs = BS.newN(modelSet.ac);
            modelSet.getAtomsWithin(tolerance, pt, bs, -1);
            bs.and(bsSelected);
            if (loadAllData) {
                n = BSUtil.cardinalityOf(bs);
                if (n == 0) {
                    Logger.warn("createAtomDataSet: no atom found at position " + pt);
                    continue;
                }
                if (n > 1 && Logger.debugging) {
                    Logger.debug("createAtomDataSet: " + n + " atoms found at position " + pt);
                }
            }
            switch (tokType) {
                case 1145047055: {
                    V3 vib = iterAtom.getVib();
                    if (vib == null) break;
                    if (Logger.debugging) {
                        Logger.debug("xyz: " + pt + " vib: " + vib);
                    }
                    modelSet.setAtomCoords(bs, 1145047055, vib);
                    break;
                }
                case 1128269825: {
                    modelSet.setAtomProperty(bs, tokType, 0, iterAtom.getOccupancy(), null, null, null);
                    break;
                }
                case 1111492619: {
                    modelSet.setAtomProperty(bs, tokType, 0, iterAtom.getPartialCharge(), null, null, null);
                    break;
                }
                case 1111492620: {
                    modelSet.setAtomProperty(bs, tokType, 0, iterAtom.getBfactor(), null, null, null);
                }
            }
        }
        switch (tokType) {
            case 1145047055: {
                String vibName = adapter.getAtomSetName(asc, 0);
                Logger.info("_vibrationName = " + vibName);
                vwr.setStringProperty("_vibrationName", vibName);
                break;
            }
            case 1145047050: {
                Logger.info(n + " atom positions read");
                modelSet.recalculateLeadMidpointsAndWingVectors(-1);
                if (n != modelSet.ac) break;
                return "boundbox {*};reset";
            }
        }
        return null;
    }
}

