/*
 * Decompiled with CFR 0.152.
 */
package jalview.util;

import jalview.ext.android.SparseIntArray;
import jalview.ext.android.SparseShortArray;

public class SparseCount {
    private static final int DEFAULT_PROFILE_SIZE = 2;
    private SparseShortArray shortProfile;
    private SparseIntArray intProfile;
    private boolean useInts;

    public SparseCount(int profileSize) {
        this.shortProfile = new SparseShortArray(profileSize);
    }

    public SparseCount() {
        this(2);
    }

    public int add(int key, int value) {
        int newValue = 0;
        if (this.useInts) {
            newValue = this.intProfile.add(key, value);
        } else {
            try {
                newValue = this.shortProfile.add(key, value);
            }
            catch (ArithmeticException e) {
                this.handleOverflow();
                newValue = this.intProfile.add(key, value);
            }
        }
        return newValue;
    }

    synchronized void handleOverflow() {
        int size = this.shortProfile.size();
        this.intProfile = new SparseIntArray(size);
        for (int i = 0; i < size; ++i) {
            short key = this.shortProfile.keyAt(i);
            short value = this.shortProfile.valueAt(i);
            this.intProfile.put(key, value);
        }
        this.shortProfile = null;
        this.useInts = true;
    }

    public int size() {
        return this.useInts ? this.intProfile.size() : this.shortProfile.size();
    }

    public int get(int key) {
        return this.useInts ? this.intProfile.get(key) : this.shortProfile.get(key);
    }

    public void put(int key, int value) {
        if (this.useInts) {
            this.intProfile.put(key, value);
        } else {
            this.shortProfile.put(key, value);
        }
    }

    public int keyAt(int k) {
        return this.useInts ? this.intProfile.keyAt(k) : (int)this.shortProfile.keyAt(k);
    }

    public int valueAt(int k) {
        return this.useInts ? this.intProfile.valueAt(k) : (int)this.shortProfile.valueAt(k);
    }

    boolean isUsingInt() {
        return this.useInts;
    }
}

