/*
 * Decompiled with CFR 0.152.
 */
package jalview.util;

import jalview.bin.Console;
import jalview.util.MappingUtils;
import jalview.util.MathUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;

public class MapList {
    private List<int[]> fromShifts = new ArrayList<int[]>();
    private List<int[]> toShifts = new ArrayList<int[]>();
    private int fromRatio;
    private int toRatio;
    private int fromLowest;
    private int fromHighest;
    private int toLowest;
    private int toHighest;

    public MapList() {
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof MapList)) {
            return false;
        }
        MapList obj = (MapList)o;
        if (obj == this) {
            return true;
        }
        if (obj.fromRatio != this.fromRatio || obj.toRatio != this.toRatio || obj.fromShifts == null || obj.toShifts == null) {
            return false;
        }
        return Arrays.deepEquals(this.fromShifts.toArray(), obj.fromShifts.toArray()) && Arrays.deepEquals(this.toShifts.toArray(), obj.toShifts.toArray());
    }

    public int hashCode() {
        int hashCode = 31 * this.fromRatio;
        hashCode = 31 * hashCode + this.toRatio;
        for (int[] shift : this.fromShifts) {
            hashCode = 31 * hashCode + shift[0];
            hashCode = 31 * hashCode + shift[1];
        }
        for (int[] shift : this.toShifts) {
            hashCode = 31 * hashCode + shift[0];
            hashCode = 31 * hashCode + shift[1];
        }
        return hashCode;
    }

    public List<int[]> getFromRanges() {
        return this.fromShifts;
    }

    public List<int[]> getToRanges() {
        return this.toShifts;
    }

    protected static int[] getRanges(List<int[]> shifts) {
        int[] rnges = new int[2 * shifts.size()];
        int i = 0;
        for (int[] r : shifts) {
            rnges[i++] = r[0];
            rnges[i++] = r[1];
        }
        return rnges;
    }

    public int getFromRatio() {
        return this.fromRatio;
    }

    public int getToRatio() {
        return this.toRatio;
    }

    public int getFromLowest() {
        return this.fromLowest;
    }

    public int getFromHighest() {
        return this.fromHighest;
    }

    public int getToLowest() {
        return this.toLowest;
    }

    public int getToHighest() {
        return this.toHighest;
    }

    public MapList(int[] from, int[] to, int fromRatio, int toRatio) {
        this();
        int i;
        this.fromRatio = fromRatio;
        this.toRatio = toRatio;
        this.fromLowest = Integer.MAX_VALUE;
        this.fromHighest = Integer.MIN_VALUE;
        for (i = 0; i < from.length; i += 2) {
            this.fromLowest = Math.min(this.fromLowest, Math.min(from[i], from[i + 1]));
            this.fromHighest = Math.max(this.fromHighest, Math.max(from[i], from[i + 1]));
            this.fromShifts.add(new int[]{from[i], from[i + 1]});
        }
        this.toLowest = Integer.MAX_VALUE;
        this.toHighest = Integer.MIN_VALUE;
        for (i = 0; i < to.length; i += 2) {
            this.toLowest = Math.min(this.toLowest, Math.min(to[i], to[i + 1]));
            this.toHighest = Math.max(this.toHighest, Math.max(to[i], to[i + 1]));
            this.toShifts.add(new int[]{to[i], to[i + 1]});
        }
    }

    public MapList(MapList map) {
        this();
        this.fromLowest = map.fromLowest;
        this.fromHighest = map.fromHighest;
        this.toLowest = map.toLowest;
        this.toHighest = map.toHighest;
        this.fromRatio = map.fromRatio;
        this.toRatio = map.toRatio;
        if (map.fromShifts != null) {
            for (int[] r : map.fromShifts) {
                this.fromShifts.add(new int[]{r[0], r[1]});
            }
        }
        if (map.toShifts != null) {
            for (int[] r : map.toShifts) {
                this.toShifts.add(new int[]{r[0], r[1]});
            }
        }
    }

    public MapList(List<int[]> fromRange, List<int[]> toRange, int fromRatio, int toRatio) {
        this();
        fromRange = MapList.coalesceRanges(fromRange);
        toRange = MapList.coalesceRanges(toRange);
        this.fromShifts = fromRange;
        this.toShifts = toRange;
        this.fromRatio = fromRatio;
        this.toRatio = toRatio;
        this.fromLowest = Integer.MAX_VALUE;
        this.fromHighest = Integer.MIN_VALUE;
        for (int[] range : fromRange) {
            if (range.length != 2) {
                Console.error("Invalid format for fromRange " + Arrays.toString(range) + " may cause errors");
            }
            this.fromLowest = Math.min(this.fromLowest, Math.min(range[0], range[1]));
            this.fromHighest = Math.max(this.fromHighest, Math.max(range[0], range[1]));
        }
        this.toLowest = Integer.MAX_VALUE;
        this.toHighest = Integer.MIN_VALUE;
        for (int[] range : toRange) {
            if (range.length != 2) {
                Console.error("Invalid format for toRange " + Arrays.toString(range) + " may cause errors");
            }
            this.toLowest = Math.min(this.toLowest, Math.min(range[0], range[1]));
            this.toHighest = Math.max(this.toHighest, Math.max(range[0], range[1]));
        }
    }

    public static List<int[]> coalesceRanges(List<int[]> ranges) {
        if (ranges == null || ranges.size() < 2) {
            return ranges;
        }
        boolean changed = false;
        ArrayList<int[]> merged = new ArrayList<int[]>();
        int[] lastRange = ranges.get(0);
        int lastDirection = lastRange[1] >= lastRange[0] ? 1 : -1;
        lastRange = new int[]{lastRange[0], lastRange[1]};
        merged.add(lastRange);
        boolean first = true;
        for (int[] range : ranges) {
            boolean extending;
            if (first) {
                first = false;
                continue;
            }
            int direction = range[1] >= range[0] ? 1 : -1;
            boolean sameDirection = range[1] == range[0] || direction == lastDirection;
            boolean bl = extending = range[0] == lastRange[1] + lastDirection;
            if (sameDirection && extending) {
                lastRange[1] = range[1];
                changed = true;
                continue;
            }
            lastRange = new int[]{range[0], range[1]};
            merged.add(lastRange);
            lastDirection = range[1] == range[0] ? lastDirection : direction;
        }
        return changed ? merged : ranges;
    }

    protected int[][] makeFromMap() {
        return this.posMap(this.fromShifts, this.fromRatio, this.toShifts, this.toRatio);
    }

    protected int[][] makeToMap() {
        return this.posMap(this.toShifts, this.toRatio, this.fromShifts, this.fromRatio);
    }

    private int[][] posMap(List<int[]> shiftTo, int sourceRatio, List<int[]> shiftFrom, int targetRatio) {
        int to;
        int[] intv;
        int from;
        int iv = 0;
        int ivSize = shiftTo.size();
        if (iv >= ivSize) {
            return null;
        }
        if ((from = (intv = shiftTo.get(iv++))[0]) > (to = intv[1])) {
            from = intv[1];
            to = intv[0];
        }
        while (iv < ivSize) {
            if ((intv = shiftTo.get(iv++))[0] < from) {
                from = intv[0];
            }
            if (intv[1] < from) {
                from = intv[1];
            }
            if (intv[0] > to) {
                to = intv[0];
            }
            if (intv[1] <= to) continue;
            to = intv[1];
        }
        int tF = 0;
        int tT = 0;
        int[][] mp = new int[to - from + 2][];
        for (int i = 0; i < mp.length; ++i) {
            int[] m = MapList.shift(i + from, shiftTo, sourceRatio, shiftFrom, targetRatio);
            if (m != null) {
                if (i == 0) {
                    tF = tT = m[0];
                } else {
                    if (m[0] < tF) {
                        tF = m[0];
                    }
                    if (m[0] > tT) {
                        tT = m[0];
                    }
                }
            }
            mp[i] = m;
        }
        int[][] map = new int[][]{{from, to, tF, tT}, new int[to - from + 2]};
        map[0][2] = tF;
        map[0][3] = tT;
        for (int i = 0; i < mp.length; ++i) {
            map[1][i] = mp[i] != null ? mp[i][0] - tF : -1;
        }
        return map;
    }

    public int[] shiftFrom(int pos) {
        return MapList.shift(pos, this.fromShifts, this.fromRatio, this.toShifts, this.toRatio);
    }

    public int[] shiftTo(int pos) {
        return MapList.shift(pos, this.toShifts, this.toRatio, this.fromShifts, this.fromRatio);
    }

    protected static int[] shift(int pos, List<int[]> shiftTo, int fromRatio, List<int[]> shiftFrom, int toRatio) {
        int[] fromCount = MapList.countPositions(shiftTo, pos);
        if (fromCount == null) {
            return null;
        }
        int fromRemainder = (fromCount[0] - 1) % fromRatio;
        int toCount = 1 + (fromCount[0] - 1) / fromRatio * toRatio;
        int[] toPos = MapList.traverseToPosition(shiftFrom, toCount);
        if (toPos == null) {
            return null;
        }
        return new int[]{toPos[0], fromRemainder, toPos[1]};
    }

    protected static int[] countPositions(List<int[]> intervals, int pos) {
        int count = 0;
        int iv = 0;
        int ivSize = intervals.size();
        while (iv < ivSize) {
            int[] intv;
            if ((intv = intervals.get(iv++))[0] <= intv[1]) {
                if (pos >= intv[0] && pos <= intv[1]) {
                    return new int[]{count + pos - intv[0] + 1, 1};
                }
                count += intv[1] - intv[0] + 1;
                continue;
            }
            if (pos >= intv[1] && pos <= intv[0]) {
                return new int[]{count + intv[0] - pos + 1, -1};
            }
            count += intv[0] - intv[1] + 1;
        }
        return null;
    }

    protected static int[] traverseToPosition(List<int[]> intervals, int count) {
        int traversed = 0;
        int ivSize = intervals.size();
        int iv = 0;
        if (count < 1) {
            return null;
        }
        while (iv < ivSize) {
            int[] intv;
            int diff;
            if ((diff = (intv = intervals.get(iv++))[1] - intv[0]) >= 0) {
                if (count <= traversed + 1 + diff) {
                    return new int[]{intv[0] + (count - traversed - 1), 1};
                }
                traversed += 1 + diff;
                continue;
            }
            if (count <= traversed + 1 - diff) {
                return new int[]{intv[0] - (count - traversed - 1), -1};
            }
            traversed += 1 - diff;
        }
        return null;
    }

    protected static int[] getIntervals(List<int[]> shiftFrom, int[] fromStart, int[] fromEnd, int fromRatio2) {
        int[] iv;
        if (fromStart == null || fromEnd == null) {
            return null;
        }
        int startpos = fromStart[0];
        int endpos = fromEnd[0];
        int endindx = fromRatio2 - 1;
        int intv = 0;
        int intvSize = shiftFrom.size();
        int i = 0;
        int fs = -1;
        int fe_s = -1;
        int fe = -1;
        while (intv < intvSize && (fs == -1 || fe == -1)) {
            iv = shiftFrom.get(intv++);
            if (fe_s > -1) {
                endpos = iv[0];
                --endindx;
            }
            if (iv[0] <= iv[1]) {
                if (fs == -1 && startpos >= iv[0] && startpos <= iv[1]) {
                    fs = i;
                }
                if (endpos >= iv[0] && endpos <= iv[1]) {
                    if (fe_s == -1) {
                        fe_s = i;
                    }
                    if (fe_s != -1) {
                        if (endpos + endindx <= iv[1]) {
                            fe = i;
                            endpos += endindx;
                        } else {
                            endindx -= iv[1] - endpos;
                        }
                    }
                }
            } else {
                if (fs == -1 && startpos <= iv[0] && startpos >= iv[1]) {
                    fs = i;
                }
                if (endpos <= iv[0] && endpos >= iv[1]) {
                    if (fe_s == -1) {
                        fe_s = i;
                    }
                    if (fe_s != -1) {
                        if (endpos - endindx >= iv[1]) {
                            fe = i;
                            endpos -= endindx;
                        } else {
                            endindx -= endpos - iv[1];
                        }
                    }
                }
            }
            ++i;
        }
        if (fs == fe && fe == -1) {
            return null;
        }
        ArrayList<int[]> ranges = new ArrayList<int[]>();
        if (fs <= fe) {
            intv = fs;
            i = fs;
            iv = shiftFrom.get(intv++);
            iv = new int[]{iv[0], iv[1]};
            if (i == fs) {
                iv[0] = startpos;
            }
            while (i != fe) {
                ranges.add(iv);
                iv = shiftFrom.get(intv++);
                iv = new int[]{iv[0], iv[1]};
                ++i;
            }
            if (i == fe) {
                iv[1] = endpos;
            }
            ranges.add(iv);
        } else {
            for (i = shiftFrom.size() - 1; i > fs; --i) {
            }
            iv = shiftFrom.get(i);
            iv = new int[]{iv[1], iv[0]};
            if (i == fs) {
                iv[0] = startpos;
            }
            while (--i != fe) {
                ranges.add(iv);
                iv = shiftFrom.get(i);
                iv = new int[]{iv[1], iv[0]};
            }
            if (i == fe) {
                iv[1] = endpos;
            }
            ranges.add(iv);
        }
        int[] range = null;
        if (ranges != null && ranges.size() > 0) {
            range = new int[ranges.size() * 2];
            intv = 0;
            intvSize = ranges.size();
            i = 0;
            while (intv < intvSize) {
                iv = (int[])ranges.get(intv);
                range[i++] = iv[0];
                range[i++] = iv[1];
                ranges.set(intv++, null);
            }
        }
        return range;
    }

    public int getToPosition(int mpos) {
        int[] mp = this.shiftTo(mpos);
        if (mp != null) {
            return mp[0];
        }
        return mpos;
    }

    public MapList getInverse() {
        return new MapList(this.getToRanges(), this.getFromRanges(), this.getToRatio(), this.getFromRatio());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(64);
        sb.append("[");
        for (int[] shift : this.fromShifts) {
            sb.append(" ").append(Arrays.toString(shift));
        }
        sb.append(" ] ");
        sb.append(this.fromRatio).append(":").append(this.toRatio);
        sb.append(" to [");
        for (int[] shift : this.toShifts) {
            sb.append(" ").append(Arrays.toString(shift));
        }
        sb.append(" ]");
        return sb.toString();
    }

    public void addMapList(MapList map) {
        if (this.equals(map)) {
            return;
        }
        this.fromLowest = Math.min(this.fromLowest, map.fromLowest);
        this.toLowest = Math.min(this.toLowest, map.toLowest);
        this.fromHighest = Math.max(this.fromHighest, map.fromHighest);
        this.toHighest = Math.max(this.toHighest, map.toHighest);
        for (int[] range : map.getFromRanges()) {
            MapList.addRange(range, this.fromShifts);
        }
        for (int[] range : map.getToRanges()) {
            MapList.addRange(range, this.toShifts);
        }
    }

    static void addRange(int[] range, List<int[]> addTo) {
        boolean newForward;
        if (addTo.size() == 0) {
            addTo.add(range);
            return;
        }
        int[] last = addTo.get(addTo.size() - 1);
        boolean lastForward = last[1] >= last[0];
        boolean bl = newForward = range[1] >= range[0];
        if (lastForward == newForward && last[1] == range[0]) {
            last[1] = range[1];
            return;
        }
        if (lastForward && newForward && range[0] == last[1] + 1) {
            last[1] = range[1];
            return;
        }
        if (!lastForward && !newForward && range[0] == last[1] - 1) {
            last[1] = range[1];
            return;
        }
        addTo.add(range);
    }

    public boolean isFromForwardStrand() {
        return this.isForwardStrand(this.getFromRanges());
    }

    public boolean isToForwardStrand() {
        return this.isForwardStrand(this.getToRanges());
    }

    private boolean isForwardStrand(List<int[]> ranges) {
        boolean forwardStrand = true;
        for (int[] range : ranges) {
            if (range[1] > range[0]) break;
            if (range[1] >= range[0]) continue;
            forwardStrand = false;
            break;
        }
        return forwardStrand;
    }

    public boolean isTripletMap() {
        return this.toRatio == 3 && this.fromRatio == 1 || this.fromRatio == 3 && this.toRatio == 1;
    }

    public MapList traverse(MapList map) {
        if (map == null) {
            return null;
        }
        int outFromRatio = this.getFromRatio() * map.getFromRatio();
        int outToRatio = this.getToRatio() * map.getToRatio();
        int gcd = MathUtils.gcd(outFromRatio, outToRatio);
        outFromRatio /= gcd;
        outToRatio /= gcd;
        ArrayList<int[]> toRanges = new ArrayList<int[]>();
        for (int[] range : this.getToRanges()) {
            int fromLength = Math.abs(range[1] - range[0]) + 1;
            int[] transferred = map.locateInTo(range[0], range[1]);
            if (transferred == null || transferred.length % 2 != 0) {
                return null;
            }
            int toLength = 0;
            for (int i = 0; i < transferred.length; i += 2) {
                toRanges.add(new int[]{transferred[i], transferred[i + 1]});
                toLength += Math.abs(transferred[i + 1] - transferred[i]) + 1;
            }
            if (fromLength * map.getToRatio() == toLength * map.getFromRatio()) continue;
            return null;
        }
        return new MapList(this.getFromRanges(), toRanges, outFromRatio, outToRatio);
    }

    public boolean isContiguous() {
        return this.fromShifts.size() == 1 && this.toShifts.size() == 1;
    }

    public int[] locateInFrom(int start, int end) {
        return MapList.mapPositions(start, end, this.toShifts, this.fromShifts, this.toRatio, this.fromRatio);
    }

    public int[] locateInTo(int start, int end) {
        return MapList.mapPositions(start, end, this.fromShifts, this.toShifts, this.fromRatio, this.toRatio);
    }

    static final int[] mapPositions(int start, int end, List<int[]> sourceRange, List<int[]> targetRange, int sourceWordLength, int targetWordLength) {
        BitSet offsets;
        List<int[]> mapped;
        if (end < start) {
            int tmp = end;
            end = start;
            start = tmp;
        }
        return (mapped = MapList.getPositionsForOffsets(targetRange, offsets = MapList.getMappedOffsetsForPositions(start, end, sourceRange, sourceWordLength, targetWordLength))).isEmpty() ? null : MappingUtils.rangeListToArray(mapped);
    }

    protected static final BitSet getMappedOffsetsForPositions(int start, int end, List<int[]> sourceRange, int sourceWordLength, int targetWordLength) {
        BitSet overlaps = new BitSet();
        int offset = 0;
        int s1 = sourceRange.size();
        for (int i = 0; i < s1; ++i) {
            int overlapEnd;
            int overlapStart;
            int[] range = sourceRange.get(i);
            int offset1 = offset;
            int overlapStartOffset = -1;
            int overlapEndOffset = -1;
            if (range[1] >= range[0]) {
                if (start <= range[1] && end >= range[0]) {
                    overlapStart = Math.max(start, range[0]);
                    overlapStartOffset = offset1 + overlapStart - range[0];
                    overlapEnd = Math.min(end, range[1]);
                    overlapEndOffset = offset1 + overlapEnd - range[0];
                }
            } else if (start <= range[0] && end >= range[1]) {
                overlapStart = Math.max(start, range[1]);
                overlapEnd = Math.min(end, range[0]);
                overlapStartOffset = offset1 + range[0] - overlapEnd;
                overlapEndOffset = offset1 + range[0] - overlapStart;
            }
            if (overlapStartOffset > -1) {
                if (sourceWordLength != targetWordLength) {
                    overlapStartOffset -= overlapStartOffset % sourceWordLength;
                    overlapStartOffset = overlapStartOffset / sourceWordLength * targetWordLength;
                    overlapEndOffset -= overlapEndOffset % sourceWordLength;
                    overlapEndOffset = overlapEndOffset / sourceWordLength * targetWordLength;
                    overlapEndOffset += targetWordLength - 1;
                }
                overlaps.set(overlapStartOffset, overlapEndOffset + 1);
            }
            offset += 1 + Math.abs(range[1] - range[0]);
        }
        return overlaps;
    }

    protected static final List<int[]> getPositionsForOffsets(List<int[]> targetRange, BitSet offsets) {
        ArrayList<int[]> mapped = new ArrayList<int[]>();
        if (offsets.isEmpty()) {
            return mapped;
        }
        int traversed = 0;
        int toAdd = offsets.cardinality();
        int added = 0;
        int s2 = targetRange.size();
        for (int i = 0; added < toAdd && i < s2; ++i) {
            int[] range = targetRange.get(i);
            added += MapList.addOffsetPositions(mapped, traversed, range, offsets);
            traversed += Math.abs(range[1] - range[0]) + 1;
        }
        return mapped;
    }

    static final int addOffsetPositions(List<int[]> mapped, int mapOffset, int[] range, BitSet overlaps) {
        int rangeLength = 1 + Math.abs(range[1] - range[0]);
        int step = range[1] < range[0] ? -1 : 1;
        int offsetStart = 0;
        int added = 0;
        while (offsetStart < rangeLength) {
            int overlapStart = overlaps.nextSetBit(mapOffset + offsetStart);
            if (overlapStart == -1 || overlapStart - mapOffset >= rangeLength) {
                return added;
            }
            int overlapEnd = overlaps.nextClearBit(mapOffset + (overlapStart -= mapOffset) + 1);
            overlapEnd = overlapEnd == -1 ? rangeLength - 1 : Math.min(rangeLength - 1, overlapEnd - mapOffset - 1);
            int startPosition = range[0] + step * overlapStart;
            int endPosition = range[0] + step * overlapEnd;
            mapped.add(new int[]{startPosition, endPosition});
            offsetStart = overlapEnd + 1;
            added += Math.abs(endPosition - startPosition) + 1;
        }
        return added;
    }

    public int[] getOverlapsInFrom(int begin, int end) {
        int[] overlaps = MappingUtils.findOverlap(this.toShifts, begin, end);
        return overlaps == null ? null : this.locateInFrom(overlaps[0], overlaps[1]);
    }

    public int[] getOverlapsInTo(int begin, int end) {
        int[] overlaps = MappingUtils.findOverlap(this.fromShifts, begin, end);
        return overlaps == null ? null : this.locateInTo(overlaps[0], overlaps[1]);
    }
}

