/*
 * Decompiled with CFR 0.152.
 */
package jalview.io;

import jalview.analysis.Conservation;
import jalview.api.AlignViewportI;
import jalview.bin.Console;
import jalview.datamodel.AlignmentAnnotation;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.Annotation;
import jalview.datamodel.ColumnSelection;
import jalview.datamodel.GraphLine;
import jalview.datamodel.HiddenColumns;
import jalview.datamodel.HiddenSequences;
import jalview.datamodel.SequenceGroup;
import jalview.datamodel.SequenceI;
import jalview.io.DataSourceType;
import jalview.io.FileParse;
import jalview.schemes.ColourSchemeI;
import jalview.schemes.ColourSchemeProperty;
import jalview.util.ColorUtils;
import jalview.util.Comparison;
import jalview.util.Format;
import java.awt.Color;
import java.io.BufferedReader;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;

public class AnnotationFile {
    private static final String GRAPHLINE = "GRAPHLINE";
    private static final String COMBINE = "COMBINE";
    protected String newline = System.getProperty("line.separator");
    private StringBuffer text;
    private SequenceI refSeq = null;
    private String refSeqId = null;
    private long nlinesread = 0L;
    private String lastread = "";

    public AnnotationFile() {
        this.init();
    }

    private void init() {
        this.text = new StringBuffer("JALVIEW_ANNOTATION" + this.newline + "# Created: " + new Date() + this.newline + this.newline);
        this.refSeq = null;
        this.refSeqId = null;
    }

    public String printAnnotations(AlignmentAnnotation[] annotations, List<SequenceGroup> list, Hashtable properties) {
        return this.printAnnotations(annotations, list, properties, null, null, null);
    }

    public String printAnnotations(AlignmentAnnotation[] annotations, List<SequenceGroup> list, Hashtable properties, HiddenColumns cs, AlignmentI al, ViewDef view) {
        if (view != null) {
            if (view.viewname != null) {
                this.text.append("VIEW_DEF\t" + view.viewname + "\n");
            }
            if (list == null) {
                // empty if block
            }
            if (cs == null) {
                cs = view.hiddencols;
            }
            if (al == null) {
                // empty if block
            }
        }
        if (al != null && al.hasSeqrep()) {
            this.text.append("VIEW_SETREF\t" + al.getSeqrep().getName() + "\n");
        }
        if (cs != null && cs.hasHiddenColumns()) {
            this.text.append("VIEW_HIDECOLS\t");
            String regions = cs.regionsToString(",", "-");
            this.text.append(regions);
            this.text.append("\n");
        }
        if (annotations != null) {
            boolean oneColour = true;
            SequenceI refSeq = null;
            SequenceGroup refGroup = null;
            StringBuffer colours = new StringBuffer();
            StringBuffer graphLine = new StringBuffer();
            StringBuffer rowprops = new StringBuffer();
            Hashtable<Integer, Object> graphGroup = new Hashtable<Integer, Object>();
            Hashtable<Integer, Object[]> graphGroup_refs = new Hashtable<Integer, Object[]>();
            BitSet graphGroupSeen = new BitSet();
            for (int i = 0; i < annotations.length; ++i) {
                int j;
                AlignmentAnnotation row = annotations[i];
                if (!row.visible && !row.hasScore() && (row.graphGroup <= -1 || !graphGroupSeen.get(row.graphGroup))) continue;
                Color color = null;
                oneColour = true;
                this.writeSequence_Ref(refSeq, row.sequenceRef);
                refSeq = row.sequenceRef;
                this.writeGroup_Ref(refGroup, row.groupRef);
                refGroup = row.groupRef;
                boolean hasGlyphs = row.hasIcons;
                boolean hasLabels = row.hasText;
                boolean hasValues = row.hasScore;
                boolean hasText = false;
                for (j = 0; !(row.annotations == null || j >= row.annotations.length || hasGlyphs && hasLabels && hasValues); ++j) {
                    if (row.annotations[j] == null) continue;
                    hasLabels |= row.annotations[j].displayCharacter != null && row.annotations[j].displayCharacter.length() > 0 && !row.annotations[j].displayCharacter.equals(" ");
                    hasGlyphs |= row.annotations[j].secondaryStructure != '\u0000' && row.annotations[j].secondaryStructure != ' ';
                    hasValues |= !Float.isNaN(row.annotations[j].value);
                    hasText |= row.annotations[j].description != null && row.annotations[j].description.length() > 0;
                }
                if (row.graph == 0) {
                    this.text.append("NO_GRAPH\t");
                    hasValues = false;
                } else {
                    if (row.graph == 1) {
                        this.text.append("BAR_GRAPH\t");
                        hasGlyphs = false;
                    } else if (row.graph == 2) {
                        hasGlyphs = false;
                        this.text.append("LINE_GRAPH\t");
                    }
                    if (row.getThreshold() != null) {
                        graphLine.append("GRAPHLINE\t");
                        graphLine.append(row.label);
                        graphLine.append("\t");
                        graphLine.append(row.getThreshold().value);
                        graphLine.append("\t");
                        graphLine.append(row.getThreshold().label);
                        graphLine.append("\t");
                        graphLine.append(Format.getHexString(row.getThreshold().colour));
                        graphLine.append(this.newline);
                    }
                    if (row.graphGroup > -1) {
                        graphGroupSeen.set(row.graphGroup);
                        Integer key = row.graphGroup;
                        if (graphGroup.containsKey(key)) {
                            graphGroup.put(key, (String)graphGroup.get(key) + "\t" + row.label);
                        } else {
                            graphGroup_refs.put(key, new Object[]{refSeq, refGroup});
                            graphGroup.put(key, row.label);
                        }
                    }
                }
                this.text.append(row.label + "\t");
                if (row.description != null) {
                    this.text.append(row.description + "\t");
                }
                for (j = 0; row.annotations != null && j < row.annotations.length; ++j) {
                    if (refSeq != null && Comparison.isGap(refSeq.getCharAt(j))) continue;
                    if (row.annotations[j] != null) {
                        String comma = "";
                        if (hasGlyphs) {
                            this.text.append(comma);
                            if (row.annotations[j].secondaryStructure != ' ') {
                                this.text.append(row.annotations[j].secondaryStructure);
                            }
                            comma = ",";
                        }
                        if (hasValues) {
                            if (!Float.isNaN(row.annotations[j].value)) {
                                this.text.append(comma + row.annotations[j].value);
                            } else {
                                this.text.append(comma + "0.0");
                            }
                            comma = ",";
                        }
                        if (hasLabels && row.annotations[j].displayCharacter != null && row.annotations[j].displayCharacter.length() > 0 && !row.annotations[j].displayCharacter.equals(" ")) {
                            this.text.append(comma + row.annotations[j].displayCharacter);
                            comma = ",";
                        }
                        if (hasText && row.annotations[j].description != null && row.annotations[j].description.length() > 0 && !row.annotations[j].description.equals(row.annotations[j].displayCharacter)) {
                            this.text.append(comma + row.annotations[j].description);
                            comma = ",";
                        }
                        if (color != null && !color.equals(row.annotations[j].colour)) {
                            oneColour = false;
                        }
                        color = row.annotations[j].colour;
                        if (row.annotations[j].colour != null && row.annotations[j].colour != Color.black) {
                            this.text.append(comma + "[" + Format.getHexString(row.annotations[j].colour) + "]");
                            comma = ",";
                        }
                    }
                    this.text.append("|");
                }
                if (row.hasScore()) {
                    this.text.append("\t" + row.score);
                }
                this.text.append(this.newline);
                if (color != null && color != Color.black && oneColour) {
                    colours.append("COLOUR\t");
                    colours.append(row.label);
                    colours.append("\t");
                    colours.append(Format.getHexString(color));
                    colours.append(this.newline);
                }
                if (row.scaleColLabel || row.showAllColLabels || row.centreColLabels) {
                    rowprops.append("ROWPROPERTIES\t");
                    rowprops.append(row.label);
                    rowprops.append("\tscaletofit=");
                    rowprops.append(row.scaleColLabel);
                    rowprops.append("\tshowalllabs=");
                    rowprops.append(row.showAllColLabels);
                    rowprops.append("\tcentrelabs=");
                    rowprops.append(row.centreColLabels);
                    rowprops.append(this.newline);
                }
                if (graphLine.length() <= 0) continue;
                this.text.append(graphLine.toString());
                graphLine.setLength(0);
            }
            this.text.append(this.newline);
            this.text.append(colours.toString());
            if (graphGroup.size() > 0) {
                SequenceI oldRefSeq = refSeq;
                SequenceGroup oldRefGroup = refGroup;
                for (Map.Entry combine_statement : graphGroup.entrySet()) {
                    Object[] seqRefAndGroup = (Object[])graphGroup_refs.get(combine_statement.getKey());
                    this.writeSequence_Ref(refSeq, (SequenceI)seqRefAndGroup[0]);
                    refSeq = (SequenceI)seqRefAndGroup[0];
                    this.writeGroup_Ref(refGroup, (SequenceGroup)seqRefAndGroup[1]);
                    refGroup = (SequenceGroup)seqRefAndGroup[1];
                    this.text.append("COMBINE\t");
                    this.text.append((String)combine_statement.getValue());
                    this.text.append(this.newline);
                }
                this.writeSequence_Ref(refSeq, oldRefSeq);
                refSeq = oldRefSeq;
                this.writeGroup_Ref(refGroup, oldRefGroup);
                refGroup = oldRefGroup;
            }
            this.text.append(rowprops.toString());
        }
        if (list != null) {
            this.printGroups(list);
        }
        if (properties != null) {
            this.text.append(this.newline);
            this.text.append(this.newline);
            this.text.append("ALIGNMENT");
            Enumeration en = properties.keys();
            while (en.hasMoreElements()) {
                String key = en.nextElement().toString();
                this.text.append("\t");
                this.text.append(key);
                this.text.append("=");
                this.text.append(properties.get(key));
            }
        }
        return this.text.toString();
    }

    private Object writeGroup_Ref(SequenceGroup refGroup, SequenceGroup next_refGroup) {
        if (next_refGroup == null) {
            if (refGroup != null) {
                this.text.append(this.newline);
                this.text.append("GROUP_REF\t");
                this.text.append("ALIGNMENT");
                this.text.append(this.newline);
            }
            return true;
        }
        if (refGroup == null || refGroup != next_refGroup) {
            this.text.append(this.newline);
            this.text.append("GROUP_REF\t");
            this.text.append(next_refGroup.getName());
            this.text.append(this.newline);
            return true;
        }
        return false;
    }

    private boolean writeSequence_Ref(SequenceI refSeq, SequenceI next_refSeq) {
        if (next_refSeq == null) {
            if (refSeq != null) {
                this.text.append(this.newline);
                this.text.append("SEQUENCE_REF\t");
                this.text.append("ALIGNMENT");
                this.text.append(this.newline);
                return true;
            }
        } else if (refSeq == null || refSeq != next_refSeq) {
            this.text.append(this.newline);
            this.text.append("SEQUENCE_REF\t");
            this.text.append(next_refSeq.getName());
            this.text.append(this.newline);
            return true;
        }
        return false;
    }

    protected void printGroups(List<SequenceGroup> list) {
        SequenceI seqrep = null;
        for (SequenceGroup sg : list) {
            if (!sg.hasSeqrep()) {
                this.text.append("SEQUENCE_GROUP\t" + sg.getName() + "\t" + (sg.getStartRes() + 1) + "\t" + (sg.getEndRes() + 1) + "\t-1\t");
                seqrep = null;
            } else {
                seqrep = sg.getSeqrep();
                this.text.append("SEQUENCE_REF\t");
                this.text.append(seqrep.getName());
                this.text.append(this.newline);
                this.text.append("SEQUENCE_GROUP\t");
                this.text.append(sg.getName());
                this.text.append("\t");
                this.text.append(seqrep.findPosition(sg.getStartRes()));
                this.text.append("\t");
                this.text.append(seqrep.findPosition(sg.getEndRes()));
                this.text.append("\t");
                this.text.append("-1\t");
            }
            for (int s = 0; s < sg.getSize(); ++s) {
                this.text.append(sg.getSequenceAt(s).getName());
                this.text.append("\t");
            }
            this.text.append(this.newline);
            this.text.append("PROPERTIES\t");
            this.text.append(sg.getName());
            this.text.append("\t");
            if (sg.getDescription() != null) {
                this.text.append("description=");
                this.text.append(sg.getDescription());
                this.text.append("\t");
            }
            if (sg.cs != null) {
                this.text.append("colour=");
                this.text.append(ColourSchemeProperty.getColourName(sg.cs.getColourScheme()));
                this.text.append("\t");
                if (sg.cs.getThreshold() != 0) {
                    this.text.append("pidThreshold=");
                    this.text.append(sg.cs.getThreshold());
                }
                if (sg.cs.isConsensusSecondaryStructureColouring()) {
                    this.text.append("secondaryStructureConservationThreshold=");
                    this.text.append(sg.cs.getConsensusSecondaryStructureThreshold());
                    this.text.append("\t");
                }
                if (sg.cs.conservationApplied()) {
                    this.text.append("consThreshold=");
                    this.text.append(sg.cs.getConservationInc());
                    this.text.append("\t");
                }
            }
            this.text.append("outlineColour=");
            this.text.append(Format.getHexString(sg.getOutlineColour()));
            this.text.append("\t");
            this.text.append("displayBoxes=");
            this.text.append(sg.getDisplayBoxes());
            this.text.append("\t");
            this.text.append("displayText=");
            this.text.append(sg.getDisplayText());
            this.text.append("\t");
            this.text.append("colourText=");
            this.text.append(sg.getColourText());
            this.text.append("\t");
            this.text.append("showUnconserved=");
            this.text.append(sg.getShowNonconserved());
            this.text.append("\t");
            if (sg.textColour != Color.black) {
                this.text.append("textCol1=");
                this.text.append(Format.getHexString(sg.textColour));
                this.text.append("\t");
            }
            if (sg.textColour2 != Color.white) {
                this.text.append("textCol2=");
                this.text.append(Format.getHexString(sg.textColour2));
                this.text.append("\t");
            }
            if (sg.thresholdTextColour != 0) {
                this.text.append("textColThreshold=");
                this.text.append(sg.thresholdTextColour);
                this.text.append("\t");
            }
            if (sg.idColour != null) {
                this.text.append("idColour=");
                this.text.append(Format.getHexString(sg.idColour));
                this.text.append("\t");
            }
            if (sg.isHidereps()) {
                this.text.append("hide=true\t");
            }
            if (sg.isHideCols()) {
                this.text.append("hidecols=true\t");
            }
            if (seqrep != null) {
                this.text.append(this.newline);
                this.text.append("SEQUENCE_REF");
            }
            this.text.append(this.newline);
            this.text.append(this.newline);
        }
    }

    public boolean annotateAlignmentView(AlignViewportI viewport, Object file, DataSourceType protocol) {
        boolean rslt;
        ColumnSelection colSel = viewport.getColumnSelection();
        HiddenColumns hidden = viewport.getAlignment().getHiddenColumns();
        if (colSel == null) {
            colSel = new ColumnSelection();
        }
        if (hidden == null) {
            hidden = new HiddenColumns();
        }
        if ((rslt = this.readAnnotationFile(viewport.getAlignment(), hidden, file, protocol)) && (colSel.hasSelectedColumns() || hidden.hasHiddenColumns())) {
            viewport.setColumnSelection(colSel);
            viewport.getAlignment().setHiddenColumns(hidden);
        }
        return rslt;
    }

    public boolean readAnnotationFile(AlignmentI al, String file, DataSourceType sourceType) {
        return this.readAnnotationFile(al, null, file, sourceType);
    }

    public boolean readAnnotationFile(AlignmentI al, HiddenColumns hidden, Object file, DataSourceType sourceType) {
        BufferedReader in = null;
        try {
            in = new FileParse().getBufferedReader(file, sourceType);
            if (in != null) {
                return this.parseAnnotationFrom(al, hidden, in);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Console.outPrintln("Problem reading annotation file: " + ex);
            if (this.nlinesread > 0L) {
                Console.outPrintln("Last read line " + this.nlinesread + ": '" + this.lastread + "' (first 80 chars) ...");
            }
            return false;
        }
        return false;
    }

    public boolean parseAnnotationFrom(AlignmentI al, HiddenColumns hidden, BufferedReader in) throws Exception {
        String line;
        this.nlinesread = 0L;
        ArrayList<Object[]> combineAnnotation_calls = new ArrayList<Object[]>();
        ArrayList<Object[]> deferredAnnotation_calls = new ArrayList<Object[]>();
        boolean modified = false;
        String groupRef = null;
        Hashtable groupRefRows = new Hashtable();
        Hashtable<Object, Integer> autoAnnots = new Hashtable<Object, Integer>();
        int refSeqIndex = 1;
        int existingAnnotations = 0;
        boolean overrideAutoAnnot = false;
        if (al.getAlignmentAnnotation() != null && (existingAnnotations = al.getAlignmentAnnotation().length) > 0) {
            AlignmentAnnotation[] aa = al.getAlignmentAnnotation();
            for (int aai = 0; aai < aa.length; ++aai) {
                if (!aa[aai].autoCalculated) continue;
                autoAnnots.put(this.autoAnnotsKey(aa[aai], aa[aai].sequenceRef, aa[aai].groupRef == null ? null : aa[aai].groupRef.getName()), 1);
            }
        }
        int alWidth = al.getWidth();
        AlignmentAnnotation annotation = null;
        boolean jvAnnotationFile = false;
        while ((line = in.readLine()) != null) {
            ++this.nlinesread;
            this.lastread = new String(line);
            if (line.indexOf("#") == 0 || line.indexOf("JALVIEW_ANNOTATION") <= -1) continue;
            jvAnnotationFile = true;
            break;
        }
        if (!jvAnnotationFile) {
            in.close();
            return false;
        }
        while ((line = in.readLine()) != null) {
            ++this.nlinesread;
            this.lastread = new String(line);
            if (line.indexOf("#") == 0 || line.indexOf("JALVIEW_ANNOTATION") > -1 || line.length() == 0) continue;
            StringTokenizer st = new StringTokenizer(line, "\t");
            String token = st.nextToken();
            if (token.equalsIgnoreCase("COLOUR")) {
                this.colourAnnotations(al, st.nextToken(), st.nextToken());
                modified = true;
                continue;
            }
            if (token.equalsIgnoreCase(COMBINE)) {
                combineAnnotation_calls.add(new Object[]{st, this.refSeq, groupRef});
                modified = true;
                continue;
            }
            if (token.equalsIgnoreCase("ROWPROPERTIES")) {
                this.addRowProperties(al, st);
                modified = true;
                continue;
            }
            if (token.equalsIgnoreCase(GRAPHLINE)) {
                deferredAnnotation_calls.add(new Object[]{GRAPHLINE, st, this.refSeq, groupRef});
                modified = true;
                continue;
            }
            if (token.equalsIgnoreCase("SEQUENCE_REF")) {
                if (st.hasMoreTokens()) {
                    this.refSeqId = st.nextToken();
                    this.refSeq = al.findName(this.refSeqId);
                    if (this.refSeq == null) {
                        this.refSeqId = null;
                    }
                    try {
                        refSeqIndex = Integer.parseInt(st.nextToken());
                        if (refSeqIndex >= 1) continue;
                        refSeqIndex = 1;
                        Console.outPrintln("WARNING: SEQUENCE_REF index must be > 0 in AnnotationFile");
                    }
                    catch (Exception ex) {
                        refSeqIndex = 1;
                    }
                    continue;
                }
                this.refSeq = null;
                this.refSeqId = null;
                continue;
            }
            if (token.equalsIgnoreCase("GROUP_REF")) {
                groupRef = null;
                if (!st.hasMoreTokens()) continue;
                groupRef = st.nextToken();
                if (groupRef.length() < 1) {
                    groupRef = null;
                    continue;
                }
                if (groupRefRows.get(groupRef) != null) continue;
                groupRefRows.put(groupRef, new Vector());
                continue;
            }
            if (token.equalsIgnoreCase("SEQUENCE_GROUP")) {
                this.addGroup(al, st);
                modified = true;
                continue;
            }
            if (token.equalsIgnoreCase("PROPERTIES")) {
                this.addProperties(al, st);
                modified = true;
                continue;
            }
            if (token.equalsIgnoreCase("BELOW_ALIGNMENT")) {
                this.setBelowAlignment(al, st);
                modified = true;
                continue;
            }
            if (token.equalsIgnoreCase("ALIGNMENT")) {
                this.addAlignmentDetails(al, st);
                modified = true;
                continue;
            }
            if (token.equalsIgnoreCase("VIEW_SETREF")) {
                if (this.refSeq != null) {
                    al.setSeqrep(this.refSeq);
                }
                modified = true;
                continue;
            }
            if (token.equalsIgnoreCase("VIEW_HIDECOLS")) {
                if (st.hasMoreTokens()) {
                    if (hidden == null) {
                        hidden = new HiddenColumns();
                    }
                    this.parseHideCols(hidden, st.nextToken());
                }
                modified = true;
                continue;
            }
            if (token.equalsIgnoreCase("HIDE_INSERTIONS")) {
                SequenceI sr;
                SequenceI sequenceI = sr = this.refSeq == null ? al.getSeqrep() : this.refSeq;
                if (sr == null) {
                    sr = al.getSequenceAt(0);
                }
                if (sr != null) {
                    if (hidden == null) {
                        Console.errPrintln("Cannot process HIDE_INSERTIONS without an alignment view: Ignoring line: " + line);
                    } else {
                        hidden.hideList(sr.getInsertions());
                    }
                }
                modified = true;
                continue;
            }
            int graphStyle = AlignmentAnnotation.getGraphValueFromString(token);
            String label = st.nextToken();
            int index = 0;
            Annotation[] annotations = new Annotation[alWidth];
            String description = null;
            float score = Float.NaN;
            if (st.hasMoreTokens()) {
                boolean onlyOneElement;
                line = st.nextToken();
                if (line.indexOf("|") == -1) {
                    description = line;
                    if (st.hasMoreTokens()) {
                        line = st.nextToken();
                    }
                }
                if (st.hasMoreTokens()) {
                    score = Float.valueOf(st.nextToken()).floatValue();
                }
                st = new StringTokenizer(line, "|", true);
                boolean emptyColumn = true;
                boolean bl = onlyOneElement = st.countTokens() == 1;
                while (st.hasMoreElements() && index < alWidth) {
                    token = st.nextToken().trim();
                    if (onlyOneElement) {
                        try {
                            score = Float.valueOf(token).floatValue();
                            break;
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    if (token.equals("|")) {
                        if (emptyColumn) {
                            ++index;
                        }
                        emptyColumn = true;
                        continue;
                    }
                    annotations[index++] = this.parseAnnotation(token, graphStyle);
                    emptyColumn = false;
                }
            }
            annotation = new AlignmentAnnotation(label, description, index == 0 ? null : annotations, 0.0f, 0.0f, graphStyle);
            annotation.score = score;
            if (!overrideAutoAnnot && autoAnnots.containsKey(this.autoAnnotsKey(annotation, this.refSeq, groupRef))) continue;
            if (this.refSeq != null) {
                annotation.belowAlignment = false;
                SequenceI referedSeq = this.refSeq;
                do {
                    AlignmentAnnotation ann = new AlignmentAnnotation(annotation);
                    annotation.createSequenceMapping(referedSeq, refSeqIndex, false);
                    annotation.adjustForAlignment();
                    referedSeq.addAlignmentAnnotation(annotation);
                    al.addAnnotation(annotation);
                    al.setAnnotationIndex(annotation, al.getAlignmentAnnotation().length - existingAnnotations - 1);
                    if (groupRef != null) {
                        ((Vector)groupRefRows.get(groupRef)).addElement(annotation);
                    }
                    annotation = ann;
                } while (this.refSeqId != null && (referedSeq = al.findName(referedSeq, this.refSeqId, true)) != null);
            } else {
                al.addAnnotation(annotation);
                al.setAnnotationIndex(annotation, al.getAlignmentAnnotation().length - existingAnnotations - 1);
                if (groupRef != null) {
                    ((Vector)groupRefRows.get(groupRef)).addElement(annotation);
                }
            }
            modified = true;
        }
        Hashtable<String, SequenceGroup> groupRefLookup = new Hashtable<String, SequenceGroup>();
        Enumeration en = groupRefRows.keys();
        while (en.hasMoreElements()) {
            groupRef = (String)en.nextElement();
            boolean matched = false;
            for (SequenceGroup theGroup : al.getGroups()) {
                if (!theGroup.getName().equals(groupRef)) continue;
                if (matched) {
                    Console.errPrintln("Ignoring 1:many group reference mappings for group name '" + groupRef + "'");
                    continue;
                }
                matched = true;
                Vector rowset = (Vector)groupRefRows.get(groupRef);
                groupRefLookup.put(groupRef, theGroup);
                if (rowset == null || rowset.size() <= 0) continue;
                AlignmentAnnotation alan = null;
                int elmSize = rowset.size();
                for (int elm = 0; elm < elmSize; ++elm) {
                    alan = (AlignmentAnnotation)rowset.elementAt(elm);
                    alan.groupRef = theGroup;
                }
            }
            ((Vector)groupRefRows.get(groupRef)).removeAllElements();
        }
        for (Object[] _deferred_args : deferredAnnotation_calls) {
            if (_deferred_args[0] != GRAPHLINE) continue;
            this.addLine(al, (StringTokenizer)_deferred_args[1], (SequenceI)_deferred_args[2], _deferred_args[3] == null ? null : (SequenceGroup)groupRefLookup.get(_deferred_args[3]));
        }
        int combinecount = 0;
        for (Object[] _combine_args : combineAnnotation_calls) {
            this.combineAnnotations(al, ++combinecount, (StringTokenizer)_combine_args[0], (SequenceI)_combine_args[1], _combine_args[2] == null ? null : (SequenceGroup)groupRefLookup.get(_combine_args[2]));
        }
        return modified;
    }

    private void parseHideCols(HiddenColumns hidden, String nextToken) {
        StringTokenizer inval = new StringTokenizer(nextToken, ",");
        while (inval.hasMoreTokens()) {
            int from;
            String range = inval.nextToken().trim();
            int to = range.indexOf("-");
            if (to == -1) {
                to = Integer.parseInt(range);
                from = to;
                if (from < 0) continue;
                hidden.hideColumns(from, to);
                continue;
            }
            from = Integer.parseInt(range.substring(0, to));
            to = to < range.length() - 1 ? Integer.parseInt(range.substring(to + 1)) : from;
            if (from <= 0 || to < from) continue;
            hidden.hideColumns(from, to);
        }
    }

    private Object autoAnnotsKey(AlignmentAnnotation annotation, SequenceI refSeq, String groupRef) {
        return annotation.graph + "\t" + annotation.label + "\t" + annotation.description + "\t" + (refSeq != null ? refSeq.getDisplayId(true) : "");
    }

    Annotation parseAnnotation(String string, int graphStyle) {
        boolean hasSymbols = graphStyle == 0;
        String desc = null;
        String displayChar = null;
        char ss = ' ';
        float value = 0.0f;
        boolean parsedValue = false;
        boolean dcset = false;
        Color colour = null;
        int i = ((String)string).indexOf("[");
        int j = ((String)string).indexOf("]");
        if (i > -1 && j > -1) {
            colour = ColorUtils.parseColourString(((String)string).substring(i + 1, j));
            if (i > 0 && ((String)string).charAt(i - 1) == ',') {
                --i;
            }
            string = ((String)string).substring(0, i) + ((String)string).substring(j + 1);
        }
        StringTokenizer st = new StringTokenizer((String)string, ",", true);
        boolean seenContent = false;
        int pass = 0;
        while (st.hasMoreTokens()) {
            ++pass;
            String token = st.nextToken().trim();
            if (token.equals(",")) {
                if (!seenContent && parsedValue && !dcset) {
                    dcset = true;
                    displayChar = " ";
                }
                seenContent = false;
                continue;
            }
            seenContent = true;
            if (!parsedValue) {
                try {
                    displayChar = token;
                    value = Float.valueOf(token).floatValue();
                    parsedValue = true;
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                }
            } else if (token.length() == 1) {
                displayChar = token;
            }
            if (hasSymbols && token.length() == 1 && "()<>[]{}AaBbCcDdEeFfGgHhIiJjKkLlMmNnOoPpQqRrSsTtUuVvWwXxYyZz".contains(token)) {
                ss = token.charAt(0);
                if (!displayChar.equals(token.substring(0, 1))) continue;
                displayChar = "";
                continue;
            }
            if (desc != null && (!parsedValue || pass <= 2)) continue;
            desc = token;
        }
        if (displayChar != null && desc != null && desc.length() == 1) {
            if (displayChar.length() > 1) {
                String tmp = displayChar;
                displayChar = desc;
                desc = tmp;
            } else if (displayChar.equals(desc)) {
                desc = null;
            }
        }
        Annotation anot = new Annotation(displayChar, desc, ss, value);
        anot.colour = colour;
        return anot;
    }

    void colourAnnotations(AlignmentI al, String label, String colour) {
        Color awtColour = ColorUtils.parseColourString(colour);
        for (int i = 0; i < al.getAlignmentAnnotation().length; ++i) {
            if (!al.getAlignmentAnnotation()[i].label.equalsIgnoreCase(label)) continue;
            Annotation[] annotations = al.getAlignmentAnnotation()[i].annotations;
            for (int j = 0; j < annotations.length; ++j) {
                if (annotations[j] == null) continue;
                annotations[j].colour = awtColour;
            }
        }
    }

    void combineAnnotations(AlignmentI al, int combineCount, StringTokenizer st, SequenceI seqRef, SequenceGroup groupRef) {
        String group = st.nextToken();
        int graphGroup = 0;
        if (al.getAlignmentAnnotation() != null) {
            AlignmentAnnotation aa;
            int i;
            for (i = 0; i < al.getAlignmentAnnotation().length; ++i) {
                aa = al.getAlignmentAnnotation()[i];
                if (aa.graphGroup > graphGroup) {
                    graphGroup = aa.graphGroup + 1;
                }
                if (aa.sequenceRef != seqRef || aa.groupRef != groupRef || !aa.label.equalsIgnoreCase(group)) continue;
                if (aa.graphGroup > -1) {
                    graphGroup = aa.graphGroup;
                    break;
                }
                if (graphGroup <= combineCount) {
                    graphGroup = combineCount + 1;
                }
                aa.graphGroup = graphGroup;
                break;
            }
            block1: while (st.hasMoreTokens()) {
                group = st.nextToken();
                for (i = 0; i < al.getAlignmentAnnotation().length; ++i) {
                    aa = al.getAlignmentAnnotation()[i];
                    if (aa.sequenceRef != seqRef || aa.groupRef != groupRef || !aa.label.equalsIgnoreCase(group)) continue;
                    aa.graphGroup = graphGroup;
                    continue block1;
                }
            }
        } else {
            Console.errPrintln("Couldn't combine annotations. None are added to alignment yet!");
        }
    }

    void addLine(AlignmentI al, StringTokenizer st, SequenceI seqRef, SequenceGroup groupRef) {
        String group = st.nextToken();
        AlignmentAnnotation[] alannot = al.getAlignmentAnnotation();
        String nextToken = st.nextToken();
        float value = 0.0f;
        try {
            value = Float.valueOf(nextToken).floatValue();
        }
        catch (NumberFormatException e) {
            Console.errPrintln("line " + this.nlinesread + ": Threshold '" + nextToken + "' invalid, setting to zero");
        }
        String label = st.hasMoreTokens() ? st.nextToken() : null;
        Color colour = null;
        if (st.hasMoreTokens()) {
            colour = ColorUtils.parseColourString(st.nextToken());
        }
        if (alannot != null) {
            for (int i = 0; i < alannot.length; ++i) {
                if (!alannot[i].label.equalsIgnoreCase(group) || seqRef != null && alannot[i].sequenceRef != seqRef || groupRef != null && alannot[i].groupRef != groupRef) continue;
                alannot[i].setThreshold(new GraphLine(value, label, colour));
            }
        }
    }

    void addGroup(AlignmentI al, StringTokenizer st) {
        SequenceGroup sg = new SequenceGroup();
        sg.setName(st.nextToken());
        String rng = "";
        try {
            rng = st.nextToken();
            if (rng.length() > 0 && !rng.startsWith("*")) {
                sg.setStartRes(Integer.parseInt(rng) - 1);
            } else {
                sg.setStartRes(0);
            }
            rng = st.nextToken();
            if (rng.length() > 0 && !rng.startsWith("*")) {
                sg.setEndRes(Integer.parseInt(rng) - 1);
            } else {
                sg.setEndRes(al.getWidth() - 1);
            }
        }
        catch (Exception e) {
            Console.errPrintln("Couldn't parse Group Start or End Field as '*' or a valid column or sequence index: '" + rng + "' - assuming alignment width for group.");
            sg.setStartRes(0);
            sg.setEndRes(al.getWidth() - 1);
        }
        String index = st.nextToken();
        if (index.equals("-1")) {
            while (st.hasMoreElements()) {
                sg.addSequence(al.findName(st.nextToken()), false);
            }
        } else {
            StringTokenizer st2 = new StringTokenizer(index, ",");
            while (st2.hasMoreTokens()) {
                String tmp = st2.nextToken();
                if (tmp.equals("*")) {
                    for (int i = 0; i < al.getHeight(); ++i) {
                        sg.addSequence(al.getSequenceAt(i), false);
                    }
                    continue;
                }
                if (tmp.indexOf("-") >= 0) {
                    StringTokenizer st3 = new StringTokenizer(tmp, "-");
                    int start = Integer.parseInt(st3.nextToken());
                    int end = Integer.parseInt(st3.nextToken());
                    if (end <= start) continue;
                    for (int i = start; i <= end; ++i) {
                        sg.addSequence(al.getSequenceAt(i - 1), false);
                    }
                    continue;
                }
                sg.addSequence(al.getSequenceAt(Integer.parseInt(tmp) - 1), false);
            }
        }
        if (this.refSeq != null) {
            sg.setStartRes(this.refSeq.findIndex(sg.getStartRes() + 1) - 1);
            sg.setEndRes(this.refSeq.findIndex(sg.getEndRes() + 1) - 1);
            sg.setSeqrep(this.refSeq);
        }
        if (sg.getSize() > 0) {
            al.addGroup(sg);
        }
    }

    void addRowProperties(AlignmentI al, StringTokenizer st) {
        String label = st.nextToken();
        boolean scaletofit = false;
        boolean centerlab = false;
        boolean showalllabs = false;
        while (st.hasMoreTokens()) {
            AlignmentAnnotation[] alr;
            String keyValue = st.nextToken();
            String key = keyValue.substring(0, keyValue.indexOf("="));
            String value = keyValue.substring(keyValue.indexOf("=") + 1);
            if (key.equalsIgnoreCase("scaletofit")) {
                scaletofit = Boolean.valueOf(value);
            }
            if (key.equalsIgnoreCase("showalllabs")) {
                showalllabs = Boolean.valueOf(value);
            }
            if (key.equalsIgnoreCase("centrelabs")) {
                centerlab = Boolean.valueOf(value);
            }
            if ((alr = al.getAlignmentAnnotation()) == null) continue;
            for (int i = 0; i < alr.length; ++i) {
                if (!alr[i].label.equalsIgnoreCase(label)) continue;
                alr[i].centreColLabels = centerlab;
                alr[i].scaleColLabel = scaletofit;
                alr[i].showAllColLabels = showalllabs;
            }
        }
    }

    void addProperties(AlignmentI al, StringTokenizer st) {
        if (al.getGroups() == null) {
            return;
        }
        String name = st.nextToken();
        HashMap<String, String> properties = new HashMap<String, String>();
        while (st.hasMoreTokens()) {
            String keyValue = st.nextToken();
            String key = keyValue.substring(0, keyValue.indexOf("="));
            String value = keyValue.substring(keyValue.indexOf("=") + 1);
            properties.put(key, value);
        }
        for (SequenceGroup sg : al.getGroups()) {
            if (!sg.getName().equals(name)) continue;
            this.addProperties(sg, properties, al);
        }
    }

    private void addProperties(SequenceGroup sg, Map<String, String> properties, AlignmentI al) {
        ColourSchemeI def = sg.getColourScheme();
        for (String key : properties.keySet()) {
            String value = properties.get(key);
            if (key.equalsIgnoreCase("description")) {
                sg.setDescription(value);
            } else if (key.equalsIgnoreCase("colour")) {
                sg.cs.setColourScheme(ColourSchemeProperty.getColourScheme(null, al, value));
            } else if (key.equalsIgnoreCase("pidThreshold")) {
                sg.cs.setThreshold(Integer.parseInt(value), true);
            } else if (key.equalsIgnoreCase("secondaryStructureConservationThreshold")) {
                sg.cs.setConsensusSecondaryStructureThreshold(Integer.parseInt(value));
                sg.cs.setConsensusSecondaryStructureColouring(true);
            } else if (key.equalsIgnoreCase("consThreshold")) {
                sg.cs.setConservationInc(Integer.parseInt(value));
                Conservation c = new Conservation("Group", sg.getSequences(null), sg.getStartRes(), sg.getEndRes() + 1);
                c.calculate();
                c.verdict(false, 25.0f);
                sg.cs.setConservation(c);
            } else if (key.equalsIgnoreCase("outlineColour")) {
                sg.setOutlineColour(ColorUtils.parseColourString(value));
            } else if (key.equalsIgnoreCase("displayBoxes")) {
                sg.setDisplayBoxes(Boolean.valueOf(value));
            } else if (key.equalsIgnoreCase("showUnconserved")) {
                sg.setShowNonconserved(Boolean.valueOf(value));
            } else if (key.equalsIgnoreCase("displayText")) {
                sg.setDisplayText(Boolean.valueOf(value));
            } else if (key.equalsIgnoreCase("colourText")) {
                sg.setColourText(Boolean.valueOf(value));
            } else if (key.equalsIgnoreCase("textCol1")) {
                sg.textColour = ColorUtils.parseColourString(value);
            } else if (key.equalsIgnoreCase("textCol2")) {
                sg.textColour2 = ColorUtils.parseColourString(value);
            } else if (key.equalsIgnoreCase("textColThreshold")) {
                sg.thresholdTextColour = Integer.parseInt(value);
            } else if (key.equalsIgnoreCase("idColour")) {
                Color idColour = ColorUtils.parseColourString(value);
                sg.setIdColour(idColour == null ? Color.black : idColour);
            } else if (key.equalsIgnoreCase("hide")) {
                sg.setHidereps(true);
            } else if (key.equalsIgnoreCase("hidecols")) {
                sg.setHideCols(true);
            }
            sg.recalcConservation();
        }
        if (sg.getColourScheme() == null) {
            sg.setColourScheme(def);
        }
    }

    void setBelowAlignment(AlignmentI al, StringTokenizer st) {
        AlignmentAnnotation[] ala = al.getAlignmentAnnotation();
        if (ala == null) {
            System.err.print("Warning - no annotation to set below for sequence associated annotation:");
        }
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (ala == null) {
                System.err.print(" " + token);
                continue;
            }
            for (int i = 0; i < al.getAlignmentAnnotation().length; ++i) {
                AlignmentAnnotation aa = al.getAlignmentAnnotation()[i];
                if (aa.sequenceRef != this.refSeq || !aa.label.equals(token)) continue;
                aa.belowAlignment = true;
            }
        }
        if (ala == null) {
            System.err.print("\n");
        }
    }

    void addAlignmentDetails(AlignmentI al, StringTokenizer st) {
        while (st.hasMoreTokens()) {
            String keyValue = st.nextToken();
            String key = keyValue.substring(0, keyValue.indexOf("="));
            String value = keyValue.substring(keyValue.indexOf("=") + 1);
            al.setProperty(key, value);
        }
    }

    public String printCSVAnnotations(AlignmentAnnotation[] annotations) {
        if (annotations == null) {
            return "";
        }
        StringBuffer sp = new StringBuffer();
        for (int i = 0; i < annotations.length; ++i) {
            int cp;
            String atos = annotations[i].toString();
            int p = 0;
            do {
                cp = atos.indexOf("\n", p);
                sp.append(annotations[i].label);
                sp.append(",");
                if (cp > p) {
                    sp.append(atos.substring(p, cp + 1));
                    continue;
                }
                sp.append(atos.substring(p));
                sp.append(this.newline);
            } while ((p = cp + 1) > 0);
        }
        return sp.toString();
    }

    public String printAnnotationsForView(AlignViewportI viewport) {
        return this.printAnnotations(viewport.isShowAnnotation() ? viewport.getAlignment().getAlignmentAnnotation() : null, viewport.getAlignment().getGroups(), viewport.getAlignment().getProperties(), viewport.getAlignment().getHiddenColumns(), viewport.getAlignment(), null);
    }

    public String printAnnotationsForAlignment(AlignmentI al) {
        return this.printAnnotations(al.getAlignmentAnnotation(), al.getGroups(), al.getProperties(), null, al, null);
    }

    public class ViewDef {
        public final String viewname;
        public final HiddenSequences hidseqs;
        public final HiddenColumns hiddencols;
        public final Hashtable hiddenRepSeqs;

        public ViewDef(String vname, HiddenSequences hseqs, HiddenColumns hcols, Hashtable hRepSeqs) {
            this.viewname = vname;
            this.hidseqs = hseqs;
            this.hiddencols = hcols;
            this.hiddenRepSeqs = hRepSeqs;
        }
    }
}

