/*
 * Decompiled with CFR 0.152.
 */
package jalview.ext.jmol;

import jalview.api.AlignmentViewPanel;
import jalview.api.FeatureRenderer;
import jalview.api.FeatureSettingsModelI;
import jalview.bin.Console;
import jalview.datamodel.PDBEntry;
import jalview.datamodel.SequenceI;
import jalview.ext.jmol.JmolCommands;
import jalview.ext.jmol.JmolParser;
import jalview.gui.AppJmol;
import jalview.gui.IProgressIndicator;
import jalview.gui.SequenceRenderer;
import jalview.gui.StructureViewer;
import jalview.io.DataSourceType;
import jalview.io.StructureFile;
import jalview.structure.AtomSpec;
import jalview.structure.StructureCommand;
import jalview.structure.StructureCommandI;
import jalview.structure.StructureSelectionManager;
import jalview.structures.models.AAStructureBindingModel;
import jalview.ws.dbsources.Pdb;
import java.awt.Container;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import javajs.util.BS;
import javax.swing.SwingUtilities;
import org.jmol.adapter.smarter.SmarterJmolAdapter;
import org.jmol.api.JmolAdapter;
import org.jmol.api.JmolAppConsoleInterface;
import org.jmol.api.JmolSelectionListener;
import org.jmol.api.JmolStatusListener;
import org.jmol.api.JmolViewer;
import org.jmol.c.CBK;
import org.jmol.viewer.Viewer;

public abstract class JalviewJmolBinding
extends AAStructureBindingModel
implements JmolStatusListener,
JmolSelectionListener,
ComponentListener {
    private String lastMessage;
    private boolean associateNewStructs = false;
    private Vector<String> atomsPicked = new Vector();
    private String lastCommand;
    private boolean loadedInline;
    private StringBuffer resetLastRes = new StringBuffer();
    public Viewer jmolViewer;
    private int[] _modelFileNameMap;
    private boolean debug = true;
    private long loadNotifiesHandled = 0L;
    protected JmolAppConsoleInterface console = null;

    public JalviewJmolBinding(StructureSelectionManager ssm, PDBEntry[] pdbentry, SequenceI[][] sequenceIs, DataSourceType protocol) {
        super(ssm, pdbentry, sequenceIs, protocol);
        this.setStructureCommands(new JmolCommands());
    }

    public JalviewJmolBinding(StructureSelectionManager ssm, SequenceI[][] seqs, Viewer theViewer) {
        super(ssm, seqs);
        this.jmolViewer = theViewer;
        this.jmolViewer.setJmolStatusListener((JmolStatusListener)this);
        this.jmolViewer.addSelectionListener((JmolSelectionListener)this);
        this.setStructureCommands(new JmolCommands());
    }

    public String getViewerTitle() {
        return this.getViewerTitle("Jmol", true);
    }

    private String jmolScript(String script) {
        return this.jmolScript(script, false);
    }

    private String jmolScript(String script, boolean useScriptWait) {
        Console.debug(">>Jmol>> " + script);
        String s = useScriptWait ? this.jmolViewer.scriptWait(script) : this.jmolViewer.evalStringQuiet(script);
        Console.debug("<<Jmol<< " + s);
        return s;
    }

    @Override
    public List<String> executeCommand(StructureCommandI command, boolean getReply) {
        if (command == null) {
            return null;
        }
        String cmd = command.getCommand();
        this.jmolHistory(false);
        if (this.lastCommand == null || !this.lastCommand.equals(cmd)) {
            this.jmolScript(cmd + "\n", command.isWaitNeeded());
        }
        this.jmolHistory(true);
        this.lastCommand = cmd;
        return null;
    }

    public void createImage(String file, String type, int quality) {
        Console.outPrintln("JMOL CREATE IMAGE");
    }

    public String createImage(String fileName, String type, Object textOrBytes, int quality) {
        Console.outPrintln("JMOL CREATE IMAGE");
        return null;
    }

    public String eval(String strEval) {
        return null;
    }

    @Override
    public Map<String, String> getHetatmNames() {
        HashMap<String, String> hetlist = new HashMap<String, String>();
        for (int mc = 0; mc < this.jmolViewer.ms.mc; ++mc) {
            Map hets = this.jmolViewer.ms.getHeteroList(mc);
            if (hets == null) continue;
            hetlist.putAll(hets);
        }
        return hetlist;
    }

    public float[][] functionXY(String functionName, int x, int y) {
        return null;
    }

    public float[][][] functionXYZ(String functionName, int nx, int ny, int nz) {
        return null;
    }

    @Override
    public synchronized String[] getStructureFiles() {
        if (this.jmolViewer == null) {
            return new String[0];
        }
        if (this.modelFileNames == null) {
            int modelCount = this.jmolViewer.ms.mc;
            String filePath = null;
            ArrayList<String> mset = new ArrayList<String>();
            for (int i = 0; i < modelCount; ++i) {
                filePath = this.jmolViewer.ms.getModelFileName(i);
                if (filePath == null || mset.contains(filePath)) continue;
                mset.add(filePath);
            }
            if (!mset.isEmpty()) {
                this.modelFileNames = mset.toArray(new String[mset.size()]);
            }
        }
        return this.modelFileNames;
    }

    public Map<String, Object> getRegistryInfo() {
        return null;
    }

    public void handlePopupMenu(int x, int y) {
    }

    @Override
    public void highlightAtoms(List<AtomSpec> atoms) {
        if (atoms != null) {
            if (this.resetLastRes.length() > 0) {
                this.jmolScript(this.resetLastRes.toString());
                this.resetLastRes.setLength(0);
            }
            StringBuilder highlightCommands = null;
            for (AtomSpec atom : atoms) {
                StringBuilder thisAtom = this.highlightAtom(atom.getAtomIndex(), atom.getPdbResNum(), atom.getChain(), atom.getPdbFile());
                if (thisAtom == null) continue;
                if (highlightCommands == null) {
                    highlightCommands = thisAtom;
                    continue;
                }
                highlightCommands.append((CharSequence)thisAtom);
            }
            if (highlightCommands != null) {
                this.jmolHistory(false);
                this.jmolScript(highlightCommands.toString());
                this.jmolHistory(true);
            }
        }
    }

    private StringBuilder highlightAtom(int atomIndex, int pdbResNum, String chain, String pdbfile) {
        String modelId = this.getModelIdForFile(pdbfile);
        if (modelId.isEmpty()) {
            return null;
        }
        StringBuilder selection = new StringBuilder(32);
        StringBuilder cmd = new StringBuilder(64);
        selection.append("select ").append(String.valueOf(pdbResNum));
        selection.append(":");
        if (!chain.equals(" ")) {
            selection.append(chain);
        }
        selection.append(" /").append(modelId);
        cmd.append((CharSequence)selection).append(";wireframe 100;").append((CharSequence)selection).append(" and not hetero;").append("spacefill 200;select none");
        this.resetLastRes.append((CharSequence)selection).append(";wireframe 0;").append((CharSequence)selection).append(" and not hetero; spacefill 0;");
        return cmd;
    }

    private void jmolHistory(boolean enable) {
        this.jmolHistory(enable, false);
    }

    private void jmolHistory(boolean enable, boolean useScriptWait) {
        this.jmolScript("History " + (this.debug || enable ? "on" : "off"), useScriptWait);
    }

    public void loadInline(String string) {
        this.loadedInline = true;
        this.jmolViewer.openStringInline(string);
    }

    protected void mouseOverStructure(int atomIndex, String strInfo) {
        String label;
        int alocsep = strInfo.indexOf("^");
        int mdlSep = strInfo.indexOf("/");
        int chainSeparator = strInfo.indexOf(":");
        int chainSeparator1 = -1;
        if (chainSeparator == -1) {
            chainSeparator = strInfo.indexOf(".");
            if (mdlSep > -1 && mdlSep < chainSeparator) {
                chainSeparator1 = chainSeparator;
                chainSeparator = mdlSep;
            }
        }
        int pdbResNum = alocsep != -1 ? Integer.parseInt(strInfo.substring(strInfo.indexOf("]") + 1, alocsep)) : Integer.parseInt(strInfo.substring(strInfo.indexOf("]") + 1, chainSeparator));
        String chainId = strInfo.indexOf(":") > -1 ? strInfo.substring(strInfo.indexOf(":") + 1, strInfo.indexOf(".")) : " ";
        String pdbfilename = this.modelFileNames[0];
        if (mdlSep > -1) {
            if (chainSeparator1 == -1) {
                chainSeparator1 = strInfo.indexOf(".", mdlSep);
            }
            String mdlId = chainSeparator1 > -1 ? strInfo.substring(mdlSep + 1, chainSeparator1) : strInfo.substring(mdlSep + 1);
            try {
                int mnumber = Integer.valueOf(mdlId) - 1;
                if (this._modelFileNameMap != null) {
                    int _mp = this._modelFileNameMap.length - 1;
                    while (mnumber < this._modelFileNameMap[_mp]) {
                        --_mp;
                    }
                    pdbfilename = this.modelFileNames[_mp];
                } else {
                    if (mnumber >= 0 && mnumber < this.modelFileNames.length) {
                        pdbfilename = this.modelFileNames[mnumber];
                    }
                    if (pdbfilename == null) {
                        pdbfilename = new File(this.jmolViewer.ms.getModelFileName(mnumber)).getAbsolutePath();
                    }
                }
            }
            catch (Exception mnumber) {
                // empty catch block
            }
        }
        if ((label = this.getSsm().mouseOverStructure(pdbResNum, chainId, pdbfilename)) != null) {
            label = label.replace(',', '|');
            StringTokenizer toks = new StringTokenizer(strInfo, " ");
            StringBuilder sb = new StringBuilder();
            sb.append("select ").append(String.valueOf(pdbResNum)).append(":").append(chainId).append("/1");
            sb.append(";set hoverLabel \"").append(toks.nextToken()).append(" ").append(toks.nextToken());
            sb.append("|").append(label).append("\"");
            this.executeCommand(new StructureCommand(sb.toString(), new String[0]), false);
        }
    }

    public void notifyAtomHovered(int atomIndex, String strInfo, String data) {
        if (strInfo.equals(this.lastMessage)) {
            return;
        }
        this.lastMessage = strInfo;
        if (data != null) {
            Console.errPrintln("Ignoring additional hover info: " + data + " (other info: '" + strInfo + "' pos " + atomIndex + ")");
        }
        this.mouseOverStructure(atomIndex, strInfo);
    }

    public void notifyAtomPicked(int atomIndex, String strInfo, String strData) {
        if (strData != null) {
            Console.errPrintln("Ignoring additional pick data string " + strData);
        }
        int chainSeparator = strInfo.indexOf(":");
        int p = 0;
        if (chainSeparator == -1) {
            chainSeparator = strInfo.indexOf(".");
        }
        Object picked = strInfo.substring(strInfo.indexOf("]") + 1, chainSeparator);
        Object mdlString = "";
        p = strInfo.indexOf(":");
        if (p > -1) {
            picked = (String)picked + strInfo.substring(p, strInfo.indexOf("."));
        }
        if ((p = strInfo.indexOf("/")) > -1) {
            mdlString = (String)mdlString + strInfo.substring(p, strInfo.indexOf(" #"));
        }
        picked = "((" + (String)picked + ".CA" + (String)mdlString + ")|(" + (String)picked + ".P" + (String)mdlString + "))";
        this.jmolHistory(false);
        if (!this.atomsPicked.contains(picked)) {
            this.jmolScript("select " + (String)picked + ";label %n %r:%c");
            this.atomsPicked.addElement((String)picked);
        } else {
            this.jmolViewer.evalString("select " + (String)picked + ";label off");
            this.atomsPicked.removeElement(picked);
        }
        this.jmolHistory(true);
    }

    public void notifyCallback(final CBK type, final Object[] data) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JalviewJmolBinding.this.processCallback(type, data);
            }
        });
    }

    protected void processCallback(CBK type, Object[] data) {
        try {
            switch (type) {
                case LOADSTRUCT: {
                    this.notifyFileLoaded((String)data[1], (String)data[2], (String)data[3], (String)data[4], (Integer)data[5]);
                    break;
                }
                case PICK: {
                    this.notifyAtomPicked((Integer)data[2], (String)data[1], (String)data[0]);
                }
                case HOVER: {
                    this.notifyAtomHovered((Integer)data[2], (String)data[1], (String)data[0]);
                    break;
                }
                case SCRIPT: {
                    this.notifyScriptTermination((String)data[2], (Integer)data[3]);
                    break;
                }
                case ECHO: {
                    this.sendConsoleEcho((String)data[1]);
                    break;
                }
                case MESSAGE: {
                    this.sendConsoleMessage(data == null ? (String)null : (String)data[1]);
                    break;
                }
                case ERROR: {
                    break;
                }
                case SYNC: 
                case RESIZE: {
                    this.refreshGUI();
                    break;
                }
                default: {
                    Console.errPrintln("Unhandled callback " + type + " " + data[1].toString());
                    break;
                }
            }
        }
        catch (Exception e) {
            Console.errPrintln("Squashed Jmol callback handler error:");
            e.printStackTrace();
        }
    }

    public boolean notifyEnabled(CBK callbackPick) {
        switch (callbackPick) {
            case LOADSTRUCT: 
            case PICK: 
            case HOVER: 
            case SCRIPT: 
            case ECHO: 
            case MESSAGE: 
            case ERROR: 
            case MEASURE: {
                return true;
            }
        }
        return false;
    }

    public long getLoadNotifiesHandled() {
        return this.loadNotifiesHandled;
    }

    public void notifyFileLoaded(String fullPathName, String fileName2, String modelName, String errorMsg, int modelParts) {
        if (errorMsg != null) {
            this.fileLoadingError = errorMsg;
            this.refreshGUI();
            return;
        }
        this.fileLoadingError = null;
        String[] oldmodels = this.modelFileNames;
        this.modelFileNames = null;
        boolean notifyLoaded = false;
        String[] modelfilenames = this.getStructureFiles();
        if (modelfilenames == null) {
            return;
        }
        if (Console.isTraceEnabled()) {
            Console.trace("New structures loaded in Jmol:");
            int i = 1;
            for (String mfn : modelfilenames) {
                Console.trace(i++ + " " + (mfn == null ? "NULL" : mfn));
            }
        }
        if (oldmodels != null && oldmodels.length > 0) {
            int oldm = 0;
            for (int i = 0; i < oldmodels.length; ++i) {
                for (int n = 0; n < modelfilenames.length; ++n) {
                    if (modelfilenames[n] != oldmodels[i]) continue;
                    oldmodels[i] = null;
                    break;
                }
                if (oldmodels[i] == null) continue;
                ++oldm;
            }
            if (oldm > 0) {
                String[] oldmfn = new String[oldm];
                oldm = 0;
                for (int i = 0; i < oldmodels.length; ++i) {
                    if (oldmodels[i] == null) continue;
                    oldmfn[oldm++] = oldmodels[i];
                }
                this.getSsm().removeStructureViewerListener(this, oldmfn);
            }
        }
        this.refreshPdbEntries();
        for (int modelnum = 0; modelnum < modelfilenames.length; ++modelnum) {
            String fileName = modelfilenames[modelnum];
            boolean foundEntry = false;
            StructureFile pdb = null;
            String pdbfile = null;
            if (this.loadedInline) {
                pdbfile = this.jmolViewer.getData(1 + this._modelFileNameMap[modelnum] + ".0", "PDB");
            }
            for (int pe = 0; pe < this.getPdbCount(); ++pe) {
                boolean matches = false;
                this.addSequence(pe, this.getSequence()[pe]);
                if (fileName != null) {
                    String jvPdbFile = this.getPdbEntry(pe).getFile();
                    File fl = new File(jvPdbFile);
                    boolean bl = matches = fl.equals(new File(fileName)) || JmolCommands.filePathMatch(fileName, jvPdbFile);
                    if (matches) {
                        foundEntry = true;
                        DataSourceType protocol = DataSourceType.URL;
                        try {
                            if (fl.exists()) {
                                protocol = DataSourceType.FILE;
                            }
                        }
                        catch (Exception exception) {
                        }
                        catch (Error error) {
                            // empty catch block
                        }
                        pdb = this.getSsm().setMapping(this.getSequence()[pe], this.getChains()[pe], fileName, protocol, this.getIProgressIndicator());
                    }
                }
                if (!matches) continue;
                this.stashFoundChains(pdb, fileName);
                notifyLoaded = true;
            }
            if (foundEntry || !this.associateNewStructs) continue;
            String pdbcontent = this.jmolViewer.getData("/" + (modelnum + 1) + ".1", "PDB");
            notifyLoaded = true;
        }
        if (!this.isLoadingFromArchive()) {
            this.jmolScript("model *; select backbone;restrict;cartoon;wireframe off;spacefill off");
        }
        this.getSsm().addStructureViewerListener(this);
        if (notifyLoaded) {
            FeatureRenderer fr = this.getFeatureRenderer(null);
            if (fr != null) {
                FeatureSettingsModelI colours = new Pdb().getFeatureColourScheme();
                ((AppJmol)this.getViewer()).getAlignmentPanel().av.applyFeaturesStyle(colours);
            }
            this.refreshGUI();
            ++this.loadNotifiesHandled;
        }
        this.setLoadingFromArchive(false);
    }

    protected IProgressIndicator getIProgressIndicator() {
        return null;
    }

    public void notifyNewPickingModeMeasurement(int iatom, String strMeasure) {
        this.notifyAtomPicked(iatom, strMeasure, null);
    }

    public abstract void notifyScriptTermination(String var1, int var2);

    public abstract void sendConsoleEcho(String var1);

    public abstract void sendConsoleMessage(String var1);

    public void setCallbackFunction(String callbackType, String callbackFunction) {
        Console.errPrintln("Ignoring set-callback request to associate " + callbackType + " with function " + callbackFunction);
    }

    public void showHelp() {
        this.showUrl("http://wiki.jmol.org", "jmolHelp");
    }

    public abstract void showUrl(String var1, String var2);

    public abstract void showConsole(boolean var1);

    public static Viewer getJmolData(JmolParser jmolParser) {
        return (Viewer)JmolViewer.allocateViewer(null, null, null, null, null, (String)"-x -o -n", (JmolStatusListener)jmolParser);
    }

    public void allocateViewer(Container renderPanel, boolean jmolfileio, String htmlName, URL documentBase, URL codeBase, String commandOptions) {
        this.allocateViewer(renderPanel, jmolfileio, htmlName, documentBase, codeBase, commandOptions, null, null);
    }

    public void allocateViewer(Container renderPanel, boolean jmolfileio, String htmlName, URL documentBase, URL codeBase, String commandOptions, Container consolePanel, String buttonsToShow) {
        Console.errPrintln("Allocating Jmol Viewer: " + commandOptions);
        if (commandOptions == null) {
            commandOptions = "";
        }
        this.jmolViewer = (Viewer)JmolViewer.allocateViewer((Object)renderPanel, (JmolAdapter)(jmolfileio ? new SmarterJmolAdapter() : null), (String)(htmlName + this.toString()), (URL)documentBase, (URL)codeBase, (String)commandOptions, (JmolStatusListener)this);
        this.jmolViewer.setJmolStatusListener((JmolStatusListener)this);
        try {
            this.console = this.createJmolConsole(consolePanel, buttonsToShow);
        }
        catch (Throwable e) {
            Console.errPrintln("Could not create Jmol application console. " + e.getMessage());
            e.printStackTrace();
        }
        if (consolePanel != null) {
            consolePanel.addComponentListener(this);
        }
    }

    protected abstract JmolAppConsoleInterface createJmolConsole(Container var1, String var2);

    public int[] resizeInnerPanel(String data) {
        return null;
    }

    protected void closeConsole() {
        if (this.console != null) {
            try {
                this.console.setVisible(false);
            }
            catch (Error error) {
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.console = null;
        }
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
        this.showConsole(true);
    }

    @Override
    public void componentHidden(ComponentEvent e) {
        this.showConsole(false);
    }

    @Override
    protected String getModelIdForFile(String pdbFile) {
        if (this.modelFileNames == null) {
            return "";
        }
        for (int i = 0; i < this.modelFileNames.length; ++i) {
            if (!JmolCommands.filePathMatch(this.modelFileNames[i], pdbFile)) continue;
            return String.valueOf(i + 1);
        }
        return "";
    }

    @Override
    protected StructureViewer.ViewerType getViewerType() {
        return StructureViewer.ViewerType.JMOL;
    }

    @Override
    protected String getModelId(int pdbfnum, String file) {
        return String.valueOf(pdbfnum + 1);
    }

    @Override
    public String getSessionFileExtension() {
        return ".spt";
    }

    public void selectionChanged(BS arg0) {
    }

    @Override
    public jalview.api.SequenceRenderer getSequenceRenderer(AlignmentViewPanel avp) {
        return new SequenceRenderer(avp.getAlignViewport());
    }

    @Override
    public String getHelpURL() {
        return "http://wiki.jmol.org";
    }
}

