/*
 * Decompiled with CFR 0.152.
 */
package jalview.datamodel;

import jalview.datamodel.AlignmentAnnotation;
import java.awt.Color;

public class BinaryNode<T> {
    T element;
    String name;
    String label = null;
    AlignmentAnnotation alignmentAnnotation = null;
    BinaryNode<T> left = null;
    BinaryNode<T> right = null;
    BinaryNode<T> parent = null;
    public int bootstrap = 0;
    public double dist = 0.0;
    public int count;
    public double height;
    public float ycount;
    public Color color = Color.black;
    public boolean dummy = false;

    public BinaryNode() {
    }

    public BinaryNode(T element, BinaryNode<T> parent, String name, double dist) {
        this();
        this.element = element;
        this.parent = parent;
        this.name = name;
        this.dist = dist;
    }

    public BinaryNode(T element, BinaryNode<T> parent, String name, double dist, int bootstrap) {
        this(element, parent, name, dist);
        this.bootstrap = bootstrap;
    }

    public BinaryNode(T val, BinaryNode<T> parent, String name, double dist, int bootstrap, boolean dummy) {
        this(val, parent, name, dist, bootstrap);
        this.dummy = dummy;
    }

    public T element() {
        return this.element;
    }

    public T setElement(T v) {
        this.element = v;
        return this.element;
    }

    public BinaryNode<T> left() {
        return this.left;
    }

    public BinaryNode<T> setLeft(BinaryNode<T> n) {
        this.left = n;
        return this.left;
    }

    public BinaryNode<T> right() {
        return this.right;
    }

    public BinaryNode<T> setRight(BinaryNode<T> n) {
        this.right = n;
        return this.right;
    }

    public BinaryNode<T> parent() {
        return this.parent;
    }

    public BinaryNode<T> setParent(BinaryNode<T> n) {
        this.parent = n;
        return this.parent;
    }

    public boolean isLeaf() {
        return this.left == null && this.right == null;
    }

    public void SetChildren(BinaryNode<T> leftchild, BinaryNode<T> rightchild) {
        if (leftchild != null) {
            this.setLeft(leftchild);
            leftchild.detach();
            leftchild.setParent(this);
        }
        if (rightchild != null) {
            this.setRight(rightchild);
            rightchild.detach();
            rightchild.setParent(this);
        }
    }

    public BinaryNode<T> detach() {
        if (this.parent != null) {
            if (this.parent.left == this) {
                this.parent.left = null;
            } else if (this.parent.right == this) {
                this.parent.right = null;
            }
        }
        this.parent = null;
        return this;
    }

    public BinaryNode<T> ascendLeft() {
        BinaryNode<T> c = this;
        while ((c = c.parent()) != null && c.left() != null && !c.left().isLeaf()) {
        }
        return c;
    }

    public BinaryNode<T> ascendRight() {
        BinaryNode<T> c = this;
        while ((c = c.parent()) != null && c.right() != null && !c.right().isLeaf()) {
        }
        return c;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setBootstrap(int boot) {
        this.bootstrap = boot;
    }

    public int getBootstrap() {
        return this.bootstrap;
    }

    public boolean isDummy() {
        return this.dummy;
    }

    public boolean setDummy(boolean newstate) {
        boolean oldstate = this.dummy;
        this.dummy = newstate;
        return oldstate;
    }

    public boolean hasLabel() {
        return this.label != null && !this.label.isEmpty();
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public boolean hasAlignmentAnnotation() {
        return this.alignmentAnnotation != null;
    }

    public AlignmentAnnotation getAlignmentAnnotation() {
        return this.alignmentAnnotation;
    }

    public void setAlignmentAnnotation(AlignmentAnnotation alignmentAnnotation) {
        this.alignmentAnnotation = alignmentAnnotation;
    }

    public BinaryNode<T> AscendTree() {
        BinaryNode<T> c = this;
        while ((c = c.parent()) != null && c.dummy) {
        }
        return c;
    }

    public String getDisplayName() {
        if (this.name != null && !this.name.isBlank()) {
            if (this.hasLabel()) {
                return this.getName() + "|" + this.label;
            }
            return this.name;
        }
        return this.hasLabel() ? this.label : "";
    }
}

