/*
 * Decompiled with CFR 0.152.
 */
package compbio.metadata;

import compbio.metadata.Option;
import compbio.metadata.ValueConstrain;
import compbio.metadata.WrongParameterException;
import compbio.util.SysPrefs;
import compbio.util.Util;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.bind.ValidationException;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class Parameter<T>
extends Option<T> {
    @XmlElement
    Set<String> possibleValues = new HashSet<String>();
    ValueConstrain validValue;

    private Parameter() {
    }

    public Parameter(String name, String description) {
        super(name, description);
    }

    public ValueConstrain getValidValue() {
        return this.validValue;
    }

    public void setValidValue(ValueConstrain validValue) {
        if (validValue == null) {
            throw new NullPointerException("ValueConstrain is expected!");
        }
        this.validValue = validValue;
    }

    @Override
    public String toString() {
        String value = super.toString();
        if (this.validValue != null) {
            value = value + this.validValue.toString();
        }
        if (!this.possibleValues.isEmpty()) {
            TreeSet<String> sortedPosval = new TreeSet<String>(this.possibleValues);
            value = value + "POSSIBLE VALUES:" + SysPrefs.newlinechar;
            for (String val : sortedPosval) {
                value = value + val + SysPrefs.newlinechar;
            }
        }
        return value;
    }

    @Override
    public String toCommand(String nameValueSeparator) {
        if (nameValueSeparator == null) {
            throw new NullPointerException("Name value separator is expected!");
        }
        return this.getOptionName() + nameValueSeparator + this.getValue();
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        Parameter objp = null;
        if (!(obj instanceof Parameter)) {
            return false;
        }
        objp = (Parameter)obj;
        if (objp.possibleValues.size() != this.possibleValues.size()) {
            return false;
        }
        int matchCount = 0;
        block0: for (String pv : objp.possibleValues) {
            if (Util.isEmpty(pv)) continue;
            for (String thispv : this.possibleValues) {
                if (!pv.equals(thispv)) continue;
                ++matchCount;
                continue block0;
            }
        }
        return matchCount == objp.possibleValues.size();
    }

    @Override
    public List<String> getPossibleValues() {
        return new ArrayList<String>(this.possibleValues);
    }

    public void setPossibleValues(Set<String> possibleValues) {
        this.possibleValues = new HashSet<String>(possibleValues);
    }

    public Set<String> addPossibleValues(String ... value) {
        for (String v : value) {
            this.possibleValues.add(v);
        }
        return this.possibleValues;
    }

    @Override
    public int hashCode() {
        int code = super.hashCode();
        if (this.possibleValues != null) {
            code += this.possibleValues.hashCode();
        }
        return code;
    }

    @Override
    public void setOptionNames(Set<String> optionName) {
        if (optionName.size() != 1) {
            throw new IllegalArgumentException("Parameter must have a single option name! But given " + optionName.size() + " names:  " + optionName);
        }
        super.setOptionNames(optionName);
    }

    @Override
    public Set<String> addOptionNames(String ... value) {
        throw new UnsupportedOperationException("Parameter must have only one optionName! If you setting the only name that use setOptionName instead");
    }

    public String getOptionName() {
        assert (this.optionNames.size() == 1);
        return (String)this.optionNames.iterator().next();
    }

    public void setOptionName(String optionName) {
        assert (!Util.isEmpty(optionName));
        this.setOptionNames(Collections.singleton(optionName));
    }

    String getValue() {
        if (this.possibleValues.size() == 1) {
            return this.possibleValues.iterator().next();
        }
        return this.getDefaultValue();
    }

    @Override
    void validate() throws ValidationException {
        super.validate();
        if (this.validValue == null) {
            if (this.possibleValues.isEmpty()) {
                throw new ValidationException("No possible values defined for parameter: " + this);
            }
            if (this.possibleValues.size() > 1 && Util.isEmpty(this.getDefaultValue())) {
                throw new ValidationException("Multiple possible values are defined but no default value for parameter: " + this);
            }
        } else {
            if (Util.isEmpty(this.getDefaultValue())) {
                throw new ValidationException("Default value is not defined for numeric parameter! " + this);
            }
            this.validValue.checkValue(this.getDefaultValue());
        }
    }

    boolean isValidValue(String value) {
        assert (!Util.isEmpty(value));
        return Option.valueExist(value, this.getPossibleValues());
    }

    @Override
    public void setDefaultValue(String defaultVal) throws WrongParameterException {
        if (this.validValue == null) {
            if (this.getPossibleValues().isEmpty()) {
                throw new IllegalStateException("Attempting to set default value for parameter: " + this + " Without possible values! Please define possible value first!");
            }
            if (!this.isValidValue(defaultVal)) {
                throw new WrongParameterException("Attempting to set illegal value '" + defaultVal + "' for the parameter: " + this);
            }
        } else {
            try {
                this.validValue.checkValue(defaultVal);
            }
            catch (IndexOutOfBoundsException e) {
                throw new WrongParameterException("Attempting to set default value outside boundaries defined by the constraint: " + this.validValue + "\n For parameter: " + this);
            }
        }
        this.defaultValue = defaultVal;
    }
}

