/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.calc;

import javajs.util.BS;
import javajs.util.P3;
import javajs.util.P3i;
import javajs.util.P4;
import javajs.util.SB;
import javajs.util.V3;
import org.jmol.jvxl.api.VertexDataServer;
import org.jmol.jvxl.data.JvxlCoder;
import org.jmol.jvxl.data.VolumeData;
import org.jmol.jvxl.readers.Parameters;
import org.jmol.util.TriangleData;

public class MarchingCubes
extends TriangleData {
    protected VertexDataServer surfaceReader;
    protected VolumeData volumeData;
    protected int contourType;
    protected boolean isContoured;
    protected float cutoff;
    protected boolean isCutoffAbsolute;
    protected boolean isSquared;
    protected boolean isXLowToHigh;
    protected int cubeCountX;
    protected int cubeCountY;
    protected int cubeCountZ;
    protected int nY;
    protected int nZ;
    protected int yzCount;
    protected boolean colorDensity;
    protected boolean integrateSquared = true;
    public BS bsVoxels;
    protected BS bsExcludedVertices;
    protected BS bsExcludedTriangles;
    protected BS bsExcludedPlanes;
    protected SB edgeData = new SB();
    private boolean excludePartialCubes = true;
    protected int mode;
    protected static final int MODE_CUBE = 1;
    protected static final int MODE_JVXL = 2;
    protected static final int MODE_PLANES = 3;
    protected final float[] vertexValues = new float[8];
    protected int edgeCount;
    protected final V3[] voxelVertexVectors = new V3[8];
    protected final V3[] edgeVectors = new V3[12];
    protected static int[] yzPlanePts = new int[]{0, 1, 1, 0, 0, 1, 1, 0};
    protected final int[] edgePointIndexes;
    protected int[][][] isoPointIndexPlanes;
    protected float[][] yzPlanes;
    private P4 mappingPlane;
    private boolean allInside;
    private boolean isInside;
    private P3i offset;
    private float[][][] voxelData;
    protected int nTriangles;
    protected BS bsValues;
    protected final P3 pt0;
    protected final P3 pointA;
    protected static final int[] edgeVertexPointersLowToHigh = new int[]{1, 1, 2, 0, 5, 5, 6, 4, 0, 1, 2, 3};
    protected static final int[] edgeVertexPointersHighToLow = new int[]{0, 1, 3, 0, 4, 5, 7, 4, 0, 1, 2, 3};
    protected int[] edgeVertexPointers;
    protected static final int[] edgeVertexPlanesLowToHigh = new int[]{1, 1, 1, 0, 1, 1, 1, 0, 0, 1, 1, 0};
    protected static final int[] edgeVertexPlanesHighToLow = new int[]{1, 0, 1, 1, 1, 0, 1, 1, 1, 0, 0, 1};
    protected int[] edgeVertexPlanes;
    protected float[] fReturn;
    protected static final V3[] cubeVertexVectors = new V3[]{V3.new3(0.0f, 0.0f, 0.0f), V3.new3(1.0f, 0.0f, 0.0f), V3.new3(1.0f, 0.0f, 1.0f), V3.new3(0.0f, 0.0f, 1.0f), V3.new3(0.0f, 1.0f, 0.0f), V3.new3(1.0f, 1.0f, 0.0f), V3.new3(1.0f, 1.0f, 1.0f), V3.new3(0.0f, 1.0f, 1.0f)};
    protected static final int[] edgeTypeTable = new int[]{0, 2, 0, 2, 0, 2, 0, 2, 1, 1, 1, 1};
    protected final int[] linearOffsets;
    protected static final short[] insideMaskTable = new short[]{0, 265, 515, 778, 1030, 1295, 1541, 1804, 2060, 2309, 2575, 2822, 3082, 3331, 3593, 3840, 400, 153, 915, 666, 1430, 1183, 1941, 1692, 2460, 2197, 2975, 2710, 3482, 3219, 3993, 3728, 560, 825, 51, 314, 1590, 1855, 1077, 1340, 2620, 2869, 2111, 2358, 3642, 3891, 3129, 3376, 928, 681, 419, 170, 1958, 1711, 1445, 1196, 2988, 2725, 2479, 2214, 4010, 3747, 3497, 3232, 1120, 1385, 1635, 1898, 102, 367, 613, 876, 3180, 3429, 3695, 3942, 2154, 2403, 2665, 2912, 1520, 1273, 2035, 1786, 502, 255, 1013, 764, 3580, 3317, 4095, 3830, 2554, 2291, 3065, 2800, 1616, 1881, 1107, 1370, 598, 863, 85, 348, 3676, 3925, 3167, 3414, 2650, 2899, 2137, 2384, 1984, 1737, 1475, 1226, 966, 719, 453, 204, 4044, 3781, 3535, 3270, 3018, 2755, 2505, 2240, 2240, 2505, 2755, 3018, 3270, 3535, 3781, 4044, 204, 453, 719, 966, 1226, 1475, 1737, 1984, 2384, 2137, 2899, 2650, 3414, 3167, 3925, 3676, 348, 85, 863, 598, 1370, 1107, 1881, 1616, 2800, 3065, 2291, 2554, 3830, 4095, 3317, 3580, 764, 1013, 255, 502, 1786, 2035, 1273, 1520, 2912, 2665, 2403, 2154, 3942, 3695, 3429, 3180, 876, 613, 367, 102, 1898, 1635, 1385, 1120, 3232, 3497, 3747, 4010, 2214, 2479, 2725, 2988, 1196, 1445, 1711, 1958, 170, 419, 681, 928, 3376, 3129, 3891, 3642, 2358, 2111, 2869, 2620, 1340, 1077, 1855, 1590, 314, 51, 825, 560, 3728, 3993, 3219, 3482, 2710, 2975, 2197, 2460, 1692, 1941, 1183, 1430, 666, 915, 153, 400, 3840, 3593, 3331, 3082, 2822, 2575, 2309, 2060, 1804, 1541, 1295, 1030, 778, 515, 265, 0};

    public MarchingCubes() {
        int i = 12;
        while (--i >= 0) {
            this.edgeVectors[i] = new V3();
        }
        this.edgePointIndexes = new int[12];
        this.bsValues = new BS();
        this.pt0 = new P3();
        this.pointA = new P3();
        this.fReturn = new float[1];
        this.linearOffsets = new int[8];
    }

    public MarchingCubes(VertexDataServer surfaceReader, VolumeData volumeData, Parameters params, BS bsVoxels) {
        int i = 12;
        while (--i >= 0) {
            this.edgeVectors[i] = new V3();
        }
        this.edgePointIndexes = new int[12];
        this.bsValues = new BS();
        this.pt0 = new P3();
        this.pointA = new P3();
        this.fReturn = new float[1];
        this.linearOffsets = new int[8];
        this.excludePartialCubes = true;
        this.surfaceReader = surfaceReader;
        this.bsVoxels = bsVoxels;
        BS[] bsExcluded = params.bsExcluded;
        this.bsExcludedVertices = bsExcluded[0] == null ? new BS() : bsExcluded[0];
        this.bsExcludedPlanes = bsExcluded[2] == null ? new BS() : bsExcluded[2];
        BS bS = this.bsExcludedTriangles = bsExcluded[3] == null ? new BS() : bsExcluded[3];
        this.mode = volumeData.getVoxelData() != null || volumeData.mappingPlane != null ? 1 : (bsVoxels != null ? 2 : 3);
        this.setParameters(volumeData, params);
    }

    protected void setParameters(VolumeData volumeData, Parameters params) {
        this.volumeData = volumeData;
        this.colorDensity = params.colorDensity;
        this.isContoured = params.thePlane == null && params.isContoured && !this.colorDensity;
        this.cutoff = params.cutoff;
        this.isCutoffAbsolute = params.isCutoffAbsolute;
        this.contourType = params.contourType;
        this.isSquared = params.isSquared;
        this.isXLowToHigh = params.isXLowToHigh;
        this.cubeCountX = volumeData.voxelCounts[0] - 1;
        this.cubeCountY = volumeData.voxelCounts[1] - 1;
        this.cubeCountZ = volumeData.voxelCounts[2] - 1;
        volumeData.getYzCount();
        if (params.mapLattice != null) {
            this.cubeCountX = (int)((float)this.cubeCountX * Math.abs(params.mapLattice.x));
            this.cubeCountY = (int)((float)this.cubeCountY * Math.abs(params.mapLattice.y));
            this.cubeCountZ = (int)((float)this.cubeCountZ * Math.abs(params.mapLattice.z));
        }
        this.nY = this.cubeCountY + 1;
        this.nZ = this.cubeCountZ + 1;
        this.yzCount = this.nY * this.nZ;
        if (this.bsVoxels == null) {
            this.bsVoxels = new BS();
        }
        this.edgeVertexPointers = this.isXLowToHigh ? edgeVertexPointersLowToHigh : edgeVertexPointersHighToLow;
        this.edgeVertexPlanes = this.isXLowToHigh ? edgeVertexPlanesLowToHigh : edgeVertexPlanesHighToLow;
        this.isoPointIndexPlanes = new int[2][this.yzCount][3];
        this.yzPlanes = this.mode == 3 ? new float[2][this.yzCount] : null;
        this.setLinearOffsets();
        this.calcVoxelVertexVectors();
    }

    protected void calcVoxelVertexVectors() {
        int i = 8;
        while (--i >= 0) {
            this.voxelVertexVectors[i] = new V3();
            this.volumeData.transform(cubeVertexVectors[i], this.voxelVertexVectors[i]);
        }
        i = 12;
        while (--i >= 0) {
            this.edgeVectors[i].sub2(this.voxelVertexVectors[edgeVertexes[i + i + 1]], this.voxelVertexVectors[edgeVertexes[i + i]]);
        }
    }

    protected int[][] resetIndexPlane(int[][] plane) {
        for (int i = 0; i < this.yzCount; ++i) {
            for (int j = 0; j < 3; ++j) {
                plane[i][j] = Integer.MIN_VALUE;
            }
        }
        return plane;
    }

    public String getEdgeData() {
        int ptStep;
        int xStep;
        int ptX;
        int x1;
        int x0;
        if (this.cubeCountX < 0 || this.cubeCountY < 0 || this.cubeCountZ < 0) {
            return "";
        }
        this.mappingPlane = this.volumeData.mappingPlane;
        this.edgeCount = 0;
        if (this.isXLowToHigh) {
            x0 = 0;
            x1 = this.cubeCountX + (this.colorDensity ? 1 : 0);
            if (this.colorDensity) {
                x1 = this.cubeCountX + 1;
                ptX = this.yzCount - 1;
            } else {
                x1 = this.cubeCountX;
                ptX = this.yzCount - 1 - this.nZ - 1;
            }
            xStep = 1;
            ptStep = this.yzCount;
        } else {
            if (this.colorDensity) {
                x0 = this.cubeCountX;
                ptX = (this.cubeCountX + 1) * this.yzCount - 1;
            } else {
                x0 = this.cubeCountX - 1;
                ptX = this.cubeCountX * this.yzCount - 1 - this.nZ - 1;
            }
            x1 = -1;
            xStep = -1;
            ptStep = -this.yzCount;
        }
        int pt = ptX;
        this.resetIndexPlane(this.isoPointIndexPlanes[1]);
        this.voxelData = null;
        int y1 = this.cubeCountY + (this.colorDensity ? 1 : 0);
        int z1 = this.cubeCountZ + (this.colorDensity ? 1 : 0);
        switch (this.mode) {
            case 3: {
                this.getPlane(x0, false);
                break;
            }
            case 1: {
                this.voxelData = this.volumeData.getVoxelData();
            }
        }
        this.allInside = this.colorDensity && (this.cutoff == 0.0f || this.mode == 2 && this.bsVoxels.nextSetBit(0) < 0);
        boolean colorDensityAll = this.colorDensity && this.cutoff == 0.0f;
        float v = 0.0f;
        for (int x = x0; x != x1; x += xStep) {
            if (this.mode == 3 && x + xStep <= x1) {
                this.getPlane(x + xStep, true);
            }
            if (!this.bsExcludedPlanes.get(x) || !this.bsExcludedPlanes.get(x + xStep)) {
                if (this.colorDensity) {
                    int y = y1;
                    while (--y >= 0) {
                        int z = z1;
                        while (--z >= 0) {
                            v = this.getValue(x, y, z, pt, 0);
                            if (colorDensityAll || this.isInside) {
                                this.addVertex(x, y, z, pt, v);
                            }
                            --pt;
                        }
                    }
                } else {
                    int[][] indexPlane = this.isoPointIndexPlanes[0];
                    this.isoPointIndexPlanes[0] = this.isoPointIndexPlanes[1];
                    this.isoPointIndexPlanes[1] = this.resetIndexPlane(indexPlane);
                    boolean noValues = true;
                    int y = y1;
                    while (--y >= 0) {
                        int z = z1;
                        while (--z >= 0) {
                            int insideMask = 0;
                            int i = 8;
                            while (--i >= 0) {
                                v = this.getValue(x, y, z, pt, i);
                                if (!this.isInside) continue;
                                insideMask |= Pwr2[i];
                            }
                            if (noValues && !Float.isNaN(v)) {
                                noValues = false;
                            }
                            if (insideMask != 0 && insideMask != 255 && this.processOneCubical(insideMask, x, y, z, pt) && !this.isContoured && !this.colorDensity) {
                                this.processTriangles(insideMask);
                            }
                            --pt;
                        }
                        --pt;
                    }
                    if (noValues) {
                        this.bsExcludedPlanes.set(x);
                    }
                }
            }
            pt = ptX += ptStep;
        }
        return this.edgeData.toString();
    }

    private float getValue(int x, int y, int z, int pt, int i) {
        float v;
        this.offset = cubeVertexOffsets[i];
        int pti = pt + this.linearOffsets[i];
        switch (this.mode) {
            case 3: {
                v = this.vertexValues[i] = this.getValueArray(x + this.offset.x, y + this.offset.y, z + this.offset.z, pti, this.yzPlanes[yzPlanePts[i]]);
                this.isInside = this.allInside || this.bsVoxels.get(pti);
                break;
            }
            case 2: {
                boolean bl = this.isInside = this.allInside || this.bsVoxels.get(pti);
                this.vertexValues[i] = this.bsExcludedVertices.get(pti) ? Float.NaN : (this.isInside ? 1.0f : 0.0f);
                v = this.vertexValues[i];
                break;
            }
            default: {
                if (this.mappingPlane == null) {
                    v = this.vertexValues[i] = this.voxelData[x + this.offset.x][y + this.offset.y][z + this.offset.z];
                } else {
                    this.volumeData.voxelPtToXYZ(x + this.offset.x, y + this.offset.y, z + this.offset.z, this.pt0);
                    v = this.vertexValues[i] = this.volumeData.distanceToMappingPlane(this.pt0);
                }
                if (this.isSquared) {
                    int n = i;
                    this.vertexValues[n] = this.vertexValues[n] * this.vertexValues[i];
                }
                boolean bl = this.isInside = this.allInside ? true : MarchingCubes.isInside(this.vertexValues[i], this.cutoff, this.isCutoffAbsolute);
                if (!this.isInside) break;
                this.bsVoxels.set(pti);
            }
        }
        return v;
    }

    private void getPlane(int i, boolean andSwap) {
        if (i < 0 || i > this.cubeCountX) {
            return;
        }
        this.surfaceReader.getPlane(i);
        if (andSwap) {
            float[] plane = this.yzPlanes[0];
            this.yzPlanes[0] = this.yzPlanes[1];
            this.yzPlanes[1] = plane;
        }
    }

    protected void processTriangles(int insideMask) {
        byte[] triangles = triangleTable2[insideMask];
        int i = triangles.length;
        while ((i -= 4) >= 0) {
            this.addTriangle(triangles[i], triangles[i + 1], triangles[i + 2], triangles[i + 3]);
        }
    }

    protected void addVertex(int x, int y, int z, int pti, float value) {
        this.volumeData.voxelPtToXYZ(x, y, z, this.pt0);
        if (this.surfaceReader.addVertexCopy(this.pt0, value, -4, true) < 0) {
            this.bsExcludedVertices.set(pti);
        }
    }

    protected void addTriangle(int ia, int ib, int ic, int edgeType) {
        if (!this.bsExcludedTriangles.get(this.nTriangles) && this.surfaceReader.addTriangleCheck(this.edgePointIndexes[ia], this.edgePointIndexes[ib], this.edgePointIndexes[ic], edgeType, 0, this.isCutoffAbsolute, 0) < 0) {
            this.bsExcludedTriangles.set(this.nTriangles);
        }
        ++this.nTriangles;
    }

    protected float getValueArray(int x, int y, int z, int pt, float[] tempValues) {
        int ptyz = pt % this.yzCount;
        this.bsValues.set(pt);
        float value = this.surfaceReader.getValue(x, y, z, ptyz);
        if (this.isSquared) {
            value *= value;
        }
        tempValues[ptyz] = value;
        if (MarchingCubes.isInside(value, this.cutoff, this.isCutoffAbsolute)) {
            this.bsVoxels.set(pt);
        }
        return value;
    }

    public static boolean isInside(float voxelValue, float max, boolean isAbsolute) {
        return max > 0.0f && (isAbsolute ? Math.abs(voxelValue) : voxelValue) >= max || max <= 0.0f && voxelValue <= max;
    }

    protected boolean processOneCubical(int insideMask, int x, int y, int z, int pt) {
        short edgeMask = insideMaskTable[insideMask];
        boolean isNaN = false;
        int iEdge = 12;
        while (--iEdge >= 0) {
            int xEdge = Pwr2[iEdge];
            if ((edgeMask & xEdge) == 0) continue;
            int iPlane = this.edgeVertexPlanes[iEdge];
            int iPt = (pt + this.linearOffsets[this.edgeVertexPointers[iEdge]]) % this.yzCount;
            int iType = edgeTypeTable[iEdge];
            this.edgePointIndexes[iEdge] = this.isoPointIndexPlanes[iPlane][iPt][iType];
            int index = this.edgePointIndexes[iEdge];
            if (index != Integer.MIN_VALUE) {
                if (index != -1) continue;
                isNaN = this.excludePartialCubes;
                continue;
            }
            byte vertexA = edgeVertexes[iEdge << 1];
            byte vertexB = edgeVertexes[(iEdge << 1) + 1];
            float valueA = this.vertexValues[vertexA];
            float valueB = this.vertexValues[vertexB];
            this.calcVertexPoint(x, y, z, vertexA, this.pointA);
            ++this.edgeCount;
            int n = this.surfaceReader.getSurfacePointIndexAndFraction(this.cutoff, this.isCutoffAbsolute, x, y, z, cubeVertexOffsets[vertexA], vertexA, vertexB, valueA, valueB, this.pointA, this.edgeVectors[iEdge], iType == this.contourType, this.fReturn);
            this.isoPointIndexPlanes[iPlane][iPt][iType] = n;
            this.edgePointIndexes[iEdge] = n;
            int i = n;
            this.addEdgeData(i < 0 ? Float.NaN : this.fReturn[0]);
            if (!Float.isNaN(this.fReturn[0]) && i >= 0) continue;
            isNaN = this.excludePartialCubes;
        }
        return !isNaN;
    }

    protected void addEdgeData(float f) {
        char ch = JvxlCoder.jvxlFractionAsCharacter(f);
        this.edgeData.appendC(ch);
    }

    public void calcVertexPoint(int x, int y, int z, int vertex, P3 pt) {
        this.volumeData.voxelPtToXYZ(x, y, z, this.pt0);
        pt.add2(this.pt0, this.voxelVertexVectors[vertex]);
    }

    protected void setLinearOffsets() {
        this.linearOffsets[0] = 0;
        this.linearOffsets[1] = this.yzCount;
        this.linearOffsets[2] = this.yzCount + 1;
        this.linearOffsets[3] = 1;
        this.linearOffsets[4] = this.nZ;
        this.linearOffsets[5] = this.yzCount + this.nZ;
        this.linearOffsets[6] = this.yzCount + this.nZ + 1;
        this.linearOffsets[7] = this.nZ + 1;
    }

    public int getLinearOffset(int x, int y, int z, int offset) {
        return x * this.yzCount + y * this.nZ + z + this.linearOffsets[offset];
    }
}

