/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.vamsas.client.simpleclient;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import uk.ac.vamsas.client.picking.IMessageHandler;
import uk.ac.vamsas.client.picking.IPickManager;
import uk.ac.vamsas.client.picking.Message;
import uk.ac.vamsas.client.picking.SocketManager;

public class SimplePickManager
implements IPickManager {
    private Log log = LogFactory.getLog((Class)SimplePickManager.class);
    SocketManager manager = null;
    private boolean passThru = true;
    private boolean qUEUE = false;
    IMessageHandler pickHandler = null;

    SimplePickManager(SocketManager manager) {
        this.manager = manager;
        final SimplePickManager me = this;
        manager.registerMessageHandler(new IMessageHandler(){

            public void handleMessage(Message message) {
                me.handleMessage(message);
            }
        });
    }

    public void registerMessageHandler(IMessageHandler handler) {
        this.pickHandler = handler;
    }

    public synchronized void sendMessage(Message message) {
        if (this.passThru && this.manager != null) {
            this.manager.sendMessage(message);
        }
    }

    protected synchronized void handleMessage(Message message) {
        if (this.qUEUE) {
            while (!this.passThru && this.manager != null) {
                this.log.debug((Object)"Not passing through.");
                try {
                    Thread.sleep(5L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (this.passThru && this.manager != null) {
            this.pickHandler.handleMessage(message);
        }
    }

    public boolean isPassThru() {
        return this.passThru;
    }

    public void setPassThru(boolean passThru) {
        this.passThru = passThru;
    }

    public void shutdown() {
        this.passThru = false;
        this.manager.registerMessageHandler(null);
        SocketManager dying = this.manager;
        this.manager = null;
        dying.shutdown();
    }
}

