/*
 * Decompiled with CFR 0.152.
 */
package io.github.warownia1.simplehttpclient.impl;

import io.github.warownia1.simplehttpclient.HttpHeaders;
import io.github.warownia1.simplehttpclient.HttpRequest;
import io.github.warownia1.simplehttpclient.impl.SimpleHttpRequestBuilder;
import java.net.URI;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;

public final class ImmutableHttpRequest
extends HttpRequest {
    private final String method;
    private final URI uri;
    private final HttpHeaders headers;
    private final HttpRequest.Body body;
    private final Duration timeout;

    ImmutableHttpRequest(SimpleHttpRequestBuilder builder) {
        this.method = Objects.requireNonNull(builder.method);
        this.uri = Objects.requireNonNull(builder.uri);
        this.headers = HttpHeaders.of(builder.headers.map());
        this.body = builder.body;
        this.timeout = builder.timeout;
    }

    @Override
    public String method() {
        return this.method;
    }

    @Override
    public URI uri() {
        return this.uri;
    }

    @Override
    public HttpHeaders headers() {
        return this.headers;
    }

    @Override
    public Optional<HttpRequest.Body> body() {
        return Optional.ofNullable(this.body);
    }

    @Override
    public Optional<Duration> timeout() {
        return Optional.ofNullable(this.timeout);
    }

    public String toString() {
        return this.uri.toString() + " " + this.method;
    }
}

