/*
 * Decompiled with CFR 0.152.
 */
package io.github.warownia1.simplehttpclient.impl;

import io.github.warownia1.simplehttpclient.HttpHeaders;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class HttpHeadersBuilder {
    private final TreeMap<String, List<String>> headers = new TreeMap(String.CASE_INSENSITIVE_ORDER);

    public HttpHeadersBuilder structuralCopy() {
        HttpHeadersBuilder builder = new HttpHeadersBuilder();
        for (Map.Entry<String, List<String>> entry : this.headers.entrySet()) {
            ArrayList valuesCopy = new ArrayList(entry.getValue());
            builder.headers.put(entry.getKey(), valuesCopy);
        }
        return builder;
    }

    public void addHeader(String name, String value) {
        this.headers.computeIfAbsent(name, k -> new ArrayList(1)).add(value);
    }

    public void setHeader(String name, String value) {
        ArrayList<String> values = new ArrayList<String>(1);
        values.add(value);
        this.headers.put(name, values);
    }

    public void clear() {
        this.headers.clear();
    }

    public Map<String, List<String>> map() {
        return this.headers;
    }

    public HttpHeaders build() {
        return HttpHeaders.of(this.headers);
    }

    public String toString() {
        return super.toString() + " { " + this.map() + " }";
    }
}

