/*
 * Decompiled with CFR 0.152.
 */
package io.github.warownia1.simplehttpclient;

import io.github.warownia1.simplehttpclient.HttpHeaders;
import io.github.warownia1.simplehttpclient.impl.SimpleHttpRequestBuilder;
import java.net.URI;
import java.time.Duration;
import java.util.Optional;

public abstract class HttpRequest {
    public static Builder newBuilder(URI uri) {
        return HttpRequest.newBuilder().uri(uri);
    }

    public static Builder newBuilder() {
        return new SimpleHttpRequestBuilder();
    }

    public abstract Optional<Body> body();

    public abstract String method();

    public abstract URI uri();

    public abstract HttpHeaders headers();

    public abstract Optional<Duration> timeout();

    public static interface Body {
        public byte[] getBytes();

        public long contentLength();
    }

    public static interface Builder {
        public Builder uri(URI var1);

        public Builder header(String var1, String var2);

        public Builder HEAD();

        public Builder GET();

        public Builder POST(Body var1);

        public Builder PUT(Body var1);

        public Builder DELETE();

        public Builder method(String var1, Body var2);

        public Builder timeout(Duration var1);

        public HttpRequest build();
    }
}

