/*
 * Decompiled with CFR 0.152.
 */
package io.github.warownia1.simplehttpclient;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import java.util.TreeSet;

public final class HttpHeaders {
    private final Map<String, List<String>> headers;

    private HttpHeaders(Map<String, List<String>> headers) {
        this.headers = headers;
    }

    public static HttpHeaders of(Map<String, List<String>> map) {
        Objects.requireNonNull(map);
        TreeMap headers = new TreeMap(String.CASE_INSENSITIVE_ORDER);
        TreeSet notAdded = new TreeSet(String.CASE_INSENSITIVE_ORDER);
        map.forEach((key, value) -> {
            String headerName = Objects.requireNonNull(key, "header name").trim();
            if (headerName.isEmpty()) {
                throw new IllegalArgumentException("empty header name");
            }
            Objects.requireNonNull(value, "header values");
            ArrayList<String> headerValues = new ArrayList<String>(1);
            for (String headerValue : value) {
                headerValue = Objects.requireNonNull(headerValue, "header value").trim();
                headerValues.add(headerValue);
            }
            if (headers.containsKey(headerName) || notAdded.contains(headerName)) {
                throw new IllegalArgumentException("duplicate header: " + headerName);
            }
            if (!headerValues.isEmpty()) {
                headers.put(headerName, Collections.unmodifiableList(headerValues));
            } else {
                notAdded.add(headerName);
            }
        });
        return new HttpHeaders(Collections.unmodifiableMap(headers));
    }

    public Map<String, List<String>> map() {
        return this.headers;
    }

    public List<String> allValues(String name) {
        Objects.requireNonNull(name);
        List<String> values = this.headers.get(name);
        return values != null ? values : Collections.emptyList();
    }

    public Optional<String> firstValue(String name) {
        List<String> values = this.allValues(name);
        if (values.isEmpty()) {
            return Optional.empty();
        }
        return Optional.ofNullable(values.get(0));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof HttpHeaders)) {
            return false;
        }
        return this.map().equals(((HttpHeaders)obj).map());
    }

    public int hashCode() {
        int h = 0;
        for (Map.Entry<String, List<String>> e : this.map().entrySet()) {
            h += HttpHeaders.entryHash(e);
        }
        return h;
    }

    private static int entryHash(Map.Entry<String, List<String>> e) {
        int keyHash = e.getKey().toLowerCase(Locale.ROOT).hashCode();
        int valHash = e.getValue().hashCode();
        return keyHash ^ valHash;
    }

    public String toString() {
        return super.toString() + " { " + this.map() + " }";
    }
}

