/*
 * Decompiled with CFR 0.152.
 */
package demo;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.RenderingHints;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.jcolorbrewer.ColorBrewer;

public class GetColorGradient
extends JPanel {
    private static final long serialVersionUID = -4954397192682351367L;
    Color[] colors;

    private static Color[] getMyGradient() {
        Color[] myGradient;
        boolean colorBlindSave = true;
        ColorBrewer[] sequentialPalettes = ColorBrewer.getSequentialColorPalettes(colorBlindSave);
        ColorBrewer myBrewer = sequentialPalettes[0];
        System.out.println("Name of this color brewer: " + (Object)((Object)myBrewer));
        for (Color color : myGradient = myBrewer.getColorPalette(8)) {
            String hex = Integer.toHexString(color.getRGB() & 0xFFFFFF);
            System.out.println("#" + hex + ";");
        }
        return myGradient;
    }

    public GetColorGradient(Color[] colors) {
        super(new GridLayout(colors.length, 1));
        this.colors = colors;
        this.setPreferredSize(new Dimension(15, (colors.length + 1) * 15));
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                UIManager.put("swing.boldMetal", Boolean.FALSE);
                GetColorGradient.createAndShowGUI();
            }
        });
    }

    private static void createAndShowGUI() {
        Color[] colors = GetColorGradient.getMyGradient();
        JFrame frame = new JFrame("Color Palette Demo");
        frame.setDefaultCloseOperation(3);
        frame.add(new GetColorGradient(colors));
        frame.pack();
        frame.setVisible(true);
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int x = 5;
        int y = 7;
        int width = 15;
        int height = 15;
        int colorCount = this.colors.length;
        for (int i = 0; i < colorCount; ++i) {
            g.setColor(this.colors[i]);
            g.fillRect(x, y + i * height, width, height);
            g.setColor(Color.BLACK);
            g.drawRect(x, y + i * height, width, height);
        }
    }
}

