/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.util;

import com.sun.istack.NotNull;
import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.databinding.MetadataReader;
import com.sun.xml.ws.api.server.AsyncProvider;
import com.sun.xml.ws.api.streaming.XMLStreamReaderFactory;
import com.sun.xml.ws.handler.HandlerChainsModel;
import com.sun.xml.ws.model.ReflectAnnotationReader;
import com.sun.xml.ws.server.EndpointFactory;
import com.sun.xml.ws.streaming.XMLStreamReaderUtil;
import com.sun.xml.ws.util.HandlerAnnotationInfo;
import com.sun.xml.ws.util.UtilException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.logging.Logger;
import javax.jws.HandlerChain;
import javax.jws.WebService;
import javax.jws.soap.SOAPMessageHandlers;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.ws.Provider;
import javax.xml.ws.Service;

public class HandlerAnnotationProcessor {
    private static final Logger logger = Logger.getLogger("com.sun.xml.ws.util");

    public static HandlerAnnotationInfo buildHandlerInfo(@NotNull Class<?> clazz, QName qName, QName qName2, WSBinding wSBinding) {
        HandlerChain handlerChain;
        MetadataReader metadataReader = EndpointFactory.getExternalMetadatReader(clazz, wSBinding);
        if (metadataReader == null) {
            metadataReader = new ReflectAnnotationReader();
        }
        if ((handlerChain = metadataReader.getAnnotation(HandlerChain.class, clazz)) == null) {
            if ((clazz = HandlerAnnotationProcessor.getSEI(clazz, metadataReader)) != null) {
                handlerChain = metadataReader.getAnnotation(HandlerChain.class, clazz);
            }
            if (handlerChain == null) {
                return null;
            }
        }
        if (clazz.getAnnotation(SOAPMessageHandlers.class) != null) {
            throw new UtilException("util.handler.cannot.combine.soapmessagehandlers", new Object[0]);
        }
        InputStream inputStream = HandlerAnnotationProcessor.getFileAsStream(clazz, handlerChain);
        XMLStreamReader xMLStreamReader = XMLStreamReaderFactory.create(null, inputStream, true);
        XMLStreamReaderUtil.nextElementContent(xMLStreamReader);
        HandlerAnnotationInfo handlerAnnotationInfo = HandlerChainsModel.parseHandlerFile(xMLStreamReader, clazz.getClassLoader(), qName, qName2, wSBinding);
        try {
            xMLStreamReader.close();
            inputStream.close();
        }
        catch (XMLStreamException xMLStreamException) {
            xMLStreamException.printStackTrace();
            throw new UtilException(xMLStreamException.getMessage(), new Object[0]);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new UtilException(iOException.getMessage(), new Object[0]);
        }
        return handlerAnnotationInfo;
    }

    public static HandlerChainsModel buildHandlerChainsModel(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        HandlerChain handlerChain = clazz.getAnnotation(HandlerChain.class);
        if (handlerChain == null) {
            return null;
        }
        InputStream inputStream = HandlerAnnotationProcessor.getFileAsStream(clazz, handlerChain);
        XMLStreamReader xMLStreamReader = XMLStreamReaderFactory.create(null, inputStream, true);
        XMLStreamReaderUtil.nextElementContent(xMLStreamReader);
        HandlerChainsModel handlerChainsModel = HandlerChainsModel.parseHandlerConfigFile(clazz, xMLStreamReader);
        try {
            xMLStreamReader.close();
            inputStream.close();
        }
        catch (XMLStreamException xMLStreamException) {
            xMLStreamException.printStackTrace();
            throw new UtilException(xMLStreamException.getMessage(), new Object[0]);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new UtilException(iOException.getMessage(), new Object[0]);
        }
        return handlerChainsModel;
    }

    static Class getClass(String string) {
        try {
            return Thread.currentThread().getContextClassLoader().loadClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new UtilException("util.handler.class.not.found", string);
        }
    }

    static Class getSEI(Class<?> clazz, MetadataReader metadataReader) {
        if (metadataReader == null) {
            metadataReader = new ReflectAnnotationReader();
        }
        if (Provider.class.isAssignableFrom(clazz) || AsyncProvider.class.isAssignableFrom(clazz)) {
            return null;
        }
        if (Service.class.isAssignableFrom(clazz)) {
            return null;
        }
        WebService webService = metadataReader.getAnnotation(WebService.class, clazz);
        if (webService == null) {
            throw new UtilException("util.handler.no.webservice.annotation", clazz.getCanonicalName());
        }
        String string = webService.endpointInterface();
        if (string.length() > 0) {
            clazz = HandlerAnnotationProcessor.getClass(webService.endpointInterface());
            WebService webService2 = metadataReader.getAnnotation(WebService.class, clazz);
            if (webService2 == null) {
                throw new UtilException("util.handler.endpoint.interface.no.webservice", webService.endpointInterface());
            }
            return clazz;
        }
        return null;
    }

    static InputStream getFileAsStream(Class clazz, HandlerChain handlerChain) {
        Package package_ = clazz.getPackage();
        String string = handlerChain.file();
        String string2 = HandlerAnnotationProcessor.addPackagePath(string, package_);
        InputStream inputStream = HandlerAnnotationProcessor.moduleResource(clazz, string);
        if (inputStream != null) {
            return inputStream;
        }
        inputStream = HandlerAnnotationProcessor.moduleResource(clazz, string2);
        if (inputStream != null) {
            return inputStream;
        }
        URL uRL = HandlerAnnotationProcessor.cpResource(clazz, string);
        if (uRL == null) {
            uRL = HandlerAnnotationProcessor.cpResource(clazz, string2);
        }
        if (uRL == null) {
            throw new UtilException("util.failed.to.find.handlerchain.file", clazz.getName(), string);
        }
        try {
            return uRL.openStream();
        }
        catch (IOException iOException) {
            throw new UtilException("util.failed.to.parse.handlerchain.file", clazz.getName(), string);
        }
    }

    private static URL cpResource(Class clazz, String string) {
        URL uRL = clazz.getResource(string);
        if (uRL == null) {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            uRL = classLoader.getResource(string);
        }
        return uRL;
    }

    private static InputStream moduleResource(Class clazz, String string) {
        Module module = clazz.getModule();
        try {
            InputStream inputStream = module.getResourceAsStream(string);
            if (inputStream != null) {
                return inputStream;
            }
        }
        catch (IOException iOException) {
            throw new UtilException("util.failed.to.find.handlerchain.file", clazz.getName(), string);
        }
        return null;
    }

    private static String addPackagePath(String string, Package package_) {
        Object object = package_.getName();
        object = ((String)object).replace('.', '/');
        object = (String)object + "/" + string;
        return object;
    }
}

