/*
 * Decompiled with CFR 0.152.
 */
package javajs.async;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import swingjs.api.JSUtilI;

public class Assets {
    public static boolean isJS = false;
    public static JSUtilI jsutil;
    private Map<String, Map<String, ZipEntry>> htZipContents = new HashMap<String, Map<String, ZipEntry>>();
    private static boolean doCacheZipContents;
    private static Assets instance;
    private Map<String, Asset> assetsByPath = new HashMap<String, Asset>();
    private String[] sortedList = new String[0];
    private static HashSet<String> loadedAssets;

    private Assets() {
    }

    public static byte[] addJSCachedBytes(Object URLorURIorFile) {
        return isJS ? jsutil.addJSCachedBytes(URLorURIorFile) : null;
    }

    public static Assets getInstance() {
        return instance;
    }

    public static URL getAbsoluteURL(String path) {
        URL url = null;
        try {
            URL uRL = url = path.indexOf(":/") < 0 ? new File(new File(path).getAbsolutePath()).toURL() : new URL(path);
            if (path.indexOf("!/") >= 0) {
                url = new URL("jar", null, url.toString());
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        return url;
    }

    public static URI getAbsoluteURI(String path) {
        URI uri = null;
        try {
            uri = path.indexOf(":/") < 0 ? new File(new File(path).getAbsolutePath()).toURI() : new URI(path);
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        return uri;
    }

    public static void add(Object o) {
        if (o == null) {
            return;
        }
        try {
            if (o instanceof Object[]) {
                Object[] a = (Object[])o;
                for (int i = 0; i < a.length; ++i) {
                    Assets.add(a[i]);
                }
                return;
            }
            Asset a = (Asset)o;
            if (a.name == null || a.zipPath == null || a.classPath == null && a.classPaths == null || a.classPath != null && a.classPaths != null) {
                throw new NullPointerException("Assets could not parse " + o);
            }
            if (a.classPaths == null) {
                Assets.add(a.name, a.zipPath, a.classPath);
            } else {
                Assets.add(a.name, a.zipPath, a.classPaths);
            }
        }
        catch (Throwable t) {
            throw new IllegalArgumentException(t.getMessage());
        }
    }

    public static void add(String name, String zipFile, String path) {
        Assets.add(name, zipFile, new String[]{path});
    }

    public static boolean hasLoaded(String name) {
        return loadedAssets.contains(name);
    }

    public static void reset() {
        Assets.getInstance().htZipContents.clear();
        Assets.getInstance().assetsByPath.clear();
        Assets.getInstance().sortedList = new String[0];
    }

    public static void add(String name, String zipFile, String[] paths) {
        Assets.getInstance()._add(name, zipFile, paths);
    }

    private void _add(String name, String zipFile, String[] paths) {
        if (Assets.hasLoaded(name)) {
            System.err.println("Assets warning: Asset " + name + " already exists");
        }
        loadedAssets.add(name);
        int i = paths.length;
        while (--i >= 0) {
            this.assetsByPath.put(paths[i], new Asset(name, zipFile, paths[i]));
        }
        this.resort();
    }

    public static byte[] getAssetBytes(String assetPath) {
        return Assets.getAssetBytes(assetPath, false);
    }

    public static String getAssetString(String assetPath) {
        return Assets.getAssetString(assetPath, false);
    }

    public static InputStream getAssetStream(String assetPath) {
        return Assets.getAssetStream(assetPath, false);
    }

    public static byte[] getAssetBytesFromZip(String assetPath) {
        return Assets.getAssetBytes(assetPath, true);
    }

    public static String getAssetStringFromZip(String assetPath) {
        return Assets.getAssetString(assetPath, true);
    }

    public static InputStream getAssetStreamFromZip(String assetPath) {
        return Assets.getAssetStream(assetPath, true);
    }

    private static byte[] getAssetBytes(String path, boolean zipOnly) {
        byte[] bytes = null;
        try {
            URL url = Assets.getInstance()._getURLFromPath(path, true);
            if (url == null && !zipOnly) {
                url = Assets.getAbsoluteURL(path);
            }
            if (url == null) {
                return null;
            }
            if (isJS) {
                bytes = jsutil.getURLBytes(url);
                if (bytes == null) {
                    url.openStream();
                    bytes = jsutil.getURLBytes(url);
                }
            } else {
                bytes = Assets.getLimitedStreamBytes(url.openStream(), -1L, null);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return bytes;
    }

    private static String getAssetString(String path, boolean zipOnly) {
        byte[] bytes = Assets.getAssetBytes(path, zipOnly);
        return bytes == null ? null : new String(bytes);
    }

    private static InputStream getAssetStream(String path, boolean zipOnly) {
        try {
            URL url = Assets.getInstance()._getURLFromPath(path, true);
            if (url == null && !zipOnly) {
                url = Assets.class.getClassLoader().getResource(path);
            }
            if (url != null) {
                return url.openStream();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public static URL getURLFromPath(String fullPath) {
        return Assets.getInstance()._getURLFromPath(fullPath, false);
    }

    public static URL getURLFromPath(String fullPath, boolean zipOnly) {
        return Assets.getInstance()._getURLFromPath(fullPath, zipOnly);
    }

    private URL _getURLFromPath(String fullPath, boolean zipOnly) {
        URL url = null;
        try {
            if (fullPath.startsWith("/")) {
                fullPath = fullPath.substring(1);
            }
            int i = this.sortedList.length;
            while (--i >= 0) {
                if (!fullPath.startsWith(this.sortedList[i])) continue;
                url = this.assetsByPath.get(this.sortedList[i]).getURL(fullPath);
                ZipEntry ze = Assets.findZipEntry(url);
                if (ze == null) break;
                if (isJS) {
                    jsutil.setURLBytes(url, jsutil.getZipBytes(ze));
                }
                return url;
            }
            if (!zipOnly) {
                return Assets.getAbsoluteURL(fullPath);
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return null;
    }

    public static ZipEntry findZipEntry(URL url) {
        String[] parts = Assets.getJarURLParts(url.toString());
        if (parts == null || parts[0] == null || parts[1].length() == 0) {
            return null;
        }
        return Assets.findZipEntry(parts[0], parts[1]);
    }

    public static ZipEntry findZipEntry(String zipFile, String fileName) {
        return Assets.getZipContents(zipFile).get(fileName);
    }

    public static Map<String, ZipEntry> getZipContents(String zipPath) {
        return Assets.getInstance()._getZipContents(zipPath);
    }

    private Map<String, ZipEntry> _getZipContents(String zipPath) {
        URL url = Assets.getURLWithCachedBytes(zipPath);
        Map<String, ZipEntry> fileNames = this.htZipContents.get(url.toString());
        if (fileNames != null) {
            return fileNames;
        }
        try {
            return this.readZipContents(url.openStream(), url);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static String[] getJarURLParts(String source) {
        int n = source.indexOf("!/");
        if (n < 0) {
            return null;
        }
        String jarfile = source.substring(0, n).replace("jar:", "");
        while (jarfile.startsWith("//")) {
            jarfile = jarfile.substring(1);
        }
        return new String[]{jarfile, n == source.length() - 2 ? null : source.substring(n + 2)};
    }

    public static byte[] getURLContents(URL url) {
        if (url == null) {
            return null;
        }
        try {
            if (isJS) {
                return jsutil.readAllBytes(url.openStream());
            }
            return Assets.getLimitedStreamBytes(url.openStream(), -1L, null);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static URL getURLWithCachedBytes(String path) {
        URL url = Assets.getAbsoluteURL(path);
        if (url != null) {
            Assets.addJSCachedBytes(url);
        }
        return url;
    }

    private Map<String, ZipEntry> readZipContents(InputStream is, URL url) throws IOException {
        HashMap<String, ZipEntry> fileNames = new HashMap<String, ZipEntry>();
        if (doCacheZipContents) {
            this.htZipContents.put(url.toString(), fileNames);
        }
        ZipInputStream input = new ZipInputStream(is);
        ZipEntry zipEntry = null;
        int n = 0;
        while ((zipEntry = input.getNextEntry()) != null) {
            if (zipEntry.isDirectory() || zipEntry.getSize() == 0L) continue;
            ++n;
            String fileName = zipEntry.getName();
            fileNames.put(fileName, zipEntry);
        }
        input.close();
        System.out.println("Assets: " + n + " zip entries found in " + url);
        return fileNames;
    }

    private void resort() {
        this.sortedList = new String[this.assetsByPath.size()];
        int i = 0;
        for (String path : this.assetsByPath.keySet()) {
            this.sortedList[i++] = path;
        }
        Arrays.sort(this.sortedList);
    }

    private static byte[] getLimitedStreamBytes(InputStream is, long n, OutputStream out) throws IOException {
        boolean toOut = out != null;
        int buflen = n > 0L && n < 1024L ? (int)n : 1024;
        byte[] buf = new byte[buflen];
        byte[] bytes = out == null ? new byte[n < 0L ? 4096 : (int)n] : null;
        int len = 0;
        int totalLen = 0;
        if (n < 0L) {
            n = Integer.MAX_VALUE;
        }
        while ((long)totalLen < n && (len = is.read(buf, 0, buflen)) > 0) {
            totalLen += len;
            if (toOut) {
                out.write(buf, 0, len);
                continue;
            }
            if (totalLen > bytes.length) {
                bytes = Arrays.copyOf(bytes, totalLen * 2);
            }
            System.arraycopy(buf, 0, bytes, totalLen - len, len);
            if (n == Integer.MAX_VALUE || totalLen + buflen <= bytes.length) continue;
            buflen = bytes.length - totalLen;
        }
        if (toOut) {
            return null;
        }
        if (totalLen == bytes.length) {
            return bytes;
        }
        buf = new byte[totalLen];
        System.arraycopy(bytes, 0, buf, 0, totalLen);
        return buf;
    }

    public String toString() {
        Object s = "[";
        for (int i = 0; i < this.sortedList.length; ++i) {
            Asset a = this.assetsByPath.get(this.sortedList[i]);
            s = (String)s + (i == 0 ? "" : ",") + a;
        }
        return (String)s + "]";
    }

    static {
        try {
            if (isJS) {
                jsutil = (JSUtilI)Class.forName("swingjs.JSUtil").newInstance();
            }
        }
        catch (Exception e) {
            System.err.println("Assets could not create swinjs.JSUtil instance");
        }
        doCacheZipContents = true;
        instance = new Assets();
        loadedAssets = new HashSet();
    }

    public static class Asset {
        String name;
        URI uri;
        String classPath;
        String zipPath;
        String[] classPaths;

        public Asset(String name, String zipPath, String[] classPaths) {
            this.name = name;
            this.zipPath = zipPath;
            this.classPaths = classPaths;
        }

        public Asset(String name, String zipPath, String classPath) {
            this.name = name;
            this.zipPath = zipPath;
            this.uri = Assets.getAbsoluteURI(zipPath);
            this.classPath = classPath.endsWith("/") ? classPath : classPath + "/";
        }

        public URL getURL(String fullPath) throws MalformedURLException {
            return fullPath.indexOf(this.classPath) < 0 ? null : new URL("jar", null, this.uri + "!/" + fullPath);
        }

        public String toString() {
            return "{\"name\":\"" + this.name + "\",\"zipPath\":\"" + this.zipPath + "\",\"classPath\":\"" + this.classPath + "\"}";
        }
    }
}

