/*
 * Decompiled with CFR 0.152.
 */
package jalview.ws2.gui;

import jalview.api.SplitContainerI;
import jalview.bin.Console;
import jalview.datamodel.Alignment;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.AlignmentOrder;
import jalview.datamodel.HiddenColumns;
import jalview.gui.AlignFrame;
import jalview.gui.Desktop;
import jalview.gui.JvOptionPane;
import jalview.gui.SplitFrame;
import jalview.gui.WebserviceInfo;
import jalview.util.ArrayUtils;
import jalview.util.MessageManager;
import jalview.ws2.actions.alignment.AlignmentAction;
import jalview.ws2.actions.alignment.AlignmentResult;
import jalview.ws2.actions.api.JobI;
import jalview.ws2.actions.api.TaskEventListener;
import jalview.ws2.actions.api.TaskI;
import jalview.ws2.api.JobStatus;
import jalview.ws2.api.WebService;
import jalview.ws2.helpers.WSClientTaskWrapper;
import java.awt.Component;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import javax.swing.SwingUtilities;

class AlignmentServiceGuiHandler
implements TaskEventListener<AlignmentResult> {
    private final WebService<?> service;
    private final AlignFrame frame;
    private WebserviceInfo infoPanel;
    private String alnTitle;
    private JobI[] jobs = new JobI[0];
    private int[] tabs = new int[0];
    private int[] logOffset = new int[0];
    private int[] errLogOffset = new int[0];

    public AlignmentServiceGuiHandler(AlignmentAction action, AlignFrame frame) {
        this.service = action.getWebService();
        this.frame = frame;
        String panelInfo = String.format("%s using service hosted at %s%n%s", this.service.getName(), this.service.getUrl(), this.service.getDescription());
        this.infoPanel = new WebserviceInfo(this.service.getName(), panelInfo, false);
        String actionName = action.getName() != null ? action.getName() : "Alignment";
        this.alnTitle = String.format("%s %s of %s", this.service.getName(), actionName, frame.getTitle());
    }

    @Override
    public void taskStatusChanged(TaskI<AlignmentResult> source, JobStatus status) {
        switch (status) {
            case INVALID: {
                this.infoPanel.setVisible(false);
                JvOptionPane.showMessageDialog((Component)this.frame, MessageManager.getString("info.invalid_msa_input_mininfo"), MessageManager.getString("info.invalid_msa_notenough"), 1);
                break;
            }
            case READY: {
                this.infoPanel.setthisService(new WSClientTaskWrapper(source));
                this.infoPanel.setVisible(true);
            }
            case SUBMITTED: 
            case QUEUED: {
                this.infoPanel.setStatus(0);
                break;
            }
            case RUNNING: 
            case UNKNOWN: {
                this.infoPanel.setStatus(1);
                break;
            }
            case COMPLETED: {
                this.infoPanel.setProgressBar(MessageManager.getString("status.collecting_job_results"), this.jobs[0].getInternalId());
                this.infoPanel.setStatus(2);
                break;
            }
            case FAILED: {
                this.infoPanel.removeProgressBar(this.jobs[0].getInternalId());
                this.infoPanel.setStatus(4);
                break;
            }
            case CANCELLED: {
                this.infoPanel.setStatus(3);
                break;
            }
            case SERVER_ERROR: {
                this.infoPanel.removeProgressBar(this.jobs[0].getInternalId());
                this.infoPanel.setStatus(5);
            }
        }
    }

    @Override
    public void taskStarted(TaskI<AlignmentResult> source, List<? extends JobI> subJobs) {
        this.jobs = subJobs.toArray(new JobI[0]);
        this.tabs = new int[subJobs.size()];
        this.logOffset = new int[subJobs.size()];
        this.errLogOffset = new int[subJobs.size()];
        for (int i = 0; i < subJobs.size(); ++i) {
            int tabIndex;
            JobI job = this.jobs[i];
            this.tabs[i] = tabIndex = this.infoPanel.addJobPane();
            this.infoPanel.setProgressName(String.format("region %d", i), tabIndex);
            this.infoPanel.setProgressText(tabIndex, this.alnTitle + "\nJob details\n");
            if (job.getStatus() == JobStatus.INVALID) {
                this.infoPanel.setStatus(tabIndex, 2);
                continue;
            }
            if (job.getStatus() != JobStatus.READY) continue;
            this.infoPanel.setStatus(tabIndex, 0);
        }
    }

    @Override
    public void taskCompleted(TaskI<AlignmentResult> source, AlignmentResult result) {
        SwingUtilities.invokeLater(() -> this.infoPanel.removeProgressBar(this.jobs[0].getInternalId()));
        if (result == null) {
            SwingUtilities.invokeLater(this.infoPanel::setFinishedNoResults);
            return;
        }
        this.infoPanel.showResultsNewFrame.addActionListener(evt -> {
            AlignmentI aln = result.getAlignment();
            Alignment alnCpy = new Alignment(aln);
            alnCpy.setGapCharacter(aln.getGapCharacter());
            alnCpy.setDataset(aln.getDataset());
            this.displayResultsNewFrame(alnCpy, result.getAlignmentOrders(), result.getHiddenColumns());
        });
        SwingUtilities.invokeLater(this.infoPanel::setResultsReady);
    }

    private void displayResultsNewFrame(Alignment aln, List<AlignmentOrder> alorders, HiddenColumns hidden) {
        AlignFrame requestingFrame;
        SplitContainerI splitContainer;
        AlignFrame newFrame = new AlignFrame((AlignmentI)aln, hidden, 700, 500);
        newFrame.getFeatureRenderer().transferSettings(this.frame.getFeatureRenderer().getSettings());
        if (alorders.size() > 0) {
            this.addSortByMenuItems(newFrame, alorders);
        }
        if ((splitContainer = (requestingFrame = this.frame).getSplitViewContainer()) != null && splitContainer.getComplement(requestingFrame) != null) {
            AlignmentI complement = splitContainer.getComplement(requestingFrame);
            String complementTitle = splitContainer.getComplementTitle(requestingFrame);
            Alignment copyComplement = new Alignment(complement);
            copyComplement.setGapCharacter(complement.getGapCharacter());
            copyComplement.setDataset(complement.getDataset());
            copyComplement.alignAs(aln);
            if (copyComplement.getHeight() > 0) {
                newFrame.setTitle(this.alnTitle);
                AlignFrame newFrame2 = new AlignFrame(copyComplement, 700, 500);
                newFrame2.setTitle(complementTitle);
                String linkedTitle = MessageManager.getString("label.linked_view_title");
                SplitFrame splitFrame = new SplitFrame(aln.isNucleotide() ? newFrame : newFrame2, aln.isNucleotide() ? newFrame2 : newFrame);
                Desktop.addInternalFrame(splitFrame, linkedTitle, -1, -1);
                return;
            }
        }
        Desktop.addInternalFrame(newFrame, this.alnTitle, 700, 500);
    }

    private void addSortByMenuItems(AlignFrame frame, List<AlignmentOrder> alorders) {
        if (alorders.size() == 1) {
            frame.addSortByOrderMenuItem(this.service.getName() + " Ordering", alorders.get(0));
            return;
        }
        BitSet collected = new BitSet(alorders.size());
        int N = alorders.size();
        for (int i = 0; i < N; ++i) {
            if (collected.get(i)) continue;
            ArrayList<String> regions = new ArrayList<String>();
            AlignmentOrder order = alorders.get(i);
            for (int j = i; j < N; ++j) {
                if (collected.get(j) || !alorders.get(j).equals(order)) continue;
                regions.add(Integer.toString(j + 1));
                collected.set(j);
            }
            String orderName = String.format("%s Region %s Ordering", this.service.getName(), String.join((CharSequence)",", regions));
            frame.addSortByOrderMenuItem(orderName, order);
        }
    }

    @Override
    public void taskException(TaskI<AlignmentResult> source, Exception e) {
        Console.error(String.format("Service %s raised an exception.", this.service.getName()), e);
        this.infoPanel.appendProgressText(e.getMessage());
    }

    @Override
    public void subJobStatusChanged(TaskI<AlignmentResult> source, JobI job, JobStatus status) {
        int wsStatus;
        int i = ArrayUtils.indexOf(this.jobs, job);
        assert (i >= 0) : "job does not exist";
        if (i < 0) {
            return;
        }
        switch (status) {
            case INVALID: 
            case COMPLETED: {
                wsStatus = 2;
                break;
            }
            case READY: 
            case SUBMITTED: 
            case QUEUED: {
                wsStatus = 0;
                break;
            }
            case RUNNING: 
            case UNKNOWN: {
                wsStatus = 1;
                break;
            }
            case FAILED: {
                wsStatus = 4;
                break;
            }
            case CANCELLED: {
                wsStatus = 3;
                break;
            }
            case SERVER_ERROR: {
                wsStatus = 5;
                break;
            }
            default: {
                throw new AssertionError((Object)"Non-exhaustive switch statement");
            }
        }
        this.infoPanel.setStatus(this.tabs[i], wsStatus);
    }

    @Override
    public void subJobLogChanged(TaskI<AlignmentResult> source, JobI job, String log) {
        int i = ArrayUtils.indexOf(this.jobs, job);
        assert (i >= 0) : "job does not exist";
        if (i < 0) {
            return;
        }
        this.infoPanel.appendProgressText(this.tabs[i], log.substring(this.logOffset[i]));
    }

    @Override
    public void subJobErrorLogChanged(TaskI<AlignmentResult> source, JobI job, String log) {
        int i = ArrayUtils.indexOf(this.jobs, job);
        assert (i >= 0) : "job does not exist";
        if (i < 0) {
            return;
        }
        this.infoPanel.appendProgressText(this.tabs[i], log.substring(this.errLogOffset[i]));
    }
}

