/*
 * Decompiled with CFR 0.152.
 */
package jalview.ws2.client.jpred4;

import jalview.ws.params.ParamManager;
import jalview.ws2.actions.secstructpred.SecStructPredAction;
import jalview.ws2.api.WebService;
import jalview.ws2.client.api.AbstractWebServiceDiscoverer;
import jalview.ws2.client.jpred4.JPred4WSClient;
import jalview.ws2.params.SimpleParamDatastore;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import uk.ac.dundee.compbio.jpred.JPredClient;

public class JPred4WSDiscoverer
extends AbstractWebServiceDiscoverer {
    private static final URL DEFAULT_URL;
    private static JPred4WSDiscoverer instance;
    private static ParamManager paramManager;

    private JPred4WSDiscoverer() {
    }

    public static JPred4WSDiscoverer getInstance() {
        if (instance == null) {
            instance = new JPred4WSDiscoverer();
        }
        return instance;
    }

    public static void setParamManager(ParamManager manager) {
        paramManager = manager;
    }

    @Override
    public int getStatusForUrl(URL url) {
        return 1;
    }

    @Override
    public String getUrlsPropertyKey() {
        return null;
    }

    @Override
    protected URL getDefaultUrl() {
        return DEFAULT_URL;
    }

    @Override
    protected List<WebService<?>> fetchServices(URL url) throws IOException {
        JPredClient client = new JPredClient(url);
        WebService.Builder<SecStructPredAction> wsBuilder = WebService.newBuilder();
        wsBuilder.url(url);
        wsBuilder.clientName("jpred4");
        wsBuilder.category("Secondary structure prediction");
        wsBuilder.name("jpred4");
        wsBuilder.description("JPred4 Secondary Structure Prediction.");
        wsBuilder.interactive(false);
        wsBuilder.paramDatastore(new SimpleParamDatastore(url, Collections.emptyList(), Collections.emptyList(), paramManager));
        wsBuilder.actionClass(SecStructPredAction.class);
        WebService<SecStructPredAction> webService = wsBuilder.build();
        SecStructPredAction.Builder actionBuilder = SecStructPredAction.newBuilder(new JPred4WSClient(client, false));
        actionBuilder.webService(webService);
        actionBuilder.msaMode(false);
        actionBuilder.name("JPred4 (Single sequence)");
        webService.addAction(actionBuilder.build());
        SecStructPredAction.Builder actionBuilderMsa = SecStructPredAction.newBuilder(new JPred4WSClient(client, true));
        actionBuilderMsa.webService(webService);
        actionBuilderMsa.msaMode(true);
        actionBuilderMsa.name("JPred4 (MSA)");
        webService.addAction(actionBuilderMsa.build());
        return List.of(webService);
    }

    static {
        try {
            DEFAULT_URL = new URL("https://www.compbio.dundee.ac.uk/jpred4/");
        }
        catch (MalformedURLException e) {
            throw new ExceptionInInitializerError(e);
        }
        instance = null;
        paramManager = null;
    }
}

