/*
 * Decompiled with CFR 0.152.
 */
package jalview.ws2.client.jpred4;

import jalview.datamodel.SequenceI;
import jalview.io.AlignFile;
import jalview.io.DataSourceType;
import jalview.io.FastaFile;
import jalview.io.FileFormat;
import jalview.io.JPredFile;
import jalview.ws.params.ArgumentI;
import jalview.ws2.api.Credentials;
import jalview.ws2.api.JobStatus;
import jalview.ws2.api.WebServiceJobHandle;
import jalview.ws2.client.api.SecStructPredWebServiceClientI;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import uk.ac.dundee.compbio.jpred.JPredClient;
import uk.ac.dundee.compbio.jpred.JPredRequest;

public class JPred4WSClient
implements SecStructPredWebServiceClientI {
    final JPredClient client;
    private final JPredRequest.Mode mode;
    private final JPredRequest.Format format;

    JPred4WSClient(JPredClient client, boolean msaMode) {
        this.mode = msaMode ? JPredRequest.Mode.MSA : JPredRequest.Mode.SINGLE;
        this.format = msaMode ? JPredRequest.Format.FASTA : JPredRequest.Format.SEQ;
        this.client = client;
    }

    @Override
    public String getUrl() {
        return this.client.getURL().toString();
    }

    @Override
    public String getClientName() {
        return "jpred4";
    }

    @Override
    public WebServiceJobHandle submit(List<SequenceI> sequences, List<ArgumentI> args, Credentials credentials) throws IOException {
        String input = this.mode == JPredRequest.Mode.MSA ? FileFormat.Fasta.getWriter(null).print(sequences.toArray(new SequenceI[sequences.size()]), false) : sequences.get(0).getSequenceAsString();
        JPredRequest request = JPredRequest.newBuilder().mode(this.mode).format(this.format).input((CharSequence)input).build();
        String jobId = this.client.submit(request);
        return new WebServiceJobHandle(this.getClientName(), "jpred4", this.getUrl(), jobId);
    }

    @Override
    public JobStatus getStatus(WebServiceJobHandle job) throws IOException {
        JPredClient.Status status = this.client.getStatus(job.getJobId());
        switch (status) {
            case PENDING: {
                return JobStatus.QUEUED;
            }
            case RUNNING: {
                return JobStatus.RUNNING;
            }
            case FINISHED: {
                return JobStatus.COMPLETED;
            }
            case NO_JOB: {
                return JobStatus.SERVER_ERROR;
            }
            case MALFORMED: {
                return JobStatus.INVALID;
            }
            case NOT_EXIST: {
                return JobStatus.SERVER_ERROR;
            }
        }
        return JobStatus.UNKNOWN;
    }

    @Override
    public String getLog(WebServiceJobHandle job) throws IOException {
        InputStream stream = this.client.getResultStream(job.getJobId(), "LOG");
        return new String(stream.readAllBytes());
    }

    @Override
    public String getErrorLog(WebServiceJobHandle job) throws IOException {
        return "";
    }

    @Override
    public void cancel(WebServiceJobHandle job) throws IOException, UnsupportedOperationException {
    }

    @Override
    public AlignFile getAlignmentFile(WebServiceJobHandle job) throws IOException {
        InputStream stream = this.client.getResultStream(job.getJobId(), "align");
        byte[] buffer = new byte[2048];
        ByteArrayOutputStream file = new ByteArrayOutputStream();
        int len = 0;
        while ((len = stream.read(buffer)) >= 0) {
            file.write(buffer, 0, len);
        }
        return new FastaFile(file.toString("UTF-8"), DataSourceType.PASTE);
    }

    @Override
    public JPredFile getPredictionFile(WebServiceJobHandle job) throws IOException {
        InputStream stream = this.client.getResultStream(job.getJobId(), "concise");
        byte[] buffer = new byte[2048];
        ByteArrayOutputStream file = new ByteArrayOutputStream();
        int len = 0;
        while ((len = stream.read(buffer)) >= 0) {
            file.write(buffer, 0, len);
        }
        return new JPredFile(file.toString("UTF-8"), DataSourceType.PASTE);
    }
}

