/*
 * Decompiled with CFR 0.152.
 */
package jalview.ws2.actions.annotation;

import jalview.api.AlignViewportI;
import jalview.viewmodel.AlignmentViewport;
import jalview.ws.params.ArgumentI;
import jalview.ws2.actions.BaseAction;
import jalview.ws2.actions.annotation.AnnotationResult;
import jalview.ws2.actions.annotation.AnnotationTask;
import jalview.ws2.api.Credentials;
import jalview.ws2.client.api.AnnotationWebServiceClientI;
import java.util.List;
import java.util.Objects;

public class AnnotationAction
extends BaseAction<AnnotationResult> {
    protected final AnnotationWebServiceClientI client;
    protected final boolean alignmentAnalysis;
    protected final boolean requireAlignedSequences;
    protected final boolean filterSymbols;

    public static Builder newBuilder(AnnotationWebServiceClientI client) {
        return new Builder(client);
    }

    protected AnnotationAction(Builder builder) {
        super(builder);
        this.client = builder.client;
        this.alignmentAnalysis = builder.alignmentAnalysis;
        this.requireAlignedSequences = builder.requireAlignedSequences;
        this.filterSymbols = builder.filterSymbols;
    }

    public AnnotationTask createTask(AlignViewportI viewport, List<ArgumentI> args, Credentials credentials) {
        return new AnnotationTask(this.client, this, args, credentials, viewport);
    }

    public boolean isAlignmentAnalysis() {
        return this.alignmentAnalysis;
    }

    public boolean getRequireAlignedSequences() {
        return this.requireAlignedSequences;
    }

    public boolean getFilterSymbols() {
        return this.filterSymbols;
    }

    @Override
    public boolean isActive(AlignmentViewport viewport) {
        return false;
    }

    public static class Builder
    extends BaseAction.Builder<AnnotationAction> {
        protected AnnotationWebServiceClientI client;
        protected boolean alignmentAnalysis = false;
        protected boolean requireAlignedSequences = false;
        protected boolean filterSymbols = true;

        public Builder(AnnotationWebServiceClientI client) {
            Objects.requireNonNull(client);
            this.client = client;
        }

        public void alignmentAnalysis(boolean val) {
            this.alignmentAnalysis = val;
        }

        public void requireAlignedSequences(boolean val) {
            this.requireAlignedSequences = val;
        }

        public void filterSymbols(boolean val) {
            this.filterSymbols = val;
        }

        public AnnotationAction build() {
            return new AnnotationAction(this);
        }
    }
}

