/*
 * Decompiled with CFR 0.152.
 */
package jalview.ws2.actions.annotation;

import jalview.analysis.AlignmentAnnotationUtils;
import jalview.api.AlignViewportI;
import jalview.api.AlignmentViewPanel;
import jalview.api.PollableAlignCalcWorkerI;
import jalview.datamodel.AlignmentAnnotation;
import jalview.datamodel.AlignmentI;
import jalview.workers.AlignCalcWorker;
import jalview.ws.params.ArgumentI;
import jalview.ws2.actions.annotation.AnnotationAction;
import jalview.ws2.actions.annotation.AnnotationResult;
import jalview.ws2.actions.api.TaskEventListener;
import jalview.ws2.actions.api.TaskI;
import jalview.ws2.api.Credentials;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;

public class AlignCalcWorkerAdapter
extends AlignCalcWorker
implements PollableAlignCalcWorkerI {
    private static int calcCount = 0;
    private final int calcNumber = calcCount++;
    private final AnnotationAction action;
    private final List<ArgumentI> args;
    private final Credentials credentials;
    private TaskI<AnnotationResult> currentTask = null;
    private TaskEventListener<AnnotationResult> taskListener = new TaskEventListener<AnnotationResult>(){

        @Override
        public void taskCompleted(TaskI source, AnnotationResult result) {
            int graphGroup = AlignCalcWorkerAdapter.this.alignViewport.getAlignment().getLastGraphGroup();
            ArrayList<AlignmentAnnotation> annotations = new ArrayList<AlignmentAnnotation>();
            for (AlignmentAnnotation ala : result.getAnnotations()) {
                if (ala.graphGroup > 0) {
                    ala.graphGroup += graphGroup;
                }
                AlignmentAnnotation newAnnot = AlignCalcWorkerAdapter.this.alignViewport.getAlignment().updateFromOrCopyAnnotation(ala);
                if (newAnnot.sequenceRef != null) {
                    newAnnot.sequenceRef.addAlignmentAnnotation(newAnnot);
                    newAnnot.adjustForAlignment();
                    AlignmentAnnotationUtils.replaceAnnotationOnAlignmentWith(newAnnot, newAnnot.label, newAnnot.getCalcId());
                }
                annotations.add(newAnnot);
            }
            AlignCalcWorkerAdapter.this.updateOurAnnots(annotations);
            AlignCalcWorkerAdapter.this.listener.workerHasResult(AlignCalcWorkerAdapter.this, new AnnotationResult(annotations, result.hasFeatures, result.featureColours, result.featureFilters));
        }
    };
    private WorkerListener listener = WorkerListener.NULL_LISTENER;

    public AlignCalcWorkerAdapter(AlignViewportI alignViewport, AlignmentViewPanel alignPanel, AnnotationAction action, List<ArgumentI> args, Credentials credentials) {
        super(alignViewport, alignPanel);
        this.action = action;
        this.args = args;
        this.credentials = credentials;
    }

    @Override
    public String getCalcName() {
        return this.action.getWebService().getName();
    }

    @Override
    public void updateAnnotation() {
    }

    private void updateOurAnnots(List<AlignmentAnnotation> newAnnots) {
        List oldAnnots = this.ourAnnots != null ? this.ourAnnots : List.of();
        AlignmentI alignment = this.alignViewport.getAlignment();
        for (AlignmentAnnotation annotation : oldAnnots) {
            if (newAnnots.contains(annotation)) continue;
            alignment.deleteAnnotation(annotation);
        }
        for (AlignmentAnnotation annotation : newAnnots) {
            alignment.validateAnnotation(annotation);
        }
        this.ourAnnots = Collections.synchronizedList(newAnnots);
    }

    @Override
    public synchronized void startUp() throws Throwable {
        if (this.alignViewport.isClosed()) {
            this.calcMan.disableWorker(this);
            this.abortAndDestroy();
            throw new IllegalStateException("Starting calculation for closed viewport");
        }
        this.currentTask = this.action.createTask(this.alignViewport, (List)this.args, this.credentials);
        this.currentTask.addTaskEventListener(this.taskListener);
        this.currentTask.init();
        this.listener.workerStarted(this);
    }

    @Override
    public boolean poll() throws Throwable {
        return this.currentTask.poll();
    }

    @Override
    public synchronized void cancel() {
        try {
            this.currentTask.cancel();
        }
        finally {
            this.currentTask.removeTaskEventListener(this.taskListener);
            this.listener.workerStopped(this);
        }
    }

    @Override
    public synchronized void done() {
        try {
            this.currentTask.complete();
        }
        catch (Exception exception) {
        }
        finally {
            this.currentTask.removeTaskEventListener(this.taskListener);
            this.listener.workerStopped(this);
        }
    }

    @Override
    public boolean isDeletable() {
        return true;
    }

    public String toString() {
        return "AlignCalcWorkerAdapter-" + this.calcNumber + " for " + this.getCalcName();
    }

    public void setWorkerListener(WorkerListener listener) {
        if (listener == null) {
            listener = WorkerListener.NULL_LISTENER;
        }
        this.listener = listener;
    }

    public static interface WorkerListener
    extends EventListener {
        public static final WorkerListener NULL_LISTENER = new WorkerListener(){};

        default public void workerStarted(AlignCalcWorkerAdapter source) {
        }

        default public void workerStopped(AlignCalcWorkerAdapter source) {
        }

        default public void workerHasResult(AlignCalcWorkerAdapter source, AnnotationResult result) {
        }
    }
}

