/*
 * Decompiled with CFR 0.152.
 */
package jalview.ws.rest;

import jalview.datamodel.SequenceI;
import jalview.io.packed.DataProvider;
import jalview.util.StringUtils;
import jalview.ws.api.UIinfo;
import jalview.ws.rest.InputType;
import jalview.ws.rest.params.Alignment;
import jalview.ws.rest.params.AnnotationFile;
import jalview.ws.rest.params.SeqGroupIndexVector;
import jalview.ws.rest.params.SeqIdVector;
import jalview.ws.rest.params.SeqVector;
import jalview.ws.rest.params.Tree;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RestServiceDescription {
    private static final Pattern PARAM_ENCODED_URL_PATTERN = Pattern.compile("([?&])([A-Za-z0-9_]+)=\\$([^$]+)\\$");
    public UIinfo details;
    String postUrl;
    String urlSuffix;
    Map<String, InputType> inputParams = new HashMap<String, InputType>();
    boolean aligndata;
    boolean annotdata;
    boolean partitiondata;
    private String invalidMessage = null;
    boolean hseparable = false;
    boolean vseparable = false;
    char gapCharacter = (char)45;
    private List<DataProvider.JvDataType> resultData = new ArrayList<DataProvider.JvDataType>();

    public RestServiceDescription() {
    }

    public RestServiceDescription(String action, String description, String name, String postUrl, String urlSuffix, Map<String, InputType> inputParams, boolean hseparable, boolean vseparable, char gapCharacter) {
        this.details = new UIinfo(action, action, name, description, postUrl);
        this.postUrl = postUrl == null ? "" : postUrl;
        String string = this.urlSuffix = urlSuffix == null ? "" : urlSuffix;
        if (inputParams != null) {
            this.inputParams = inputParams;
        }
        this.hseparable = hseparable;
        this.vseparable = vseparable;
        this.gapCharacter = gapCharacter;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof RestServiceDescription)) {
            return false;
        }
        RestServiceDescription other = (RestServiceDescription)o;
        boolean diff = this.gapCharacter != other.gapCharacter;
        diff |= this.vseparable != other.vseparable;
        diff |= this.hseparable != other.hseparable;
        diff |= !(this.urlSuffix == null && other.urlSuffix == null || this.urlSuffix != null && other.urlSuffix != null && this.urlSuffix.equals(other.urlSuffix));
        return !(diff |= !this.details.equals(other.details));
    }

    public String getAction() {
        return this.details.getAction();
    }

    public void setAction(String action) {
        this.details.setAction(action);
    }

    public String getName() {
        return this.details.getName();
    }

    public void setName(String name) {
        this.details.setName(name);
    }

    public String getDescription() {
        return this.details.getDescription();
    }

    public void setDescription(String description) {
        this.details.setDescription(description);
    }

    public String getPostUrl() {
        return this.postUrl;
    }

    public void setPostUrl(String postUrl) {
        this.postUrl = postUrl;
    }

    public String getUrlSuffix() {
        return this.urlSuffix;
    }

    public void setUrlSuffix(String urlSuffix) {
        this.urlSuffix = urlSuffix;
    }

    public Map<String, InputType> getInputParams() {
        return this.inputParams;
    }

    public void setInputParams(Map<String, InputType> inputParams) {
        this.inputParams = inputParams;
    }

    public void setHseparable(boolean hseparable) {
        this.hseparable = hseparable;
    }

    public void setVseparable(boolean vseparable) {
        this.vseparable = vseparable;
    }

    public void setGapCharacter(char gapCharacter) {
        this.gapCharacter = gapCharacter;
    }

    public void setInputParam(InputType it) {
        this.inputParams.put(it.token, it);
    }

    public void removeInputParam(InputType it) {
        this.inputParams.remove(it.token);
    }

    public void setInvolvesFlags() {
        this.aligndata = this.inputInvolves(Alignment.class);
        this.annotdata = this.inputInvolves(AnnotationFile.class);
        this.partitiondata = this.inputInvolves(SeqGroupIndexVector.class);
    }

    public RestServiceDescription(String link) {
        StringBuffer warnings = new StringBuffer();
        if (!this.configureFromEncodedString(link, warnings) && warnings.length() > 0) {
            this.invalidMessage = warnings.toString();
        }
    }

    public RestServiceDescription(RestServiceDescription toedit) {
        this(toedit.toString());
    }

    public String getInvalidMessage() {
        return this.invalidMessage;
    }

    public boolean isValid() {
        return this.invalidMessage == null;
    }

    private boolean configureFromServiceInputProperties(String propList, StringBuffer warnings) {
        String[] props = StringUtils.separatorListToArray(propList, ",");
        if (props == null) {
            return true;
        }
        boolean valid = true;
        String val = null;
        int l = warnings.length();
        for (String prop : props) {
            int i = prop.indexOf("=");
            if (i > -1) {
                val = prop.substring(i + 1);
                if (val.startsWith("'") && val.endsWith("'")) {
                    val = val.substring(1, val.length() - 1);
                }
                prop = prop.substring(0, i);
            }
            if (prop.equals("hseparable")) {
                this.hseparable = true;
            }
            if (prop.equals("vseparable")) {
                this.vseparable = true;
            }
            if (prop.equals("gapCharacter")) {
                if (val == null || val.length() == 0 || val.length() > 1) {
                    valid = false;
                    warnings.append((warnings.length() > 0 ? "\n" : "") + "Invalid service property: gapCharacter=' ' (single character) - was given '" + val + "'");
                } else {
                    this.gapCharacter = val.charAt(0);
                }
            }
            if (!prop.equals("returns")) continue;
            this._configureOutputFormatFrom(val, warnings);
        }
        return valid && l == warnings.length();
    }

    private String _genOutputFormatString() {
        Object buff = "";
        if (this.resultData == null) {
            return "";
        }
        for (DataProvider.JvDataType type : this.resultData) {
            if (((String)buff).length() > 0) {
                buff = (String)buff + ";";
            }
            buff = (String)buff + type.toString();
        }
        return buff;
    }

    private void _configureOutputFormatFrom(String outstring, StringBuffer warnings) {
        if (((String)outstring).indexOf(";") == -1) {
            outstring = (String)outstring + ";";
        }
        StringTokenizer st = new StringTokenizer((String)outstring, ";");
        String tok = "";
        this.resultData = new ArrayList<DataProvider.JvDataType>();
        while (st.hasMoreTokens()) {
            try {
                tok = st.nextToken();
                this.resultData.add(DataProvider.JvDataType.valueOf(tok));
            }
            catch (NoSuchElementException x) {
                warnings.append("Invalid result type: '" + tok + "' (must be one of: ");
                String sep = "";
                for (DataProvider.JvDataType vl : DataProvider.JvDataType.values()) {
                    warnings.append(sep);
                    warnings.append(vl.toString());
                    sep = " ,";
                }
                warnings.append(" separated by semi-colons)\n");
            }
        }
    }

    private String getServiceIOProperties() {
        ArrayList<String> vls = new ArrayList<String>();
        if (this.isHseparable()) {
            vls.add("hseparable");
        }
        if (this.isVseparable()) {
            vls.add("vseparable");
        }
        vls.add(new String("gapCharacter='" + this.gapCharacter + "'"));
        vls.add(new String("returns='" + this._genOutputFormatString() + "'"));
        return StringUtils.arrayToSeparatorList(vls.toArray(new String[0]), ",");
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("|");
        result.append(this.details.getName());
        result.append('|');
        result.append(this.details.getAction());
        result.append('|');
        if (this.details.getDescription() != null) {
            result.append(this.details.getDescription());
        }
        result.append('|');
        result.append(this.getServiceIOProperties());
        if (this.urlSuffix != null && this.urlSuffix.length() > 0) {
            result.append('|');
            result.append(this.urlSuffix);
        }
        result.append('|');
        result.append(this.getInputParamEncodedUrl());
        return result.toString();
    }

    public boolean configureFromEncodedString(String encoding, StringBuffer warnings) {
        String[] list = StringUtils.separatorListToArray(encoding, "|");
        int nextpos = this.parseServiceList(list, warnings, 0);
        return nextpos > 0;
    }

    protected int parseServiceList(String[] list, StringBuffer warnings, int p) {
        boolean invalid = false;
        while (list[p] != null && list[p].trim().length() == 0) {
            ++p;
        }
        String action = list[p + 1];
        String name = list[p];
        String descrip = list[p + 2];
        invalid |= !this.configureFromServiceInputProperties(list[p + 3], warnings);
        if (list.length - p > 5 && list[p + 5] != null && list[p + 5].trim().length() > 5) {
            this.urlSuffix = list[p + 4];
            invalid |= !this.configureFromInputParamEncodedUrl(list[p + 5], warnings);
            p += 6;
        } else if (list.length - p > 4 && list[p + 4] != null && list[p + 4].trim().length() > 5) {
            this.urlSuffix = null;
            invalid |= !this.configureFromInputParamEncodedUrl(list[p + 4], warnings);
            p += 5;
        }
        this.details = new UIinfo(action, action, name, descrip, this.postUrl);
        return invalid ? -1 : p;
    }

    private String getInputParamEncodedUrl() {
        StringBuffer url = new StringBuffer();
        if (this.postUrl == null || this.postUrl.length() < 5) {
            return "";
        }
        url.append(this.postUrl);
        int appendChar = this.postUrl.indexOf("?") > -1 ? 38 : 63;
        boolean consts = true;
        do {
            for (Map.Entry<String, InputType> param : this.inputParams.entrySet()) {
                List<String> vals = param.getValue().getURLEncodedParameter();
                if (param.getValue().isConstant()) {
                    if (!consts) continue;
                    url.append((char)appendChar);
                    appendChar = 38;
                    url.append(param.getValue().token);
                    if (vals.size() != 1) continue;
                    url.append("=");
                    url.append(vals.get(0));
                    continue;
                }
                if (consts) continue;
                url.append((char)appendChar);
                appendChar = 38;
                url.append(param.getValue().token);
                url.append("=");
                url.append("$");
                url.append(param.getValue().getURLtokenPrefix());
                url.append(":");
                url.append(StringUtils.arrayToSeparatorList(vals.toArray(new String[0]), ","));
                url.append("$");
            }
        } while (!(consts = !consts));
        return url.toString();
    }

    private boolean configureFromInputParamEncodedUrl(String ipurl, StringBuffer warnings) {
        boolean valid = true;
        int lastp = 0;
        Object url = new String();
        Matcher prms = PARAM_ENCODED_URL_PATTERN.matcher(ipurl);
        Hashtable<String, InputType> iparams = new Hashtable<String, InputType>();
        while (prms.find()) {
            if (lastp < prms.start(0)) {
                url = (String)url + ipurl.substring(lastp, prms.start(0));
                lastp = prms.end(0) + 1;
            }
            String sep = prms.group(1);
            String tok = prms.group(2);
            String iprm = prms.group(3);
            int colon = iprm.indexOf(":");
            String iprmparams = "";
            if (colon > -1) {
                iprmparams = iprm.substring(colon + 1);
                iprm = iprm.substring(0, colon);
            }
            valid = RestServiceDescription.parseTypeString(prms.group(0), tok, iprm, iprmparams, iparams, warnings);
        }
        if (valid) {
            try {
                URL u = new URL((String)url);
                this.postUrl = url;
                this.inputParams = iparams;
            }
            catch (Exception e) {
                warnings.append("Failed to parse '" + (String)url + "' as a URL.\n");
                valid = false;
            }
        }
        return valid;
    }

    public static Class[] getInputTypes() {
        return new Class[]{Alignment.class, AnnotationFile.class, SeqGroupIndexVector.class, SeqIdVector.class, SeqVector.class, Tree.class};
    }

    public static boolean parseTypeString(String fullstring, String tok, String iprm, String iprmparams, Map<String, InputType> iparams, StringBuffer warnings) {
        boolean valid = true;
        for (Class type : RestServiceDescription.getInputTypes()) {
            try {
                InputType jinput = (InputType)type.getConstructor(new Class[0]).newInstance(new Object[0]);
                if (!iprm.equalsIgnoreCase(jinput.getURLtokenPrefix())) continue;
                ArrayList<String> al = new ArrayList<String>();
                for (String prprm : StringUtils.separatorListToArray(iprmparams, ",")) {
                    al.add(prprm.trim());
                }
                if (!jinput.configureFromURLtokenString(al, warnings)) {
                    valid = false;
                    warnings.append("Failed to parse '" + fullstring + "' as a " + jinput.getURLtokenPrefix() + " input tag.\n");
                    break;
                }
                jinput.token = tok;
                iparams.put(tok, jinput);
                valid = true;
                break;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return valid;
    }

    public static String[][] formStrings(SequenceI[] seqs) {
        String[][] idset = new String[2][seqs.length];
        for (int i = 0; i < seqs.length; ++i) {
            idset[0][i] = seqs[i].getName();
            idset[1][i] = seqs[i].getSequenceAsString();
        }
        return idset;
    }

    public boolean isHseparable() {
        return this.hseparable;
    }

    public boolean isVseparable() {
        return this.vseparable;
    }

    public boolean inputInvolves(Class<?> class1) {
        assert (InputType.class.isAssignableFrom(class1));
        for (InputType val : this.inputParams.values()) {
            if (!class1.isAssignableFrom(val.getClass())) continue;
            return true;
        }
        return false;
    }

    public char getGapCharacter() {
        return this.gapCharacter;
    }

    public String getDecoratedResultUrl(String jobId) {
        return jobId + this.urlSuffix;
    }

    public void addResultDatatype(DataProvider.JvDataType dt) {
        if (this.resultData == null) {
            this.resultData = new ArrayList<DataProvider.JvDataType>();
        }
        this.resultData.add(dt);
    }

    public boolean removeRsultDatatype(DataProvider.JvDataType dt) {
        if (this.resultData != null) {
            return this.resultData.remove((Object)dt);
        }
        return false;
    }

    public List<DataProvider.JvDataType> getResultDataTypes() {
        return this.resultData;
    }

    public static List<RestServiceDescription> parseDescriptions(String services) throws Exception {
        String[] list = StringUtils.separatorListToArray(services, "|");
        ArrayList<RestServiceDescription> svcparsed = new ArrayList<RestServiceDescription>();
        int p = 0;
        int lastp = 0;
        StringBuffer warnings = new StringBuffer();
        do {
            RestServiceDescription rsd;
            if ((p = (rsd = new RestServiceDescription()).parseServiceList(list, warnings, lastp = p)) <= lastp || !rsd.isValid()) {
                throw new Exception("Failed to parse user defined RSBS services from :" + services + "\nFirst error was encountered at token " + lastp + " starting " + list[lastp] + ":\n" + rsd.getInvalidMessage());
            }
            svcparsed.add(rsd);
        } while (p < lastp && p < list.length - 1);
        return svcparsed;
    }
}

