/*
 * Decompiled with CFR 0.152.
 */
package jalview.ws.jws2;

import jalview.api.AlignCalcWorkerI;
import jalview.gui.AlignFrame;
import jalview.gui.Desktop;
import jalview.gui.JvSwingUtils;
import jalview.util.MessageManager;
import jalview.ws.api.ServiceWithParameters;
import jalview.ws.jws2.Jws2Client;
import jalview.ws.jws2.Jws2ClientFactory;
import jalview.ws.jws2.SeqAnnotationServiceCalcWorker;
import jalview.ws.params.AutoCalcSetting;
import jalview.ws.params.WsParamSetI;
import jalview.ws.uimodel.AlignAnalysisUIText;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.List;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public class SequenceAnnotationWSClient
extends Jws2Client {
    public SequenceAnnotationWSClient() {
    }

    public SequenceAnnotationWSClient(ServiceWithParameters sh, AlignFrame alignFrame, WsParamSetI preset, boolean editParams) {
        super(alignFrame, preset, null);
        this.initSequenceAnnotationWSClient(sh, alignFrame, preset, editParams);
    }

    private void initSequenceAnnotationWSClient(ServiceWithParameters sh, AlignFrame alignFrame, WsParamSetI preset, boolean editParams) {
        AlignAnalysisUIText aaui = sh.getAlignAnalysisUI();
        if (aaui != null) {
            SeqAnnotationServiceCalcWorker worker;
            Class clientClass = aaui.getClient();
            List<AlignCalcWorkerI> clnts = alignFrame.getViewport().getCalcManager().getWorkersOfClass(SeqAnnotationServiceCalcWorker.class);
            SeqAnnotationServiceCalcWorker tmpworker = null;
            if (clnts != null) {
                AlignCalcWorkerI _worker;
                Iterator<AlignCalcWorkerI> iterator = clnts.iterator();
                while (!(!iterator.hasNext() || (tmpworker = (SeqAnnotationServiceCalcWorker)(_worker = iterator.next())).hasService() && tmpworker.getService().getClass().equals(clientClass))) {
                    tmpworker = null;
                }
            }
            if ((worker = tmpworker) == null) {
                this.processParams(sh, editParams).thenAccept(startJob -> {
                    if (startJob.booleanValue()) {
                        SeqAnnotationServiceCalcWorker worker_;
                        try {
                            worker_ = new SeqAnnotationServiceCalcWorker(sh, alignFrame, this.preset, this.paramset);
                        }
                        catch (Exception x) {
                            x.printStackTrace();
                            throw new Error(MessageManager.getString("error.implementation_error"), x);
                        }
                        alignFrame.getViewport().getCalcManager().registerWorker(worker_);
                        this.startSeqAnnotationWorker(sh, alignFrame, preset, editParams);
                    }
                });
            } else {
                WsParamSetI preset_;
                if (editParams) {
                    this.paramset = worker.getArguments();
                    preset_ = worker.getPreset();
                } else {
                    preset_ = preset;
                }
                this.processParams(sh, editParams, true).thenAccept(startJob -> {
                    if (startJob.booleanValue()) {
                        alignFrame.getViewport().getCalcManager().enableWorker(worker);
                        worker.updateParameters(this.preset, this.paramset);
                        this.startSeqAnnotationWorker(sh, alignFrame, preset_, editParams);
                    }
                });
            }
        } else {
            this.startSeqAnnotationWorker(sh, alignFrame, preset, editParams);
        }
    }

    private void startSeqAnnotationWorker(ServiceWithParameters sh, AlignFrame alignFrame, WsParamSetI preset, boolean editParams) {
        if (!sh.isInteractiveUpdate()) {
            this.processParams(sh, editParams).thenAccept(startJob -> {
                if (startJob.booleanValue()) {
                    alignFrame.getViewport().getCalcManager().startWorker(new SeqAnnotationServiceCalcWorker(sh, alignFrame, preset, this.paramset));
                }
            });
        }
    }

    public SequenceAnnotationWSClient(AutoCalcSetting fave, AlignFrame alignFrame, boolean b) {
        super(alignFrame, fave.getPreset(), fave.getArgumentSet());
        this.initSequenceAnnotationWSClient(fave.getService(), alignFrame, fave.getPreset(), b);
    }

    @Override
    public void attachWSMenuEntry(JMenu wsmenu, final ServiceWithParameters service, final AlignFrame alignFrame) {
        if (Jws2ClientFactory.registerAAConWSInstance(wsmenu, service, alignFrame)) {
            return;
        }
        boolean hasparams = service.hasParameters();
        String calcName = service.getName();
        if (calcName.endsWith("WS")) {
            calcName = calcName.substring(0, calcName.length() - 2);
        }
        JMenuItem annotservice = new JMenuItem(MessageManager.formatMessage("label.calcname_with_default_settings", new String[]{calcName}));
        annotservice.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new SequenceAnnotationWSClient(service, alignFrame, null, false);
            }
        });
        wsmenu.add(annotservice);
        if (hasparams) {
            annotservice = new JMenuItem(MessageManager.getString("label.edit_settings_and_run"));
            annotservice.setToolTipText(MessageManager.getString("label.view_and_change_parameters_before_running_calculation"));
            annotservice.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    new SequenceAnnotationWSClient(service, alignFrame, null, true);
                }
            });
            wsmenu.add(annotservice);
            List<WsParamSetI> presets = service.getParamStore().getPresets();
            if (presets != null && presets.size() > 0) {
                JMenu presetlist = new JMenu(MessageManager.formatMessage("label.run_with_preset", new String[]{calcName}));
                for (final WsParamSetI preset : presets) {
                    JMenuItem methodR = new JMenuItem(preset.getName());
                    methodR.setToolTipText(JvSwingUtils.wrapTooltip(true, "<strong>" + (preset.isModifiable() ? MessageManager.getString("label.user_preset") : MessageManager.getString("label.service_preset")) + "</strong><br/>" + preset.getDescription()));
                    methodR.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            new SequenceAnnotationWSClient(service, alignFrame, preset, false);
                        }
                    });
                    presetlist.add(methodR);
                }
                wsmenu.add(presetlist);
            }
        } else {
            annotservice = new JMenuItem(MessageManager.getString("label.view_documentation"));
            if (service != null && service.hasDocumentationUrl()) {
                annotservice.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent arg0) {
                        Desktop.getInstance();
                        Desktop.showUrl(service.getDocumentationUrl());
                    }
                });
                annotservice.setToolTipText(JvSwingUtils.wrapTooltip(true, MessageManager.formatMessage("label.view_service_doc_url", new String[]{service.getDocumentationUrl(), service.getDocumentationUrl()})));
                wsmenu.add(annotservice);
            }
        }
    }
}

