/*
 * Decompiled with CFR 0.152.
 */
package jalview.ws.jws2;

import compbio.data.msa.Category;
import compbio.data.msa.JABAService;
import compbio.data.msa.RegistryWS;
import compbio.ws.client.Jws2Client;
import compbio.ws.client.Services;
import jalview.bin.Console;
import jalview.util.HttpUtils;
import jalview.ws.jws2.Jws2Discoverer;
import jalview.ws.jws2.jabaws2.Jws2Instance;
import jalview.ws.jws2.jabaws2.Jws2InstanceFactory;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import javax.xml.ws.WebServiceException;

public class JabaWsServerQuery
implements Runnable {
    Jws2Discoverer jws2Discoverer = null;
    String jwsserver = null;
    boolean quit = false;
    boolean running = false;
    Services[] JABAWS1SERVERS = new Services[]{Services.ClustalWS, Services.MuscleWS, Services.MafftWS, Services.ProbconsWS, Services.TcoffeeWS};
    Services[] JABAWS2SERVERS = new Services[]{Services.ClustalWS, Services.MuscleWS, Services.MafftWS, Services.ProbconsWS, Services.TcoffeeWS, Services.AAConWS, Services.DisemblWS, Services.GlobPlotWS, Services.IUPredWS, Services.JronnWS, Services.RNAalifoldWS};

    public boolean isRunning() {
        return this.running;
    }

    public void setQuit(boolean quit) {
        this.quit = quit;
    }

    public JabaWsServerQuery(Jws2Discoverer jws2Discoverer, String server) {
        this.jws2Discoverer = jws2Discoverer;
        this.jwsserver = server;
    }

    @Override
    public void run() {
        block17: {
            this.running = true;
            try {
                if (this.isValidUrl(this.jwsserver)) {
                    Set categories;
                    Set<Services> srv_set;
                    boolean noservices;
                    RegistryWS registry;
                    block16: {
                        registry = null;
                        Set svccategories = null;
                        noservices = true;
                        boolean jabasws2 = false;
                        srv_set = new HashSet();
                        categories = Category.getCategories();
                        try {
                            registry = Jws2Client.connectToRegistry((String)this.jwsserver);
                            if (registry == null) break block16;
                            jabasws2 = true;
                            srv_set = registry.getSupportedServices();
                            Console.outPrintln("registry.getSupportedServices: " + srv_set.toString());
                            svccategories = registry.getServiceCategories();
                        }
                        catch (Exception ex) {
                            Console.errPrintln("Exception whilst trying to get at registry:");
                            ex.printStackTrace();
                            Console.errPrintln("JWS2 Discoverer: " + this.jwsserver + " is a JABAWS1 server. Using hardwired list.");
                            for (Services srv : this.JABAWS1SERVERS) {
                                srv_set.add(srv);
                            }
                        }
                    }
                    for (Category cat : categories) {
                        for (Services srv : cat.getServices()) {
                            if (this.quit) {
                                this.running = false;
                                return;
                            }
                            if (!srv_set.contains(srv)) continue;
                            JABAService service = null;
                            try {
                                service = Jws2Client.connect((String)this.jwsserver, (Services)srv);
                            }
                            catch (Exception e) {
                                Console.errPrintln("Jws2 Discoverer: Problem on " + this.jwsserver + " with service " + srv + ":\n" + e.getMessage());
                                if (!(e instanceof WebServiceException)) {
                                    e.printStackTrace();
                                }
                                this.jws2Discoverer.addInvalidServiceUrl(this.jwsserver);
                            }
                            if (service == null || Jws2InstanceFactory.ignoreService(srv.toString())) continue;
                            noservices = false;
                            Jws2Instance svc = null;
                            if (registry != null) {
                                String description = registry.getServiceDescription(srv);
                                svc = Jws2InstanceFactory.newJws2Instance(this.jwsserver, srv.toString(), cat.name, description, service);
                            }
                            if (svc == null) {
                                svc = Jws2InstanceFactory.newJws2Instance(this.jwsserver, srv.toString(), cat.name, "JABAWS 1 Alignment Service", service);
                            }
                            this.jws2Discoverer.addService(this.jwsserver, svc);
                        }
                    }
                    if (noservices) {
                        this.jws2Discoverer.addUrlwithnoservices(this.jwsserver);
                    }
                    break block17;
                }
                this.jws2Discoverer.addInvalidServiceUrl(this.jwsserver);
                Console.warn("Ignoring invalid Jws2 service url " + this.jwsserver);
            }
            catch (Exception e) {
                e.printStackTrace();
                Console.warn("Exception when discovering Jws2 services.", e);
                this.jws2Discoverer.addInvalidServiceUrl(this.jwsserver);
            }
            catch (Error e) {
                Console.error("Exception when discovering Jws2 services.", e);
                this.jws2Discoverer.addInvalidServiceUrl(this.jwsserver);
            }
        }
        this.running = false;
    }

    private boolean isValidUrl(String server) {
        boolean result = false;
        if (server != null) {
            try {
                URL url = new URL(server);
                HttpUtils.openStream(url).close();
                result = true;
            }
            catch (MalformedURLException e) {
                Console.errPrintln("Invalid server URL: " + server);
                result = false;
            }
            catch (IOException e) {
                Console.errPrintln("Error connecting to server: " + server + ": " + e.toString());
                result = false;
            }
        }
        return result;
    }
}

