/*
 * Decompiled with CFR 0.152.
 */
package jalview.ws.api;

import jalview.bin.Console;
import jalview.gui.AlignFrame;
import jalview.ws.api.UIinfo;
import jalview.ws.jws2.MsaWSClient;
import jalview.ws.jws2.SequenceAnnotationWSClient;
import jalview.ws.params.ParamManager;
import jalview.ws.uimodel.AlignAnalysisUIText;
import javax.swing.JMenu;

public abstract class ServiceWithParameters
extends UIinfo {
    protected AlignAnalysisUIText aaui;
    protected ServiceClient style = null;

    public ServiceWithParameters(String serviceType, String action, String name, String description, String hosturl) {
        super(serviceType, action, name, description, hosturl);
    }

    public abstract void initParamStore(ParamManager var1);

    public AlignAnalysisUIText getAlignAnalysisUI() {
        return this.aaui;
    }

    public void setAlignAnalysisUI(AlignAnalysisUIText aaui) {
        this.aaui = aaui;
    }

    public boolean isInteractiveUpdate() {
        return this.aaui != null && this.aaui.isAA();
    }

    public boolean isProteinService() {
        return this.aaui == null ? true : this.aaui.isPr();
    }

    public boolean isNucleotideService() {
        return this.aaui == null ? false : this.aaui.isNa();
    }

    public boolean isNeedsAlignedSequences() {
        return this.aaui == null ? false : this.aaui.isNeedsAlignedSeqs();
    }

    public boolean isAlignmentAnalysis() {
        return this.aaui == null ? false : this.aaui.isAA();
    }

    public boolean isFilterSymbols() {
        return this.aaui != null ? this.aaui.isFilterSymbols() : true;
    }

    public int getMinimumInputSequences() {
        return this.aaui != null ? this.aaui.getMinimumSequences() : 1;
    }

    public String getNameURI() {
        return "java:" + this.getName();
    }

    public String getUri() {
        return this.getHostURL() + (this.getHostURL().lastIndexOf("/") == this.getHostURL().length() - 1 ? "" : "/") + this.getName();
    }

    public void attachWSMenuEntry(JMenu atpoint, AlignFrame alignFrame) {
        switch (this.style) {
            case MSAWSCLIENT: {
                new MsaWSClient().attachWSMenuEntry(atpoint, this, alignFrame);
                break;
            }
            case SEQUENCEANNOTATIONWSCLIENT: {
                new SequenceAnnotationWSClient().attachWSMenuEntry(atpoint, this, alignFrame);
                break;
            }
            default: {
                Console.warn("Implementation error ? Service " + this.getName() + " has Unknown service style " + this.style);
            }
        }
    }

    protected static enum ServiceClient {
        MSAWSCLIENT,
        SEQUENCEANNOTATIONWSCLIENT;

    }
}

