/*
 * Decompiled with CFR 0.152.
 */
package jalview.workers;

import jalview.api.AlignViewportI;
import jalview.api.AlignmentViewPanel;
import jalview.datamodel.AlignmentAnnotation;
import jalview.datamodel.AlignmentI;
import jalview.renderer.seqfeatures.FeatureRenderer;
import jalview.workers.AlignCalcWorker;
import jalview.workers.AnnotationProviderI;
import java.util.ArrayList;
import java.util.List;

class AnnotationWorker
extends AlignCalcWorker {
    AnnotationProviderI counter;

    public AnnotationWorker(AlignViewportI viewport, AlignmentViewPanel panel, AnnotationProviderI counter) {
        super(viewport, panel);
        this.ourAnnots = new ArrayList();
        this.counter = counter;
        this.calcMan.registerWorker(this);
    }

    @Override
    public void run() {
        if (this.alignViewport.isClosed()) {
            this.abortAndDestroy();
            return;
        }
        AlignmentI alignment = this.alignViewport.getAlignment();
        if (alignment != null) {
            try {
                List<AlignmentAnnotation> anns = this.counter.calculateAnnotation(alignment, new FeatureRenderer(this.alignViewport));
                for (AlignmentAnnotation ann : anns) {
                    AlignmentAnnotation theAnn = alignment.findOrCreateAnnotation(ann.label, ann.description, false, null, null);
                    theAnn.showAllColLabels = true;
                    theAnn.graph = 1;
                    theAnn.scaleColLabel = true;
                    theAnn.annotations = ann.annotations;
                    this.setGraphMinMax(theAnn, theAnn.annotations);
                    theAnn.validateRangeAndDisplay();
                    if (this.ourAnnots.contains(theAnn)) continue;
                    this.ourAnnots.add(theAnn);
                }
            }
            catch (IndexOutOfBoundsException x) {
                return;
            }
        }
        if (this.ap != null) {
            this.ap.adjustAnnotationHeight();
            this.ap.paintAlignment(true, true);
        }
    }

    @Override
    public void updateAnnotation() {
    }

    @Override
    public boolean isDeletable() {
        return true;
    }
}

