/*
 * Decompiled with CFR 0.152.
 */
package jalview.structure;

public class AtomSpec {
    int modelNo;
    private String pdbFile;
    private String chain;
    private int pdbResNum;
    private int atomIndex;

    public static AtomSpec fromChimeraAtomspec(String spec) {
        int modelSeparatorPos = spec.indexOf(":");
        if (modelSeparatorPos == -1) {
            throw new IllegalArgumentException(spec);
        }
        int hashPos = spec.indexOf("#");
        if (hashPos == -1 && modelSeparatorPos != 0) {
            throw new IllegalArgumentException(spec);
        }
        String modelSubmodel = spec.substring(hashPos + 1, modelSeparatorPos);
        int modelId = 0;
        try {
            int subModelPos = modelSubmodel.indexOf(".");
            modelId = Integer.valueOf(subModelPos > 0 ? modelSubmodel.substring(0, subModelPos) : modelSubmodel);
        }
        catch (NumberFormatException subModelPos) {
            // empty catch block
        }
        String atomsAndChain = spec.substring(modelSeparatorPos + 1);
        String[] tokens = atomsAndChain.split("\\.");
        String atoms = tokens.length == 1 ? atomsAndChain : tokens[0];
        int resNum = 0;
        try {
            resNum = Integer.parseInt(atoms);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(spec);
        }
        String chainId = tokens.length == 1 ? "" : tokens[1];
        return new AtomSpec(modelId, chainId, resNum, 0);
    }

    public AtomSpec(String pdbFile, String chain, int resNo, int atomNo) {
        this.pdbFile = pdbFile;
        this.chain = chain;
        this.pdbResNum = resNo;
        this.atomIndex = atomNo;
    }

    public AtomSpec(int modelId, String chainId, int resNo, int atomNo) {
        this.modelNo = modelId;
        this.chain = chainId;
        this.pdbResNum = resNo;
        this.atomIndex = atomNo;
    }

    public String getPdbFile() {
        return this.pdbFile;
    }

    public String getChain() {
        return this.chain;
    }

    public int getPdbResNum() {
        return this.pdbResNum;
    }

    public int getAtomIndex() {
        return this.atomIndex;
    }

    public int getModelNumber() {
        return this.modelNo;
    }

    public void setPdbFile(String file) {
        this.pdbFile = file;
    }

    public String toString() {
        return "pdbFile: " + this.pdbFile + ", chain: " + this.chain + ", res: " + this.pdbResNum + ", atom: " + this.atomIndex;
    }

    public static AtomSpec fromChimeraXAtomspec(String spec) {
        int modelSeparatorPos = spec.indexOf("/");
        if (modelSeparatorPos == -1) {
            throw new IllegalArgumentException(spec);
        }
        int hashPos = spec.indexOf("#");
        if (hashPos == -1 && modelSeparatorPos != 0) {
            throw new IllegalArgumentException(spec);
        }
        String modelSubmodel = spec.substring(hashPos + 1, modelSeparatorPos);
        int modelId = 0;
        try {
            int subModelPos = modelSubmodel.indexOf(".");
            modelId = Integer.valueOf(subModelPos > 0 ? modelSubmodel.substring(0, subModelPos) : modelSubmodel);
        }
        catch (NumberFormatException subModelPos) {
            // empty catch block
        }
        String atomsAndChain = spec.substring(modelSeparatorPos + 1);
        String[] tokens = atomsAndChain.split("\\:");
        String atoms = tokens.length == 1 ? atomsAndChain : tokens[1];
        int resNum = 0;
        try {
            resNum = Integer.parseInt(atoms);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(spec);
        }
        String chainId = tokens.length == 1 ? "" : tokens[0];
        return new AtomSpec(modelId, chainId, resNum, 0);
    }
}

