/*
 * Decompiled with CFR 0.152.
 */
package jalview.schemes;

import jalview.api.AlignViewportI;
import jalview.datamodel.AnnotatedCollectionI;
import jalview.datamodel.HiddenMarkovModel;
import jalview.datamodel.SequenceI;
import jalview.schemes.ColourSchemeI;
import jalview.schemes.JalviewColourScheme;
import jalview.schemes.ResidueColourScheme;
import jalview.util.ColorUtils;
import jalview.util.Comparison;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HMMMatchScoreColourScheme
extends ResidueColourScheme {
    private Map<Character, Map<Integer, Map<String, Double>>> probabilities;
    private List<Integer> ranges;
    private static double binSize;
    private static final Color INSERTION_COLOUR;
    private SequenceI hmmSeq;
    private HiddenMarkovModel hmm;
    private Map<Character, Float> frequencies;

    public HMMMatchScoreColourScheme(List<SequenceI> hmmSeqs) {
        this.hmmSeq = hmmSeqs.isEmpty() ? null : hmmSeqs.get(0);
        this.hmm = this.hmmSeq == null ? null : this.hmmSeq.getHMM();
        try {
            MatchProbReader probabilityReader = new MatchProbReader();
            this.probabilities = probabilityReader.getProbabilities();
        }
        catch (IOException e) {
            System.out.println(e.getStackTrace());
        }
    }

    public HMMMatchScoreColourScheme() {
    }

    @Override
    public Color findColour(char symbol, int column, SequenceI seq, String consensusResidue, float pid) {
        if (seq == null) {
            return null;
        }
        return this.findColour(symbol, column, seq.gapMap().length);
    }

    private Color findColour(char symbol, int column, int length) {
        double llr;
        int lengthBin;
        if (this.getHmm() == null || Comparison.isGap(symbol)) {
            return Color.white;
        }
        if (Comparison.isGap(this.hmmSeq.getCharAt(column))) {
            return INSERTION_COLOUR;
        }
        if (Character.isLowerCase(symbol)) {
            symbol = Character.toUpperCase(symbol);
        }
        double prob = 0.0;
        if (this.hmm.getBackgroundFrequencies().containsKey(Character.valueOf(symbol))) {
            lengthBin = this.getLengthBin(length);
            llr = Math.log(this.getHmm().getMatchEmissionProbability(column, symbol) / (double)this.hmm.getBackgroundFrequencies().get(Character.valueOf(symbol)).floatValue());
            if (!this.probabilities.containsKey(Character.valueOf(symbol)) || !this.probabilities.get(Character.valueOf(symbol)).get(lengthBin).containsKey(HMMMatchScoreColourScheme.format(llr))) {
                return new Color(140, 140, 140);
            }
        } else {
            return new Color(140, 140, 140);
        }
        prob = this.probabilities.get(Character.valueOf(symbol)).get(lengthBin).get(HMMMatchScoreColourScheme.format(llr));
        Color colour = Color.ORANGE;
        colour = prob >= 0.5 ? ColorUtils.getGraduatedColour((float)prob, 0.5f, Color.WHITE, 1.0f, Color.blue) : ColorUtils.getGraduatedColour((float)prob, 0.0f, Color.red, 0.5f, Color.WHITE);
        return colour;
    }

    public static String format(Double d) {
        Object formatArg = String.valueOf(binSize);
        if (binSize < 1.0) {
            formatArg = "." + ((String)formatArg).split("\\.")[1].length();
        }
        Double rounded = (double)Math.round(d / binSize) * binSize;
        String formatted = String.format("%" + (String)formatArg + "f", rounded);
        if (Double.valueOf(formatted) == 0.0) {
            formatted = "0";
        }
        return formatted;
    }

    protected float getMaxInformationScore() {
        return 0.0f;
    }

    @Override
    public ColourSchemeI getInstance(AlignViewportI viewport, AnnotatedCollectionI ac) {
        return this.newInstance(ac);
    }

    public HMMMatchScoreColourScheme(AnnotatedCollectionI ac) {
        this(ac.getHmmSequences());
    }

    protected HMMMatchScoreColourScheme newInstance(AnnotatedCollectionI ac) {
        return new HMMMatchScoreColourScheme(ac);
    }

    @Override
    public boolean isSimple() {
        return false;
    }

    @Override
    public boolean isApplicableTo(AnnotatedCollectionI ac) {
        return !ac.getHmmSequences().isEmpty() && ac.getHmmSequences().get(0).getHMM().getBackgroundFrequencies() != null;
    }

    protected Map<Character, Float> getFrequencies() {
        return this.frequencies;
    }

    protected void setFrequencies(Map<Character, Float> frequencies) {
        this.frequencies = frequencies;
    }

    protected HiddenMarkovModel getHmm() {
        return this.hmm;
    }

    protected SequenceI getHmmSequence() {
        return this.hmmSeq;
    }

    @Override
    public String getSchemeName() {
        return JalviewColourScheme.HMMMatchScore.toString();
    }

    private int getLengthBin(int l) {
        for (int i = 1; i < this.ranges.size(); ++i) {
            if (l < this.ranges.get(i - 1) || l >= this.ranges.get(i)) continue;
            return this.ranges.get(i);
        }
        return -1;
    }

    static {
        INSERTION_COLOUR = Color.white;
    }

    public class MatchProbReader {
        private BufferedReader reader = new BufferedReader(new FileReader("resources/ProbabilityOfMatch"));

        MatchProbReader() throws FileNotFoundException {
        }

        public Map<Character, Map<Integer, Map<String, Double>>> getProbabilities() throws IOException {
            HashMap<Character, Map<Integer, Map<String, Double>>> probabilities = new HashMap<Character, Map<Integer, Map<String, Double>>>();
            HMMMatchScoreColourScheme.this.ranges = new ArrayList<Integer>();
            HMMMatchScoreColourScheme.this.ranges.add(0);
            binSize = Double.valueOf(this.reader.readLine().replaceAll("\\ ", ""));
            String line = this.reader.readLine();
            char c = line.charAt(0);
            while (line != null) {
                line = this.reader.readLine();
                while (line != null && line.split("\\,").length != 1) {
                    String[] llrs = line.split("\\,");
                    String[] counts = this.reader.readLine().split("\\,");
                    int range = Integer.valueOf(llrs[0]);
                    if (!HMMMatchScoreColourScheme.this.ranges.contains(range)) {
                        HMMMatchScoreColourScheme.this.ranges.add(range);
                    }
                    if (!probabilities.containsKey(Character.valueOf(c))) {
                        probabilities.put(Character.valueOf(c), new HashMap());
                    }
                    ((Map)probabilities.get(Character.valueOf(c))).put(range, new HashMap());
                    for (int i = 1; i < llrs.length; ++i) {
                        ((Map)((Map)probabilities.get(Character.valueOf(c))).get(range)).put(llrs[i].replaceAll("\\ ", ""), Double.valueOf(counts[i].replaceAll("\\ ", "")));
                    }
                    line = this.reader.readLine();
                }
                if (line == null) continue;
                c = line.charAt(0);
            }
            return probabilities;
        }
    }
}

