/*
 * Decompiled with CFR 0.152.
 */
package jalview.schemes;

import jalview.api.AlignViewportI;
import jalview.datamodel.AnnotatedCollectionI;
import jalview.datamodel.SequenceCollectionI;
import jalview.datamodel.SequenceI;
import jalview.schemes.ColourSchemeI;
import jalview.schemes.Consensus;
import jalview.schemes.JalviewColourScheme;
import jalview.schemes.ResidueColourScheme;
import jalview.schemes.ResidueProperties;
import jalview.util.Comparison;
import java.awt.Color;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ClustalxColourScheme
extends ResidueColourScheme {
    private static final int EIGHTY_FIVE = 85;
    private static final int FIFTY = 50;
    private static final int EIGHTY = 80;
    private static final int SIXTY = 60;
    private int[][] cons2;
    private ConsensusColour[] colours;
    private ConsensusColour[] residueColour;
    private int size;
    private Consensus[] conses = new Consensus[32];
    private boolean includeGaps = true;

    public ClustalxColourScheme() {
    }

    public ClustalxColourScheme(AnnotatedCollectionI alignment, Map<SequenceI, SequenceCollectionI> hiddenReps) {
        this.alignmentChanged(alignment, hiddenReps);
    }

    @Override
    public synchronized void alignmentChanged(AnnotatedCollectionI alignment, Map<SequenceI, SequenceCollectionI> hiddenReps) {
        int maxWidth = alignment.getWidth();
        List<SequenceI> seqs = alignment.getSequences(hiddenReps);
        this.cons2 = new int[maxWidth][24];
        this.includeGaps = this.isIncludeGaps();
        int res = 0;
        for (SequenceI sq : seqs) {
            int end_j = sq.getLength() - 1;
            int length = sq.getLength();
            for (int i = 0; i <= end_j; ++i) {
                res = length - 1 < i ? 23 : ResidueProperties.aaIndex[sq.getCharAt(i)];
                int[] nArray = this.cons2[i];
                int n = res;
                nArray[n] = nArray[n] + 1;
            }
        }
        this.size = seqs.size();
        this.makeColours();
    }

    void makeColours() {
        this.conses[0] = new Consensus("WLVIMAFCYHP", 60.0);
        this.conses[1] = new Consensus("WLVIMAFCYHP", 80.0);
        this.conses[2] = new Consensus("ED", 50.0);
        this.conses[3] = new Consensus("KR", 60.0);
        this.conses[4] = new Consensus("G", 50.0);
        this.conses[5] = new Consensus("N", 50.0);
        this.conses[6] = new Consensus("QE", 50.0);
        this.conses[7] = new Consensus("P", 50.0);
        this.conses[8] = new Consensus("TS", 50.0);
        this.conses[26] = new Consensus("A", 85.0);
        this.conses[27] = new Consensus("C", 85.0);
        this.conses[10] = new Consensus("E", 85.0);
        this.conses[11] = new Consensus("F", 85.0);
        this.conses[12] = new Consensus("G", 85.0);
        this.conses[13] = new Consensus("H", 85.0);
        this.conses[14] = new Consensus("I", 85.0);
        this.conses[15] = new Consensus("L", 85.0);
        this.conses[16] = new Consensus("M", 85.0);
        this.conses[17] = new Consensus("N", 85.0);
        this.conses[18] = new Consensus("P", 85.0);
        this.conses[19] = new Consensus("Q", 85.0);
        this.conses[20] = new Consensus("R", 85.0);
        this.conses[21] = new Consensus("S", 85.0);
        this.conses[22] = new Consensus("T", 85.0);
        this.conses[23] = new Consensus("V", 85.0);
        this.conses[24] = new Consensus("W", 85.0);
        this.conses[25] = new Consensus("Y", 85.0);
        this.conses[28] = new Consensus("K", 85.0);
        this.conses[29] = new Consensus("D", 85.0);
        this.conses[30] = new Consensus("G", 0.0);
        this.conses[31] = new Consensus("P", 0.0);
        this.colours = new ConsensusColour[11];
        Consensus[] tmp8 = new Consensus[]{this.conses[30]};
        this.colours[7] = new ConsensusColour(ClustalColour.ORANGE, tmp8);
        Consensus[] tmp9 = new Consensus[]{this.conses[31]};
        this.colours[8] = new ConsensusColour(ClustalColour.YELLOW, tmp9);
        Consensus[] tmp10 = new Consensus[]{this.conses[27]};
        this.colours[9] = new ConsensusColour(ClustalColour.PINK, tmp8);
        Consensus[] tmp1 = new Consensus[]{this.conses[0], this.conses[1], this.conses[26], this.conses[27], this.conses[11], this.conses[13], this.conses[14], this.conses[15], this.conses[16], this.conses[23], this.conses[24], this.conses[25], this.conses[18], this.conses[19]};
        this.colours[0] = new ConsensusColour(ClustalColour.BLUE, tmp1);
        this.colours[10] = new ConsensusColour(ClustalColour.CYAN, tmp1);
        Consensus[] tmp2 = new Consensus[]{this.conses[8], this.conses[21], this.conses[22], this.conses[0], this.conses[1]};
        this.colours[1] = new ConsensusColour(ClustalColour.GREEN, tmp2);
        Consensus[] tmp3 = new Consensus[]{this.conses[17], this.conses[29], this.conses[5]};
        this.colours[2] = new ConsensusColour(ClustalColour.GREEN, tmp3);
        Consensus[] tmp4 = new Consensus[]{this.conses[6], this.conses[19], this.conses[22], this.conses[3], this.conses[28], this.conses[20]};
        this.colours[3] = new ConsensusColour(ClustalColour.GREEN, tmp4);
        Consensus[] tmp5 = new Consensus[]{this.conses[3], this.conses[28], this.conses[20], this.conses[19]};
        this.colours[4] = new ConsensusColour(ClustalColour.RED, tmp5);
        Consensus[] tmp6 = new Consensus[]{this.conses[3], this.conses[29], this.conses[10], this.conses[6], this.conses[19], this.conses[2]};
        this.colours[5] = new ConsensusColour(ClustalColour.MAGENTA, tmp6);
        Consensus[] tmp7 = new Consensus[]{this.conses[3], this.conses[29], this.conses[10], this.conses[17], this.conses[2]};
        this.colours[6] = new ConsensusColour(ClustalColour.MAGENTA, tmp7);
        this.residueColour = new ConsensusColour[20];
        this.residueColour[0] = this.colours[0];
        this.residueColour[1] = this.colours[4];
        this.residueColour[2] = this.colours[2];
        this.residueColour[3] = this.colours[6];
        this.residueColour[4] = this.colours[0];
        this.residueColour[5] = this.colours[3];
        this.residueColour[6] = this.colours[5];
        this.residueColour[7] = this.colours[7];
        this.residueColour[8] = this.colours[10];
        this.residueColour[9] = this.colours[0];
        this.residueColour[10] = this.colours[0];
        this.residueColour[11] = this.colours[4];
        this.residueColour[12] = this.colours[0];
        this.residueColour[13] = this.colours[0];
        this.residueColour[14] = this.colours[8];
        this.residueColour[15] = this.colours[1];
        this.residueColour[16] = this.colours[1];
        this.residueColour[17] = this.colours[0];
        this.residueColour[18] = this.colours[10];
        this.residueColour[19] = this.colours[0];
    }

    @Override
    public Color findColour(char c) {
        return Color.pink;
    }

    @Override
    protected synchronized Color findColour(char c, int j, SequenceI seq) {
        if (this.cons2.length <= j || Comparison.isGap(c)) {
            return Color.white;
        }
        int i = ResidueProperties.aaIndex[c];
        Color colour = Color.white;
        if (i > 19) {
            return colour;
        }
        for (int k = 0; k < this.residueColour[i].cons.length; ++k) {
            if (!this.residueColour[i].cons[k].isConserved(this.cons2, j, this.size, this.includeGaps)) continue;
            colour = this.residueColour[i].c;
        }
        if (i == 4 && this.conses[27].isConserved(this.cons2, j, this.size, this.includeGaps)) {
            colour = ClustalColour.PINK.colour;
        }
        return colour;
    }

    protected boolean isIncludeGaps() {
        return this.includeGaps;
    }

    protected void setIncludeGaps(boolean includeGaps) {
        this.includeGaps = includeGaps;
    }

    @Override
    public ColourSchemeI getInstance(AlignViewportI view, AnnotatedCollectionI sg) {
        ClustalxColourScheme css = new ClustalxColourScheme(sg, view == null ? null : view.getHiddenRepSequences());
        css.includeGaps = this.includeGaps;
        return css;
    }

    @Override
    public boolean isPeptideSpecific() {
        return true;
    }

    @Override
    public String getSchemeName() {
        return JalviewColourScheme.Clustal.toString();
    }

    @Override
    public boolean isSimple() {
        return false;
    }

    public String toRuleRep() {
        this.makeColours();
        HashMap<String, Object> cols = new HashMap<String, Object>();
        for (String res : ResidueProperties.aa) {
            ConsensusColour cc;
            StringBuilder sb = new StringBuilder();
            int rnum = ResidueProperties.aaIndex[res.charAt(0)];
            if (rnum < 0 || rnum >= this.residueColour.length || (cc = this.residueColour[rnum]) == null) continue;
            sb.append(cc.c.toString());
            double f = 0.0;
            sb.append("\t");
            for (Consensus cons : cc.cons) {
                if (cons.threshold == 0.0 || f != cons.threshold) {
                    if (f != 0.0) {
                        sb.append("}, {");
                    } else {
                        sb.append("{");
                    }
                    sb.append(cons.threshold);
                    sb.append(",");
                    f = cons.threshold;
                } else {
                    sb.append(",");
                }
                sb.append(cons.maskstr);
            }
            sb.append("}");
            String clxrep = sb.toString();
            Object xres = (String)cols.get(clxrep);
            if (xres == null) {
                xres = "";
            }
            xres = (String)xres + res;
            cols.put(clxrep, xres);
        }
        StringBuilder sb = new StringBuilder();
        for (String clxrep : cols.keySet()) {
            sb.append((String)cols.get(clxrep));
            sb.append("\t");
            sb.append(clxrep);
            sb.append("\n");
        }
        return sb.toString();
    }

    private class ConsensusColour {
        Consensus[] cons;
        Color c;

        public ConsensusColour(ClustalColour col, Consensus[] conses) {
            this.cons = conses;
            this.c = col.colour;
        }
    }

    static enum ClustalColour {
        RED(0.9f, 0.2f, 0.1f),
        BLUE(0.5f, 0.7f, 0.9f),
        GREEN(0.1f, 0.8f, 0.1f),
        ORANGE(0.9f, 0.6f, 0.3f),
        CYAN(0.1f, 0.7f, 0.7f),
        PINK(0.9f, 0.5f, 0.5f),
        MAGENTA(0.8f, 0.3f, 0.8f),
        YELLOW(0.8f, 0.8f, 0.0f);

        final Color colour;

        private ClustalColour(float r, float g, float b) {
            this.colour = new Color(r, g, b);
        }
    }
}

