/*
 * Decompiled with CFR 0.152.
 */
package jalview.jbgui;

import jalview.analysis.AnnotationSorter;
import jalview.analysis.GeneticCodeI;
import jalview.analysis.GeneticCodes;
import jalview.api.SplitContainerI;
import jalview.bin.Cache;
import jalview.bin.Console;
import jalview.gui.JvSwingUtils;
import jalview.hmmer.HmmerCommand;
import jalview.io.FileFormatException;
import jalview.io.FileFormats;
import jalview.util.MessageManager;
import jalview.util.Platform;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

public class GAlignFrame
extends JInternalFrame {
    protected JMenuBar alignFrameMenuBar = new JMenuBar();
    protected JMenuItem closeMenuItem = new JMenuItem();
    public JMenu webService = new JMenu();
    public JMenu hmmerMenu = new JMenu();
    public JMenuItem webServiceNoServices;
    protected JCheckBoxMenuItem viewBoxesMenuItem = new JCheckBoxMenuItem();
    protected JCheckBoxMenuItem viewTextMenuItem = new JCheckBoxMenuItem();
    protected JMenu sortByAnnotScore = new JMenu();
    public JLabel statusBar = new JLabel();
    protected JMenu outputTextboxMenu = new JMenu();
    protected JCheckBoxMenuItem annotationPanelMenuItem = new JCheckBoxMenuItem();
    protected JCheckBoxMenuItem colourTextMenuItem = new JCheckBoxMenuItem();
    protected JCheckBoxMenuItem showNonconservedMenuItem = new JCheckBoxMenuItem();
    protected JMenuItem undoMenuItem = new JMenuItem();
    protected JMenuItem redoMenuItem = new JMenuItem();
    protected JCheckBoxMenuItem wrapMenuItem = new JCheckBoxMenuItem();
    protected JCheckBoxMenuItem renderGapsMenuItem = new JCheckBoxMenuItem();
    public JCheckBoxMenuItem showSeqFeatures = new JCheckBoxMenuItem();
    JMenuItem copy = new JMenuItem();
    JMenuItem copyHighlighted = new JMenuItem();
    JMenuItem cut = new JMenuItem();
    JMenu pasteMenu = new JMenu();
    protected JCheckBoxMenuItem seqLimits = new JCheckBoxMenuItem();
    protected JCheckBoxMenuItem scaleAbove = new JCheckBoxMenuItem();
    protected JCheckBoxMenuItem scaleLeft = new JCheckBoxMenuItem();
    protected JCheckBoxMenuItem scaleRight = new JCheckBoxMenuItem();
    protected JCheckBoxMenuItem applyToAllGroups;
    protected JMenu colourMenu = new JMenu();
    protected JMenuItem textColour;
    protected JCheckBoxMenuItem conservationMenuItem;
    protected JMenuItem modifyConservation;
    protected JCheckBoxMenuItem abovePIDThreshold;
    protected JMenuItem modifyPID;
    protected JCheckBoxMenuItem byConsensusSecondaryStructureMenuItem;
    protected JMenuItem modifyConsensusSecondaryStructureThreshold;
    protected JRadioButtonMenuItem annotationColour;
    protected JMenu sortByTreeMenu = new JMenu();
    protected JCheckBoxMenuItem sortAnnBySequence;
    protected JCheckBoxMenuItem sortAnnByLabel;
    protected JMenu sortAnnotationByTreeMenu = new JMenu();
    protected JMenu sort = new JMenu();
    protected JMenuItem calculateTree = new JMenuItem();
    protected JCheckBoxMenuItem padGapsMenuitem = new JCheckBoxMenuItem();
    protected JCheckBoxMenuItem showNpFeatsMenuitem = new JCheckBoxMenuItem();
    protected JCheckBoxMenuItem showDbRefsMenuitem = new JCheckBoxMenuItem();
    protected JMenu showTranslation = new JMenu();
    protected JMenuItem showReverse = new JMenuItem();
    protected JMenuItem showReverseComplement = new JMenuItem();
    protected JMenu showProducts = new JMenu();
    protected JMenuItem runGroovy = new JMenuItem();
    protected JMenuItem loadVcf;
    protected JCheckBoxMenuItem autoCalculate = new JCheckBoxMenuItem();
    protected JCheckBoxMenuItem sortByTree = new JCheckBoxMenuItem();
    protected JCheckBoxMenuItem listenToViewSelections = new JCheckBoxMenuItem();
    protected JPanel statusPanel = new JPanel();
    protected JMenuItem showAllSeqAnnotations = new JMenuItem();
    protected JMenuItem hideAllSeqAnnotations = new JMenuItem();
    protected JMenuItem showAllAlAnnotations = new JMenuItem();
    protected JMenuItem hideAllAlAnnotations = new JMenuItem();
    protected JCheckBoxMenuItem showComplementMenuItem = new JCheckBoxMenuItem();
    protected JCheckBoxMenuItem hiddenMarkers = new JCheckBoxMenuItem();
    protected JTabbedPane tabbedPane = new JTabbedPane();
    protected JMenuItem reload = new JMenuItem();
    protected JMenu formatMenu = new JMenu();
    protected JCheckBoxMenuItem idRightAlign = new JCheckBoxMenuItem();
    protected JCheckBoxMenuItem centreColumnLabelsMenuItem = new JCheckBoxMenuItem();
    protected JCheckBoxMenuItem followHighlightMenuItem = new JCheckBoxMenuItem();
    protected JMenuItem gatherViews = new JMenuItem();
    protected JMenuItem expandViews = new JMenuItem();
    protected JCheckBoxMenuItem showStrucProvider = new JCheckBoxMenuItem();
    protected JCheckBoxMenuItem showSSConsensus = new JCheckBoxMenuItem();
    protected JCheckBoxMenuItem showGroupSSConsensus = new JCheckBoxMenuItem();
    protected JCheckBoxMenuItem showGroupConsensus = new JCheckBoxMenuItem();
    protected JCheckBoxMenuItem showGroupConservation = new JCheckBoxMenuItem();
    protected JCheckBoxMenuItem showConsensusHistogram = new JCheckBoxMenuItem();
    protected JCheckBoxMenuItem showSequenceLogo = new JCheckBoxMenuItem();
    protected JCheckBoxMenuItem normaliseSequenceLogo = new JCheckBoxMenuItem();
    protected JCheckBoxMenuItem showInformationHistogram = new JCheckBoxMenuItem();
    protected JCheckBoxMenuItem showHMMSequenceLogo = new JCheckBoxMenuItem();
    protected JCheckBoxMenuItem normaliseHMMSequenceLogo = new JCheckBoxMenuItem();
    protected JCheckBoxMenuItem applyAutoAnnotationSettings = new JCheckBoxMenuItem();
    protected JMenuItem openFeatureSettings;
    private AnnotationSorter.SequenceAnnotationOrder annotationSortOrder;
    private boolean showAutoCalculatedAbove = false;
    private Map<KeyStroke, JMenuItem> accelerators = new HashMap<KeyStroke, JMenuItem>();
    private SplitContainerI splitFrame;

    public GAlignFrame() {
        try {
            this.setFrameIcon(null);
            this.setName(Platform.getAppID("alignment"));
            this.jbInit();
            this.setJMenuBar(this.alignFrameMenuBar);
            for (String ff : FileFormats.getInstance().getWritableFormats(true)) {
                JMenuItem item = new JMenuItem(ff);
                item.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        GAlignFrame.this.outputText_actionPerformed(e.getActionCommand());
                    }
                });
                this.outputTextboxMenu.add(item);
            }
        }
        catch (Exception e) {
            Console.errPrintln(e.toString());
        }
        if (Platform.allowMnemonics()) {
            this.closeMenuItem.setMnemonic('C');
            this.outputTextboxMenu.setMnemonic('T');
            this.undoMenuItem.setMnemonic('Z');
            this.redoMenuItem.setMnemonic('0');
            this.copy.setMnemonic('C');
            this.cut.setMnemonic('U');
            this.pasteMenu.setMnemonic('P');
            this.reload.setMnemonic('R');
        }
    }

    private void jbInit() throws Exception {
        this.setFrameIcon(null);
        this.initColourMenu();
        JMenuItem saveAs = new JMenuItem(MessageManager.getString("action.save_as"));
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.saveAs_actionPerformed();
            }
        };
        KeyStroke keyStroke = KeyStroke.getKeyStroke(83, Platform.SHORTCUT_KEY_MASK | 0x40, false);
        this.addMenuActionAndAccelerator(keyStroke, saveAs, al);
        this.closeMenuItem.setText(MessageManager.getString("action.close"));
        keyStroke = KeyStroke.getKeyStroke(87, Platform.SHORTCUT_KEY_MASK, false);
        al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.closeMenuItem_actionPerformed(false);
            }
        };
        this.addMenuActionAndAccelerator(keyStroke, this.closeMenuItem, al);
        JMenu editMenu = new JMenu(MessageManager.getString("action.edit"));
        JMenu viewMenu = new JMenu(MessageManager.getString("action.view"));
        JMenu annotationsMenu = new JMenu(MessageManager.getString("action.annotations"));
        JMenu showMenu = new JMenu(MessageManager.getString("action.show"));
        this.colourMenu.setText(MessageManager.getString("action.colour"));
        JMenu calculateMenu = new JMenu(MessageManager.getString("action.calculate"));
        this.webService.setText(MessageManager.getString("action.web_service"));
        this.initHMMERMenu();
        JMenuItem selectAllSequenceMenuItem = new JMenuItem(MessageManager.getString("action.select_all"));
        keyStroke = KeyStroke.getKeyStroke(65, Platform.SHORTCUT_KEY_MASK, false);
        al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.selectAllSequenceMenuItem_actionPerformed(e);
            }
        };
        this.addMenuActionAndAccelerator(keyStroke, selectAllSequenceMenuItem, al);
        JMenuItem deselectAllSequenceMenuItem = new JMenuItem(MessageManager.getString("action.deselect_all"));
        keyStroke = KeyStroke.getKeyStroke(27, 0, false);
        al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.deselectAllSequenceMenuItem_actionPerformed(e);
            }
        };
        this.addMenuActionAndAccelerator(keyStroke, deselectAllSequenceMenuItem, al);
        JMenuItem invertSequenceMenuItem = new JMenuItem(MessageManager.getString("action.invert_sequence_selection"));
        keyStroke = KeyStroke.getKeyStroke(73, Platform.SHORTCUT_KEY_MASK, false);
        al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.invertSequenceMenuItem_actionPerformed(e);
            }
        };
        this.addMenuActionAndAccelerator(keyStroke, invertSequenceMenuItem, al);
        JMenuItem grpsFromSelection = new JMenuItem(MessageManager.getString("action.make_groups_selection"));
        grpsFromSelection.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.makeGrpsFromSelection_actionPerformed(e);
            }
        });
        JMenuItem expandAlignment = new JMenuItem(MessageManager.getString("action.view_flanking_regions"));
        expandAlignment.setToolTipText(MessageManager.getString("label.view_flanking_regions"));
        expandAlignment.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.expand_newalign(e);
            }
        });
        JMenuItem remove2LeftMenuItem = new JMenuItem(MessageManager.getString("action.remove_left"));
        keyStroke = KeyStroke.getKeyStroke(76, Platform.SHORTCUT_KEY_MASK, false);
        al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.remove2LeftMenuItem_actionPerformed(e);
            }
        };
        this.addMenuActionAndAccelerator(keyStroke, remove2LeftMenuItem, al);
        JMenuItem remove2RightMenuItem = new JMenuItem(MessageManager.getString("action.remove_right"));
        keyStroke = KeyStroke.getKeyStroke(82, Platform.SHORTCUT_KEY_MASK, false);
        al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.remove2RightMenuItem_actionPerformed(e);
            }
        };
        this.addMenuActionAndAccelerator(keyStroke, remove2RightMenuItem, al);
        JMenuItem removeGappedColumnMenuItem = new JMenuItem(MessageManager.getString("action.remove_empty_columns"));
        keyStroke = KeyStroke.getKeyStroke(69, Platform.SHORTCUT_KEY_MASK, false);
        al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.removeGappedColumnMenuItem_actionPerformed(e);
            }
        };
        this.addMenuActionAndAccelerator(keyStroke, removeGappedColumnMenuItem, al);
        JMenuItem removeAllGapsMenuItem = new JMenuItem(MessageManager.getString("action.remove_all_gaps"));
        keyStroke = KeyStroke.getKeyStroke(69, Platform.SHORTCUT_KEY_MASK | 0x40, false);
        al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.removeAllGapsMenuItem_actionPerformed(e);
            }
        };
        this.addMenuActionAndAccelerator(keyStroke, removeAllGapsMenuItem, al);
        JMenuItem justifyLeftMenuItem = new JMenuItem(MessageManager.getString("action.left_justify"));
        justifyLeftMenuItem.setToolTipText(MessageManager.getString("tooltip.left_justify"));
        justifyLeftMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.justifyLeftMenuItem_actionPerformed(e);
            }
        });
        JMenuItem justifyRightMenuItem = new JMenuItem(MessageManager.getString("action.right_justify"));
        justifyRightMenuItem.setToolTipText(MessageManager.getString("action.left_justify"));
        justifyRightMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.justifyRightMenuItem_actionPerformed(e);
            }
        });
        this.viewBoxesMenuItem.setText(MessageManager.getString("action.boxes"));
        this.viewBoxesMenuItem.setState(true);
        this.viewBoxesMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.viewBoxesMenuItem_actionPerformed(e);
            }
        });
        this.viewTextMenuItem.setText(MessageManager.getString("action.text"));
        this.viewTextMenuItem.setState(true);
        this.viewTextMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.viewTextMenuItem_actionPerformed(e);
            }
        });
        this.showNonconservedMenuItem.setText(MessageManager.getString("label.show_non_conserved"));
        this.showNonconservedMenuItem.setState(false);
        this.showNonconservedMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.showUnconservedMenuItem_actionPerformed(e);
            }
        });
        JMenuItem sortPairwiseMenuItem = new JMenuItem(MessageManager.getString("action.by_pairwise_id"));
        sortPairwiseMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.sortPairwiseMenuItem_actionPerformed(e);
            }
        });
        JMenuItem sortIDMenuItem = new JMenuItem(MessageManager.getString("action.by_id"));
        sortIDMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.sortIDMenuItem_actionPerformed(e);
            }
        });
        JMenuItem sortDescriptionMenuItem = new JMenuItem(MessageManager.getString("action.by_description"));
        sortDescriptionMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.sortDescriptionMenuItem_actionPerformed(e);
            }
        });
        JMenuItem sortLengthMenuItem = new JMenuItem(MessageManager.getString("action.by_length"));
        sortLengthMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.sortLengthMenuItem_actionPerformed(e);
            }
        });
        JMenuItem sortGroupMenuItem = new JMenuItem(MessageManager.getString("action.by_group"));
        sortGroupMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.sortGroupMenuItem_actionPerformed(e);
            }
        });
        JMenuItem sortEValueMenuItem = new JMenuItem(MessageManager.getString("action.by_evalue"));
        sortEValueMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.sortEValueMenuItem_actionPerformed(e);
            }
        });
        JMenuItem sortBitScoreMenuItem = new JMenuItem(MessageManager.getString("action.by_bit_score"));
        sortBitScoreMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.sortBitScoreMenuItem_actionPerformed(e);
            }
        });
        JMenuItem removeRedundancyMenuItem = new JMenuItem(MessageManager.getString("action.remove_redundancy"));
        keyStroke = KeyStroke.getKeyStroke(68, Platform.SHORTCUT_KEY_MASK, false);
        al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.removeRedundancyMenuItem_actionPerformed(e);
            }
        };
        this.addMenuActionAndAccelerator(keyStroke, removeRedundancyMenuItem, al);
        JMenuItem filterByEValue = new JMenuItem(MessageManager.getString("action.filter_by_evalue"));
        filterByEValue.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.filterByEValue_actionPerformed();
            }
        });
        JMenuItem filterByScore = new JMenuItem(MessageManager.getString("action.filter_by_score"));
        filterByScore.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.filterByScore_actionPerformed();
            }
        });
        JMenuItem pairwiseAlignmentMenuItem = new JMenuItem(MessageManager.getString("action.pairwise_alignment"));
        pairwiseAlignmentMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.pairwiseAlignmentMenuItem_actionPerformed(e);
            }
        });
        this.getContentPane().setLayout(new BorderLayout());
        this.alignFrameMenuBar.setFont(new Font("Verdana", 0, 11));
        this.statusBar.setBackground(Color.white);
        this.statusBar.setFont(new Font("Verdana", 0, 11));
        this.statusBar.setBorder(BorderFactory.createLineBorder(Color.black));
        this.statusBar.setText(MessageManager.getString("label.status_bar"));
        this.outputTextboxMenu.setText(MessageManager.getString("label.out_to_textbox"));
        this.annotationPanelMenuItem.setActionCommand("");
        this.annotationPanelMenuItem.setText(MessageManager.getString("label.show_annotations"));
        this.annotationPanelMenuItem.setState(Cache.getDefault("SHOW_ANNOTATIONS", true));
        this.annotationPanelMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.annotationPanelMenuItem_actionPerformed(e);
            }
        });
        this.showAllAlAnnotations.setText(MessageManager.getString("label.show_all_al_annotations"));
        boolean isAnnotationPanelShown = this.annotationPanelMenuItem.getState();
        this.showAllAlAnnotations.setEnabled(isAnnotationPanelShown);
        this.showAllAlAnnotations.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.showAllAnnotations_actionPerformed(false, true);
            }
        });
        this.hideAllAlAnnotations.setText(MessageManager.getString("label.hide_all_al_annotations"));
        this.hideAllAlAnnotations.setEnabled(isAnnotationPanelShown);
        this.hideAllAlAnnotations.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.hideAllAnnotations_actionPerformed(false, true);
            }
        });
        this.showAllSeqAnnotations.setText(MessageManager.getString("label.show_all_seq_annotations"));
        this.showAllSeqAnnotations.setEnabled(isAnnotationPanelShown);
        this.showAllSeqAnnotations.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.showAllAnnotations_actionPerformed(true, false);
            }
        });
        this.hideAllSeqAnnotations.setText(MessageManager.getString("label.hide_all_seq_annotations"));
        this.hideAllSeqAnnotations.setEnabled(isAnnotationPanelShown);
        this.hideAllSeqAnnotations.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.hideAllAnnotations_actionPerformed(true, false);
            }
        });
        AnnotationSorter.SequenceAnnotationOrder sortAnnotationsBy = AnnotationSorter.SequenceAnnotationOrder.valueOf(Cache.getDefault("SORT_ANNOTATIONS", AnnotationSorter.SequenceAnnotationOrder.NONE.name()));
        this.sortAnnBySequence = new JCheckBoxMenuItem(MessageManager.getString("label.sort_annotations_by_sequence"));
        this.sortAnnByLabel = new JCheckBoxMenuItem(MessageManager.getString("label.sort_annotations_by_label"));
        this.sortAnnotationByTreeMenu.setText(MessageManager.getString("label.sort_annotations_by_tree"));
        this.sortAnnBySequence.setSelected(sortAnnotationsBy == AnnotationSorter.SequenceAnnotationOrder.SEQUENCE_AND_LABEL);
        this.sortAnnBySequence.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean newState = GAlignFrame.this.sortAnnBySequence.getState();
                GAlignFrame.this.sortAnnByLabel.setSelected(false);
                GAlignFrame.this.setAnnotationSortOrder(newState ? AnnotationSorter.SequenceAnnotationOrder.SEQUENCE_AND_LABEL : AnnotationSorter.SequenceAnnotationOrder.NONE);
                GAlignFrame.this.sortAnnotations_actionPerformed();
            }
        });
        this.sortAnnByLabel.setSelected(sortAnnotationsBy == AnnotationSorter.SequenceAnnotationOrder.LABEL_AND_SEQUENCE);
        this.sortAnnByLabel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean newState = GAlignFrame.this.sortAnnByLabel.getState();
                GAlignFrame.this.sortAnnBySequence.setSelected(false);
                GAlignFrame.this.setAnnotationSortOrder(newState ? AnnotationSorter.SequenceAnnotationOrder.LABEL_AND_SEQUENCE : AnnotationSorter.SequenceAnnotationOrder.NONE);
                GAlignFrame.this.sortAnnotations_actionPerformed();
            }
        });
        this.showStrucProvider = new JCheckBoxMenuItem(MessageManager.getString("label.show_structure_provider"));
        this.showStrucProvider.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.showStructureProvider_actionPerformed(e);
            }
        });
        this.colourTextMenuItem = new JCheckBoxMenuItem(MessageManager.getString("label.colour_text"));
        this.colourTextMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.colourTextMenuItem_actionPerformed(e);
            }
        });
        JMenuItem htmlMenuItem = new JMenuItem(MessageManager.getString("label.html"));
        htmlMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.htmlMenuItem_actionPerformed(e);
            }
        });
        JMenuItem createBioJS = new JMenuItem(MessageManager.getString("label.biojs_html_export"));
        createBioJS.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.bioJSMenuItem_actionPerformed(e);
            }
        });
        JMenuItem overviewMenuItem = new JMenuItem(MessageManager.getString("label.overview_window"));
        overviewMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.overviewMenuItem_actionPerformed(e);
            }
        });
        this.undoMenuItem.setEnabled(false);
        this.undoMenuItem.setText(MessageManager.getString("action.undo"));
        keyStroke = KeyStroke.getKeyStroke(90, Platform.SHORTCUT_KEY_MASK, false);
        al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.undoMenuItem_actionPerformed(e);
            }
        };
        this.addMenuActionAndAccelerator(keyStroke, this.undoMenuItem, al);
        this.redoMenuItem.setEnabled(false);
        this.redoMenuItem.setText(MessageManager.getString("action.redo"));
        keyStroke = KeyStroke.getKeyStroke(89, Platform.SHORTCUT_KEY_MASK, false);
        al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.redoMenuItem_actionPerformed(e);
            }
        };
        this.addMenuActionAndAccelerator(keyStroke, this.redoMenuItem, al);
        this.wrapMenuItem.setText(MessageManager.getString("label.wrap"));
        this.wrapMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.wrapMenuItem_actionPerformed(e);
            }
        });
        JMenuItem printMenuItem = new JMenuItem(MessageManager.getString("action.print"));
        keyStroke = KeyStroke.getKeyStroke(80, Platform.SHORTCUT_KEY_MASK, false);
        al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.printMenuItem_actionPerformed(e);
            }
        };
        this.addMenuActionAndAccelerator(keyStroke, printMenuItem, al);
        this.renderGapsMenuItem.setText(MessageManager.getString("action.show_gaps"));
        this.renderGapsMenuItem.setState(true);
        this.renderGapsMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.renderGapsMenuItem_actionPerformed(e);
            }
        });
        JMenuItem findMenuItem = new JMenuItem(MessageManager.getString("action.find"));
        keyStroke = KeyStroke.getKeyStroke(70, Platform.SHORTCUT_KEY_MASK, false);
        findMenuItem.setToolTipText(JvSwingUtils.wrapTooltip(true, MessageManager.getString("label.find_tip")));
        al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.findMenuItem_actionPerformed(e);
            }
        };
        this.addMenuActionAndAccelerator(keyStroke, findMenuItem, al);
        this.showSeqFeatures.setText(MessageManager.getString("label.show_sequence_features"));
        this.showSeqFeatures.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GAlignFrame.this.showSeqFeatures_actionPerformed(actionEvent);
            }
        });
        this.showDbRefsMenuitem.setText(MessageManager.getString("label.show_database_refs"));
        this.showDbRefsMenuitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.showDbRefs_actionPerformed(e);
            }
        });
        this.showNpFeatsMenuitem.setText(MessageManager.getString("label.show_non_positional_features"));
        this.showNpFeatsMenuitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.showNpFeats_actionPerformed(e);
            }
        });
        this.showGroupConservation.setText(MessageManager.getString("label.group_conservation"));
        this.showGroupConservation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.showGroupConservation_actionPerformed(e);
            }
        });
        this.showSSConsensus.setText(MessageManager.getString("label.show_secondary_structure_consensus"));
        this.showSSConsensus.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.showSSConsensus_actionPerformed(e);
            }
        });
        this.showGroupSSConsensus.setText(MessageManager.getString("label.group_ss_consensus"));
        this.showGroupSSConsensus.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.showGroupSSConsensus_actionPerformed(e);
            }
        });
        this.showGroupConsensus.setText(MessageManager.getString("label.group_consensus"));
        this.showGroupConsensus.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.showGroupConsensus_actionPerformed(e);
            }
        });
        this.showConsensusHistogram.setText(MessageManager.getString("label.show_consensus_histogram"));
        this.showConsensusHistogram.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.showConsensusHistogram_actionPerformed(e);
            }
        });
        this.showSequenceLogo.setText(MessageManager.getString("label.show_consensus_logo"));
        this.showSequenceLogo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.showSequenceLogo_actionPerformed(e);
            }
        });
        this.normaliseSequenceLogo.setText(MessageManager.getString("label.norm_consensus_logo"));
        this.normaliseSequenceLogo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.normaliseSequenceLogo_actionPerformed(e);
            }
        });
        this.applyAutoAnnotationSettings.setText(MessageManager.getString("label.apply_all_groups"));
        this.applyAutoAnnotationSettings.setState(false);
        this.applyAutoAnnotationSettings.setVisible(true);
        this.applyAutoAnnotationSettings.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.applyAutoAnnotationSettings_actionPerformed(e);
            }
        });
        ButtonGroup buttonGroup = new ButtonGroup();
        final JRadioButtonMenuItem showAutoFirst = new JRadioButtonMenuItem(MessageManager.getString("label.show_first"));
        final JRadioButtonMenuItem showAutoLast = new JRadioButtonMenuItem(MessageManager.getString("label.show_last"));
        buttonGroup.add(showAutoFirst);
        buttonGroup.add(showAutoLast);
        boolean autoFirst = Cache.getDefault("SHOW_AUTOCALC_ABOVE", false);
        showAutoFirst.setSelected(autoFirst);
        this.setShowAutoCalculatedAbove(autoFirst);
        showAutoFirst.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.setShowAutoCalculatedAbove(showAutoFirst.isSelected());
                GAlignFrame.this.sortAnnotations_actionPerformed();
            }
        });
        showAutoLast.setSelected(!showAutoFirst.isSelected());
        showAutoLast.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.setShowAutoCalculatedAbove(!showAutoLast.isSelected());
                GAlignFrame.this.sortAnnotations_actionPerformed();
            }
        });
        JMenuItem deleteGroups = new JMenuItem(MessageManager.getString("action.undefine_groups"));
        keyStroke = KeyStroke.getKeyStroke(85, Platform.SHORTCUT_KEY_MASK, false);
        al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.deleteGroups_actionPerformed(e);
            }
        };
        this.addMenuActionAndAccelerator(keyStroke, deleteGroups, al);
        JMenuItem annotationColumn = new JMenuItem(MessageManager.getString("action.select_by_annotation"));
        annotationColumn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.annotationColumn_actionPerformed(e);
            }
        });
        JMenuItem createGroup = new JMenuItem(MessageManager.getString("action.create_group"));
        keyStroke = KeyStroke.getKeyStroke(71, Platform.SHORTCUT_KEY_MASK, false);
        al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.createGroup_actionPerformed(e);
            }
        };
        this.addMenuActionAndAccelerator(keyStroke, createGroup, al);
        JMenuItem unGroup = new JMenuItem(MessageManager.getString("action.remove_group"));
        keyStroke = KeyStroke.getKeyStroke(71, Platform.SHORTCUT_KEY_MASK | 0x40, false);
        al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.unGroup_actionPerformed(e);
            }
        };
        this.addMenuActionAndAccelerator(keyStroke, unGroup, al);
        this.copy.setText(MessageManager.getString("action.copy"));
        keyStroke = KeyStroke.getKeyStroke(67, Platform.SHORTCUT_KEY_MASK, false);
        al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.copy_actionPerformed();
            }
        };
        this.addMenuActionAndAccelerator(keyStroke, this.copy, al);
        this.cut.setText(MessageManager.getString("action.cut"));
        keyStroke = KeyStroke.getKeyStroke(88, Platform.SHORTCUT_KEY_MASK, false);
        al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.cut_actionPerformed();
            }
        };
        this.addMenuActionAndAccelerator(keyStroke, this.cut, al);
        JMenuItem delete = new JMenuItem(MessageManager.getString("action.delete"));
        delete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.delete_actionPerformed();
            }
        });
        this.pasteMenu.setText(MessageManager.getString("action.paste"));
        JMenuItem pasteNew = new JMenuItem(MessageManager.getString("label.to_new_alignment"));
        keyStroke = KeyStroke.getKeyStroke(86, Platform.SHORTCUT_KEY_MASK | 0x40, false);
        al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    GAlignFrame.this.pasteNew_actionPerformed(e);
                }
                catch (IOException | InterruptedException e1) {
                    e1.printStackTrace();
                }
            }
        };
        this.addMenuActionAndAccelerator(keyStroke, pasteNew, al);
        JMenuItem pasteThis = new JMenuItem(MessageManager.getString("label.to_this_alignment"));
        keyStroke = KeyStroke.getKeyStroke(86, Platform.SHORTCUT_KEY_MASK, false);
        al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    GAlignFrame.this.pasteThis_actionPerformed(e);
                }
                catch (IOException | InterruptedException e1) {
                    e1.printStackTrace();
                }
            }
        };
        this.addMenuActionAndAccelerator(keyStroke, pasteThis, al);
        JMenuItem createPNG = new JMenuItem("PNG");
        createPNG.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.createPNG_actionPerformed(e);
            }
        });
        createPNG.setActionCommand(MessageManager.getString("label.save_png_image"));
        JMenuItem font = new JMenuItem(MessageManager.getString("action.font"));
        font.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.font_actionPerformed(e);
            }
        });
        this.seqLimits.setText(MessageManager.getString("label.show_sequence_limits"));
        this.seqLimits.setState(Cache.getDefault("SHOW_JVSUFFIX", true));
        this.seqLimits.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.seqLimit_actionPerformed(e);
            }
        });
        JMenuItem epsFile = new JMenuItem("EPS");
        epsFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.createEPS_actionPerformed(e);
            }
        });
        JMenuItem createSVG = new JMenuItem("SVG");
        createSVG.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.createSVG_actionPerformed(e);
            }
        });
        JMenuItem loadTreeMenuItem = new JMenuItem(MessageManager.getString("label.load_associated_tree"));
        loadTreeMenuItem.setActionCommand(MessageManager.getString("label.load_tree_for_sequence_set"));
        loadTreeMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.loadTreeMenuItem_actionPerformed(e);
            }
        });
        this.scaleAbove.setVisible(false);
        this.scaleAbove.setText(MessageManager.getString("action.scale_above"));
        this.scaleAbove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.scaleAbove_actionPerformed(e);
            }
        });
        this.scaleLeft.setVisible(false);
        this.scaleLeft.setSelected(true);
        this.scaleLeft.setText(MessageManager.getString("action.scale_left"));
        this.scaleLeft.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.scaleLeft_actionPerformed(e);
            }
        });
        this.scaleRight.setVisible(false);
        this.scaleRight.setSelected(true);
        this.scaleRight.setText(MessageManager.getString("action.scale_right"));
        this.scaleRight.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.scaleRight_actionPerformed(e);
            }
        });
        this.centreColumnLabelsMenuItem.setVisible(true);
        this.centreColumnLabelsMenuItem.setState(false);
        this.centreColumnLabelsMenuItem.setText(MessageManager.getString("label.centre_column_labels"));
        this.centreColumnLabelsMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.centreColumnLabels_actionPerformed(e);
            }
        });
        this.followHighlightMenuItem.setVisible(true);
        this.followHighlightMenuItem.setState(true);
        this.followHighlightMenuItem.setText(MessageManager.getString("label.automatic_scrolling"));
        this.followHighlightMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.followHighlight_actionPerformed();
            }
        });
        this.sortByTreeMenu.setText(MessageManager.getString("action.by_tree_order"));
        this.sort.setText(MessageManager.getString("action.sort"));
        this.sort.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent e) {
                GAlignFrame.this.enableSortMenuOptions();
            }

            @Override
            public void menuDeselected(MenuEvent e) {
            }

            @Override
            public void menuCanceled(MenuEvent e) {
            }
        });
        this.sortByTreeMenu.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent e) {
                GAlignFrame.this.buildTreeSortMenu();
            }

            @Override
            public void menuDeselected(MenuEvent e) {
            }

            @Override
            public void menuCanceled(MenuEvent e) {
            }
        });
        this.sortByAnnotScore.setText(MessageManager.getString("label.sort_by_score"));
        this.sort.add(this.sortByAnnotScore);
        this.sort.addMenuListener(new MenuListener(){

            @Override
            public void menuCanceled(MenuEvent e) {
            }

            @Override
            public void menuDeselected(MenuEvent e) {
            }

            @Override
            public void menuSelected(MenuEvent e) {
                GAlignFrame.this.buildSortByAnnotationScoresMenu();
            }
        });
        this.sortByAnnotScore.setVisible(false);
        this.calculateTree.setText(MessageManager.getString("action.calculate_tree_pca"));
        this.padGapsMenuitem.setText(MessageManager.getString("label.pad_gaps"));
        this.padGapsMenuitem.setState(Cache.getDefault("PAD_GAPS", false));
        this.padGapsMenuitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.padGapsMenuitem_actionPerformed(e);
            }
        });
        JMenuItem vamsasStore = new JMenuItem(MessageManager.getString("label.vamsas_store"));
        vamsasStore.setVisible(false);
        vamsasStore.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.vamsasStore_actionPerformed(e);
            }
        });
        this.showTranslation.setText(MessageManager.getString("label.translate_cDNA"));
        boolean first = true;
        for (final GeneticCodeI table : GeneticCodes.getInstance().getCodeTables()) {
            JMenuItem item = new JMenuItem(table.getId() + " " + table.getName());
            this.showTranslation.add(item);
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GAlignFrame.this.showTranslation_actionPerformed(table);
                }
            });
            if (first) {
                this.showTranslation.addSeparator();
            }
            first = false;
        }
        this.showReverse.setText(MessageManager.getString("label.reverse"));
        this.showReverse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.showReverse_actionPerformed(false);
            }
        });
        this.showReverseComplement.setText(MessageManager.getString("label.reverse_complement"));
        this.showReverseComplement.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.showReverse_actionPerformed(true);
            }
        });
        JMenuItem extractScores = new JMenuItem(MessageManager.getString("label.extract_scores"));
        extractScores.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.extractScores_actionPerformed(e);
            }
        });
        extractScores.setVisible(true);
        this.showProducts.setText(MessageManager.getString("label.get_cross_refs"));
        this.runGroovy.setText(MessageManager.getString("label.run_groovy"));
        this.runGroovy.setToolTipText(MessageManager.getString("label.run_groovy_tip"));
        this.runGroovy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.runGroovy_actionPerformed();
            }
        });
        this.openFeatureSettings = new JMenuItem(MessageManager.getString("action.feature_settings"));
        this.openFeatureSettings.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.featureSettings_actionPerformed(e);
            }
        });
        JMenuItem fetchSequence = new JMenuItem(MessageManager.getString("label.fetch_sequences"));
        fetchSequence.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.fetchSequence_actionPerformed();
            }
        });
        JMenuItem associatedData = new JMenuItem(MessageManager.getString("label.load_features_annotations"));
        associatedData.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    GAlignFrame.this.associatedData_actionPerformed(e);
                }
                catch (IOException | InterruptedException e1) {
                    e1.printStackTrace();
                }
            }
        });
        this.loadVcf = new JMenuItem(MessageManager.getString("label.load_vcf_file"));
        this.loadVcf.setToolTipText(MessageManager.getString("label.load_vcf"));
        this.loadVcf.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.loadVcf_actionPerformed();
            }
        });
        this.autoCalculate.setText(MessageManager.getString("label.autocalculate_consensus"));
        this.autoCalculate.setState(Cache.getDefault("AUTO_CALC_CONSENSUS", true));
        this.autoCalculate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.autoCalculate_actionPerformed(e);
            }
        });
        this.sortByTree.setText(MessageManager.getString("label.sort_alignment_new_tree"));
        this.sortByTree.setToolTipText("<html>" + MessageManager.getString("label.enable_automatically_sort_alignment_when_open_new_tree"));
        this.sortByTree.setState(Cache.getDefault("SORT_BY_TREE", false));
        this.sortByTree.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.sortByTreeOption_actionPerformed(e);
            }
        });
        this.listenToViewSelections.setText(MessageManager.getString("label.listen_for_selections"));
        this.listenToViewSelections.setToolTipText("<html>" + MessageManager.getString("label.selections_mirror_selections_made_same_sequences_other_views"));
        this.listenToViewSelections.setState(false);
        this.listenToViewSelections.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.listenToViewSelections_actionPerformed(e);
            }
        });
        JMenu addSequenceMenu = new JMenu(MessageManager.getString("label.add_sequences"));
        JMenuItem addFromFile = new JMenuItem(MessageManager.getString("label.from_file"));
        addFromFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.addFromFile_actionPerformed(e);
            }
        });
        JMenuItem addFromText = new JMenuItem(MessageManager.getString("label.from_textbox"));
        addFromText.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.addFromText_actionPerformed(e);
            }
        });
        JMenuItem addFromURL = new JMenuItem(MessageManager.getString("label.from_url"));
        addFromURL.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.addFromURL_actionPerformed(e);
            }
        });
        JMenuItem exportFeatures = new JMenuItem(MessageManager.getString("label.export_features"));
        exportFeatures.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.exportFeatures_actionPerformed(e);
            }
        });
        JMenuItem exportAnnotations = new JMenuItem(MessageManager.getString("label.export_annotations"));
        exportAnnotations.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.exportAnnotations_actionPerformed(e);
            }
        });
        this.statusPanel.setLayout(new GridLayout());
        JMenuItem showAllSeqs = new JMenuItem(MessageManager.getString("label.all_sequences"));
        showAllSeqs.setToolTipText(MessageManager.getString("label.toggle_sequence_visibility"));
        showAllSeqs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.showAllSeqs_actionPerformed(e);
            }
        });
        JMenuItem showAllColumns = new JMenuItem(MessageManager.getString("label.all_columns"));
        showAllColumns.setToolTipText(MessageManager.getString("label.toggle_columns_visibility"));
        showAllColumns.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.showAllColumns_actionPerformed(e);
            }
        });
        JMenu hideMenu = new JMenu(MessageManager.getString("action.hide"));
        JMenuItem hideSelSequences = new JMenuItem(MessageManager.getString("label.selected_sequences"));
        hideSelSequences.setToolTipText(MessageManager.getString("label.toggle_sequence_visibility"));
        hideSelSequences.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.hideSelSequences_actionPerformed(e);
            }
        });
        JMenuItem hideSelColumns = new JMenuItem(MessageManager.getString("label.selected_columns"));
        hideSelColumns.setToolTipText(MessageManager.getString("label.toggle_columns_visibility"));
        hideSelColumns.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.hideSelColumns_actionPerformed(e);
            }
        });
        JMenuItem hideAllSelection = new JMenuItem(MessageManager.getString("label.selected_region"));
        hideAllSelection.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.hideAllSelection_actionPerformed(e);
            }
        });
        JMenuItem hideAllButSelection = new JMenuItem(MessageManager.getString("label.all_but_selected_region"));
        hideAllButSelection.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.hideAllButSelection_actionPerformed(e);
            }
        });
        JMenuItem showAllhidden = new JMenuItem(MessageManager.getString("label.all_sequences_columns"));
        showAllhidden.setToolTipText(MessageManager.getString("label.toggles_visibility_hidden_selected_regions"));
        showAllhidden.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.showAllhidden_actionPerformed(e);
            }
        });
        this.hiddenMarkers.setText(MessageManager.getString("action.show_hidden_markers"));
        this.hiddenMarkers.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.hiddenMarkers_actionPerformed(e);
            }
        });
        JMenuItem invertColSel = new JMenuItem(MessageManager.getString("action.invert_column_selection"));
        keyStroke = KeyStroke.getKeyStroke(73, Platform.SHORTCUT_KEY_MASK | 0x200, false);
        al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.invertColSel_actionPerformed(e);
            }
        };
        this.addMenuActionAndAccelerator(keyStroke, invertColSel, al);
        this.showComplementMenuItem.setVisible(false);
        this.showComplementMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.showComplement_actionPerformed(GAlignFrame.this.showComplementMenuItem.getState());
            }
        });
        this.tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                JTabbedPane pane = (JTabbedPane)evt.getSource();
                int sel = pane.getSelectedIndex();
                GAlignFrame.this.tabSelectionChanged(sel);
            }
        });
        this.tabbedPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    GAlignFrame.this.tabbedPane_mousePressed(e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    GAlignFrame.this.tabbedPane_mousePressed(e);
                }
            }
        });
        this.tabbedPane.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                GAlignFrame.this.tabbedPane_focusGained(e);
            }
        });
        JMenuItem save = new JMenuItem(MessageManager.getString("action.save"));
        keyStroke = KeyStroke.getKeyStroke(83, Platform.SHORTCUT_KEY_MASK, false);
        al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.save_actionPerformed(e);
            }
        };
        this.addMenuActionAndAccelerator(keyStroke, save, al);
        this.reload.setEnabled(false);
        this.reload.setText(MessageManager.getString("action.reload"));
        this.reload.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.reload_actionPerformed(e);
            }
        });
        JMenuItem newView = new JMenuItem(MessageManager.getString("action.new_view"));
        keyStroke = KeyStroke.getKeyStroke(84, Platform.SHORTCUT_KEY_MASK, false);
        al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.newView_actionPerformed(e);
            }
        };
        this.addMenuActionAndAccelerator(keyStroke, newView, al);
        this.tabbedPane.setToolTipText("<html><i>" + MessageManager.getString("label.rename_tab_eXpand_reGroup") + "</i></html>");
        this.formatMenu.setText(MessageManager.getString("action.format"));
        JMenu selectMenu = new JMenu(MessageManager.getString("action.select"));
        this.idRightAlign.setText(MessageManager.getString("label.right_align_sequence_id"));
        this.idRightAlign.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.idRightAlign_actionPerformed(e);
            }
        });
        this.gatherViews.setEnabled(false);
        this.gatherViews.setText(MessageManager.getString("action.gather_views"));
        keyStroke = KeyStroke.getKeyStroke(71, 0, false);
        al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.gatherViews_actionPerformed(e);
            }
        };
        this.addMenuActionAndAccelerator(keyStroke, this.gatherViews, al);
        this.expandViews.setEnabled(false);
        this.expandViews.setText(MessageManager.getString("action.expand_views"));
        keyStroke = KeyStroke.getKeyStroke(88, 0, false);
        al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.expandViews_actionPerformed(e);
            }
        };
        this.addMenuActionAndAccelerator(keyStroke, this.expandViews, al);
        JMenuItem pageSetup = new JMenuItem(MessageManager.getString("action.page_setup"));
        pageSetup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.pageSetup_actionPerformed(e);
            }
        });
        JMenuItem alignmentProperties = new JMenuItem(MessageManager.getString("label.alignment_props"));
        alignmentProperties.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GAlignFrame.this.alignmentProperties();
            }
        });
        JMenuItem selectHighlighted = new JMenuItem(MessageManager.getString("action.select_highlighted_columns"));
        selectHighlighted.setToolTipText(JvSwingUtils.wrapTooltip(true, MessageManager.getString("tooltip.select_highlighted_columns")));
        al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GAlignFrame.this.selectHighlightedColumns_actionPerformed(actionEvent);
            }
        };
        JMenuItem Filter2 = new JMenuItem(MessageManager.getString("action.select_highlighted_columns"));
        selectHighlighted.setToolTipText(MessageManager.getString("tooltip.select_highlighted_columns"));
        al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GAlignFrame.this.selectHighlightedColumns_actionPerformed(actionEvent);
            }
        };
        selectHighlighted.addActionListener(al);
        this.copyHighlighted = new JMenuItem(MessageManager.getString("action.copy_highlighted_regions"));
        keyStroke = KeyStroke.getKeyStroke(67, Platform.SHORTCUT_KEY_MASK + 64, false);
        this.copyHighlighted.setToolTipText(MessageManager.getString("tooltip.copy_highlighted_regions"));
        al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GAlignFrame.this.copyHighlightedColumns_actionPerformed(actionEvent);
            }
        };
        this.addMenuActionAndAccelerator(keyStroke, this.copyHighlighted, al);
        this.copyHighlighted.addActionListener(al);
        final ButtonGroup ssButtonGroup = new ButtonGroup();
        JMenu tooltipSettingsMenu = new JMenu(MessageManager.getString("label.sequence_id_tooltip"));
        JMenu autoAnnMenu = new JMenu(MessageManager.getString("label.autocalculated_annotation"));
        final JMenu showSS = new JMenu(MessageManager.getString("label.show_secondary_structure"));
        JRadioButtonMenuItem radioButtonAllSS = new JRadioButtonMenuItem(MessageManager.getString("option.ss_providers_all"));
        radioButtonAllSS.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Component[] components;
                GAlignFrame.this.showOrHideSecondaryStructureForSource(MessageManager.getString("option.ss_providers_all"), true);
                for (Component component : components = showSS.getMenuComponents()) {
                    if (!(component instanceof JCheckBoxMenuItem)) continue;
                    ((JCheckBoxMenuItem)component).setSelected(true);
                }
            }
        });
        ssButtonGroup.add(radioButtonAllSS);
        showSS.add(radioButtonAllSS);
        JRadioButtonMenuItem radioButtonNoneSS = new JRadioButtonMenuItem(MessageManager.getString("option.ss_providers_none"));
        radioButtonNoneSS.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Component[] components;
                GAlignFrame.this.showOrHideSecondaryStructureForSource(MessageManager.getString("option.ss_providers_none"), false);
                for (Component component : components = showSS.getMenuComponents()) {
                    if (!(component instanceof JCheckBoxMenuItem)) continue;
                    ((JCheckBoxMenuItem)component).setSelected(false);
                }
            }
        });
        ssButtonGroup.add(radioButtonNoneSS);
        showSS.add(radioButtonNoneSS);
        showSS.addSeparator();
        annotationsMenu.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent e) {
                GAlignFrame.this.updateShowSecondaryStructureMenu(showSS, ssButtonGroup);
                GAlignFrame.this.buildSortAnnotationByTreeMenu();
            }

            @Override
            public void menuDeselected(MenuEvent e) {
            }

            @Override
            public void menuCanceled(MenuEvent e) {
            }
        });
        JMenu exportImageMenu = new JMenu(MessageManager.getString("label.export_image"));
        JMenu fileMenu = new JMenu(MessageManager.getString("action.file"));
        this.alignFrameMenuBar.add(fileMenu);
        this.alignFrameMenuBar.add(editMenu);
        this.alignFrameMenuBar.add(selectMenu);
        this.alignFrameMenuBar.add(viewMenu);
        this.alignFrameMenuBar.add(annotationsMenu);
        this.alignFrameMenuBar.add(this.formatMenu);
        this.alignFrameMenuBar.add(this.colourMenu);
        this.alignFrameMenuBar.add(calculateMenu);
        this.alignFrameMenuBar.add(this.webService);
        if (!Platform.isJS()) {
            this.alignFrameMenuBar.add(this.hmmerMenu);
        }
        fileMenu.add(fetchSequence);
        fileMenu.add(addSequenceMenu);
        fileMenu.add(this.reload);
        fileMenu.addSeparator();
        fileMenu.add(vamsasStore);
        fileMenu.add(save);
        fileMenu.add(saveAs);
        fileMenu.add(this.outputTextboxMenu);
        fileMenu.add(pageSetup);
        fileMenu.add(printMenuItem);
        fileMenu.addSeparator();
        fileMenu.add(exportImageMenu);
        fileMenu.add(exportFeatures);
        fileMenu.add(exportAnnotations);
        fileMenu.add(loadTreeMenuItem);
        fileMenu.add(associatedData);
        if (!Platform.isJS()) {
            fileMenu.add(this.loadVcf);
        }
        fileMenu.addSeparator();
        fileMenu.add(this.closeMenuItem);
        this.pasteMenu.add(pasteNew);
        this.pasteMenu.add(pasteThis);
        editMenu.add(this.undoMenuItem);
        editMenu.add(this.redoMenuItem);
        editMenu.add(this.cut);
        editMenu.add(this.copy);
        editMenu.add(this.copyHighlighted);
        editMenu.add(this.pasteMenu);
        editMenu.add(delete);
        editMenu.addSeparator();
        editMenu.add(remove2LeftMenuItem);
        editMenu.add(remove2RightMenuItem);
        editMenu.add(removeGappedColumnMenuItem);
        editMenu.add(removeAllGapsMenuItem);
        editMenu.add(removeRedundancyMenuItem);
        editMenu.addSeparator();
        editMenu.add(justifyLeftMenuItem);
        editMenu.add(justifyRightMenuItem);
        editMenu.addSeparator();
        editMenu.add(this.padGapsMenuitem);
        editMenu.addSeparator();
        editMenu.add(filterByEValue);
        editMenu.add(filterByScore);
        showMenu.add(showAllColumns);
        showMenu.add(showAllSeqs);
        showMenu.add(showAllhidden);
        hideMenu.add(hideSelColumns);
        hideMenu.add(hideSelSequences);
        hideMenu.add(hideAllSelection);
        hideMenu.add(hideAllButSelection);
        viewMenu.add(newView);
        viewMenu.add(this.expandViews);
        viewMenu.add(this.gatherViews);
        viewMenu.addSeparator();
        viewMenu.add(showMenu);
        viewMenu.add(hideMenu);
        viewMenu.add(this.showComplementMenuItem);
        viewMenu.addSeparator();
        viewMenu.add(this.followHighlightMenuItem);
        viewMenu.addSeparator();
        viewMenu.add(this.showSeqFeatures);
        viewMenu.add(this.openFeatureSettings);
        tooltipSettingsMenu.add(this.showDbRefsMenuitem);
        tooltipSettingsMenu.add(this.showNpFeatsMenuitem);
        viewMenu.add(tooltipSettingsMenu);
        viewMenu.addSeparator();
        viewMenu.add(alignmentProperties);
        viewMenu.addSeparator();
        viewMenu.add(overviewMenuItem);
        annotationsMenu.add(this.annotationPanelMenuItem);
        annotationsMenu.addSeparator();
        annotationsMenu.add(this.showAllAlAnnotations);
        annotationsMenu.add(this.hideAllAlAnnotations);
        annotationsMenu.addSeparator();
        annotationsMenu.add(this.showAllSeqAnnotations);
        annotationsMenu.add(this.hideAllSeqAnnotations);
        annotationsMenu.add(this.sortAnnBySequence);
        annotationsMenu.add(this.sortAnnByLabel);
        annotationsMenu.add(this.sortAnnotationByTreeMenu);
        annotationsMenu.addSeparator();
        annotationsMenu.add(showSS);
        annotationsMenu.add(this.showStrucProvider);
        annotationsMenu.addSeparator();
        autoAnnMenu.add(showAutoFirst);
        autoAnnMenu.add(showAutoLast);
        autoAnnMenu.addSeparator();
        autoAnnMenu.add(this.applyAutoAnnotationSettings);
        autoAnnMenu.add(this.showConsensusHistogram);
        autoAnnMenu.add(this.showSequenceLogo);
        autoAnnMenu.add(this.normaliseSequenceLogo);
        autoAnnMenu.addSeparator();
        autoAnnMenu.add(this.showGroupConservation);
        autoAnnMenu.add(this.showGroupConsensus);
        autoAnnMenu.add(this.showGroupSSConsensus);
        annotationsMenu.add(autoAnnMenu);
        this.sort.add(sortIDMenuItem);
        this.sort.add(sortDescriptionMenuItem);
        this.sort.add(sortLengthMenuItem);
        this.sort.add(sortGroupMenuItem);
        this.sort.add(sortPairwiseMenuItem);
        this.sort.add(sortEValueMenuItem);
        this.sort.add(sortBitScoreMenuItem);
        this.sort.add(this.sortByTreeMenu);
        calculateMenu.add(this.sort);
        calculateMenu.add(this.calculateTree);
        calculateMenu.addSeparator();
        calculateMenu.add(pairwiseAlignmentMenuItem);
        calculateMenu.addSeparator();
        calculateMenu.add(this.showTranslation);
        calculateMenu.add(this.showReverse);
        calculateMenu.add(this.showReverseComplement);
        calculateMenu.add(this.showProducts);
        calculateMenu.add(this.autoCalculate);
        calculateMenu.add(this.sortByTree);
        calculateMenu.addSeparator();
        calculateMenu.add(expandAlignment);
        calculateMenu.add(extractScores);
        if (!Platform.isJS()) {
            calculateMenu.addSeparator();
            calculateMenu.add(this.runGroovy);
        }
        this.webServiceNoServices = new JMenuItem(MessageManager.getString("label.no_services"));
        this.webService.add(this.webServiceNoServices);
        if (!Platform.isJS()) {
            exportImageMenu.add(htmlMenuItem);
        }
        exportImageMenu.add(epsFile);
        exportImageMenu.add(createPNG);
        if (!Platform.isJS()) {
            exportImageMenu.add(createBioJS);
            exportImageMenu.add(createSVG);
        }
        addSequenceMenu.add(addFromFile);
        addSequenceMenu.add(addFromText);
        addSequenceMenu.add(addFromURL);
        this.getContentPane().add((Component)this.statusPanel, "South");
        this.statusPanel.add((Component)this.statusBar, null);
        this.getContentPane().add((Component)this.tabbedPane, "Center");
        this.formatMenu.add(font);
        this.formatMenu.addSeparator();
        this.formatMenu.add(this.wrapMenuItem);
        this.formatMenu.add(this.scaleAbove);
        this.formatMenu.add(this.scaleLeft);
        this.formatMenu.add(this.scaleRight);
        this.formatMenu.add(this.seqLimits);
        this.formatMenu.add(this.idRightAlign);
        this.formatMenu.add(this.hiddenMarkers);
        this.formatMenu.add(this.viewBoxesMenuItem);
        this.formatMenu.add(this.viewTextMenuItem);
        this.formatMenu.add(this.colourTextMenuItem);
        this.formatMenu.add(this.renderGapsMenuItem);
        this.formatMenu.add(this.centreColumnLabelsMenuItem);
        this.formatMenu.add(this.showNonconservedMenuItem);
        selectMenu.add(findMenuItem);
        selectMenu.addSeparator();
        selectMenu.add(selectAllSequenceMenuItem);
        selectMenu.add(deselectAllSequenceMenuItem);
        selectMenu.add(invertSequenceMenuItem);
        selectMenu.add(invertColSel);
        selectMenu.add(createGroup);
        selectMenu.add(unGroup);
        selectMenu.add(grpsFromSelection);
        selectMenu.add(deleteGroups);
        selectMenu.add(annotationColumn);
        selectMenu.add(selectHighlighted);
    }

    protected void showStructureProvider_actionPerformed(ActionEvent e) {
    }

    protected void showSSConsensus_actionPerformed(ActionEvent e) {
    }

    protected void createPNG_actionPerformed(ActionEvent object) {
    }

    protected void createEPS_actionPerformed(ActionEvent object) {
    }

    protected void createSVG_actionPerformed(ActionEvent object) {
    }

    protected void copyHighlightedColumns_actionPerformed(ActionEvent actionEvent) {
    }

    protected void initHMMERMenu() {
        JMenu hmmBuild = new JMenu(MessageManager.getString("label.hmmbuild"));
        JMenuItem hmmBuildSettings = new JMenuItem(MessageManager.getString("label.edit_settings_and_run"));
        hmmBuildSettings.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.hmmBuild_actionPerformed(false);
            }
        });
        JMenuItem hmmBuildRun = new JMenuItem(MessageManager.formatMessage("label.action_with_default_settings", "hmmbuild"));
        hmmBuildRun.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.hmmBuild_actionPerformed(true);
            }
        });
        hmmBuild.add(hmmBuildRun);
        hmmBuild.add(hmmBuildSettings);
        JMenu hmmAlign = new JMenu(MessageManager.getString("label.hmmalign"));
        JMenuItem hmmAlignRun = new JMenuItem(MessageManager.formatMessage("label.action_with_default_settings", "hmmalign"));
        hmmAlignRun.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.hmmAlign_actionPerformed(true);
            }
        });
        JMenuItem hmmAlignSettings = new JMenuItem(MessageManager.getString("label.edit_settings_and_run"));
        hmmAlignSettings.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.hmmAlign_actionPerformed(false);
            }
        });
        hmmAlign.add(hmmAlignRun);
        hmmAlign.add(hmmAlignSettings);
        JMenu hmmSearch = new JMenu(MessageManager.getString("label.hmmsearch"));
        JMenuItem hmmSearchSettings = new JMenuItem(MessageManager.getString("label.edit_settings_and_run"));
        hmmSearchSettings.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.hmmSearch_actionPerformed(false);
            }
        });
        JMenuItem hmmSearchRun = new JMenuItem(MessageManager.formatMessage("label.action_with_default_settings", "hmmsearch"));
        hmmSearchRun.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.hmmSearch_actionPerformed(true);
            }
        });
        JMenuItem addDatabase = new JMenuItem(MessageManager.getString("label.add_database"));
        addDatabase.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    GAlignFrame.this.addDatabase_actionPerformed();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        });
        hmmSearch.add(hmmSearchRun);
        hmmSearch.add(hmmSearchSettings);
        JMenu jackhmmer = new JMenu(MessageManager.getString("label.jackhmmer"));
        JMenuItem jackhmmerSettings = new JMenuItem(MessageManager.getString("label.edit_settings_and_run"));
        jackhmmerSettings.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.jackhmmer_actionPerformed(false);
            }
        });
        JMenuItem jackhmmerRun = new JMenuItem(MessageManager.formatMessage("label.action_with_default_settings", "jackhmmer"));
        jackhmmerRun.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.jackhmmer_actionPerformed(true);
            }
        });
        jackhmmer.add(jackhmmerRun);
        jackhmmer.add(jackhmmerSettings);
        this.hmmerMenu.setText(MessageManager.getString("action.hmmer"));
        this.hmmerMenu.setEnabled(HmmerCommand.isHmmerAvailable());
        this.hmmerMenu.add(hmmBuild);
        this.hmmerMenu.add(hmmAlign);
        this.hmmerMenu.add(hmmSearch);
        this.hmmerMenu.add(jackhmmer);
    }

    protected void enableSortMenuOptions() {
    }

    protected void loadVcf_actionPerformed() {
    }

    protected void initColourMenu() {
        this.applyToAllGroups = new JCheckBoxMenuItem(MessageManager.getString("label.apply_colour_to_all_groups"));
        this.applyToAllGroups.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.applyToAllGroups_actionPerformed(GAlignFrame.this.applyToAllGroups.isSelected());
            }
        });
        this.textColour = new JMenuItem(MessageManager.getString("label.text_colour"));
        this.textColour.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.textColour_actionPerformed();
            }
        });
        this.conservationMenuItem = new JCheckBoxMenuItem(MessageManager.getString("action.by_conservation"));
        this.conservationMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.conservationMenuItem_actionPerformed(GAlignFrame.this.conservationMenuItem.isSelected());
            }
        });
        this.byConsensusSecondaryStructureMenuItem = new JCheckBoxMenuItem(MessageManager.getString("action.by_secondary_structure_conservation"));
        this.byConsensusSecondaryStructureMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.colourByConsensusSecondaryStructureMenuItem_actionPerformed(GAlignFrame.this.byConsensusSecondaryStructureMenuItem.isSelected());
            }
        });
        this.abovePIDThreshold = new JCheckBoxMenuItem(MessageManager.getString("label.above_identity_threshold"));
        this.abovePIDThreshold.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.abovePIDThreshold_actionPerformed(GAlignFrame.this.abovePIDThreshold.isSelected());
            }
        });
        this.modifyPID = new JMenuItem(MessageManager.getString("label.modify_identity_threshold"));
        this.modifyPID.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.modifyPID_actionPerformed();
            }
        });
        this.modifyConservation = new JMenuItem(MessageManager.getString("label.modify_conservation_threshold"));
        this.modifyConservation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.modifyConservation_actionPerformed();
            }
        });
        this.modifyConsensusSecondaryStructureThreshold = new JMenuItem(MessageManager.getString("label.modify_secondary_structure_conservation_threshold"));
        this.modifyConsensusSecondaryStructureThreshold.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.modifyConsensusSecondaryStructureThreshold_actionPerformed();
            }
        });
        this.annotationColour = new JRadioButtonMenuItem(MessageManager.getString("action.by_annotation"));
        this.annotationColour.setName("Annotation");
        this.annotationColour.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GAlignFrame.this.annotationColour_actionPerformed();
            }
        });
    }

    protected void selectHighlightedColumns_actionPerformed(ActionEvent actionEvent) {
    }

    protected void showReverse_actionPerformed(boolean complement) {
    }

    protected void runGroovy_actionPerformed() {
    }

    protected void addMenuActionAndAccelerator(KeyStroke keyStroke, JMenuItem menuItem, ActionListener actionListener) {
        menuItem.setAccelerator(keyStroke);
        this.accelerators.put(keyStroke, menuItem);
        menuItem.addActionListener(actionListener);
    }

    protected void sortAnnotations_actionPerformed() {
    }

    protected void showAllAnnotations_actionPerformed(boolean forSequences, boolean forAlignment) {
        this.setAnnotationsVisibility(true, forSequences, forAlignment);
    }

    protected void hideAllAnnotations_actionPerformed(boolean forSequences, boolean forAlignment) {
        this.setAnnotationsVisibility(false, forSequences, forAlignment);
    }

    public void setAnnotationsVisibility(boolean visible, boolean forSequences, boolean forAlignment) {
    }

    protected void normaliseSequenceLogo_actionPerformed(ActionEvent e) {
    }

    protected void listenToViewSelections_actionPerformed(ActionEvent e) {
    }

    protected void showAllhidden_actionPerformed(ActionEvent e) {
    }

    protected void hideAllButSelection_actionPerformed(ActionEvent e) {
    }

    protected void hideAllSelection_actionPerformed(ActionEvent e) {
    }

    protected void applyAutoAnnotationSettings_actionPerformed(ActionEvent e) {
    }

    protected void showConsensusHistogram_actionPerformed(ActionEvent e) {
    }

    protected void showSequenceLogo_actionPerformed(ActionEvent e) {
    }

    protected void makeGrpsFromSelection_actionPerformed(ActionEvent e) {
    }

    protected void showGroupConsensus_actionPerformed(ActionEvent e) {
    }

    protected void showGroupSSConsensus_actionPerformed(ActionEvent e) {
    }

    protected void showGroupConservation_actionPerformed(ActionEvent e) {
    }

    protected void showUnconservedMenuItem_actionPerformed(ActionEvent e) {
    }

    protected void justifyRightMenuItem_actionPerformed(ActionEvent e) {
    }

    protected void justifyLeftMenuItem_actionPerformed(ActionEvent e) {
    }

    protected void followHighlight_actionPerformed() {
    }

    protected void showNpFeats_actionPerformed(ActionEvent e) {
    }

    protected void showDbRefs_actionPerformed(ActionEvent e) {
    }

    protected void centreColumnLabels_actionPerformed(ActionEvent e) {
    }

    protected void buildSortByAnnotationScoresMenu() {
    }

    protected void extractScores_actionPerformed(ActionEvent e) {
    }

    protected void outputText_actionPerformed(String formatName) {
    }

    public void addFromFile_actionPerformed(ActionEvent e) {
    }

    public void addFromText_actionPerformed(ActionEvent e) {
    }

    public void addFromURL_actionPerformed(ActionEvent e) {
    }

    public void exportFeatures_actionPerformed(ActionEvent e) {
    }

    public void exportAnnotations_actionPerformed(ActionEvent e) {
    }

    protected void htmlMenuItem_actionPerformed(ActionEvent e) {
    }

    protected void bioJSMenuItem_actionPerformed(ActionEvent e) {
    }

    protected void closeMenuItem_actionPerformed(boolean b) {
    }

    protected void redoMenuItem_actionPerformed(ActionEvent e) {
    }

    protected void undoMenuItem_actionPerformed(ActionEvent e) {
    }

    protected void selectAllSequenceMenuItem_actionPerformed(ActionEvent e) {
    }

    protected void deselectAllSequenceMenuItem_actionPerformed(ActionEvent e) {
    }

    protected void invertSequenceMenuItem_actionPerformed(ActionEvent e) {
    }

    protected void remove2LeftMenuItem_actionPerformed(ActionEvent e) {
    }

    protected void remove2RightMenuItem_actionPerformed(ActionEvent e) {
    }

    protected void removeGappedColumnMenuItem_actionPerformed(ActionEvent e) {
    }

    protected void removeAllGapsMenuItem_actionPerformed(ActionEvent e) {
    }

    protected void wrapMenuItem_actionPerformed(ActionEvent e) {
    }

    protected void viewBoxesMenuItem_actionPerformed(ActionEvent e) {
    }

    protected void viewTextMenuItem_actionPerformed(ActionEvent e) {
    }

    protected void colourTextMenuItem_actionPerformed(ActionEvent e) {
    }

    protected void annotationPanelMenuItem_actionPerformed(ActionEvent e) {
    }

    protected void overviewMenuItem_actionPerformed(ActionEvent e) {
    }

    protected void sortPairwiseMenuItem_actionPerformed(ActionEvent e) {
    }

    protected void sortIDMenuItem_actionPerformed(ActionEvent e) {
    }

    protected void sortDescriptionMenuItem_actionPerformed(ActionEvent e) {
    }

    protected void sortLengthMenuItem_actionPerformed(ActionEvent e) {
    }

    protected void sortGroupMenuItem_actionPerformed(ActionEvent e) {
    }

    protected void sortEValueMenuItem_actionPerformed(ActionEvent e) {
    }

    protected void sortBitScoreMenuItem_actionPerformed(ActionEvent e) {
    }

    protected void removeRedundancyMenuItem_actionPerformed(ActionEvent e) {
    }

    protected void pairwiseAlignmentMenuItem_actionPerformed(ActionEvent e) {
    }

    protected void neighbourTreeMenuItem_actionPerformed(ActionEvent e) {
    }

    protected void conservationMenuItem_actionPerformed(boolean selected) {
    }

    public void colourByConsensusSecondaryStructureMenuItem_actionPerformed(boolean selected) {
    }

    protected void printMenuItem_actionPerformed(ActionEvent e) {
    }

    protected void renderGapsMenuItem_actionPerformed(ActionEvent e) {
    }

    protected void findMenuItem_actionPerformed(ActionEvent e) {
    }

    protected void abovePIDThreshold_actionPerformed(boolean selected) {
    }

    public void showSeqFeatures_actionPerformed(ActionEvent actionEvent) {
    }

    protected void deleteGroups_actionPerformed(ActionEvent e) {
    }

    protected void createGroup_actionPerformed(ActionEvent e) {
    }

    protected void unGroup_actionPerformed(ActionEvent e) {
    }

    protected void copy_actionPerformed() {
    }

    protected void cut_actionPerformed() {
    }

    protected void delete_actionPerformed() {
    }

    protected void pasteNew_actionPerformed(ActionEvent e) throws IOException, InterruptedException {
    }

    protected void pasteThis_actionPerformed(ActionEvent e) throws IOException, InterruptedException {
    }

    protected void applyToAllGroups_actionPerformed(boolean selected) {
    }

    protected void hmmBuild_actionPerformed(boolean withDefaults) {
    }

    protected void hmmSearch_actionPerformed(boolean withDefaults) {
    }

    protected void jackhmmer_actionPerformed(boolean b) {
    }

    protected void addDatabase_actionPerformed() throws FileFormatException, IOException {
    }

    protected void hmmAlign_actionPerformed(boolean withDefaults) {
    }

    protected void font_actionPerformed(ActionEvent e) {
    }

    protected void seqLimit_actionPerformed(ActionEvent e) {
    }

    public void seqDBRef_actionPerformed(ActionEvent e) {
    }

    protected void loadTreeMenuItem_actionPerformed(ActionEvent e) {
    }

    protected void loadScores_actionPerformed(ActionEvent event) {
    }

    protected void jpred_actionPerformed(ActionEvent e) {
    }

    protected void scaleAbove_actionPerformed(ActionEvent e) {
    }

    protected void scaleLeft_actionPerformed(ActionEvent e) {
    }

    protected void filterByEValue_actionPerformed() {
    }

    protected void filterByScore_actionPerformed() {
    }

    protected void scaleRight_actionPerformed(ActionEvent e) {
    }

    protected void modifyPID_actionPerformed() {
    }

    protected void modifyConservation_actionPerformed() {
    }

    protected void modifyConsensusSecondaryStructureThreshold_actionPerformed() {
    }

    protected void saveAs_actionPerformed() {
    }

    protected void padGapsMenuitem_actionPerformed(ActionEvent e) {
    }

    public void vamsasStore_actionPerformed(ActionEvent e) {
    }

    public void vamsasLoad_actionPerformed(ActionEvent e) {
    }

    public void showTranslation_actionPerformed(GeneticCodeI codeTable) {
    }

    public void featureSettings_actionPerformed(ActionEvent e) {
    }

    public void fetchSequence_actionPerformed() {
    }

    public void smoothFont_actionPerformed(ActionEvent e) {
    }

    public void annotationColour_actionPerformed() {
    }

    public void annotationColumn_actionPerformed(ActionEvent e) {
    }

    public void associatedData_actionPerformed(ActionEvent e) throws IOException, InterruptedException {
    }

    public void autoCalculate_actionPerformed(ActionEvent e) {
    }

    public void sortByTreeOption_actionPerformed(ActionEvent e) {
    }

    public void showAllSeqs_actionPerformed(ActionEvent e) {
    }

    public void showAllColumns_actionPerformed(ActionEvent e) {
    }

    public void hideSelSequences_actionPerformed(ActionEvent e) {
    }

    public void hideSelColumns_actionPerformed(ActionEvent e) {
    }

    public void hiddenMarkers_actionPerformed(ActionEvent e) {
    }

    public void findPdbId_actionPerformed(ActionEvent e) {
    }

    public void enterPdbId_actionPerformed(ActionEvent e) {
    }

    public void pdbFile_actionPerformed(ActionEvent e) {
    }

    public void invertColSel_actionPerformed(ActionEvent e) {
    }

    public void tabSelectionChanged(int sel) {
    }

    public void tabbedPane_mousePressed(MouseEvent e) {
    }

    public void tabbedPane_focusGained(FocusEvent e) {
        this.requestFocus();
    }

    public void save_actionPerformed(ActionEvent e) {
    }

    public void reload_actionPerformed(ActionEvent e) {
    }

    public void newView_actionPerformed(ActionEvent e) {
    }

    public void textColour_actionPerformed() {
    }

    public void idRightAlign_actionPerformed(ActionEvent e) {
    }

    public void expandViews_actionPerformed(ActionEvent e) {
    }

    public void gatherViews_actionPerformed(ActionEvent e) {
    }

    public void buildTreeSortMenu() {
    }

    public void pageSetup_actionPerformed(ActionEvent e) {
    }

    public void alignmentProperties() {
    }

    protected void expand_newalign(ActionEvent e) {
    }

    protected boolean isShowAutoCalculatedAbove() {
        return this.showAutoCalculatedAbove;
    }

    protected void setShowAutoCalculatedAbove(boolean showAutoCalculatedAbove) {
        this.showAutoCalculatedAbove = showAutoCalculatedAbove;
    }

    protected AnnotationSorter.SequenceAnnotationOrder getAnnotationSortOrder() {
        return this.annotationSortOrder;
    }

    protected void setAnnotationSortOrder(AnnotationSorter.SequenceAnnotationOrder annotationSortOrder) {
        this.annotationSortOrder = annotationSortOrder;
    }

    public Map<KeyStroke, JMenuItem> getAccelerators() {
        return this.accelerators;
    }

    public int getTabIndex() {
        return this.tabbedPane.getSelectedIndex();
    }

    public JPanel getStatusPanel() {
        return this.statusPanel;
    }

    public void setSplitFrame(SplitContainerI sf) {
        this.splitFrame = sf;
        if (sf != null) {
            this.showComplementMenuItem.setVisible(true);
            this.showComplementMenuItem.setState(true);
        }
    }

    public SplitContainerI getSplitViewContainer() {
        return this.splitFrame;
    }

    protected void showComplement_actionPerformed(boolean complement) {
    }

    protected List<String> updateShowSSRadioButtons() {
        return null;
    }

    protected void showOrHideSecondaryStructureForSource(String ssSourceSelection, boolean visible) {
    }

    protected void updateShowSecondaryStructureMenu(JMenu showSS, ButtonGroup ssButtonGroup) {
    }

    public void buildSortAnnotationByTreeMenu() {
    }
}

