/*
 * Decompiled with CFR 0.152.
 */
package jalview.io.gff;

import jalview.datamodel.AlignmentI;
import jalview.datamodel.SequenceFeature;
import jalview.datamodel.SequenceI;
import jalview.io.gff.Gff3Helper;
import jalview.io.gff.SequenceOntologyFactory;
import jalview.io.gff.SequenceOntologyI;
import jalview.util.StringUtils;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class InterProScanHelper
extends Gff3Helper {
    private static final String INTER_PRO_SCAN = "InterProScan";
    private static final String SIGNATURE_DESC = "signature_desc";

    @Override
    public SequenceFeature processGff(SequenceI seq, String[] gff, AlignmentI align, List<SequenceI> newseqs, boolean relaxedIdMatching) throws IOException {
        if (".".equals(gff[1])) {
            return null;
        }
        return super.processGff(seq, gff, align, newseqs, relaxedIdMatching);
    }

    @Override
    protected SequenceFeature buildSequenceFeature(String[] gff, Map<String, List<String>> attributes) {
        SequenceFeature sf = super.buildSequenceFeature(gff, 1, INTER_PRO_SCAN, attributes);
        List<String> desc = attributes.get(SIGNATURE_DESC);
        String description = StringUtils.listToDelimitedString(desc, ", ");
        if (description.length() > 0) {
            sf.setDescription(description);
        }
        return sf;
    }

    public static boolean recognises(String[] columns) {
        String type;
        SequenceOntologyI so = SequenceOntologyFactory.getSequenceOntology();
        return so.isA(type = columns[2], "protein_match") || ".".equals(columns[1]) && so.isA(type, "polypeptide");
    }

    @Override
    protected String findTargetId(String target, Map<String, List<String>> set) {
        List<String> ids = set.get("ID");
        if (ids == null || ids.size() != 1) {
            return null;
        }
        return ids.get(0);
    }
}

