/*
 * Decompiled with CFR 0.152.
 */
package jalview.io;

import jalview.api.ComplexAlignFile;
import jalview.api.FeaturesSourceI;
import jalview.bin.Cache;
import jalview.bin.Console;
import jalview.bin.Jalview;
import jalview.datamodel.PDBEntry;
import jalview.datamodel.SequenceI;
import jalview.gui.AlignFrame;
import jalview.gui.AlignViewport;
import jalview.gui.AlignmentPanel;
import jalview.gui.Desktop;
import jalview.gui.JvOptionPane;
import jalview.gui.QuitHandler;
import jalview.io.AlignmentFileReaderI;
import jalview.io.AppletFormatAdapter;
import jalview.io.DataSourceType;
import jalview.io.FileFormat;
import jalview.io.FileFormatI;
import jalview.io.FormatAdapter;
import jalview.io.HMMFile;
import jalview.io.IdentifyFile;
import jalview.json.binding.biojson.v1.ColourSchemeMapper;
import jalview.project.Jalview2XML;
import jalview.structure.StructureSelectionManager;
import jalview.util.MessageManager;
import jalview.util.Platform;
import jalview.ws.utils.UrlDownloadClient;
import java.awt.Component;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.SwingUtilities;

public class FileLoader
implements Runnable {
    private static final String TAB = "\t";
    String file;
    DataSourceType protocol;
    FileFormatI format;
    AlignmentFileReaderI source = null;
    AlignViewport viewport;
    AlignFrame alignFrame;
    long loadtime;
    long memused;
    boolean raiseGUI = true;
    private File selectedFile;
    private static boolean useDefaultFileFormat = false;
    public static final String PROMPT_SAVE_UNCHANGED_URL_ALIGNMENTS = "PROMPT_SAVE_UNCHANGED_URL_ALIGNMENTS";

    public FileLoader() {
        this(true);
    }

    public FileLoader(boolean raiseGUI) {
        this.raiseGUI = raiseGUI;
    }

    public void LoadFile(AlignViewport viewport, Object file, DataSourceType protocol, FileFormatI format) {
        this.LoadFile(viewport, file, protocol, format, true);
    }

    public void LoadFile(AlignViewport viewport, Object file, DataSourceType protocol, FileFormatI format, boolean async) {
        this.viewport = viewport;
        if (file instanceof File) {
            this.selectedFile = (File)file;
            file = this.selectedFile.getPath();
        }
        this.LoadFile(file.toString(), protocol, format, async);
    }

    public void LoadFile(String file, DataSourceType protocol, FileFormatI format) {
        this.LoadFile(file, protocol, format, true);
    }

    public void LoadFile(String file, DataSourceType protocol, FileFormatI format, boolean async) {
        this.file = file;
        this.protocol = protocol;
        this.format = format;
        if (async) {
            final Thread loader = new Thread(this);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    loader.start();
                }
            });
        } else {
            this.run();
        }
    }

    public void LoadFile(String file, DataSourceType protocol) {
        this.LoadFile(file, protocol, null);
    }

    public AlignFrame LoadFileWaitTillLoaded(String file, DataSourceType sourceType) {
        return this.LoadFileWaitTillLoaded(file, sourceType, null);
    }

    public AlignFrame LoadFileWaitTillLoaded(String file, DataSourceType sourceType, FileFormatI format) {
        this.file = file;
        this.protocol = sourceType;
        this.format = format;
        return this._LoadFileWaitTillLoaded();
    }

    public AlignFrame LoadFileWaitTillLoaded(File file, DataSourceType sourceType, FileFormatI format) {
        this.selectedFile = file;
        this.file = file.getPath();
        this.protocol = sourceType;
        this.format = format;
        return this._LoadFileWaitTillLoaded();
    }

    public AlignFrame LoadFileWaitTillLoaded(AlignmentFileReaderI source, FileFormatI format) {
        this.source = source;
        this.file = source.getInFile();
        this.protocol = source.getDataSourceType();
        this.format = format;
        return this._LoadFileWaitTillLoaded();
    }

    protected AlignFrame _LoadFileWaitTillLoaded() {
        this.run();
        return this.alignFrame;
    }

    public void LoadFileOntoAlignmentWaitTillLoaded(AlignViewport viewport, String file, DataSourceType sourceType, FileFormatI format) {
        Vector recent = new Vector();
        if (this.protocol == DataSourceType.PASTE) {
            this.viewport = viewport;
        }
        this.file = file;
        this.protocol = sourceType;
        this.format = format;
        this._LoadFileWaitTillLoaded();
    }

    public static String updateRecentlyOpened(String filePath, DataSourceType sourceType) {
        if (sourceType != DataSourceType.FILE && sourceType != DataSourceType.URL) {
            return null;
        }
        String propertyName = sourceType == DataSourceType.FILE ? "RECENT_FILE" : "RECENT_URL";
        String historyItems = Cache.getProperty(propertyName);
        if (filePath != null && filePath.indexOf(System.getProperty("java.io.tmpdir")) > -1) {
            return null;
        }
        ArrayList<String> recent = new ArrayList<String>();
        if (historyItems != null) {
            StringTokenizer st = new StringTokenizer(historyItems, TAB);
            while (st.hasMoreTokens()) {
                String trimmed = st.nextToken().trim();
                recent.add(trimmed);
            }
        }
        if (recent.contains(filePath)) {
            recent.remove(filePath);
        }
        StringBuilder newHistory = new StringBuilder(filePath);
        for (int i = 0; i < recent.size() && i < 10; ++i) {
            newHistory.append(TAB);
            newHistory.append((String)recent.get(i));
        }
        String newProperty = newHistory.toString();
        Cache.setProperty(propertyName, newProperty);
        return newProperty;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void run() {
        title = this.protocol == DataSourceType.PASTE ? "Copied From Clipboard" : this.file;
        rt = Runtime.getRuntime();
        try {
            block43: {
                block44: {
                    block42: {
                        if (Desktop.getInstance() != null) {
                            Desktop.getInstance().startLoading(this.file);
                        }
                        if (this.format == null) {
                            this.format = this.source != null ? new IdentifyFile().identify(this.source, false) : (this.selectedFile != null ? new IdentifyFile().identify(this.selectedFile, this.protocol) : new IdentifyFile().identify(this.file, this.protocol));
                        }
                        if (this.format == null) {
                            Desktop.getInstance().stopLoading();
                            Console.errPrintln("The input file \"" + this.file + "\" has null or unidentifiable data content!");
                            if (!Jalview.isHeadlessMode() && !Jalview.isBatchMode()) {
                                JvOptionPane.showInternalMessageDialog((Component)Desktop.getDesktopPane(), MessageManager.getString("label.couldnt_read_data") + " in " + this.file + "\n" + AppletFormatAdapter.getSupportedFormats(), MessageManager.getString("label.couldnt_read_data"), 2);
                            }
                            return;
                        }
                        if (Desktop.getDesktopPane() != null && Desktop.getDesktopPane().isShowMemoryUsage()) {
                            System.gc();
                            this.memused = rt.maxMemory() - rt.totalMemory() + rt.freeMemory();
                        }
                        this.loadtime = -System.currentTimeMillis();
                        al = null;
                        if (!FileFormat.Jalview.equals(this.format)) break block42;
                        if (this.source != null) {
                            Console.errPrintln("IMPLEMENTATION ERROR: Cannot read consecutive Jalview XML projects from a stream.");
                        }
                        this.alignFrame = new Jalview2XML(this.raiseGUI != false && Jalview.isBatchMode() == false).loadJalviewAlign(this.selectedFile == null ? this.file : this.selectedFile);
                        break block43;
                    }
                    error = AppletFormatAdapter.getSupportedFormats();
                    try {
                        if (this.source != null) {
                            al = new FormatAdapter().readFromFile(this.source, this.format);
                        } else {
                            fa = new FormatAdapter();
                            v0 = downloadStructureFile = this.format.isStructureFile() != false && this.protocol.equals((Object)DataSourceType.URL) != false;
                            if (downloadStructureFile) {
                                structExt = this.format.getExtensions().split(",")[0];
                                urlLeafName = this.file.substring(this.file.lastIndexOf(System.getProperty("file.separator")), this.file.lastIndexOf("."));
                                tempStructureFileStr = FileLoader.createNamedJvTempFile(urlLeafName, structExt);
                                tempFile = new File(tempStructureFileStr);
                                UrlDownloadClient.download(this.file, tempFile);
                                al = fa.readFile(tempFile, DataSourceType.FILE, this.format);
                                this.source = fa.getAlignFile();
                            } else {
                                al = this.selectedFile == null ? fa.readFile(null, this.file, this.protocol, this.format) : fa.readFile(this.selectedFile, null, this.protocol, this.format);
                                this.source = fa.getAlignFile();
                            }
                        }
                    }
                    catch (IOException ex) {
                        error = ex.getMessage();
                    }
                    if (al == null || al.getHeight() <= 0 || !al.hasValidSequence()) break block44;
                    for (SequenceI sq : al.getSequences()) {
                        while (sq.getDatasetSequence() != null) {
                            sq = sq.getDatasetSequence();
                        }
                        if (sq.getAllPDBEntries() == null) continue;
                        for (PDBEntry pdbe : sq.getAllPDBEntries()) {
                            StructureSelectionManager.getStructureSelectionManager(Desktop.getInstance()).registerPDBEntry(pdbe);
                        }
                    }
                    proxyColourScheme = this.source.getFeatureColourScheme();
                    if (this.viewport != null) {
                        this.viewport.addAlignment(al, title);
                        if (proxyColourScheme != null) {
                            this.viewport.applyFeaturesStyle(proxyColourScheme);
                        }
                        if (this.source instanceof HMMFile) {
                            alignment = this.viewport.getAlignment();
                            seq = alignment.getSequenceAt(alignment.getHeight() - 1);
                            if (seq.hasHMMProfile()) {
                                alignment.deleteSequence(alignment.getAbsoluteHeight() - 1);
                                alignment.insertSequenceAt(0, seq);
                            }
                            ((AlignmentPanel)this.viewport.getAlignPanel()).adjustAnnotationHeight();
                            this.viewport.updateSequenceIdColours();
                        }
                    } else {
                        if (this.source instanceof ComplexAlignFile) {
                            colSel = ((ComplexAlignFile)this.source).getHiddenColumns();
                            hiddenSeqs = ((ComplexAlignFile)this.source).getHiddenSequences();
                            colourSchemeName = ((ComplexAlignFile)this.source).getGlobalColourScheme();
                            fd = ((ComplexAlignFile)this.source).getDisplayedFeatures();
                            this.alignFrame = new AlignFrame(al, hiddenSeqs, colSel, 700, 500);
                            this.alignFrame.getViewport().setFeaturesDisplayed(fd);
                            this.alignFrame.getViewport().setShowSequenceFeatures(((ComplexAlignFile)this.source).isShowSeqFeatures());
                            cs = ColourSchemeMapper.getJalviewColourScheme(colourSchemeName, al);
                            if (cs != null) {
                                this.alignFrame.changeColour(cs);
                            }
                        } else {
                            this.alignFrame = new AlignFrame(al, 700, 500);
                            if (this.source instanceof FeaturesSourceI) {
                                this.alignFrame.getViewport().setShowSequenceFeatures(true);
                            }
                        }
                        if (this.protocol != DataSourceType.PASTE) {
                            this.alignFrame.setFile(this.file, this.selectedFile, this.protocol, this.format);
                        }
                        if (proxyColourScheme != null) {
                            this.alignFrame.getViewport().applyFeaturesStyle(proxyColourScheme);
                        }
                        this.alignFrame.setStatus(MessageManager.formatMessage("label.successfully_loaded_file", new String[]{title}));
                        if (this.raiseGUI) {
                            dim = Platform.getDimIfEmbedded(this.alignFrame, 700, 500);
                            this.alignFrame.setSize(dim);
                            Desktop.addInternalFrame(this.alignFrame, title, dim.width, dim.height);
                            this.alignFrame.alignPanel.setOverviewTitle(this.alignFrame);
                        }
                        try {
                            this.alignFrame.setMaximum(Cache.getDefault("SHOW_FULLSCREEN", false));
                        }
                        catch (PropertyVetoException var6_14) {
                            // empty catch block
                        }
                    }
                    this.alignFrame.alignPanel.alignmentChanged();
                    break block43;
                }
                if (Desktop.getInstance() != null) {
                    Desktop.getInstance().stopLoading();
                }
                errorMessage = MessageManager.getString("label.couldnt_load_file") + " " + title + "\n" + error;
                if (!this.raiseGUI) ** GOTO lbl-1000
                Jalview.getInstance();
                if (Jalview.isBatchMode()) ** GOTO lbl-1000
                Desktop.getInstance();
                if (Desktop.getDesktopPane() != null) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            JvOptionPane.showInternalMessageDialog((Component)Desktop.getDesktopPane(), errorMessage, MessageManager.getString("label.error_loading_file"), 2);
                        }
                    });
                } else lbl-1000:
                // 3 sources

                {
                    Console.errPrintln(errorMessage);
                }
            }
            FileLoader.updateRecentlyOpened(this.file, this.protocol);
            if (this.protocol == DataSourceType.FILE && this.format != null) {
                Cache.setProperty("DEFAULT_FILE_FORMAT", this.format.getName());
            }
        }
        catch (Exception er) {
            Console.errPrintln("Exception whilst opening file '" + this.file);
            er.printStackTrace();
            if (this.raiseGUI && !Jalview.isBatchMode()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JvOptionPane.showInternalMessageDialog((Component)Desktop.getDesktopPane(), MessageManager.formatMessage("label.problems_opening_file", new String[]{FileLoader.this.file}), MessageManager.getString("label.file_open_error"), 2);
                    }
                });
            }
            this.alignFrame = null;
        }
        catch (OutOfMemoryError er) {
            er.printStackTrace();
            this.alignFrame = null;
            if (this.raiseGUI && !Jalview.isBatchMode()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JvOptionPane.showInternalMessageDialog((Component)Desktop.getDesktopPane(), MessageManager.formatMessage("warn.out_of_memory_loading_file", new String[]{FileLoader.this.file}), MessageManager.getString("label.out_of_memory"), 2);
                    }
                });
            }
            Console.errPrintln("Out of memory loading file " + this.file + "!!");
        }
        this.loadtime += System.currentTimeMillis();
        this.memused -= rt.maxMemory() - rt.totalMemory() + rt.freeMemory();
        if (Desktop.getDesktopPane() != null && Desktop.getDesktopPane().isShowMemoryUsage()) {
            if (this.alignFrame != null) {
                al = this.alignFrame.getViewport().getAlignment();
                Console.outPrintln("Loaded '" + title + "' in " + (double)this.loadtime / 1000.0 + "s, took an additional " + 1.0 * (double)this.memused / 1048576.0 + " MB (" + al.getHeight() + " seqs by " + al.getWidth() + " cols)");
            } else {
                Console.outPrintln("Failed to load '" + title + "' in " + (double)this.loadtime / 1000.0 + "s, took an additional " + 1.0 * (double)this.memused / 1048576.0 + " MB (alignment is null)");
            }
        }
        if (Desktop.getInstance() != null) {
            Desktop.getInstance().stopLoading();
        }
        this.setShouldBeSaved();
        FileLoader.useDefaultFileFormat = true;
    }

    private static String createNamedJvTempFile(String fileName, String extension) throws IOException {
        String seprator = System.getProperty("file.separator");
        String jvTempDir = System.getProperty("java.io.tmpdir") + "jalview" + seprator + System.currentTimeMillis();
        File tempStructFile = new File(jvTempDir + seprator + fileName + "." + extension);
        tempStructFile.mkdirs();
        return tempStructFile.toString();
    }

    private void setShouldBeSaved() {
        boolean upToDate;
        if (this.protocol == null) {
            return;
        }
        AlignFrame af = this.alignFrame;
        if (af == null) {
            return;
        }
        AlignViewport avp = af.getViewport();
        if (avp == null) {
            return;
        }
        boolean bl = upToDate = !this.protocol.isDynamic();
        if (this.protocol.isUrl() && !Cache.getDefault(PROMPT_SAVE_UNCHANGED_URL_ALIGNMENTS, true)) {
            upToDate = true;
        }
        avp.setSavedUpToDate(upToDate, upToDate ? null : QuitHandler.Message.UNSAVED_ALIGNMENTS);
    }

    public static boolean getUseDefaultFileFormat() {
        return useDefaultFileFormat;
    }
}

