/*
 * Decompiled with CFR 0.152.
 */
package jalview.io;

import jalview.bin.Cache;
import jalview.bin.Console;
import jalview.io.IntKeyStringValueEntry;
import jalview.util.MessageManager;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public class BackupFilesPresetEntry {
    public String suffix;
    public static final int DIGITSMIN = 1;
    public static final int DIGITSMAX = 6;
    public int digits;
    public boolean reverse;
    public boolean keepAll;
    public static final int ROLLMAXMIN = 1;
    public static final int ROLLMAXMAX = 999;
    public int rollMax;
    public boolean confirmDelete;
    public static final String SAVEDCONFIG = "BACKUPFILES_SAVED";
    public static final String CUSTOMCONFIG = "BACKUPFILES_CUSTOM";
    private static final String stringDelim = "\t";
    public static final int BACKUPFILESSCHEMECUSTOM = 0;
    public static final int BACKUPFILESSCHEMEDEFAULT = 1;
    public static final IntKeyStringValueEntry[] backupfilesPresetEntries = new IntKeyStringValueEntry[]{new IntKeyStringValueEntry(1, MessageManager.getString("label.default")), new IntKeyStringValueEntry(2, MessageManager.getString("label.single_file")), new IntKeyStringValueEntry(3, MessageManager.getString("label.keep_all_versions")), new IntKeyStringValueEntry(4, MessageManager.getString("label.rolled_backups")), new IntKeyStringValueEntry(0, MessageManager.getString("label.custom"))};
    public static final String[] backupfilesPresetEntryDescriptions = new String[]{MessageManager.getString("label.default_description"), MessageManager.getString("label.single_file_description"), MessageManager.getString("label.keep_all_versions_description"), MessageManager.getString("label.rolled_backups_description"), MessageManager.getString("label.custom_description")};
    public static final Map<Integer, BackupFilesPresetEntry> backupfilesPresetEntriesValues = new HashMap<Integer, BackupFilesPresetEntry>(){
        private static final long serialVersionUID = 125L;
        {
            this.put(1, new BackupFilesPresetEntry(".bak%n", 3, false, false, 3, false));
            this.put(2, new BackupFilesPresetEntry("~", 1, false, false, 1, false));
            this.put(3, new BackupFilesPresetEntry(".v%n", 3, false, true, 10, true));
            this.put(4, new BackupFilesPresetEntry("_bak.%n", 1, true, false, 9, false));
            this.put(0, new BackupFilesPresetEntry("", 0, false, false, 0, false));
        }
    };

    public BackupFilesPresetEntry(String suffix, int digits, boolean reverse, boolean keepAll, int rollMax, boolean confirmDelete) {
        String string = this.suffix = suffix == null ? "" : suffix;
        this.digits = digits < 1 ? 1 : (digits > 6 ? 6 : digits);
        this.reverse = reverse;
        this.keepAll = keepAll;
        this.rollMax = rollMax < 1 ? 1 : (rollMax > 999 ? 999 : rollMax);
        this.confirmDelete = confirmDelete;
    }

    public boolean equals(BackupFilesPresetEntry compare) {
        return this.suffix.equals(compare.suffix) && this.digits == compare.digits && this.reverse == compare.reverse && this.keepAll == compare.keepAll && this.rollMax == compare.rollMax && this.confirmDelete == compare.confirmDelete;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.suffix);
        sb.append(stringDelim);
        sb.append(this.digits);
        sb.append(stringDelim);
        sb.append(this.reverse);
        sb.append(stringDelim);
        sb.append(this.keepAll);
        sb.append(stringDelim);
        sb.append(this.rollMax);
        sb.append(stringDelim);
        sb.append(this.confirmDelete);
        return sb.toString();
    }

    public static BackupFilesPresetEntry createBackupFilesPresetEntry(String line) {
        if (line == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(line, stringDelim);
        String suffix = null;
        int digits = 0;
        boolean reverse = false;
        boolean keepAll = false;
        int rollMax = 0;
        boolean confirmDelete = false;
        try {
            suffix = st.nextToken();
            digits = Integer.valueOf(st.nextToken());
            reverse = Boolean.valueOf(st.nextToken());
            keepAll = Boolean.valueOf(st.nextToken());
            rollMax = Integer.valueOf(st.nextToken());
            confirmDelete = Boolean.valueOf(st.nextToken());
        }
        catch (Exception e) {
            Console.error("Error parsing backupfiles scheme '" + line + "'");
        }
        return new BackupFilesPresetEntry(suffix, digits, reverse, keepAll, rollMax, confirmDelete);
    }

    public static BackupFilesPresetEntry getSavedBackupEntry() {
        String savedPresetString = Cache.getDefault(SAVEDCONFIG, null);
        BackupFilesPresetEntry savedPreset = BackupFilesPresetEntry.createBackupFilesPresetEntry(savedPresetString);
        if (savedPreset == null) {
            savedPreset = backupfilesPresetEntriesValues.get(1);
        }
        return savedPreset;
    }
}

