/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui;

import jalview.bin.Console;
import jalview.gui.Desktop;
import jalview.util.ChannelProperties;
import jalview.util.Platform;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javajs.async.SwingJSUtils;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class SplashScreen
extends JPanel
implements HyperlinkListener,
SwingJSUtils.StateMachine {
    private static final int STATE_INIT = 0;
    private static final int STATE_LOOP = 1;
    private static final int STATE_DONE = 2;
    private static final int SHOW_FOR_SECS = 5;
    private static final int FONT_SIZE = Platform.isJS() ? 14 : 11;
    private boolean visible = true;
    private JPanel iconimg = new JPanel(new BorderLayout());
    private static Color bg = Color.WHITE;
    private static Color fg = Color.BLACK;
    private static Font font = new Font("SansSerif", 0, FONT_SIZE);
    private JPanel imgPanel = new JPanel(new BorderLayout());
    private Component splashText;
    private JInternalFrame iframe;
    private Image image;
    private Image logo;
    private boolean transientDialog = false;
    private long oldTextLength = -1L;
    private SwingJSUtils.StateHelper helper;
    public static int logoSize = 32;
    private MouseAdapter closer = new MouseAdapter(){

        @Override
        public void mousePressed(MouseEvent evt) {
            if (SplashScreen.this.transientDialog) {
                try {
                    SplashScreen.this.closeSplash();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    };

    public SplashScreen(boolean isStartup) {
        this.transientDialog = isStartup;
        this.image = ChannelProperties.getImage("banner");
        this.logo = ChannelProperties.getImage("logo.48");
        font = new Font("SansSerif", 0, FONT_SIZE);
        this.helper = new SwingJSUtils.StateHelper(this);
        this.helper.next(0);
    }

    protected void initSplashScreenWindow() {
        this.addMouseListener(this.closer);
        this.waitForImages();
        this.setLayout(new BorderLayout());
        this.iframe = new JInternalFrame();
        this.iframe.setFrameIcon(null);
        this.iframe.setClosable(true);
        this.iframe.setContentPane(this);
        this.iframe.setLayer(JLayeredPane.PALETTE_LAYER);
        SplashImage splashimg = new SplashImage(this.image);
        this.imgPanel.add((Component)splashimg, "Center");
        this.add((Component)this.imgPanel, "North");
        Desktop.getDesktopPane().add(this.iframe);
        this.refreshText();
    }

    private void waitForImages() {
        if (Platform.isJS()) {
            return;
        }
        MediaTracker mt = new MediaTracker(this);
        mt.addImage(this.image, 0);
        mt.addImage(this.logo, 1);
        do {
            try {
                mt.waitForAll();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!mt.isErrorAny()) continue;
            Console.errPrintln("Error when loading images!");
            break;
        } while (!mt.checkAll());
        if (this.logo != null) {
            Desktop.getInstance().setIconImage(this.logo);
        }
        this.setBackground(bg);
        this.setForeground(fg);
        this.setFont(font);
    }

    protected boolean refreshText() {
        String newtext = Desktop.getInstance().getAboutMessage();
        if (this.oldTextLength == (long)newtext.length()) {
            return false;
        }
        this.iframe.setVisible(false);
        this.oldTextLength = newtext.length();
        if (Platform.isJS()) {
            String text = "<html><br><img src=\"" + ChannelProperties.getImageURL("banner") + "\"/>" + newtext + "<br></html>";
            JLabel ta = new JLabel(text);
            ta.setOpaque(true);
            ta.setBackground(Color.white);
            this.splashText = ta;
        } else {
            JTextPane jtp = new JTextPane();
            jtp.setEditable(false);
            jtp.setBackground(bg);
            jtp.setForeground(fg);
            jtp.setFont(font);
            jtp.setContentType("text/html");
            jtp.setText("<html>" + newtext + "</html>");
            jtp.addHyperlinkListener(this);
            this.splashText = jtp;
        }
        this.splashText.addMouseListener(this.closer);
        this.splashText.setVisible(true);
        this.splashText.setSize(new Dimension(750, 425 + logoSize + (Platform.isJS() ? 40 : 0)));
        this.splashText.setBackground(bg);
        this.splashText.setForeground(fg);
        this.splashText.setFont(font);
        this.add(this.splashText, "Center");
        this.revalidate();
        int width = Math.max(this.splashText.getWidth(), this.iconimg.getWidth());
        int height = this.splashText.getHeight() + this.iconimg.getHeight();
        this.iframe.setBounds((this.iframe.getParent().getWidth() - width) / 2, (this.iframe.getParent().getHeight() - height) / 2, width, height);
        this.iframe.validate();
        this.iframe.setVisible(true);
        return true;
    }

    protected void closeSplash() {
        if (this.transientDialog) {
            Desktop.getInstance().releaseDialogQueue();
        }
        try {
            final JInternalFrame frme = this.iframe;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        frme.setClosed(true);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public boolean stateLoop() {
        block4: while (true) {
            switch (this.helper.getState()) {
                case 0: {
                    this.initSplashScreenWindow();
                    this.helper.setState(1);
                    continue block4;
                }
                case 1: {
                    if (!this.isVisible()) {
                        this.helper.setState(2);
                        continue block4;
                    }
                    if (this.refreshText()) {
                        this.iframe.repaint();
                    }
                    if (this.transientDialog) {
                        this.helper.delayedState(5000, 2);
                    }
                    return true;
                }
            }
            break;
        }
        this.setVisible(false);
        this.closeSplash();
        Desktop.getInstance().startDialogQueue();
        return true;
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent e) {
        Desktop.hyperlinkUpdate(e);
    }

    private class SplashImage
    extends JPanel {
        Image image;

        public SplashImage(Image todisplay) {
            this.image = todisplay;
            if (this.image != null) {
                this.setPreferredSize(new Dimension(this.image.getWidth(this) + 8, this.image.getHeight(this)));
            }
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(this.image.getWidth(this) + 8, this.image.getHeight(this));
        }

        @Override
        public void paintComponent(Graphics g) {
            g.setColor(bg);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            g.setColor(fg);
            g.setFont(new Font(font.getFontName(), 1, FONT_SIZE + 6));
            if (this.image != null) {
                g.drawImage(this.image, (this.getWidth() - this.image.getWidth(this)) / 2, (this.getHeight() - this.image.getHeight(this)) / 2, this);
            }
        }
    }
}

