/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui;

import jalview.bin.Console;
import jalview.datamodel.AlignmentAnnotation;
import jalview.datamodel.GraphLine;
import jalview.datamodel.HiddenColumns;
import jalview.gui.AlignViewport;
import jalview.gui.AlignmentPanel;
import jalview.gui.AnnotationRowFilter;
import jalview.gui.Desktop;
import jalview.gui.JvSwingUtils;
import jalview.io.cache.JvCacheableInputBox;
import jalview.util.MessageManager;
import jalview.util.Platform;
import jalview.viewmodel.annotationfilter.AnnotationFilterParameter;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;
import net.miginfocom.swing.MigLayout;

public class AnnotationColumnChooser
extends AnnotationRowFilter
implements ItemListener {
    private JPanel switchableViewsPanel = new JPanel(new CardLayout());
    private JPanel annotationComboBoxPanel = new JPanel();
    private StructureFilterPanel gStructureFilterPanel;
    private StructureFilterPanel ngStructureFilterPanel;
    private StructureFilterPanel currentStructureFilterPanel;
    private SearchPanel currentSearchPanel;
    private SearchPanel gSearchPanel;
    private SearchPanel ngSearchPanel;
    private FurtherActionPanel currentFurtherActionPanel;
    private FurtherActionPanel gFurtherActionPanel;
    private FurtherActionPanel ngFurtherActionPanel;
    public static final int ACTION_OPTION_SELECT = 1;
    public static int ACTION_OPTION_HIDE = 2;
    public static String NO_GRAPH_VIEW = "0";
    public static String GRAPH_VIEW = "1";
    private int actionOption = 1;
    private HiddenColumns oldHiddenColumns;
    protected static int MIN_WIDTH = Platform.isJS() ? 370 : 420;
    protected static int MIN_HEIGHT = Platform.isJS() ? 370 : 430;

    public AnnotationColumnChooser(AlignViewport av, AlignmentPanel ap) {
        this(av, ap, null);
    }

    public AnnotationColumnChooser(AlignViewport av, AlignmentPanel ap, AlignmentAnnotation selectedAnnotation) {
        super(av, ap);
        this.frame = new JInternalFrame();
        this.frame.setFrameIcon(null);
        this.frame.setContentPane(this);
        this.frame.setLayer(JLayeredPane.PALETTE_LAYER);
        Desktop.addInternalFrame(this.frame, MessageManager.getString("label.select_by_annotation"), 0, 0);
        this.frame.setMinimumSize(new Dimension(MIN_WIDTH, MIN_HEIGHT));
        this.addSliderChangeListener();
        this.addSliderMouseListeners();
        if (av.getAlignment().getAlignmentAnnotation() == null) {
            return;
        }
        this.setOldHiddenColumns(av.getAlignment().getHiddenColumns());
        this.adjusting = true;
        this.setAnnotations(new JComboBox<String>(this.getAnnotationItems(false)));
        this.populateThresholdComboBox(this.threshold);
        AnnotationColumnChooser lastChooser = av.getAnnotationColumnSelectionState();
        if (lastChooser != null) {
            this.currentSearchPanel = lastChooser.getCurrentSearchPanel();
            this.currentStructureFilterPanel = lastChooser.getCurrentStructureFilterPanel();
            this.annotations.setSelectedIndex(lastChooser.getAnnotations().getSelectedIndex());
            this.threshold.setSelectedIndex(lastChooser.getThreshold().getSelectedIndex());
            this.actionOption = lastChooser.getActionOption();
            this.percentThreshold.setSelected(lastChooser.percentThreshold.isSelected());
        }
        if (selectedAnnotation != null) {
            try {
                this.setCurrentAnnotation(selectedAnnotation);
                this.annotations.setSelectedItem(this.getAnnotationMenuLabel(selectedAnnotation));
            }
            catch (Exception x) {
                Console.error("Couldn't select annotation in column chooser", x);
            }
        }
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.adjusting = false;
        this.updateView();
        this.frame.invalidate();
        this.frame.pack();
    }

    @Override
    protected void jbInit() {
        super.jbInit();
        JPanel thresholdPanel = new JPanel();
        thresholdPanel.setBorder(new TitledBorder(MessageManager.getString("label.threshold_filter")));
        thresholdPanel.setBackground(Color.white);
        thresholdPanel.setFont(JvSwingUtils.getLabelFont());
        thresholdPanel.setLayout((LayoutManager)new MigLayout("", "[left][right]", "[][]"));
        this.percentThreshold.setBackground(Color.white);
        this.percentThreshold.setFont(JvSwingUtils.getLabelFont());
        JPanel actionPanel = new JPanel();
        actionPanel.setBackground(Color.white);
        actionPanel.setFont(JvSwingUtils.getLabelFont());
        JPanel graphFilterView = new JPanel();
        graphFilterView.setLayout((LayoutManager)new MigLayout("", "[left][right]", "[][]"));
        graphFilterView.setBackground(Color.white);
        JPanel noGraphFilterView = new JPanel();
        noGraphFilterView.setLayout((LayoutManager)new MigLayout("", "[left][right]", "[][]"));
        noGraphFilterView.setBackground(Color.white);
        this.annotationComboBoxPanel.setBackground(Color.white);
        this.annotationComboBoxPanel.setFont(JvSwingUtils.getLabelFont());
        this.gSearchPanel = new SearchPanel(this);
        this.ngSearchPanel = new SearchPanel(this);
        this.gFurtherActionPanel = new FurtherActionPanel(this);
        this.ngFurtherActionPanel = new FurtherActionPanel(this);
        this.gStructureFilterPanel = new StructureFilterPanel(this);
        this.ngStructureFilterPanel = new StructureFilterPanel(this);
        thresholdPanel.add(this.getThreshold());
        thresholdPanel.add((Component)this.percentThreshold, "wrap");
        thresholdPanel.add((Component)this.slider, "grow");
        thresholdPanel.add((Component)this.thresholdValue, "span, wrap");
        actionPanel.add(this.ok);
        actionPanel.add(this.cancel);
        graphFilterView.add((Component)this.gSearchPanel, "grow, span, wrap");
        graphFilterView.add((Component)this.gStructureFilterPanel, "grow, span, wrap");
        graphFilterView.add((Component)thresholdPanel, "grow, span, wrap");
        graphFilterView.add(this.gFurtherActionPanel);
        noGraphFilterView.add((Component)this.ngSearchPanel, "grow, span, wrap");
        noGraphFilterView.add((Component)this.ngStructureFilterPanel, "grow, span, wrap");
        noGraphFilterView.add(this.ngFurtherActionPanel);
        this.annotationComboBoxPanel.add(this.getAnnotations());
        this.switchableViewsPanel.add((Component)noGraphFilterView, NO_GRAPH_VIEW);
        this.switchableViewsPanel.add((Component)graphFilterView, GRAPH_VIEW);
        this.setLayout(new BorderLayout());
        this.add((Component)this.annotationComboBoxPanel, "First");
        this.add((Component)this.switchableViewsPanel, "Center");
        this.add((Component)actionPanel, "South");
        this.selectedAnnotationChanged();
        this.updateThresholdPanelToolTip();
        this.validate();
    }

    protected void updateThresholdPanelToolTip() {
        this.thresholdValue.setToolTipText("");
        this.slider.setToolTipText("");
        String defaultTtip = MessageManager.getString("info.change_threshold_mode_to_enable");
        String thresh = this.getThreshold().getSelectedItem().toString();
        if (thresh.equalsIgnoreCase("No Threshold")) {
            this.thresholdValue.setToolTipText(defaultTtip);
            this.slider.setToolTipText(defaultTtip);
        }
    }

    @Override
    protected void reset() {
        if (this.getOldHiddenColumns() != null) {
            this.av.getColumnSelection().clear();
            if (this.av.getAnnotationColumnSelectionState() != null) {
                HiddenColumns oldHidden = this.av.getAnnotationColumnSelectionState().getOldHiddenColumns();
                this.av.getAlignment().setHiddenColumns(oldHidden);
            }
            this.av.sendSelection();
            this.ap.paintAlignment(true, true);
        }
    }

    @Override
    public void valueChanged(boolean updateAllAnnotation) {
        if (this.slider.isEnabled()) {
            this.getCurrentAnnotation().threshold.value = this.getSliderValue();
            this.updateView();
            this.propagateSeqAssociatedThreshold(updateAllAnnotation, this.getCurrentAnnotation());
            this.ap.paintAlignment(false, false);
        }
    }

    @Override
    public void updateView() {
        boolean hideCols;
        if (this.adjusting) {
            return;
        }
        AnnotationFilterParameter filterParams = new AnnotationFilterParameter();
        this.setCurrentAnnotation(this.av.getAlignment().getAlignmentAnnotation()[this.annmap[this.getAnnotations().getSelectedIndex()]]);
        int selectedThresholdItem = this.getSelectedThresholdItem(this.getThreshold().getSelectedIndex());
        this.slider.setEnabled(true);
        this.thresholdValue.setEnabled(true);
        this.percentThreshold.setEnabled(true);
        AlignmentAnnotation currentAnnotation = this.getCurrentAnnotation();
        if (selectedThresholdItem == -1) {
            this.slider.setEnabled(false);
            this.thresholdValue.setEnabled(false);
            this.thresholdValue.setText("");
            this.percentThreshold.setEnabled(false);
        } else if (selectedThresholdItem != -1) {
            if (currentAnnotation.threshold == null) {
                currentAnnotation.setThreshold(new GraphLine((currentAnnotation.graphMax - currentAnnotation.graphMin) / 2.0f, "Threshold", Color.black));
            }
            this.adjusting = true;
            this.setSliderModel(currentAnnotation.graphMin, currentAnnotation.graphMax, currentAnnotation.threshold.value);
            this.setThresholdValueText();
            this.slider.setEnabled(true);
            this.thresholdValue.setEnabled(true);
            this.adjusting = false;
            filterParams.setThresholdType(AnnotationFilterParameter.ThresholdType.NO_THRESHOLD);
            if (currentAnnotation.isQuantitative()) {
                filterParams.setThresholdValue(currentAnnotation.threshold.value);
                if (selectedThresholdItem == 1) {
                    filterParams.setThresholdType(AnnotationFilterParameter.ThresholdType.ABOVE_THRESHOLD);
                } else if (selectedThresholdItem == 0) {
                    filterParams.setThresholdType(AnnotationFilterParameter.ThresholdType.BELOW_THRESHOLD);
                }
            }
        }
        this.updateThresholdPanelToolTip();
        if (this.currentStructureFilterPanel != null) {
            if (this.currentStructureFilterPanel.alphaHelix.isSelected()) {
                filterParams.setFilterAlphaHelix(true);
            }
            if (this.currentStructureFilterPanel.betaStrand.isSelected()) {
                filterParams.setFilterBetaSheet(true);
            }
            if (this.currentStructureFilterPanel.turn.isSelected()) {
                filterParams.setFilterTurn(true);
            }
        }
        if (this.currentSearchPanel != null && !this.currentSearchPanel.searchBox.getUserInput().isEmpty()) {
            filterParams.setRegexString(this.currentSearchPanel.searchBox.getUserInput());
            if (this.currentSearchPanel.displayName.isSelected()) {
                filterParams.addRegexSearchField(AnnotationFilterParameter.SearchableAnnotationField.DISPLAY_STRING);
            }
            if (this.currentSearchPanel.description.isSelected()) {
                filterParams.addRegexSearchField(AnnotationFilterParameter.SearchableAnnotationField.DESCRIPTION);
            }
        }
        this.av.showAllHiddenColumns();
        this.av.getColumnSelection().filterAnnotations(currentAnnotation, filterParams);
        boolean bl = hideCols = this.getActionOption() == ACTION_OPTION_HIDE;
        if (hideCols) {
            this.av.hideSelectedColumns();
        }
        this.av.sendSelection();
        filterParams = null;
        this.av.setAnnotationColumnSelectionState(this);
        this.ap.paintAlignment(hideCols, hideCols);
    }

    public HiddenColumns getOldHiddenColumns() {
        return this.oldHiddenColumns;
    }

    public void setOldHiddenColumns(HiddenColumns currentHiddenColumns) {
        if (currentHiddenColumns != null) {
            this.oldHiddenColumns = new HiddenColumns(currentHiddenColumns);
        }
    }

    public FurtherActionPanel getCurrentFutherActionPanel() {
        return this.currentFurtherActionPanel;
    }

    public void setCurrentFutherActionPanel(FurtherActionPanel currentFutherActionPanel) {
        this.currentFurtherActionPanel = currentFutherActionPanel;
    }

    public SearchPanel getCurrentSearchPanel() {
        return this.currentSearchPanel;
    }

    public void setCurrentSearchPanel(SearchPanel currentSearchPanel) {
        this.currentSearchPanel = currentSearchPanel;
    }

    public int getActionOption() {
        return this.actionOption;
    }

    public void setActionOption(int actionOption) {
        this.actionOption = actionOption;
    }

    public StructureFilterPanel getCurrentStructureFilterPanel() {
        return this.currentStructureFilterPanel;
    }

    public void setCurrentStructureFilterPanel(StructureFilterPanel currentStructureFilterPanel) {
        this.currentStructureFilterPanel = currentStructureFilterPanel;
    }

    public void select_action(ActionEvent actionEvent) {
        JRadioButton radioButton = (JRadioButton)actionEvent.getSource();
        if (radioButton.isSelected()) {
            this.setActionOption(1);
            this.updateView();
        }
    }

    public void hide_action(ActionEvent actionEvent) {
        JRadioButton radioButton = (JRadioButton)actionEvent.getSource();
        if (radioButton.isSelected()) {
            this.setActionOption(ACTION_OPTION_HIDE);
            this.updateView();
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.selectedAnnotationChanged();
    }

    @Override
    public void selectedAnnotationChanged() {
        String currentView = NO_GRAPH_VIEW;
        if (this.av.getAlignment().getAlignmentAnnotation()[this.annmap[this.getAnnotations().getSelectedIndex()]].isQuantitative()) {
            currentView = GRAPH_VIEW;
        }
        this.saveCache();
        this.gSearchPanel.syncState();
        this.gFurtherActionPanel.syncState();
        this.gStructureFilterPanel.syncState();
        this.ngSearchPanel.syncState();
        this.ngFurtherActionPanel.syncState();
        this.ngStructureFilterPanel.syncState();
        CardLayout switchableViewsLayout = (CardLayout)this.switchableViewsPanel.getLayout();
        switchableViewsLayout.show(this.switchableViewsPanel, currentView);
        this.updateView();
    }

    @Override
    public void ok_actionPerformed() {
        this.saveCache();
        super.ok_actionPerformed();
    }

    @Override
    public void cancel_actionPerformed() {
        this.saveCache();
        super.cancel_actionPerformed();
    }

    private void saveCache() {
        this.gSearchPanel.searchBox.persistCache();
        this.ngSearchPanel.searchBox.persistCache();
        this.gSearchPanel.searchBox.updateCache();
        this.ngSearchPanel.searchBox.updateCache();
    }

    public static void displayFor(AlignViewport av, AlignmentPanel ap, AlignmentAnnotation alignmentAnnotation) {
        AnnotationColumnChooser colchooser = new AnnotationColumnChooser(av, ap, alignmentAnnotation);
    }

    public class SearchPanel
    extends JPanel {
        private AnnotationColumnChooser aColChooser;
        private JCheckBox displayName = new JCheckBox();
        private JCheckBox description = new JCheckBox();
        private static final String FILTER_BY_ANN_CACHE_KEY = "CACHE.SELECT_FILTER_BY_ANNOT";
        public JvCacheableInputBox<String> searchBox = new JvCacheableInputBox("CACHE.SELECT_FILTER_BY_ANNOT", 23);

        public SearchPanel(AnnotationColumnChooser aColChooser) {
            this.aColChooser = aColChooser;
            JvSwingUtils.jvInitComponent(this);
            this.setBorder(new TitledBorder(MessageManager.getString("label.search_filter")));
            this.searchBox.getComponent().setToolTipText(MessageManager.getString("info.enter_search_text_here"));
            this.searchBox.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 10) {
                        e.consume();
                        SearchPanel.this.searchStringAction();
                    }
                }
            });
            this.searchBox.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    SearchPanel.this.searchStringAction();
                }
            });
            JvSwingUtils.jvInitComponent(this.displayName, "label.label");
            this.displayName.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SearchPanel.this.displayNameCheckboxAction();
                }
            });
            JvSwingUtils.jvInitComponent(this.description, "label.description");
            this.description.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SearchPanel.this.descriptionCheckboxAction();
                }
            });
            this.syncState();
            this.add(this.searchBox.getComponent());
            this.add(this.displayName);
            this.add(this.description);
        }

        public void displayNameCheckboxAction() {
            this.aColChooser.setCurrentSearchPanel(this);
            this.aColChooser.updateView();
        }

        public void descriptionCheckboxAction() {
            this.aColChooser.setCurrentSearchPanel(this);
            this.aColChooser.updateView();
        }

        public void searchStringAction() {
            this.aColChooser.setCurrentSearchPanel(this);
            this.aColChooser.updateView();
            this.updateSearchPanelToolTips();
            this.searchBox.updateCache();
        }

        public void syncState() {
            SearchPanel sp = this.aColChooser.getCurrentSearchPanel();
            if (sp != null) {
                this.description.setEnabled(sp.description.isEnabled());
                this.description.setSelected(sp.description.isSelected());
                this.displayName.setEnabled(sp.displayName.isEnabled());
                this.displayName.setSelected(sp.displayName.isSelected());
                this.searchBox.setSelectedItem(sp.searchBox.getUserInput());
            }
            this.updateSearchPanelToolTips();
        }

        public void updateSearchPanelToolTips() {
            String defaultTtip = MessageManager.getString("info.enter_search_text_to_enable");
            String labelTtip = MessageManager.formatMessage("info.search_in_annotation_label", AnnotationColumnChooser.this.annotations.getSelectedItem().toString());
            String descTtip = MessageManager.formatMessage("info.search_in_annotation_description", AnnotationColumnChooser.this.annotations.getSelectedItem().toString());
            this.displayName.setToolTipText(this.displayName.isEnabled() ? labelTtip : defaultTtip);
            this.description.setToolTipText(this.description.isEnabled() ? descTtip : defaultTtip);
        }
    }

    public class StructureFilterPanel
    extends JPanel {
        private AnnotationColumnChooser aColChooser;
        private JCheckBox alphaHelix = new JCheckBox();
        private JCheckBox betaStrand = new JCheckBox();
        private JCheckBox turn = new JCheckBox();
        private JCheckBox all = new JCheckBox();

        public StructureFilterPanel(AnnotationColumnChooser aColChooser) {
            this.aColChooser = aColChooser;
            JvSwingUtils.jvInitComponent(this.alphaHelix, "label.alpha_helix");
            this.alphaHelix.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    StructureFilterPanel.this.alphaHelix_actionPerformed();
                }
            });
            JvSwingUtils.jvInitComponent(this.betaStrand, "label.beta_strand");
            this.betaStrand.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    StructureFilterPanel.this.betaStrand_actionPerformed();
                }
            });
            JvSwingUtils.jvInitComponent(this.turn, "label.turn");
            this.turn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    StructureFilterPanel.this.turn_actionPerformed();
                }
            });
            JvSwingUtils.jvInitComponent(this.all, "label.select_all");
            this.all.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    StructureFilterPanel.this.all_actionPerformed();
                }
            });
            this.setBorder(new TitledBorder(MessageManager.getString("label.structures_filter")));
            JvSwingUtils.jvInitComponent(this);
            this.add(this.all);
            this.add(this.alphaHelix);
            this.add(this.betaStrand);
            this.add(this.turn);
        }

        public void alphaHelix_actionPerformed() {
            this.updateSelectAllState();
            this.aColChooser.setCurrentStructureFilterPanel(this);
            this.aColChooser.updateView();
        }

        public void betaStrand_actionPerformed() {
            this.updateSelectAllState();
            this.aColChooser.setCurrentStructureFilterPanel(this);
            this.aColChooser.updateView();
        }

        public void turn_actionPerformed() {
            this.updateSelectAllState();
            this.aColChooser.setCurrentStructureFilterPanel(this);
            this.aColChooser.updateView();
        }

        public void all_actionPerformed() {
            if (this.all.isSelected()) {
                this.alphaHelix.setSelected(true);
                this.betaStrand.setSelected(true);
                this.turn.setSelected(true);
            } else {
                this.alphaHelix.setSelected(false);
                this.betaStrand.setSelected(false);
                this.turn.setSelected(false);
            }
            this.aColChooser.setCurrentStructureFilterPanel(this);
            this.aColChooser.updateView();
        }

        public void updateSelectAllState() {
            if (this.alphaHelix.isSelected() && this.betaStrand.isSelected() && this.turn.isSelected()) {
                this.all.setSelected(true);
            } else {
                this.all.setSelected(false);
            }
        }

        public void syncState() {
            StructureFilterPanel sfp = this.aColChooser.getCurrentStructureFilterPanel();
            if (sfp != null) {
                this.alphaHelix.setSelected(sfp.alphaHelix.isSelected());
                this.betaStrand.setSelected(sfp.betaStrand.isSelected());
                this.turn.setSelected(sfp.turn.isSelected());
                if (sfp.all.isSelected()) {
                    this.all.setSelected(true);
                    this.alphaHelix.setSelected(true);
                    this.betaStrand.setSelected(true);
                    this.turn.setSelected(true);
                }
            }
        }
    }

    public class FurtherActionPanel
    extends JPanel {
        private AnnotationColumnChooser aColChooser;
        private JRadioButton hideOption = new JRadioButton();
        private JRadioButton selectOption = new JRadioButton();
        private ButtonGroup optionsGroup = new ButtonGroup();

        public FurtherActionPanel(AnnotationColumnChooser aColChooser) {
            this.aColChooser = aColChooser;
            JvSwingUtils.jvInitComponent(this.selectOption, "action.select");
            this.selectOption.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    FurtherActionPanel.this.selectRadioAction(actionEvent);
                }
            });
            JvSwingUtils.jvInitComponent(this.hideOption, "action.hide");
            this.hideOption.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    FurtherActionPanel.this.hideRadioAction(actionEvent);
                }
            });
            this.optionsGroup.add(this.selectOption);
            this.optionsGroup.add(this.hideOption);
            this.optionsGroup.setSelected(this.selectOption.getModel(), true);
            JvSwingUtils.jvInitComponent(this);
            this.syncState();
            this.add(this.selectOption);
            this.add(this.hideOption);
        }

        public void selectRadioAction(ActionEvent actionEvent) {
            this.aColChooser.setCurrentFutherActionPanel(this);
            this.aColChooser.select_action(actionEvent);
        }

        public void hideRadioAction(ActionEvent actionEvent) {
            this.aColChooser.setCurrentFutherActionPanel(this);
            this.aColChooser.hide_action(actionEvent);
        }

        public void syncState() {
            if (this.aColChooser.getActionOption() == ACTION_OPTION_HIDE) {
                this.optionsGroup.setSelected(this.hideOption.getModel(), true);
            } else {
                this.optionsGroup.setSelected(this.selectOption.getModel(), true);
            }
        }
    }
}

