/*
 * Decompiled with CFR 0.152.
 */
package jalview.datamodel;

import jalview.datamodel.AnnotationMapping;
import jalview.datamodel.Point;
import jalview.datamodel.SequenceI;

public class SequencePoint
extends AnnotationMapping {
    private final SequenceI sequence;
    public Point coord;

    public SequencePoint(SequenceI sequence, Point pt) {
        this.sequence = sequence;
        this.coord = pt;
    }

    public SequencePoint(SequenceI sequence, float[] coords) {
        this(sequence, new Point(coords[0], coords[1], coords[2]));
    }

    public SequenceI getSequence() {
        return this.sequence;
    }

    public void translate(float x, float y, float z) {
        this.coord = new Point(this.coord.x + x, this.coord.y + y, this.coord.z + z);
    }

    public String toString() {
        return this.sequence.getName() + " " + this.coord.toString();
    }

    @Override
    public String getDisplayName() {
        Object displayName = this.sequence.getName();
        if (this.hasLabel()) {
            displayName = (String)displayName + "|" + this.label;
        }
        if (this.hasAnnotationDetails()) {
            displayName = (String)displayName + "|" + this.annotationDetails;
        }
        return displayName;
    }
}

