/*
 * Decompiled with CFR 0.152.
 */
package jalview.datamodel;

import jalview.datamodel.AlignmentAnnotation;
import jalview.datamodel.Annotation;
import jalview.datamodel.ContactListI;
import jalview.datamodel.GroupSet;
import jalview.datamodel.GroupSetI;
import jalview.util.ColorUtils;
import jalview.ws.datamodel.MappableContactMatrixI;
import java.awt.Color;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;

public interface ContactMatrixI {
    public ContactListI getContactList(int var1);

    public float getMin();

    public float getMax();

    public String getAnnotDescr();

    public String getAnnotLabel();

    public String getType();

    public int getWidth();

    public int getHeight();

    public GroupSetI getGroupSet();

    default public boolean hasGroupSet() {
        return this.getGroupSet() != null;
    }

    default public boolean hasGroups() {
        return this.hasGroupSet() && this.getGroupSet().hasGroups();
    }

    default public BitSet getGroupsFor(int column) {
        if (!this.hasGroupSet()) {
            BitSet colbitset = new BitSet();
            colbitset.set(column);
            return colbitset;
        }
        return this.getGroupSet().getGroupsFor(column);
    }

    default public List<BitSet> getGroups() {
        if (!this.hasGroupSet()) {
            return Arrays.asList(new BitSet[0]);
        }
        return this.getGroupSet().getGroups();
    }

    default public boolean hasTree() {
        return this.hasGroupSet() ? this.getGroupSet().hasTree() : false;
    }

    default public String getNewick() {
        return this.hasGroupSet() ? this.getGroupSet().getNewick() : null;
    }

    default public String getTreeMethod() {
        return this.hasGroupSet() ? this.getGroupSet().getTreeMethod() : null;
    }

    default public boolean hasCutHeight() {
        return this.hasGroupSet() ? this.getGroupSet().hasCutHeight() : false;
    }

    default public double getCutHeight() {
        return this.hasGroupSet() ? this.getGroupSet().getCutHeight() : 0.0;
    }

    default public void updateGroups(List<BitSet> colGroups) {
        if (this.hasGroupSet()) {
            this.getGroupSet().updateGroups(colGroups);
        }
    }

    default public void setColorForGroup(BitSet bs, Color color) {
        if (this.hasGroupSet()) {
            this.getGroupSet().setColorForGroup(bs, color);
        }
    }

    default public Color getColourForGroup(BitSet bs) {
        if (this.hasGroupSet()) {
            return this.getGroupSet().getColourForGroup(bs);
        }
        return Color.white;
    }

    public void setGroupSet(GroupSet var1);

    default public void randomlyReColourGroups() {
        if (this.hasGroupSet()) {
            GroupSetI groups = this.getGroupSet();
            for (BitSet group : groups.getGroups()) {
                groups.setColorForGroup(group, ColorUtils.getARandomColor());
            }
        }
    }

    default public void transferGroupColorsTo(AlignmentAnnotation aa) {
        block3: {
            if (!this.hasGroupSet()) break block3;
            GroupSetI groups = this.getGroupSet();
            int sstart = aa.sequenceRef != null ? aa.sequenceRef.getStart() - 1 : 0;
            Color gpcol = null;
            int[] seqpos = null;
            for (BitSet gp : groups.getGroups()) {
                gpcol = groups.getColourForGroup(gp);
                int p = gp.nextSetBit(0);
                while (p >= 0 && p < Integer.MAX_VALUE) {
                    block5: {
                        Annotation ae;
                        block6: {
                            block4: {
                                if (!(this instanceof MappableContactMatrixI)) break block4;
                                MappableContactMatrixI mcm = (MappableContactMatrixI)this;
                                seqpos = mcm.getMappedPositionsFor(aa.sequenceRef, p);
                                if (seqpos == null) break block5;
                                ae = aa.getAnnotationForPosition(seqpos[0]);
                                break block6;
                            }
                            ae = aa.getAnnotationForPosition(p + sstart);
                        }
                        if (ae != null) {
                            ae.colour = gpcol.brighter().darker();
                        }
                    }
                    p = gp.nextSetBit(p + 1);
                }
            }
        }
    }

    default public Color getGroupColorForPosition(int column) {
        if (this.hasGroupSet()) {
            GroupSetI groups = this.getGroupSet();
            for (BitSet gp : groups.getGroups()) {
                if (!gp.get(column)) continue;
                return groups.getColourForGroup(gp);
            }
        }
        return Color.white;
    }

    public double getElementAt(int var1, int var2);
}

