/*
 * Decompiled with CFR 0.152.
 */
package jalview.bin.argparser;

import jalview.bin.Console;
import jalview.bin.argparser.Arg;
import jalview.bin.argparser.ArgValue;
import jalview.bin.argparser.ArgValuesMap;
import jalview.bin.argparser.SubVals;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ArgValues {
    public static final String ID = "id";
    private Arg arg;
    private int argCount = 0;
    private boolean boolValue = false;
    private boolean negated = false;
    private boolean setByWildcard = false;
    private String givenLinkedId = null;
    private int boolIndex = -1;
    private List<Integer> argsIndexes;
    private List<ArgValue> argValueList;
    private Map<String, ArgValue> idMap = new HashMap<String, ArgValue>();
    private ArgValuesMap avm;
    private Arg.Type type = null;

    protected ArgValues(Arg a, ArgValuesMap avm) {
        this.arg = a;
        this.argValueList = new ArrayList<ArgValue>();
        this.boolValue = this.arg.getDefaultBoolValue();
        this.avm = avm;
    }

    protected boolean setByWildcard() {
        return this.setByWildcard;
    }

    protected void setSetByWildcard(boolean b) {
        this.setByWildcard = b;
    }

    public Arg arg() {
        return this.arg;
    }

    protected void setType(Arg.Type t) {
        if (this.arg().hasOption(Arg.Opt.HASTYPE)) {
            this.type = t;
        }
    }

    public Arg.Type getType() {
        return this.type;
    }

    protected int getCount() {
        return this.argCount;
    }

    protected void incrementCount() {
        ++this.argCount;
    }

    protected void setNegated(boolean b, boolean beingSetByWildcard) {
        if (this.boolIndex >= 0 && !this.setByWildcard && beingSetByWildcard) {
            return;
        }
        this.negated = b;
    }

    protected boolean isNegated() {
        return this.negated;
    }

    protected void setBoolean(Arg.Type t, boolean b, int i, boolean beingSetByWildcard, String givenLinkedId) {
        this.setType(t);
        if (this.boolIndex >= 0 && !this.setByWildcard && beingSetByWildcard) {
            return;
        }
        this.boolValue = b;
        this.boolIndex = i;
        this.setSetByWildcard(beingSetByWildcard);
        this.givenLinkedId = givenLinkedId;
    }

    protected boolean getBoolean() {
        return this.boolValue;
    }

    public String toString() {
        if (this.argValueList == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.arg.toLongString());
        if (this.arg.hasOption(Arg.Opt.BOOLEAN) || this.arg.hasOption(Arg.Opt.UNARY)) {
            sb.append("Boolean: ").append(this.boolValue).append("; Default: ").append(this.arg.getDefaultBoolValue()).append("; Negated: ").append(this.negated).append("\n");
        }
        if (this.arg.hasOption(Arg.Opt.STRING)) {
            sb.append("Values:");
            sb.append("'").append(String.join((CharSequence)"',\n  '", this.argValueList.stream().map(av -> av.getValue()).collect(Collectors.toList()))).append("'");
            sb.append("\n");
        }
        sb.append("Count: ").append(this.argCount).append("\n");
        return sb.toString();
    }

    protected void addValue(Arg.Type type, String val, int argIndex, boolean wildcard, String givenLinkedId) {
        this.addArgValue(new ArgValue(this.arg(), type, val, argIndex, wildcard, givenLinkedId, this.avm.getLinkedId()), wildcard);
    }

    protected void addValue(SubVals sv, Arg.Type type, String content, int argIndex, boolean wildcard, String givenLinkedId) {
        this.addArgValue(new ArgValue(this.arg(), sv, type, content, argIndex, wildcard, givenLinkedId, this.avm.getLinkedId()), wildcard);
    }

    protected void addArgValue(ArgValue av, boolean beingSetByWildcard) {
        SubVals sv;
        boolean overwrite;
        boolean bl = overwrite = !this.arg.hasOption(Arg.Opt.MULTIVALUE) && this.setByWildcard && !beingSetByWildcard;
        if (!this.arg.hasOption(Arg.Opt.MULTIVALUE) && this.argValueList.size() > 0 && !overwrite) {
            return;
        }
        if (this.arg.hasOption(Arg.Opt.NODUPLICATEVALUES) && this.containsValue(av.getValue())) {
            return;
        }
        if (this.argValueList == null || overwrite) {
            this.argValueList = new ArrayList<ArgValue>();
        }
        if ((sv = new SubVals(av.getValue())).has(ID)) {
            String id = sv.get(ID);
            av.setId(id);
            this.idMap.put(id, av);
        }
        this.argValueList.add(av);
        this.setSetByWildcard(beingSetByWildcard);
    }

    protected boolean hasValue(String val) {
        return this.argValueList.contains(val);
    }

    protected ArgValue getArgValue() {
        if (this.arg.hasOption(Arg.Opt.MULTIVALUE)) {
            Console.warn("Requesting single value for multi value argument");
        }
        return this.argValueList.size() > 0 ? this.argValueList.get(0) : null;
    }

    protected List<ArgValue> getArgValueList() {
        return this.argValueList;
    }

    protected boolean hasId(String id) {
        return this.idMap.containsKey(id);
    }

    protected ArgValue getId(String id) {
        return this.idMap.get(id);
    }

    private boolean containsValue(String v) {
        if (this.argValueList == null) {
            return false;
        }
        for (ArgValue av : this.argValueList) {
            String val = av.getValue();
            if (v == null && val == null) {
                return true;
            }
            if (v == null || !v.equals(val)) continue;
            return true;
        }
        return false;
    }

    public boolean setByWildcardLinkedId() {
        return this.setByWildcard && this.givenLinkedId != null;
    }
}

