/*
 * Decompiled with CFR 0.152.
 */
package jalview.analysis.scoremodels;

import jalview.api.analysis.SimilarityParamsI;

public class SimilarityParams
implements SimilarityParamsI {
    public static final SimilarityParamsI Jalview = new SimilarityParams(true, true, true, true);
    public static final SimilarityParamsI SeqSpace = new SimilarityParams(true, false, true, true);
    public static final SimilarityParamsI PID1 = new SimilarityParams(false, false, true, false);
    public static final SimilarityParamsI PID2 = new SimilarityParams(false, false, false, false);
    public static final SimilarityParamsI PID3 = new SimilarityParams(false, false, false, true);
    public static final SimilarityParamsI PID4 = new SimilarityParams(false, false, true, true);
    private boolean includeGappedColumns;
    private boolean matchGaps;
    private boolean includeGaps;
    private boolean denominateByShortestLength;
    private String secondaryStructureSource;
    private boolean excludeSeqWithoutAnnot;

    public SimilarityParams(boolean includeGapGap, boolean matchGapResidue, boolean includeGapResidue, boolean shortestLength) {
        this.includeGappedColumns = includeGapGap;
        this.matchGaps = matchGapResidue;
        this.includeGaps = includeGapResidue;
        this.denominateByShortestLength = shortestLength;
    }

    @Override
    public boolean includeGaps() {
        return this.includeGaps;
    }

    @Override
    public boolean denominateByShortestLength() {
        return this.denominateByShortestLength;
    }

    @Override
    public boolean includeGappedColumns() {
        return this.includeGappedColumns;
    }

    @Override
    public boolean matchGaps() {
        return this.matchGaps;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.denominateByShortestLength ? 1231 : 1237);
        result = 31 * result + (this.includeGappedColumns ? 1231 : 1237);
        result = 31 * result + (this.includeGaps ? 1231 : 1237);
        result = 31 * result + (this.matchGaps ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SimilarityParams other = (SimilarityParams)obj;
        if (this.denominateByShortestLength != other.denominateByShortestLength) {
            return false;
        }
        if (this.includeGappedColumns != other.includeGappedColumns) {
            return false;
        }
        if (this.includeGaps != other.includeGaps) {
            return false;
        }
        return this.matchGaps == other.matchGaps;
    }

    @Override
    public String getSecondaryStructureSource() {
        return this.secondaryStructureSource;
    }

    @Override
    public void setSecondaryStructureSource(String secondaryStructureSource) {
        this.secondaryStructureSource = secondaryStructureSource;
    }

    @Override
    public boolean getExcludeSeqWithoutAnnot() {
        return this.excludeSeqWithoutAnnot;
    }

    @Override
    public void setExcludeSeqWithoutAnnot(boolean excludeSeqWithoutAnnot) {
        this.excludeSeqWithoutAnnot = excludeSeqWithoutAnnot;
    }
}

