/*
 * Decompiled with CFR 0.152.
 */
package jalview.analysis;

import jalview.analysis.TreeEngine;
import jalview.api.analysis.ScoreModelI;
import jalview.api.analysis.SimilarityParamsI;
import jalview.datamodel.AlignmentAnnotation;
import jalview.datamodel.AlignmentView;
import jalview.datamodel.CigarArray;
import jalview.datamodel.CigarSimple;
import jalview.datamodel.SeqCigar;
import jalview.datamodel.SequenceI;
import jalview.datamodel.SequenceNode;
import jalview.viewmodel.AlignmentViewport;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;

public abstract class TreeBuilder
extends TreeEngine {
    public static final String AVERAGE_DISTANCE = "AV";
    public static final String NEIGHBOUR_JOINING = "NJ";
    protected SequenceI[] sequences;
    protected List<String> labels;
    protected HashMap<Integer, String> annotationDetails;
    ArrayList<AlignmentAnnotation> ssAnnotationForSeqs;
    public AlignmentView seqData;
    private AlignmentView seqStrings;

    public TreeBuilder(AlignmentViewport av, ScoreModelI sm, SimilarityParamsI scoreParameters) {
        int end;
        int start;
        boolean selview = av.getSelectionGroup() != null && av.getSelectionGroup().getSize() >= 1;
        this.seqStrings = av.getAlignmentView(selview);
        if (!selview) {
            start = 0;
            end = av.getAlignment().getWidth();
            this.sequences = av.getAlignment().getSequencesArray();
        } else {
            start = av.getSelectionGroup().getStartRes();
            end = av.getSelectionGroup().getEndRes() + 1;
            this.sequences = av.getSelectionGroup().getSequencesInOrder(av.getAlignment());
        }
        this.init(this.seqStrings, start, end);
        this.computeTree(sm, scoreParameters);
    }

    public SequenceI[] getSequences() {
        return this.sequences;
    }

    public boolean hasDistances() {
        return true;
    }

    public boolean hasBootstrap() {
        return false;
    }

    public boolean hasRootDistance() {
        return true;
    }

    public List<String> getLabels() {
        return this.labels;
    }

    private void initAnnotationData() {
        this.labels = new ArrayList<String>();
        this.annotationDetails = new HashMap();
        this.ssAnnotationForSeqs = new ArrayList();
    }

    protected void computeTree(ScoreModelI sm, SimilarityParamsI scoreOptions) {
        this.initAnnotationData();
        this.sequences = sm.expandSeqData(this.sequences, this.seqData, scoreOptions, this.labels, this.ssAnnotationForSeqs, this.annotationDetails);
        this.noseqs = this.sequences.length;
        this.distances = sm.findDistances(this.seqData, scoreOptions);
        this.makeLeaves();
        this.noClus = this.clusters.size();
        this.cluster();
    }

    protected void init(AlignmentView seqView, int start, int end) {
        this.node = new Vector();
        if (seqView != null) {
            this.seqData = seqView;
        } else {
            CigarSimple[] seqs = new SeqCigar[this.sequences.length];
            for (int i = 0; i < this.sequences.length; ++i) {
                seqs[i] = new SeqCigar(this.sequences[i], start, end);
            }
            CigarArray sdata = new CigarArray(seqs);
            sdata.addOperation('M', end - start + 1);
            this.seqData = new AlignmentView(sdata, start);
        }
        this.noseqs = 0;
        this.done = new BitSet();
        for (SequenceI seq : this.sequences) {
            if (seq == null) continue;
            ++this.noseqs;
        }
    }

    private void applyAnnotationsToNode(SequenceNode sn, int index) {
        AlignmentAnnotation aa;
        if (this.ssAnnotationForSeqs != null && index < this.ssAnnotationForSeqs.size() && (aa = this.ssAnnotationForSeqs.get(index)) != null) {
            sn.setAlignmentAnnotation(aa);
            String detail = this.annotationDetails.get(index);
            if (detail != null && !detail.isEmpty()) {
                sn.setAnnotationDetails(detail);
            }
        }
    }

    void makeLeaves() {
        this.clusters = new Vector();
        for (int i = 0; i < this.noseqs; ++i) {
            SequenceNode sn = new SequenceNode();
            sn.setElement(this.sequences[i]);
            if (this.labels.size() == this.noseqs) {
                sn.setLabel(this.labels.get(i));
            }
            this.applyAnnotationsToNode(sn, i);
            sn.setName(this.sequences[i].getName());
            this.node.addElement(sn);
            BitSet bs = new BitSet();
            bs.set(i);
            this.clusters.addElement(bs);
        }
    }

    public AlignmentView getOriginalData() {
        return this.seqStrings;
    }
}

