/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.models.export;

import fr.orsay.lri.varna.models.export.SecStrDrawingProducer;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class PSExport
extends SecStrDrawingProducer {
    public PSExport() {
        super.setScale(0.4);
    }

    private String PSMacros() {
        String string = "/setbasefont \n{ /Helvetica-Bold findfont\n  exch scalefont\n  setfont \n  } def\n\n";
        String string2 = "/txtcenter \n{ dup \n  stringwidth pop\n  2 div neg \n  3 -1 roll \n  2 div neg\n  rmoveto\n  show\n  } def\n\n";
        String string3 = "/ellipse {\n  /endangle exch def\n  /startangle exch def\n  /yrad exch def\n  /xrad exch def\n  /y exch def\n  /x exch def\n  /savematrix matrix currentmatrix def\n  x y translate\n  xrad yrad scale\n  0 0 1 startangle endangle arc\n  savematrix setmatrix\n  } def\n\n";
        return string + string2 + string3;
    }

    private String EPSHeader(double d, double d2, double d3, double d4) {
        String string = this.PSBBox(d, d3, d2, d4);
        String string2 = "%!PS-Adobe-3.0\n%%Pages: 1\n" + string + "%%EndComments\n" + "%%Page: 1 1\n";
        String string3 = this.PSMacros();
        return string2 + string3;
    }

    private String EPSFooter() {
        return "showpage\n%%EndPage: 1\n%%EOF";
    }

    private String PSNewPath() {
        return "newpath\n";
    }

    private String PSMoveTo(double d, double d2) {
        return "" + d + " " + d2 + " moveto\n";
    }

    private String PSLineTo(double d, double d2) {
        return "" + d + " " + d2 + " lineto\n";
    }

    private String PSRLineTo(double d, double d2) {
        return "" + d + " " + d2 + " rlineto\n";
    }

    private String PSSetLineWidth(double d) {
        return "" + (d /= 2.0) + " setlinewidth\n";
    }

    private String PSStroke() {
        return "stroke\n";
    }

    private String PSArc(double d, double d2, double d3, double d4, double d5, double d6) {
        double d7 = d + d3 / 2.0;
        double d8 = d2;
        return d7 + " " + d8 + " " + d3 / 2.0 + " " + d4 / 2.0 + " " + d5 + " " + d6 + " ellipse\n";
    }

    private String PSArc(double d, double d2, double d3, double d4, double d5) {
        return "" + d + " " + d2 + " " + d3 + " " + d4 + " " + d5 + "  arc\n";
    }

    private String PSBBox(double d, double d2, double d3, double d4) {
        String string = "%%BoundingBox: " + (long)Math.floor(d) + " " + (long)Math.floor(d3) + " " + (long)Math.ceil(d2) + " " + (long)Math.ceil(d4) + "\n";
        String string2 = "%%HighResBoundingBox: " + (long)Math.floor(d) + " " + (long)Math.floor(d3) + " " + (long)Math.ceil(d2) + " " + (long)Math.ceil(d4) + "\n";
        return string + string2;
    }

    private String PSText(String string) {
        return "(" + string + ") ";
    }

    private String PSShow() {
        return "show\n";
    }

    private String PSClosePath() {
        return "closepath\n";
    }

    private String PSFill() {
        return "fill\n";
    }

    private String PSSetColor(Color color) {
        return "" + (double)color.getRed() / 255.0 + " " + (double)color.getGreen() / 255.0 + " " + (double)color.getBlue() / 255.0 + " setrgbcolor\n";
    }

    private String fontName(int n) {
        switch (n) {
            case 0: {
                return "/Times-Roman";
            }
            case 1: {
                return "/Times-Bold";
            }
            case 2: {
                return "/Times-Italic";
            }
            case 3: {
                return "/Times-BoldItalic";
            }
            case 16: {
                return "/Helvetica";
            }
            case 18: {
                return "/Helvetica-Bold";
            }
            case 17: {
                return "/Helvetica-Oblique";
            }
            case 19: {
                return "/Helvetica-BoldOblique";
            }
            case 12: {
                return "/Courier";
            }
            case 13: {
                return "/Courier-Bold";
            }
            case 14: {
                return "/Courier-Oblique";
            }
            case 15: {
                return "/Courier-BoldOblique";
            }
        }
        return "/Helvetica";
    }

    private String PSSetFont(int n, double d) {
        return this.fontName(n) + " findfont " + d + " scalefont setfont\n";
    }

    @Override
    public String setFontS(int n, double d) {
        this._fontsize = (long)(0.4 * d);
        return this.PSSetFont(n, this._fontsize);
    }

    @Override
    public String setColorS(Color color) {
        super.setColorS(color);
        String string = this.PSSetColor(color);
        return string;
    }

    @Override
    public String drawLineS(Point2D.Double double_, Point2D.Double double_2, double d) {
        String string = "";
        string = string + this.PSMoveTo(double_.x, double_.y);
        string = string + this.PSLineTo(double_2.x, double_2.y);
        string = string + this.PSSetLineWidth(d);
        string = string + this.PSStroke();
        return string;
    }

    @Override
    public String drawTextS(Point2D.Double double_, String string) {
        String string2 = "";
        string2 = string2 + this.PSMoveTo(double_.x, double_.y);
        string2 = string2 + "" + (this._fontsize / 2.0 + 1.0) + " \n";
        string2 = string2 + this.PSText(string);
        string2 = string2 + " txtcenter\n";
        return string2;
    }

    @Override
    public String drawRectangleS(Point2D.Double double_, Point2D.Double double_2, double d) {
        String string = this.PSNewPath();
        string = string + this.PSMoveTo(double_.x, double_.y);
        string = string + this.PSRLineTo(0.0, double_2.y);
        string = string + this.PSRLineTo(double_2.x, 0.0);
        string = string + this.PSRLineTo(0.0, -double_2.y);
        string = string + this.PSClosePath();
        string = string + this.PSSetLineWidth(d);
        string = string + this.PSStroke();
        return string;
    }

    @Override
    public String drawCircleS(Point2D.Double double_, double d, double d2) {
        String string = this.PSNewPath();
        string = string + this.PSArc(double_.x, double_.y, d, 0.0, 360.0);
        string = string + this.PSSetLineWidth(d2);
        string = string + this.PSStroke();
        return string;
    }

    @Override
    public String fillCircleS(Point2D.Double double_, double d, double d2, Color color) {
        String string = this.PSNewPath();
        string = string + this.PSArc(double_.x, double_.y, d, 0.0, 360.0);
        string = string + this.PSSetLineWidth(d2);
        string = string + this.PSSetColor(color);
        string = string + this.PSFill();
        return string;
    }

    @Override
    public String footerS() {
        return this.EPSFooter();
    }

    @Override
    public String headerS(Rectangle2D.Double double_) {
        return this.EPSHeader(double_.x, double_.y, double_.x + double_.width, double_.y + double_.height);
    }

    @Override
    public String drawArcS(Point2D.Double double_, double d, double d2, double d3, double d4) {
        return this.PSArc(double_.x, double_.y, d, d2, d3, d4) + this.PSStroke();
    }

    @Override
    public String drawPolygonS(Point2D.Double[] doubleArray, double d) {
        String string = this.PSNewPath();
        string = string + this.PSSetLineWidth(d);
        for (int i = 0; i < doubleArray.length; ++i) {
            string = i == 0 ? string + this.PSMoveTo(doubleArray[i].x, doubleArray[i].y) : string + this.PSLineTo(doubleArray[i].x, doubleArray[i].y);
        }
        string = string + this.PSClosePath();
        string = string + this.PSStroke();
        return string;
    }

    @Override
    public String fillPolygonS(Point2D.Double[] doubleArray, Color color) {
        Color color2 = this._curColor;
        String string = this.PSNewPath();
        for (int i = 0; i < doubleArray.length; ++i) {
            string = i == 0 ? string + this.PSMoveTo(doubleArray[i].x, doubleArray[i].y) : string + this.PSLineTo(doubleArray[i].x, doubleArray[i].y);
        }
        string = string + this.PSClosePath();
        string = string + this.PSSetColor(color);
        string = string + this.PSFill();
        string = string + this.PSSetColor(color2);
        return string;
    }
}

