/*
 * Decompiled with CFR 0.152.
 */
package jalview.ws2.helpers;

import jalview.ws2.actions.api.JobI;
import jalview.ws2.api.JobStatus;
import jalview.ws2.helpers.TaskEventSupport;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public class DelegateJobEventListener<T>
implements PropertyChangeListener {
    private final TaskEventSupport<T> delegate;

    public DelegateJobEventListener(TaskEventSupport<T> delegate) {
        this.delegate = delegate;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        switch (evt.getPropertyName()) {
            case "status": {
                this.statusChanged(evt);
                break;
            }
            case "log": {
                this.logChanged(evt);
                break;
            }
            case "errorLog": {
                this.errorLogChanged(evt);
                break;
            }
            default: {
                throw new AssertionError((Object)String.format("illegal property name \"%s\"", evt.getPropertyName()));
            }
        }
    }

    private void statusChanged(PropertyChangeEvent evt) {
        JobI job = (JobI)evt.getSource();
        JobStatus status = (JobStatus)((Object)evt.getNewValue());
        this.delegate.fireSubJobStatusChanged(job, status);
    }

    private void logChanged(PropertyChangeEvent evt) {
        JobI job = (JobI)evt.getSource();
        String log = (String)evt.getNewValue();
        this.delegate.fireSubJobLogChanged(job, log);
    }

    private void errorLogChanged(PropertyChangeEvent evt) {
        JobI job = (JobI)evt.getSource();
        String errorLog = (String)evt.getNewValue();
        this.delegate.fireSubJobErrorLogChanged(job, errorLog);
    }
}

