/*
 * Decompiled with CFR 0.152.
 */
package jalview.ws2.client.ebi;

import jalview.bin.Console;
import jalview.ws.params.ParamManager;
import jalview.ws2.actions.hmmer.PhmmerAction;
import jalview.ws2.api.WebService;
import jalview.ws2.client.api.AbstractWebServiceDiscoverer;
import jalview.ws2.client.ebi.ParamStores;
import jalview.ws2.client.ebi.PhmmerWSClient;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import uk.ac.dundee.compbio.hmmerclient.PhmmerClient;

public final class JobDispatcherWSDiscoverer
extends AbstractWebServiceDiscoverer {
    private static final URL DEFAULT_URL;
    private static JobDispatcherWSDiscoverer instance;
    private static ParamManager paramManager;

    private JobDispatcherWSDiscoverer() {
    }

    public static JobDispatcherWSDiscoverer getInstance() {
        if (instance == null) {
            instance = new JobDispatcherWSDiscoverer();
        }
        return instance;
    }

    public static void setParamManager(ParamManager manager) {
        paramManager = manager;
    }

    @Override
    public int getStatusForUrl(URL url) {
        try {
            return new PhmmerClient(url).testEndpoint() ? 1 : -1;
        }
        catch (URISyntaxException e) {
            Console.error(e.getMessage());
            return -1;
        }
    }

    @Override
    protected String getUrlsPropertyKey() {
        return null;
    }

    @Override
    protected URL getDefaultUrl() {
        return DEFAULT_URL;
    }

    @Override
    protected List<WebService<?>> fetchServices(URL url) throws IOException {
        PhmmerClient phmmerClient;
        try {
            phmmerClient = new PhmmerClient(url);
        }
        catch (URISyntaxException e) {
            throw new MalformedURLException(e.getMessage());
        }
        if (!phmmerClient.testEndpoint()) {
            throw new IOException("unable to reach dispatcher server at " + url);
        }
        WebService.Builder<PhmmerAction> wsBuilder = WebService.newBuilder();
        wsBuilder.url(url);
        wsBuilder.clientName("job dispatcher");
        wsBuilder.category("Database search");
        wsBuilder.name("pHMMER");
        wsBuilder.description("Hmmer3 phmmer is used to search one or more query sequences against a sequence database.");
        wsBuilder.interactive(false);
        wsBuilder.paramDatastore(ParamStores.newPhmmerDatastore(url, paramManager));
        wsBuilder.actionClass(PhmmerAction.class);
        WebService<PhmmerAction> webService = wsBuilder.build();
        PhmmerWSClient client = new PhmmerWSClient(phmmerClient);
        PhmmerAction.Builder actionBuilder = PhmmerAction.newBuilder(client);
        actionBuilder.webService(webService);
        actionBuilder.name("");
        webService.addAction(actionBuilder.build());
        return List.of(webService);
    }

    static {
        try {
            DEFAULT_URL = new URL("https://www.ebi.ac.uk/Tools/services/rest/hmmer3_phmmer/");
        }
        catch (MalformedURLException e) {
            throw new ExceptionInInitializerError(e);
        }
        instance = null;
        paramManager = null;
    }
}

