/*
 * Decompiled with CFR 0.152.
 */
package jalview.ws2.actions.secstructpred;

import jalview.analysis.AlignSeq;
import jalview.analysis.AlignmentAnnotationUtils;
import jalview.analysis.SeqsetUtils;
import jalview.api.AlignViewportI;
import jalview.bin.Console;
import jalview.commands.RemoveGapsCommand;
import jalview.datamodel.Alignment;
import jalview.datamodel.AlignmentAnnotation;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.AlignmentView;
import jalview.datamodel.SeqCigar;
import jalview.datamodel.SequenceI;
import jalview.io.JPredFile;
import jalview.io.JnetAnnotationMaker;
import jalview.util.Comparison;
import jalview.util.MessageManager;
import jalview.ws.params.ArgumentI;
import jalview.ws2.actions.BaseJob;
import jalview.ws2.actions.BaseTask;
import jalview.ws2.actions.ServiceInputInvalidException;
import jalview.ws2.api.Credentials;
import jalview.ws2.api.JobStatus;
import jalview.ws2.client.api.SecStructPredWebServiceClientI;
import java.io.IOException;
import java.util.List;

public class SecStructPredPDBSearchTask
extends BaseTask<SecStructPredJob, AlignmentI> {
    private final SecStructPredWebServiceClientI client;
    private final AlignmentView alignmentView;
    private final AlignmentI currentView;
    private final char gapChar;
    public static final int MSA_INDEX = 0;

    SecStructPredPDBSearchTask(SecStructPredWebServiceClientI client, List<ArgumentI> args, Credentials credentials, AlignViewportI viewport) {
        super(client, args, credentials);
        this.client = client;
        this.alignmentView = viewport.getAlignmentView(true);
        this.currentView = viewport.getAlignment();
        this.gapChar = viewport.getGapCharacter();
    }

    @Override
    protected List<SecStructPredJob> prepareJobs() throws ServiceInputInvalidException {
        SeqCigar[] msf = this.alignmentView.getSequences();
        if (msf.length > 1) {
            throw new ServiceInputInvalidException(MessageManager.getString("error.implementation_error_multiple_single_sequence_prediction_jobs_not_supported"));
        }
        SequenceI seq = msf[0].getSeq('-');
        if (seq == null) {
            throw new ServiceInputInvalidException("Missing sequence.");
        }
        int[] delMap = this.alignmentView.getVisibleContigMapFor(seq.gapMap());
        SeqsetUtils.SequenceInfo seqInfo = SeqsetUtils.SeqCharacterHash(seq);
        seq.setSequence(AlignSeq.extractGaps(Comparison.GapChars, this.alignmentView.getASequenceString('-', 0)));
        if (seq.getLength() < 20) {
            throw new ServiceInputInvalidException("Sequence is too short to predict with JPred - need at least 20 amino acids.");
        }
        SecStructPredJob job = new SecStructPredJob(seq, delMap, seqInfo);
        job.setStatus(JobStatus.READY);
        return List.of(job);
    }

    @Override
    protected AlignmentI collectResult(List<SecStructPredJob> jobs) throws IOException {
        SecStructPredJob job = jobs.get(0);
        JobStatus status = job.getStatus();
        Console.info(String.format("sec str pred job \"%s\" finished with status %s", new Object[]{job.getServerJob().getJobId(), status}));
        JPredFile predictionFile = this.client.getPredictionFile(job.getServerJob());
        SequenceI[] preds = predictionFile.getSeqsAsArray();
        Alignment aln = new Alignment(preds);
        int queryPosition = predictionFile.getQuerySeqPosition();
        SequenceI profileSeq = aln.getSequenceAt(queryPosition);
        if (job.delMap != null) {
            SequenceI[] seqs = (SequenceI[])this.alignmentView.getAlignmentAndHiddenColumns(this.gapChar)[0];
            if (0 >= seqs.length) {
                throw new Error(MessageManager.getString("error.implementation_error_invalid_msa_index_for_job"));
            }
            new RemoveGapsCommand(MessageManager.getString("label.remove_gaps"), new SequenceI[]{seqs[0]}, this.currentView);
            profileSeq.setSequence(seqs[0].getSequenceAsString());
        }
        if (!SeqsetUtils.SeqCharacterUnhash(aln.getSequenceAt(queryPosition), job.info)) {
            throw new IOException(MessageManager.getString("exception.couldnt_recover_sequence_props_for_jnet_query"));
        }
        aln.setDataset(this.currentView.getDataset());
        try {
            JnetAnnotationMaker.add_annotation(predictionFile, aln, queryPosition, true, job.delMap);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        SecStructPredPDBSearchTask.alignToProfileSequence(aln, profileSeq);
        if (job.delMap != null) {
            aln.setHiddenColumns(aln.propagateInsertions(profileSeq, this.alignmentView));
        }
        for (AlignmentAnnotation alnAnnot : aln.getAlignmentAnnotation()) {
            if (alnAnnot.sequenceRef == null) continue;
            AlignmentAnnotationUtils.replaceAnnotationOnAlignmentWith(alnAnnot, alnAnnot.label, this.getClass().getSimpleName());
        }
        aln.setSeqrep(profileSeq);
        return aln;
    }

    private static void alignToProfileSequence(AlignmentI al, SequenceI profileseq) {
        char gc = al.getGapCharacter();
        int[] gapMap = profileseq.gapMap();
        int lp = 0;
        for (int r = 0; r < gapMap.length; ++r) {
            if (gapMap[r] - lp > 1) {
                int s;
                StringBuffer sb = new StringBuffer();
                int ns = gapMap[r] - lp;
                for (s = 0; s < ns; ++s) {
                    sb.append(gc);
                }
                ns = al.getHeight();
                for (s = 1; s < ns; ++s) {
                    Object sq = al.getSequenceAt(s).getSequenceAsString();
                    int diff = gapMap[r] - ((String)sq).length();
                    if (diff > 0) {
                        sq = (String)sq + sb;
                        while ((diff = gapMap[r] - ((String)sq).length()) > 0) {
                            sq = (String)sq + (diff >= sb.length() ? sb.toString() : sb.substring(0, diff));
                        }
                        al.getSequenceAt(s).setSequence((String)sq);
                        continue;
                    }
                    al.getSequenceAt(s).setSequence(((String)sq).substring(0, gapMap[r]) + sb.toString() + ((String)sq).substring(gapMap[r]));
                }
            }
            lp = gapMap[r];
        }
    }

    public static class SecStructPredJob
    extends BaseJob {
        private final SeqsetUtils.SequenceInfo info;
        private final int[] delMap;

        SecStructPredJob(SequenceI querySequence, int[] delMap, SeqsetUtils.SequenceInfo info) {
            super(List.of(querySequence));
            this.delMap = delMap;
            this.info = info;
        }

        @Override
        public boolean isInputValid() {
            return true;
        }
    }
}

